/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.parse;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.arelle.parse.PreParser;

public class PreParser {
    private static final Logger log = LoggerFactory.getLogger(PreParser.class);

    public static void parse(String fullFileName, BiConsumer<String, List<ConceptHierarchy>> consumer) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        ImmutablePair roleItems = null;
        String currentRole = null;
        LinkedList<ConceptHierarchy> conceptStack = new LinkedList<ConceptHierarchy>();
        try (FileInputStream fileInputStream = new FileInputStream(fullFileName);){
            XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(new BufferedInputStream(fileInputStream));
            while (reader.hasNext()) {
                int eventType = reader.next();
                switch (eventType) {
                    case 7: {
                        break;
                    }
                    case 1: {
                        String currentStartElement = reader.getName().toString();
                        if (StringUtils.equalsIgnoreCase((CharSequence)"linkrole", (CharSequence)currentStartElement)) {
                            int n = reader.getAttributeCount();
                            for (int i = 0; i < n; ++i) {
                                QName attributeName = reader.getAttributeName(i);
                                String attributeValue = reader.getAttributeValue(i);
                                if (!StringUtils.equalsIgnoreCase((CharSequence)"role", (CharSequence)attributeName.toString())) continue;
                                currentRole = attributeValue;
                            }
                            roleItems = new ImmutablePair(currentRole, new ArrayList());
                            break;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)"concept", (CharSequence)currentStartElement)) {
                            ConceptHierarchy conceptHierarchy = new ConceptHierarchy();
                            int n = reader.getAttributeCount();
                            for (int i = 0; i < n; ++i) {
                                QName attributeName = reader.getAttributeName(i);
                                String attributeValue = reader.getAttributeValue(i);
                                if (StringUtils.equalsIgnoreCase((CharSequence)"name", (CharSequence)attributeName.toString())) {
                                    conceptHierarchy.setName(attributeValue);
                                }
                                if (!StringUtils.equalsIgnoreCase((CharSequence)"label", (CharSequence)attributeName.toString())) continue;
                                conceptHierarchy.setLabel(attributeValue);
                            }
                            ConceptHierarchy parent = (ConceptHierarchy)conceptStack.peek();
                            if (parent != null) {
                                conceptHierarchy.getParents().addAll(conceptStack);
                            }
                            conceptStack.push(conceptHierarchy);
                            break;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)"type", (CharSequence)currentStartElement)) {
                            ((ConceptHierarchy)conceptStack.peek()).setType(reader.getElementText());
                            break;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)"pref.Label", (CharSequence)currentStartElement)) {
                            ((ConceptHierarchy)conceptStack.peek()).setPrefLabel(reader.getElementText());
                            break;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)"references", (CharSequence)currentStartElement)) {
                            ((ConceptHierarchy)conceptStack.peek()).setReferences(reader.getElementText());
                            break;
                        }
                    }
                    case 2: {
                        String currentEndElement = reader.getName().toString();
                        if (StringUtils.equalsIgnoreCase((CharSequence)"concept", (CharSequence)currentEndElement)) {
                            ((List)roleItems.getValue()).add(conceptStack.pop());
                            break;
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)"linkrole", (CharSequence)currentEndElement)) break;
                        consumer.accept((String)roleItems.getKey(), (List<ConceptHierarchy>)roleItems.getValue());
                        break;
                    }
                    case 8: {
                        break;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }
}

