/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.arelle.parse.DimConcept;
import ru.cbr.xbrl.converter.arelle.parse.definition_hypercube.DefinitionHypercubeFinder;
import ru.cbr.xbrl.converter.arelle.parse.definition_hypercube.DimParserV2;
import ru.cbr.xbrl.converter.arelle.parse.definition_hypercube.dto.DefinitionHypercube;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class HypercubeService {
    private static final Logger log = LoggerFactory.getLogger(HypercubeService.class);
    private Map<String, List<DefinitionHypercube>> conceptDefinitionHypercubeMap = new HashMap();
    private Map<String, List<DefinitionHypercube>> rolesDefinitionHypercubeMap = new HashMap();
    private Map<String, DimensionType> dimensionTypes = new HashMap();
    private Map<String, String> dimensionsDefault;
    private Set<String> technicalAxises = new HashSet();

    public void readXml(String xml) {
        this.conceptDefinitionHypercubeMap.clear();
        this.rolesDefinitionHypercubeMap.clear();
        this.technicalAxises.clear();
        DimParserV2.parseString((String)xml, roleData -> {
            this.dimensionsDefault = HypercubeService.searchDimensionsDefault((List)roleData.getDimConcepts());
        });
        DimParserV2.parseString((String)xml, arg_0 -> this.processRoleData(arg_0));
    }

    private void processRoleData(DimParserV2.DimRoleData dimRoleData) {
        List dimConcepts = dimRoleData.getDimConcepts();
        String roleSystemId = dimRoleData.getRoleSystemId();
        List hypercubes = DefinitionHypercubeFinder.findHypercubesPowerSet((List)dimConcepts, (Map)this.dimensionsDefault);
        this.fillDimensionTypes(hypercubes);
        this.rolesDefinitionHypercubeMap.put(roleSystemId, hypercubes);
        hypercubes.forEach(definitionHypercube -> {
            if (definitionHypercube.getDimensions().isEmpty()) {
                this.technicalAxises.add(definitionHypercube.getContainerConcept());
            }
            definitionHypercube.getConcepts().forEach(concept -> {
                this.conceptDefinitionHypercubeMap.putIfAbsent(concept, new ArrayList());
                ((List)this.conceptDefinitionHypercubeMap.get(concept)).add(definitionHypercube);
            });
        });
    }

    private static Map<String, String> searchDimensionsDefault(List<DimConcept> dimConcepts) {
        HashMap<String, String> dimensionsDefault = new HashMap<String, String>();
        dimConcepts.forEach(dimConcept -> dimConcept.iterateAll((child, parent) -> {
            if (child.getArcrole().equals("dimension-default")) {
                dimensionsDefault.putIfAbsent(parent.getName(), child.getName());
            }
        }));
        return dimensionsDefault;
    }

    private void fillDimensionTypes(List<DefinitionHypercube> hypercubes) {
        hypercubes.forEach(definitionHypercube -> definitionHypercube.getDimensions().forEach((s, definitionHypercubeDimension) -> {
            String dimension = definitionHypercubeDimension.getDimension();
            DimensionType dimensionType = definitionHypercubeDimension.getDimensionType();
            this.dimensionTypes.putIfAbsent(dimension, dimensionType);
        }));
    }

    public boolean isHypercubeExists(AspectCellData aspectCellData) {
        AspectData concept = aspectCellData.getConcept();
        if (concept == null) {
            return false;
        }
        List availHypercubes = (List)this.conceptDefinitionHypercubeMap.get(concept.getAspectValue());
        if (availHypercubes == null) {
            return false;
        }
        return availHypercubes.stream().anyMatch(definitionHypercube -> definitionHypercube.containsAspectCellDataRecursively(aspectCellData));
    }

    public Map<String, List<DefinitionHypercube>> getRolesDefinitionHypercubeMap() {
        return this.rolesDefinitionHypercubeMap;
    }

    public Map<String, List<DefinitionHypercube>> getConceptDefinitionHypercubeMap() {
        return this.conceptDefinitionHypercubeMap;
    }

    public Map<String, List<DefinitionHypercube>> getHypercubesByRole(String roleSystemId) {
        List hypercubes = (List)this.getRolesDefinitionHypercubeMap().get(roleSystemId);
        HashMap<String, List<DefinitionHypercube>> map = new HashMap<String, List<DefinitionHypercube>>();
        hypercubes.forEach(definitionHypercube -> definitionHypercube.getConcepts().forEach(concept -> {
            map.putIfAbsent((String)concept, new ArrayList());
            ((List)map.get(concept)).add(definitionHypercube);
        }));
        return map;
    }

    public DimensionType getDimensionType(String dimension) {
        return (DimensionType)this.dimensionTypes.get(dimension);
    }

    public boolean isTechnicalConcept(String conceptQname) {
        return this.technicalAxises.contains(conceptQname);
    }
}

