/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.parse;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.arelle.parse.DimConcept;

/*
 * Exception performing whole class analysis ignored.
 */
public class DimParser {
    private static final Logger log = LoggerFactory.getLogger(DimParser.class);

    public static void parseFile(String fullFileName, BiConsumer<Pair<String, String>, List<DimConcept>> consumer) {
        try (FileInputStream fileInputStream = new FileInputStream(fullFileName);){
            DimParser.parse(consumer, (InputStream)fileInputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public static void parseString(String xml, BiConsumer<Pair<String, String>, List<DimConcept>> consumer) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8.name()));){
            DimParser.parse(consumer, (InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private static void parse(BiConsumer<Pair<String, String>, List<DimConcept>> consumer, InputStream inputStream) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        ImmutablePair roleItems = null;
        MutablePair currentRole = new MutablePair();
        LinkedList<DimConcept> conceptStack = new LinkedList<DimConcept>();
        XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(new BufferedInputStream(inputStream));
        while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 7: {
                    break;
                }
                case 1: {
                    String currentStartElement = reader.getName().toString();
                    if (StringUtils.equalsIgnoreCase((CharSequence)"linkrole", (CharSequence)currentStartElement)) {
                        int n = reader.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            QName attributeName = reader.getAttributeName(i);
                            String attributeValue = reader.getAttributeValue(i);
                            if (StringUtils.equalsIgnoreCase((CharSequence)"role", (CharSequence)attributeName.toString())) {
                                currentRole.setLeft((Object)attributeValue);
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)"roledefinition", (CharSequence)attributeName.toString())) continue;
                            currentRole.setRight((Object)attributeValue);
                        }
                        roleItems = new ImmutablePair((Object)currentRole, new ArrayList());
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"concept", (CharSequence)currentStartElement)) {
                        DimConcept concept = new DimConcept();
                        int n = reader.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            QName attributeName = reader.getAttributeName(i);
                            String attributeValue = reader.getAttributeValue(i);
                            if (StringUtils.equalsIgnoreCase((CharSequence)"name", (CharSequence)attributeName.toString())) {
                                concept.setName(attributeValue);
                            }
                            if (StringUtils.equalsIgnoreCase((CharSequence)"label", (CharSequence)attributeName.toString())) {
                                concept.setLabel(attributeValue);
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)"abstract", (CharSequence)attributeName.toString())) continue;
                            concept.setAbstractNode(Boolean.valueOf(BooleanUtils.toBoolean((String)attributeValue)));
                        }
                        DimConcept parent = (DimConcept)conceptStack.peek();
                        if (parent != null) {
                            concept.getParents().addAll(conceptStack);
                            parent.getChildren().add(concept);
                        }
                        conceptStack.push(concept);
                        break;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"arcrole", (CharSequence)currentStartElement)) {
                        ((DimConcept)conceptStack.peek()).setArcrole(reader.getElementText());
                        break;
                    }
                }
                case 2: {
                    String currentEndElement = reader.getName().toString();
                    if (StringUtils.equalsIgnoreCase((CharSequence)"concept", (CharSequence)currentEndElement)) {
                        ((List)roleItems.getValue()).add(conceptStack.pop());
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"linkrole", (CharSequence)currentEndElement)) break;
                    consumer.accept((Pair<String, String>)roleItems.getKey(), (List<DimConcept>)roleItems.getValue());
                    break;
                }
                case 8: {
                    break;
                }
            }
        }
    }
}

