/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.parse;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.XbrlDimension;

public class DimFileParser {
    private static final Logger log = LoggerFactory.getLogger(DimFileParser.class);

    public static void parse(String fullFileName, BiConsumer<Integer, XbrlDimension> xbrlDimensionConsumer) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        String currentRole = null;
        ImmutablePair currentDimInt = null;
        XbrlDimension xbrlDimension = null;
        LinkedList<XbrlDimension> memIntStack = new LinkedList<XbrlDimension>();
        try (FileInputStream fileInputStream = new FileInputStream(fullFileName);){
            XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(new BufferedInputStream(fileInputStream));
            block19: while (reader.hasNext()) {
                int eventType = reader.next();
                switch (eventType) {
                    case 7: {
                        break;
                    }
                    case 1: {
                        String currentStartElement = reader.getName().toString();
                        if (StringUtils.equalsIgnoreCase((CharSequence)"linkrole", (CharSequence)currentStartElement)) {
                            currentDimInt = null;
                            int n = reader.getAttributeCount();
                            for (int i = 0; i < n; ++i) {
                                QName attributeName = reader.getAttributeName(i);
                                String attributeValue = reader.getAttributeValue(i);
                                if (!StringUtils.equalsIgnoreCase((CharSequence)"role", (CharSequence)attributeName.toString())) continue;
                                currentRole = attributeValue;
                            }
                            continue block19;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)"concept", (CharSequence)currentStartElement)) {
                            xbrlDimension = new XbrlDimension();
                            String label = null;
                            String name = null;
                            int n = reader.getAttributeCount();
                            for (int i = 0; i < n; ++i) {
                                QName attributeName = reader.getAttributeName(i);
                                String attributeValue = reader.getAttributeValue(i);
                                if (StringUtils.equalsIgnoreCase((CharSequence)"name", (CharSequence)attributeName.toString())) {
                                    name = attributeValue;
                                }
                                if (!StringUtils.equalsIgnoreCase((CharSequence)"label", (CharSequence)attributeName.toString())) continue;
                                label = attributeValue;
                            }
                            if (name.startsWith("dim-int:")) {
                                xbrlDimension = null;
                                currentDimInt = new ImmutablePair((Object)name, label);
                                break;
                            }
                            if (currentDimInt == null) {
                                xbrlDimension = null;
                                log.trace("Current dmInt is null, name {}, label {} ", (Object)name, label);
                                break;
                            }
                            if (name.startsWith("mem-int:")) {
                                xbrlDimension.setDimIntLabel((String)currentDimInt.getValue());
                                xbrlDimension.setDimInt((String)currentDimInt.getKey());
                                xbrlDimension.setMemInt(name);
                                xbrlDimension.setMemIntLabel(label);
                                String id = DigestUtils.md5Hex((String)(xbrlDimension.getDimInt() + " -> " + xbrlDimension.getMemInt()));
                                xbrlDimension.setId(id);
                                XbrlDimension parent = (XbrlDimension)memIntStack.peek();
                                if (parent != null) {
                                    xbrlDimension.setParentId(parent.getId());
                                } else {
                                    log.trace("Parent id is null for {}:{}", (Object)xbrlDimension.getDimInt(), (Object)xbrlDimension.getMemInt());
                                }
                                memIntStack.push(xbrlDimension);
                                break;
                            }
                            xbrlDimension = null;
                            log.trace("Wrong concept name: " + name + ". Expected dim-int or mem-int.");
                            break;
                        }
                    }
                    case 2: {
                        String currentEndElement = reader.getName().toString();
                        if (!StringUtils.equalsIgnoreCase((CharSequence)"concept", (CharSequence)currentEndElement) || xbrlDimension == null) break;
                        xbrlDimensionConsumer.accept(memIntStack.size(), xbrlDimension);
                        xbrlDimension = null;
                        memIntStack.pop();
                        break;
                    }
                    case 8: {
                        break;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }
}

