/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.arelle.parse.DimConcept;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeConcepts;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeDimensions;
import ru.cbr.xbrl.converter.arelle.parse.HypercubePath;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeType;
import ru.cbr.xbrl.converter.model.xbrl_content.RoleCell;
import ru.cbr.xbrl.converter.model.xbrl_content.RoleCellId;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.utils.LruCache;
import ru.cbr.xbrl.converter.utils.MathUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

/*
 * Exception performing whole class analysis ignored.
 */
public class DimConceptProcessor {
    private static final Logger log = LoggerFactory.getLogger(DimConceptProcessor.class);
    public static final int DIMENSION_CACHE_SIZE = 100;
    public static final int DIMENSION_CARTESIAN_PRODUCT_LIMIT = 75000;
    public LruCache<String, String> dimensionHashCache = new LruCache(100);
    private final Map<String, String> dimensionsDefault;
    private List<DimConcept> dimConcepts = new ArrayList();
    private List<HypercubePath> hypercubePaths = new ArrayList();
    private List<HypercubeConcepts> hypercubeConceptsList = new ArrayList();
    private List<RoleCell> roleCells = new ArrayList();
    private List<DimConcept> concepts = new ArrayList();
    private String linkrole;
    public Set<String> largeDimensions = new HashSet();
    public Set<HypercubeDimensions> largeDimensionHypercubes = new HashSet();

    public List<RoleCell> getRoleCells() {
        return this.roleCells;
    }

    public DimConceptProcessor(Map<String, String> dimensionsDefault, List<DimConcept> dimConcepts) {
        this.dimConcepts = dimConcepts;
        this.dimensionsDefault = dimensionsDefault;
    }

    public void prepareRoleDimensionMap(String linkrole, BiConsumer<DimConcept, DimConcept> consumer) {
        this.linkrole = linkrole;
        this.findHypercubes(this.dimConcepts);
        this.hypercubeConceptsList.stream().forEach(hypercubeConcepts -> {
            DimConcept hypercubeConcept = hypercubeConcepts.getHypercube();
            hypercubeConcept.getChildren().forEach(dimintMember -> {
                if (dimintMember.getChildren().isEmpty()) {
                    consumer.accept((DimConcept)dimintMember, (DimConcept)null);
                }
                dimintMember.getChildren().forEach(memintMember -> {
                    consumer.accept((DimConcept)dimintMember, (DimConcept)memintMember);
                    memintMember.getChildren().forEach(memintMember2 -> {
                        consumer.accept((DimConcept)dimintMember, (DimConcept)memintMember2);
                        memintMember2.getChildren().forEach(memintMember3 -> {
                            consumer.accept((DimConcept)dimintMember, (DimConcept)memintMember3);
                            memintMember3.getChildren().forEach(memintMember4 -> consumer.accept((DimConcept)dimintMember, (DimConcept)memintMember4));
                        });
                    });
                });
            });
        });
    }

    public void prepareRoleConceptMap(String linkrole, Consumer<DimConcept> consumer) {
        this.dimConcepts.forEach(concept -> {
            if (!this.isNotConcept(concept) && concept.getParents().stream().noneMatch(arg_0 -> this.isNotConcept(arg_0))) {
                consumer.accept((DimConcept)concept);
            }
        });
    }

    private boolean isNotConcept(DimConcept p) {
        List<String> arcroles = Arrays.asList("all", "notAll", "Axis");
        return p.getArcrole() != null && arcroles.contains(p.getArcrole());
    }

    public void buildCellExclusionsData() {
        this.findHypercubes(this.dimConcepts);
        this.hypercubeConceptsList.stream().forEach(hypercubeConcepts -> {
            List dimensions = this.buildDimensions(hypercubeConcepts.getHypercube());
            List concepts = this.getConcepts(hypercubeConcepts.getRootConcept());
            if (dimensions.size() * concepts.size() > 75000) {
                log.warn("Product [concept * diminsions] is too large: {}. Role exclusions not processed", (Object)(dimensions.size() * concepts.size()));
            } else {
                for (DimConcept concept : concepts) {
                    for (List dimensionsList : dimensions) {
                        HypercubePath hypercubePath = new HypercubePath();
                        hypercubePath.setConcept(concept.getName());
                        hypercubePath.setDimensions(dimensionsList);
                        hypercubePath.setHypercubeType(hypercubeConcepts.getHypercubeType());
                        this.hypercubePaths.add(hypercubePath);
                    }
                }
            }
        });
        this.hypercubePaths.stream().forEach(hypercubePath -> {
            List dimensions = DimConceptProcessor.removeDefaultDimensions((List)hypercubePath.getDimensions(), (Map)this.dimensionsDefault);
            List aspectDataList = dimensions.stream().filter(d -> d != null).map(dimension -> this.buildAspectData(dimension)).collect(Collectors.toList());
            AspectData conceptAspect = new AspectData();
            conceptAspect.setType(AspectType.CONCEPT);
            conceptAspect.setAspect("concept");
            conceptAspect.setAspectValue(hypercubePath.getConcept());
            aspectDataList.add(conceptAspect);
            String dimensionsString = XbrlContextDimension.dimensionsToString((List)dimensions);
            this.dimensionHashCache.computeIfAbsent((Object)dimensionsString, dimensionsString1 -> XbrlContextDimension.dimensionToHash((List)dimensions));
            String dimensionsHash = (String)this.dimensionHashCache.get((Object)dimensionsString);
            RoleCellId roleCellId = new RoleCellId();
            roleCellId.setConcept(hypercubePath.getConcept());
            roleCellId.setDimenisonsHash(dimensionsHash);
            RoleCell roleCell = new RoleCell();
            roleCell.setRoleCellId(roleCellId);
            boolean isTypedMember = !dimensions.isEmpty() && dimensions.get(dimensions.size() - 1) != null && ((XbrlContextDimension)dimensions.get(dimensions.size() - 1)).getDimensionType().equals((Object)DimensionType.TYPED_MEMBER);
            roleCell.setOpenAxis(Boolean.valueOf(isTypedMember));
            boolean enabled = hypercubePath.getHypercubeType().equals((Object)HypercubeType.ALL);
            roleCell.setEnabled(enabled);
            this.roleCells.add(roleCell);
        });
    }

    public List<HypercubeConcepts> getHypercubeConceptsList() {
        return this.hypercubeConceptsList;
    }

    private AspectData buildAspectData(XbrlContextDimension dimension) {
        AspectData aspectData = new AspectData();
        aspectData.setType(AspectType.DIMENSION);
        aspectData.setAspect(dimension.getDimension());
        aspectData.setAspectValue(dimension.getMember());
        return aspectData;
    }

    private List<DimConcept> getConcepts(DimConcept rootConcept) {
        ArrayList<DimConcept> resConcepts = new ArrayList<DimConcept>();
        resConcepts.add(rootConcept);
        for (DimConcept childConcept : rootConcept.getChildren()) {
            if (childConcept.getArcrole().equals("all") || childConcept.getArcrole().equals("notAll") || childConcept.getArcrole().equals("Axis")) continue;
            resConcepts.addAll(this.getConcepts(childConcept));
        }
        return resConcepts;
    }

    private List<List<XbrlContextDimension>> buildDimensions(DimConcept dimConcept) {
        ArrayList dimensionsAll = new ArrayList();
        dimConcept.getChildren().forEach(dimintMember -> {
            ArrayList<XbrlContextDimension> dimensions = new ArrayList<XbrlContextDimension>();
            if (dimintMember.getChildren().isEmpty()) {
                XbrlContextDimension dimension = new XbrlContextDimension(dimintMember.getName(), null);
                dimension.setDimensionType(DimensionType.TYPED_MEMBER);
                dimensions.add(dimension);
            }
            dimintMember.getChildren().forEach(memintMember -> {
                XbrlContextDimension dimension = new XbrlContextDimension(dimintMember.getName(), memintMember.getName());
                dimension.setDimensionType(DimensionType.EXPLICIT_MEMBER);
                dimensions.add(dimension);
                memintMember.getChildren().forEach(memintMember2 -> {
                    XbrlContextDimension dimension2 = new XbrlContextDimension(dimintMember.getName(), memintMember2.getName());
                    dimensions.add(dimension2);
                });
            });
            if (dimensions.stream().anyMatch(d -> d != null)) {
                dimensionsAll.add(dimensions);
            }
        });
        Integer cartesianSize = dimensionsAll.stream().map(d -> d.size()).reduce(1, (currentSize, size) -> currentSize * size);
        if (cartesianSize > 75000) {
            log.warn("Dimension cartesian product too large: {}. Role exclusions not processed", (Object)cartesianSize);
            String largeDimension = dimConcept.getChildren().stream().map(dc -> dc.getName()).sorted().collect(Collectors.joining(";"));
            log.info("Save large dimension: " + largeDimension);
            this.largeDimensions.add(largeDimension);
            this.largeDimensionHypercubes.add(new HypercubeDimensions(dimensionsAll, this.dimensionsDefault));
            return new ArrayList<List<XbrlContextDimension>>();
        }
        return MathUtils.cartesianProduct(dimensionsAll);
    }

    private void findHypercubes(List<DimConcept> dimConcepts) {
        for (DimConcept childrenConcept : dimConcepts) {
            if (childrenConcept.getArcrole() != null && childrenConcept.getArcrole().equals("all")) {
                this.addHypercube(childrenConcept.getNearParent(), childrenConcept, HypercubeType.ALL);
                continue;
            }
            if (childrenConcept.getArcrole() != null && childrenConcept.getArcrole().equals("Axis")) {
                this.addHypercube(childrenConcept.getNearParent(), childrenConcept, HypercubeType.ALL);
                continue;
            }
            if (childrenConcept.getArcrole() != null && childrenConcept.getArcrole().equals("notAll")) {
                this.addHypercube(childrenConcept.getNearParent(), childrenConcept, HypercubeType.NOT_ALL);
                continue;
            }
            this.findHypercubes(childrenConcept.getChildren());
        }
    }

    private void addHypercube(DimConcept concept, DimConcept hcConcept, HypercubeType hypercubeType) {
        Optional<HypercubeConcepts> existing = this.hypercubeConceptsList.stream().filter(hypercubeConcepts -> hypercubeConcepts.getRootConcept().getName().equals(concept.getName()) && hypercubeConcepts.getHypercube().getName().equals(hcConcept.getName()) && hypercubeConcepts.getHypercubeType().equals((Object)hypercubeType)).findFirst();
        if (!existing.isPresent()) {
            this.hypercubeConceptsList.add(new HypercubeConcepts(hcConcept, concept, hypercubeType));
        }
    }

    public static List<XbrlContextDimension> removeDefaultDimensions(List<XbrlContextDimension> dimensions, Map<String, String> dimensionsDefault) {
        if (dimensionsDefault == null) {
            return dimensions;
        }
        List<XbrlContextDimension> filtered = dimensions.stream().filter(d -> {
            if (d == null) {
                return true;
            }
            return !dimensionsDefault.containsKey(d.getDimension()) || !((String)dimensionsDefault.get(d.getDimension())).equals(d.getMember());
        }).collect(Collectors.toList());
        return filtered;
    }

    public Set<String> getLargeDimensions() {
        return this.largeDimensions;
    }

    public Set<HypercubeDimensions> getLargeDimensionHypercubes() {
        return this.largeDimensionHypercubes;
    }
}

