/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import org.apache.commons.exec.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.arelle.ArelleOutputParser;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;

@Service
public class ArelleExecutor {
    private static final Logger log = LoggerFactory.getLogger(ArelleExecutor.class);
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    private static String COMMAND_ARG_DELIMITER = " ";
    private static AtomicReference<Process> processReference = new AtomicReference();

    private ValidationEvent sendEvent(ValidationEvent validationEvent) {
        this.simpMessagingTemplate.convertAndSend((Object)"/topic/validation-event", (Object)validationEvent);
        return validationEvent;
    }

    public String commandExecute(CommandLine commandLine) throws CancelledException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(commandLine.getExecutable());
        cmd.addAll(Arrays.asList(commandLine.getArguments()));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        this.killCurrentArelleProcess();
        log.info("Execute command: " + String.join((CharSequence)COMMAND_ARG_DELIMITER, cmd));
        Thread thread = null;
        try {
            Process process = pb.start();
            processReference.set(process);
            StringBuilder outputStringBuilder = new StringBuilder();
            thread = new /* Unavailable Anonymous Inner Class!! */;
            thread.start();
            int errCode = process.waitFor();
            log.info("Process completed, errCode: " + errCode);
            if (errCode == 0) {
                String output;
                String string = output = outputStringBuilder.toString();
                return string;
            }
            try {
                throw new CancelledException();
            }
            catch (IOException e) {
                log.warn("Arelle process IOException " + e);
                throw new CancelledException();
            }
            catch (InterruptedException e) {
                log.warn("Arelle process interrupted");
                throw new CancelledException();
            }
        }
        finally {
            if (thread != null) {
                thread.interrupt();
            }
        }
    }

    private void parseLine(String line) {
        ValidationEvent validationEvent = ArelleOutputParser.parse((String)line);
        if (validationEvent != null) {
            this.sendEvent(validationEvent);
        }
    }

    public synchronized void killCurrentArelleProcess() {
        Process process = (Process)processReference.get();
        if (process != null) {
            if (process.isAlive()) {
                log.info("Destroy process: " + process + ", isAlive: " + process.isAlive());
            }
            process.destroy();
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.killCurrentArelleProcess();
    }

    static /* synthetic */ void access$000(ArelleExecutor x0, String x1) {
        x0.parseLine(x1);
    }
}

