/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.arelle.ArelleCmdOptions;
import ru.cbr.xbrl.converter.arelle.ArelleOutputParser;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArelleCmdOptions {
    private static final Logger log = LoggerFactory.getLogger(ArelleCmdOptions.class);
    private String arelleExecutable;
    private String filePath;
    private Map<String, String> parameters = new HashMap();
    private boolean validation = false;
    private boolean vFlag = false;
    private String[] packages;
    private Boolean formulaNone = false;
    private Boolean iXbrlConvert = false;
    private String labelRole;
    public static final String[] FILE_OUTPUT_OPTIONS = new String[]{"DTS", "facts", "factTable", "concepts", "pre", "cal", "dim", "formulae", "viewArcrole", "roleTypes", "arcroleTypes", "testReport", "rssReport", "logFile", "exportDir", "parametersFile", "iXbrlConvertFile", "refFile", "labelRolesFile", "namespacesFile"};
    private Map<String, String> outputFiles = new HashMap();
    private boolean saveFileOutput = false;
    private String[] enabledFileOutputOptions = null;

    public CommandLine buildCommand() throws CommandExecutionException {
        if (StringUtils.isBlank((CharSequence)this.arelleExecutable)) {
            log.error("Arelle executable not specified");
            throw new CommandExecutionException();
        }
        String[] splittedExecutable = this.arelleExecutable.split("\\s+");
        String executable = splittedExecutable[0];
        File file = new File(executable);
        String absolutePath = file.getAbsolutePath();
        ArelleCommandLine cmdLine = new ArelleCommandLine(this, absolutePath);
        Arrays.stream(splittedExecutable).skip(1L).forEach(arg -> cmdLine.addArgument(arg));
        if (this.filePath.contains(" ")) {
            try {
                String buffer = ru.cbr.xbrl.converter.utils.FileUtils.getTempFileName((String)"");
                ru.cbr.xbrl.converter.utils.FileUtils.copyFileUsingFileChannels((String)this.filePath, (String)buffer);
                this.filePath = buffer;
            }
            catch (IOException e) {
                log.error("Can't create temporary file: " + e);
            }
        }
        cmdLine.addArgumentPair("-f", this.filePath);
        if (this.validation || this.vFlag) {
            cmdLine.addArgument("-v");
        }
        if (ArrayUtils.isNotEmpty((Object[])this.packages)) {
            cmdLine.addArgumentPair("--packages", String.join((CharSequence)"|", this.packages));
        }
        if (!this.parameters.keySet().isEmpty()) {
            cmdLine.addArgumentPair("--parameters", this.parameters.entrySet().stream().map(it -> (String)it.getKey() + "=" + (String)it.getValue()).collect(Collectors.joining(",")));
        }
        if (this.saveFileOutput) {
            String[] processedFileOutputOptions = ArrayUtils.isNotEmpty((Object[])this.enabledFileOutputOptions) ? this.enabledFileOutputOptions : FILE_OUTPUT_OPTIONS;
            Arrays.stream(processedFileOutputOptions).filter(option -> !option.equals("exportDir")).forEach(option -> {
                String temporaryFileNameSuffix = "." + option + ".xml";
                String temporaryFileName = ru.cbr.xbrl.converter.utils.FileUtils.getTempFileName((String)temporaryFileNameSuffix);
                this.outputFiles.put(option, temporaryFileName);
                cmdLine.addArgumentPair("--" + option, temporaryFileName);
            });
            boolean exportDirEnabled = Arrays.stream(processedFileOutputOptions).filter(option -> option.equals("exportDir")).findFirst().isPresent();
            if (exportDirEnabled) {
                String tempDir = null;
                try {
                    tempDir = ArelleCmdOptions.generateUniqueTemporaryDir();
                    cmdLine.addArgument("--export");
                    cmdLine.addArgumentPair("--exportDir", tempDir + File.separator);
                    this.outputFiles.put("exportDir", tempDir + File.separator);
                    for (Map.Entry entry : this.outputFiles.entrySet()) {
                        log.info("OutputfilesMap: " + (String)entry.getKey() + " " + (String)entry.getValue());
                    }
                }
                catch (IOException e) {
                    log.error("Can't create temporary directory " + tempDir + ". Options --export and --exportDir not used.");
                    e.printStackTrace();
                }
            }
        }
        cmdLine.addArgumentPair("--uiLang", "ru");
        cmdLine.addArgumentPair("--labelLang", "ru-RU");
        if (this.validation) {
            this.addFormulaCommands(cmdLine);
        }
        if (this.formulaNone.booleanValue()) {
            cmdLine.addArgumentPair("--formula", "none");
        }
        if (this.iXbrlConvert.booleanValue()) {
            cmdLine.addArgument("--iXbrlConvert");
        }
        if (StringUtils.isNotBlank((CharSequence)this.labelRole)) {
            cmdLine.addArgumentPair("--labelRole", this.labelRole);
        }
        cmdLine.addArgumentPair("--logFormat", this.getLogFormat());
        return cmdLine;
    }

    private static String generateUniqueTemporaryDir() throws IOException {
        String temporaryDirRoot = FileUtils.getTempDirectoryPath();
        String uid = UUID.randomUUID().toString();
        String temporaryDir = FilenameUtils.concat((String)temporaryDirRoot, (String)uid);
        FileUtils.forceMkdir((File)new File(temporaryDir));
        return temporaryDir;
    }

    private String getLogFormat() {
        CharSequence[] optStrings = (String[])Arrays.stream(ArelleOutputParser.AVAILABLE_OPTIONS).map(o -> "%(" + o + ")s").toArray(String[]::new);
        String logFormat = String.join((CharSequence)" DIVIDER ", optStrings) + " ENDOFROW" + "\"";
        return logFormat;
    }

    private void addFormulaCommands(ArelleCommandLine cmdLine) {
        String[] formulaArgs = new String[]{};
        cmdLine.addArgument("--calcDecimal");
        cmdLine.addArgument("--infoset");
        cmdLine.addArgumentPair("--formula", "run");
        cmdLine.addArgument("--formulaUnsatisfiedAsser");
        Arrays.stream(formulaArgs).forEach(arg -> cmdLine.addArgument("--" + arg));
    }

    public String getArelleExecutable() {
        return this.arelleExecutable;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public boolean isVFlag() {
        return this.vFlag;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public Boolean getFormulaNone() {
        return this.formulaNone;
    }

    public Boolean getIXbrlConvert() {
        return this.iXbrlConvert;
    }

    public String getLabelRole() {
        return this.labelRole;
    }

    public Map<String, String> getOutputFiles() {
        return this.outputFiles;
    }

    public boolean isSaveFileOutput() {
        return this.saveFileOutput;
    }

    public String[] getEnabledFileOutputOptions() {
        return this.enabledFileOutputOptions;
    }

    public void setArelleExecutable(String arelleExecutable) {
        this.arelleExecutable = arelleExecutable;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public void setVFlag(boolean vFlag) {
        this.vFlag = vFlag;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public void setFormulaNone(Boolean formulaNone) {
        this.formulaNone = formulaNone;
    }

    public void setIXbrlConvert(Boolean iXbrlConvert) {
        this.iXbrlConvert = iXbrlConvert;
    }

    public void setLabelRole(String labelRole) {
        this.labelRole = labelRole;
    }

    public void setOutputFiles(Map<String, String> outputFiles) {
        this.outputFiles = outputFiles;
    }

    public void setSaveFileOutput(boolean saveFileOutput) {
        this.saveFileOutput = saveFileOutput;
    }

    public void setEnabledFileOutputOptions(String[] enabledFileOutputOptions) {
        this.enabledFileOutputOptions = enabledFileOutputOptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArelleCmdOptions)) {
            return false;
        }
        ArelleCmdOptions other = (ArelleCmdOptions)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$arelleExecutable = this.getArelleExecutable();
        String other$arelleExecutable = other.getArelleExecutable();
        if (this$arelleExecutable == null ? other$arelleExecutable != null : !this$arelleExecutable.equals(other$arelleExecutable)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        Map this$parameters = this.getParameters();
        Map other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        if (this.isValidation() != other.isValidation()) {
            return false;
        }
        if (this.isVFlag() != other.isVFlag()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPackages(), other.getPackages())) {
            return false;
        }
        Boolean this$formulaNone = this.getFormulaNone();
        Boolean other$formulaNone = other.getFormulaNone();
        if (this$formulaNone == null ? other$formulaNone != null : !((Object)this$formulaNone).equals(other$formulaNone)) {
            return false;
        }
        Boolean this$iXbrlConvert = this.getIXbrlConvert();
        Boolean other$iXbrlConvert = other.getIXbrlConvert();
        if (this$iXbrlConvert == null ? other$iXbrlConvert != null : !((Object)this$iXbrlConvert).equals(other$iXbrlConvert)) {
            return false;
        }
        String this$labelRole = this.getLabelRole();
        String other$labelRole = other.getLabelRole();
        if (this$labelRole == null ? other$labelRole != null : !this$labelRole.equals(other$labelRole)) {
            return false;
        }
        Map this$outputFiles = this.getOutputFiles();
        Map other$outputFiles = other.getOutputFiles();
        if (this$outputFiles == null ? other$outputFiles != null : !((Object)this$outputFiles).equals(other$outputFiles)) {
            return false;
        }
        if (this.isSaveFileOutput() != other.isSaveFileOutput()) {
            return false;
        }
        return Arrays.deepEquals(this.getEnabledFileOutputOptions(), other.getEnabledFileOutputOptions());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArelleCmdOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $arelleExecutable = this.getArelleExecutable();
        result = result * 59 + ($arelleExecutable == null ? 43 : $arelleExecutable.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        Map $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        result = result * 59 + (this.isValidation() ? 79 : 97);
        result = result * 59 + (this.isVFlag() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getPackages());
        Boolean $formulaNone = this.getFormulaNone();
        result = result * 59 + ($formulaNone == null ? 43 : ((Object)$formulaNone).hashCode());
        Boolean $iXbrlConvert = this.getIXbrlConvert();
        result = result * 59 + ($iXbrlConvert == null ? 43 : ((Object)$iXbrlConvert).hashCode());
        String $labelRole = this.getLabelRole();
        result = result * 59 + ($labelRole == null ? 43 : $labelRole.hashCode());
        Map $outputFiles = this.getOutputFiles();
        result = result * 59 + ($outputFiles == null ? 43 : ((Object)$outputFiles).hashCode());
        result = result * 59 + (this.isSaveFileOutput() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getEnabledFileOutputOptions());
        return result;
    }

    public String toString() {
        return "ArelleCmdOptions(arelleExecutable=" + this.getArelleExecutable() + ", filePath=" + this.getFilePath() + ", parameters=" + this.getParameters() + ", validation=" + this.isValidation() + ", vFlag=" + this.isVFlag() + ", packages=" + Arrays.deepToString(this.getPackages()) + ", formulaNone=" + this.getFormulaNone() + ", iXbrlConvert=" + this.getIXbrlConvert() + ", labelRole=" + this.getLabelRole() + ", outputFiles=" + this.getOutputFiles() + ", saveFileOutput=" + this.isSaveFileOutput() + ", enabledFileOutputOptions=" + Arrays.deepToString(this.getEnabledFileOutputOptions()) + ")";
    }
}

