/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.arelle;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.arelle.ArelleCmdOptions;
import ru.cbr.xbrl.converter.arelle.ArelleOutputParser;
import ru.cbr.xbrl.converter.arelle.ArelleService;
import ru.cbr.xbrl.converter.arelle.data.XbrlParsedData;
import ru.cbr.xbrl.converter.arelle.executor.ArelleExecutor;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.validation.CsvLineInfo;
import ru.cbr.xbrl.converter.model.validation.ValidationEvent;
import ru.cbr.xbrl.converter.model.validation.ValidationLogEntry;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlPeriodService;
import ru.cbr.xbrl.converter.service.import_export.CsvLineInfoService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.label_linkbase.LabelLinkbaseService;
import ru.cbr.xbrl.converter.service.log.EventLogService;
import ru.cbr.xbrl.converter.utils.FileUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvCommon;

@Service
public class ArelleCliService
implements ArelleService {
    private static final Logger log = LoggerFactory.getLogger(ArelleCliService.class);
    public static final String XML_SCHEMA_SYNTAX = "xmlSchema:syntax";
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private ArelleExecutor arelleExecutor;
    @Autowired
    private XbrlPeriodService xbrlPeriodService;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    private boolean isLastActionCancelled = false;
    @Autowired
    private EventLogService eventLogService;
    @Autowired
    private CsvLineInfoService csvLineInfoService;
    @Autowired
    private LabelLinkbaseService labelLinkbaseService;
    private static final String XBRLDIE_ILLEGAL_TYPED_DIMENSION_CONTENT_ERROR = "xbrldie:IllegalTypedDimensionContentError";
    private static final String XBRLDIE_PRIMARY_ITEM_DIMENSIONALLY_INVALID_ERROR = "xbrldie:PrimaryItemDimensionallyInvalidError";

    public XbrlParsedData read(String xbrlFile, String[] packages) throws CommandExecutionException, CancelledException {
        ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
        cmdOptions.setArelleExecutable(this.configProperties.getArelleExecutable());
        cmdOptions.setFilePath(xbrlFile);
        cmdOptions.setValidation(Boolean.FALSE.booleanValue());
        cmdOptions.setPackages(packages);
        cmdOptions.setSaveFileOutput(Boolean.TRUE.booleanValue());
        this.setDateParameters(cmdOptions);
        CommandLine command = cmdOptions.buildCommand();
        String output = this.arelleExecutor.commandExecute(command);
        Map<String, String> dataMap = Arrays.stream(ArelleCmdOptions.FILE_OUTPUT_OPTIONS).collect(Collectors.toMap(o -> o, o -> FileUtils.readTextFile((String)((String)cmdOptions.getOutputFiles().get(o)))));
        XbrlParsedData outputData = new XbrlParsedData(dataMap);
        outputData.setOutput(output);
        return outputData;
    }

    public String convertIxbrlToXml(String xbrlFile, String[] packages) throws CommandExecutionException, CancelledException {
        String iXbrlConvertFileOption = "iXbrlConvertFile";
        String logFile = "logFile";
        String[] fileOutputOptions = new String[]{iXbrlConvertFileOption, logFile};
        Date startProcessing = new Date();
        log.info("Getting output files using arelle started...");
        ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
        cmdOptions.setArelleExecutable(this.configProperties.getArelleExecutable());
        cmdOptions.setFilePath(xbrlFile);
        cmdOptions.setIXbrlConvert(Boolean.TRUE);
        cmdOptions.setVFlag(Boolean.FALSE.booleanValue());
        cmdOptions.setValidation(Boolean.FALSE.booleanValue());
        cmdOptions.setFormulaNone(Boolean.valueOf(true));
        cmdOptions.setPackages(packages);
        cmdOptions.setSaveFileOutput(Boolean.TRUE.booleanValue());
        cmdOptions.setEnabledFileOutputOptions(fileOutputOptions);
        CommandLine command = cmdOptions.buildCommand();
        String output = this.arelleExecutor.commandExecute(command);
        log.info("Getting output files using arelle started completed in " + (new Date().getTime() - startProcessing.getTime()) + " msec");
        return (String)cmdOptions.getOutputFiles().get(iXbrlConvertFileOption);
    }

    public boolean checkXbrlFile(String xbrlFile, String[] packages, EventLog.EventLogType eventLogType) throws CommandExecutionException, CancelledException {
        String[] fileOutputOptions = new String[]{"logFile"};
        Date startProcessing = new Date();
        log.info("Getting output files using arelle started...");
        String logFile = "logFile";
        ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
        cmdOptions.setArelleExecutable(this.configProperties.getArelleExecutable());
        cmdOptions.setFilePath(xbrlFile);
        cmdOptions.setValidation(Boolean.FALSE.booleanValue());
        cmdOptions.setVFlag(Boolean.TRUE.booleanValue());
        cmdOptions.setPackages(packages);
        cmdOptions.setSaveFileOutput(Boolean.TRUE.booleanValue());
        cmdOptions.setEnabledFileOutputOptions(fileOutputOptions);
        cmdOptions.setFormulaNone(Boolean.valueOf(true));
        this.setDateParameters(cmdOptions);
        CommandLine command = cmdOptions.buildCommand();
        String output = this.arelleExecutor.commandExecute(command);
        String logFilePath = (String)cmdOptions.getOutputFiles().get(logFile);
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        Long xbrlReportId = xbrlPackage.getXbrlReport().getId();
        AtomicBoolean valid = new AtomicBoolean(Boolean.TRUE);
        ArelleOutputParser.parseXmlValidation((String)logFilePath, (XbrlReport)new XbrlReport(), (Boolean)Boolean.FALSE, validationLogEntry -> {
            String level = validationLogEntry.getLevel();
            if (!(level == null || !level.toLowerCase().equals("error") || validationLogEntry.getCode().startsWith("xbrlte:") || validationLogEntry.getCode().startsWith("err:") || validationLogEntry.getCode().startsWith("xfie:") || validationLogEntry.getCode().startsWith("xbrlve:") || validationLogEntry.getCode().startsWith("xmlSchema:valueError") || validationLogEntry.getCode().equals("IOerror") || validationLogEntry.getCode().equals("xbrl:schemaImportMissing") || validationLogEntry.getCode().contains("simpleLinkHref") || validationLogEntry.getCode().equals("xbrl.4.11.1.1:instanceLoc") || validationLogEntry.getCode().equals("xbrl.3.5.4:hrefIdNotFound") || validationLogEntry.getCode().equals("xbrl.4.11.1.1:footnoteLinkLocTarget") || validationLogEntry.getCode().equals("xmlSchema1.4.2.3:refSchemaNamespace"))) {
                if (this.processContextError(validationLogEntry, xbrlPackage.getXbrlReport()).booleanValue()) {
                    return;
                }
                valid.set(Boolean.FALSE);
                EventLog eventLog = new EventLog();
                eventLog.setEventLogType(eventLogType);
                eventLog.setMessage(validationLogEntry.getMessage());
                eventLog.setXbrlReportId(xbrlReportId);
                this.eventLogService.createInNewTransaction(eventLog);
            }
        });
        log.info("Getting output files using arelle started completed in " + (new Date().getTime() - startProcessing.getTime()) + " msec");
        return valid.get();
    }

    private Boolean processContextError(ValidationLogEntry validationLogEntry, XbrlReport xbrlReport) {
        if (validationLogEntry == null) {
            return false;
        }
        String code = validationLogEntry.getCode();
        if (StringUtils.isBlank((CharSequence)code)) {
            return false;
        }
        switch (code) {
            case "xbrldie:IllegalTypedDimensionContentError": {
                Map messageAttributeMap = validationLogEntry.getMessageAttributeMap();
                if (CollectionUtils.isEmpty((Map)messageAttributeMap)) {
                    log.warn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 CSV. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0432 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430\u0445 message");
                    return false;
                }
                String contextID = (String)messageAttributeMap.get("contextID");
                if (StringUtils.isBlank((CharSequence)contextID)) {
                    log.warn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 CSV. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 contextID \u0438\u043b\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442. \r\n" + messageAttributeMap.toString());
                    return false;
                }
                List csvLineInfoList = this.csvLineInfoService.findByCsvIdAndType(contextID, CsvCommon.CSV_SOURCE_FILES.CONTEXTS);
                if (CollectionUtils.isEmpty((Collection)csvLineInfoList)) {
                    log.warn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 CSV. \u041f\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u0432 \u043b\u043e\u0433\u0430\u0445 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 contextID {} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u043e\u0432 \u0438\u0437 CSV.", (Object)contextID);
                    return false;
                }
                CsvLineInfo csvLineInfo = (CsvLineInfo)csvLineInfoList.iterator().next();
                if (csvLineInfo == null) {
                    return false;
                }
                Integer lineNumber = csvLineInfo.getLineNumber();
                this.eventLogService.createCsvEventLogMessageInNewTransaction(String.format("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0442\u0435\u0433 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u0434\u043b\u044f \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043c\u043d\u043e\u0433\u043e\u043c\u0435\u0440\u043d\u044b\u0445 \u0430\u043d\u0430\u043b\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0440\u0430\u0437\u0440\u0435\u0437\u043e\u0432 \u043f\u043e \u0441\u0442\u0440\u043e\u043a\u0435 %s \u0432 \u0444\u0430\u0439\u043b\u0435 Context.csv", lineNumber), CsvCommon.CSV_SOURCE_FILES.CONTEXTS.name(), Integer.toString(lineNumber), xbrlReport);
                return true;
            }
            case "xbrldie:PrimaryItemDimensionallyInvalidError": {
                Map messageAttributeMap = validationLogEntry.getMessageAttributeMap();
                if (CollectionUtils.isEmpty((Map)messageAttributeMap)) {
                    log.warn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 CSV. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0432 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430\u0445 message");
                    return false;
                }
                String contextID = (String)messageAttributeMap.get("contextID");
                String fact = (String)messageAttributeMap.get("fact");
                if (StringUtils.isBlank((CharSequence)contextID)) {
                    log.warn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 CSV. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 contextID \u0438\u043b\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442. \r\n" + messageAttributeMap.toString());
                    return false;
                }
                List csvLineInfoList = this.csvLineInfoService.findByCsvIdAndType(contextID, CsvCommon.CSV_SOURCE_FILES.CONTEXTS);
                if (CollectionUtils.isEmpty((Collection)csvLineInfoList)) {
                    log.warn("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 CSV. \u041f\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u0432 \u043b\u043e\u0433\u0430\u0445 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 contextID {} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u043e\u0432 \u0438\u0437 CSV.", (Object)contextID);
                    return false;
                }
                CsvLineInfo csvLineInfo = (CsvLineInfo)csvLineInfoList.iterator().next();
                if (csvLineInfo == null) {
                    return false;
                }
                Integer lineNumber = csvLineInfo.getLineNumber();
                this.eventLogService.createCsvEventLogMessageInNewTransaction(String.format("\u0410\u043d\u0430\u043b\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0440\u0430\u0437\u0440\u0435\u0437 \u043f\u043e \u0441\u0442\u0440\u043e\u043a\u0435 %s \u0432 \u0444\u0430\u0439\u043b\u0435 \u00abContext.csv\u00bb \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0432 \u0442\u0430\u043a\u0441\u043e\u043d\u043e\u043c\u0438\u0438 \u0434\u043b\u044f \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0433\u043e \u043a\u043e\u043d\u0446\u0435\u043f\u0442\u0430 %s.", lineNumber, fact), CsvCommon.CSV_SOURCE_FILES.CONTEXTS.name(), Integer.toString(lineNumber), xbrlReport);
                return true;
            }
            case "xmlSchema:syntax": {
                String fileName = (String)validationLogEntry.getMessageAttributeMap().get("fileName");
                String lineNumber = (String)validationLogEntry.getMessageAttributeMap().get("line");
                String columnNumber = (String)validationLogEntry.getMessageAttributeMap().get("column");
                String errorMessage = (String)validationLogEntry.getMessageAttributeMap().get("error");
                validationLogEntry.setMessage(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441\u0430 \u0432 \u0444\u0430\u0439\u043b\u0435 \"%s\". \u0421\u0442\u0440\u043e\u043a\u0430: %s, \u043f\u043e\u0437\u0438\u0446\u0438\u044f: %s. \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: %s", fileName, lineNumber, columnNumber, errorMessage));
                return false;
            }
        }
        return false;
    }

    public Map<String, String> saveOutputFiles(String xbrlFile, String[] packages, String[] fileOutputOptions) throws CommandExecutionException, CancelledException {
        Date startProcessing = new Date();
        log.info("Getting output files using arelle started...");
        ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
        cmdOptions.setArelleExecutable(this.configProperties.getArelleExecutable());
        cmdOptions.setFilePath(xbrlFile);
        cmdOptions.setVFlag(Boolean.FALSE.booleanValue());
        cmdOptions.setValidation(Boolean.FALSE.booleanValue());
        cmdOptions.setFormulaNone(Boolean.valueOf(true));
        cmdOptions.setPackages(packages);
        cmdOptions.setSaveFileOutput(Boolean.TRUE.booleanValue());
        cmdOptions.setEnabledFileOutputOptions(fileOutputOptions);
        String activeLabelRole = this.labelLinkbaseService.getActiveLabelRole();
        if (StringUtils.isNotBlank((CharSequence)activeLabelRole)) {
            cmdOptions.setLabelRole(activeLabelRole);
        }
        this.setDateParameters(cmdOptions);
        CommandLine command = cmdOptions.buildCommand();
        String output = this.arelleExecutor.commandExecute(command);
        log.info("Getting output files using arelle started completed in " + (new Date().getTime() - startProcessing.getTime()) + " msec");
        return cmdOptions.getOutputFiles();
    }

    public List<ValidationEvent> validate(XbrlReport xbrlReport, String[] packages) throws CommandExecutionException, CancelledException {
        return this.validate(xbrlReport, xbrlReport.getFilePath(), packages);
    }

    public List<ValidationEvent> validate(XbrlReport xbrlReport, String xbrlFilePath, String[] packages) throws CommandExecutionException, CancelledException {
        String logFile = "logFile";
        ArelleCmdOptions cmdOptions = new ArelleCmdOptions();
        cmdOptions.setArelleExecutable(this.configProperties.getArelleExecutable());
        cmdOptions.setFilePath(xbrlFilePath);
        cmdOptions.setValidation(Boolean.TRUE.booleanValue());
        cmdOptions.setSaveFileOutput(Boolean.TRUE.booleanValue());
        String[] options = new String[]{logFile};
        cmdOptions.setEnabledFileOutputOptions(options);
        cmdOptions.setPackages(packages);
        this.setDateParameters(cmdOptions);
        CommandLine command = cmdOptions.buildCommand();
        log.info("Validation started...");
        Date validationStartDate = new Date();
        if (ArelleOutputParser.getIsLastActionCancelled()) {
            return null;
        }
        String resultString = this.arelleExecutor.commandExecute(command);
        log.info("Validation completed in " + (new Date().getTime() - validationStartDate.getTime()) + " msec");
        String logFilePath = (String)cmdOptions.getOutputFiles().get(logFile);
        return ArelleOutputParser.parseXmlValidation((String)logFilePath, (XbrlReport)xbrlReport);
    }

    public void killCurrentArelleProcess() {
        this.arelleExecutor.killCurrentArelleProcess();
    }

    private void setDateParameters(ArelleCmdOptions cmdOptions) {
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        if (xbrlPackage != null && !xbrlPackage.getXbrlParameters().isEmpty()) {
            HashMap periodsParam = new HashMap();
            List parameters = xbrlPackage.getXbrlParameters();
            parameters.forEach(xbrlParameter -> {
                String[] splitted = xbrlParameter.getQName().split(":");
                String par = splitted[1];
                String key = "{http://parameters}" + par;
                periodsParam.put(key, PeriodDates.formatDate((Date)xbrlParameter.getValue()));
            });
            cmdOptions.setParameters(periodsParam);
            return;
        }
        XbrlPeriod defaultPeriod = this.xbrlPeriodService.getDefaultPeriod();
        if (defaultPeriod == null) {
            log.warn("Not found default period!!");
            return;
        }
        HashMap<String, String> periodsParam = new HashMap<String, String>();
        periodsParam.put("{http://parameters}refPeriodEnd", PeriodDates.formatDate((Date)defaultPeriod.getEnd()));
        cmdOptions.setParameters(periodsParam);
    }

    public void setLastActionCancelled(boolean lastActionCancelled) {
        this.isLastActionCancelled = lastActionCancelled;
    }
}

