/**
 * DevExtreme (ui/scheduler/ui.scheduler.work_space_week.js)
 * Version: 17.1.6
 * Build date: Tue Sep 05 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
var $ = require("../../core/renderer"),
    registerComponent = require("../../core/component_registrator"),
    SchedulerWorkSpace = require("./ui.scheduler.work_space");
var WEEK_CLASS = "dx-scheduler-work-space-week";
var SchedulerWorkSpaceWeek = SchedulerWorkSpace.inherit({
    _getElementClass: function() {
        return WEEK_CLASS
    },
    _getRowCount: function() {
        return this._getCellCountInDay()
    },
    _getCellCount: function() {
        return 7
    },
    _getDateByIndex: function(headerIndex) {
        var resultDate = new Date(this._firstViewDate);
        resultDate.setDate(this._firstViewDate.getDate() + headerIndex);
        return resultDate
    },
    _getFormat: function() {
        return this._formatWeekdayAndDay
    },
    _getCellsBetween: function($first, $last) {
        if (this._hasAllDayClass($last)) {
            return this.callBase($first, $last)
        }
        var $cells = this._getCells(),
            firstColumn = $first.index(),
            firstRow = $first.parent().index(),
            lastColumn = $last.index(),
            lastRow = $last.parent().index(),
            groupCount = this._getGroupCount(),
            cellCount = groupCount > 0 ? this._getTotalCellCount(groupCount) : this._getCellCount(),
            rowCount = this._getTotalRowCount(groupCount),
            result = [];
        for (var i = 0; i < cellCount; i++) {
            for (var j = 0; j < rowCount; j++) {
                var cell = $cells.get(cellCount * j + i);
                result.push(cell)
            }
        }
        var newFirstIndex = rowCount * firstColumn + firstRow,
            newLastIndex = rowCount * lastColumn + lastRow;
        if (newFirstIndex > newLastIndex) {
            var buffer = newFirstIndex;
            newFirstIndex = newLastIndex;
            newLastIndex = buffer
        }
        $cells = $(result).slice(newFirstIndex, newLastIndex + 1);
        if (!!this._getGroupCount()) {
            var arr = [],
                focusedGroupIndex = this._getGroupIndexByCell($first);
            $.each($cells, function(_, cell) {
                var groupIndex = this._getGroupIndexByCell($(cell));
                if (focusedGroupIndex === groupIndex) {
                    arr.push(cell)
                }
            }.bind(this));
            $cells = $(arr)
        }
        return $cells
    },
    _getRightCell: function(isMultiSelection) {
        if (!isMultiSelection) {
            return this.callBase(isMultiSelection)
        }
        var $rightCell, $focusedCell = this._$focusedCell,
            groupCount = this._getGroupCount(),
            rowCellCount = isMultiSelection ? this._getCellCount() : this._getTotalCellCount(groupCount),
            edgeCellIndex = this._isRTL() ? 0 : rowCellCount - 1,
            direction = this._isRTL() ? "prev" : "next";
        if ($focusedCell.index() === edgeCellIndex || this._isGroupEndCell($focusedCell)) {
            $rightCell = $focusedCell
        } else {
            $rightCell = $focusedCell[direction]();
            $rightCell = this._checkForViewBounds($rightCell)
        }
        return $rightCell
    },
    _getLeftCell: function(isMultiSelection) {
        if (!isMultiSelection) {
            return this.callBase(isMultiSelection)
        }
        var $leftCell, $focusedCell = this._$focusedCell,
            groupCount = this._getGroupCount(),
            rowCellCount = isMultiSelection ? this._getCellCount() : this._getTotalCellCount(groupCount),
            edgeCellIndex = this._isRTL() ? rowCellCount - 1 : 0,
            direction = this._isRTL() ? "next" : "prev";
        if ($focusedCell.index() === edgeCellIndex || this._isGroupStartCell($focusedCell)) {
            $leftCell = $focusedCell
        } else {
            $leftCell = $focusedCell[direction]();
            $leftCell = this._checkForViewBounds($leftCell)
        }
        return $leftCell
    }
});
registerComponent("dxSchedulerWorkSpaceWeek", SchedulerWorkSpaceWeek);
module.exports = SchedulerWorkSpaceWeek;
