/**
 * DevExtreme (ui/grid_core/ui.grid_core.sorting.js)
 * Version: 17.1.6
 * Build date: Tue Sep 05 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
var $ = require("../../core/renderer"),
    clickEvent = require("../../events/click"),
    commonUtils = require("../../core/utils/common"),
    extend = require("../../core/utils/extend").extend,
    sortingMixin = require("../grid_core/ui.grid_core.sorting_mixin"),
    messageLocalization = require("../../localization/message"),
    eventUtils = require("../../events/utils");
var COLUMN_HEADERS_VIEW_NAMESPACE = "dxDataGridColumnHeadersView";
var ColumnHeadersViewSortingExtender = extend({}, sortingMixin, {
    _createRow: function(row) {
        var that = this,
            $row = that.callBase(row);
        if ("header" === row.rowType) {
            $row.on(eventUtils.addNamespace(clickEvent.name, COLUMN_HEADERS_VIEW_NAMESPACE), "> td", that.createAction(function(e) {
                var keyName = null,
                    event = e.jQueryEvent,
                    $cellElementFromEvent = $(event.currentTarget),
                    rowIndex = $cellElementFromEvent.parent().index(),
                    columnIndex = $.map(that.getCellElements(rowIndex), function($cellElement, index) {
                        if ($cellElement === $cellElementFromEvent.get(0)) {
                            return index
                        }
                    })[0],
                    visibleColumns = that._columnsController.getVisibleColumns(rowIndex),
                    column = visibleColumns[columnIndex],
                    editingController = that.getController("editing"),
                    editingMode = that.option("editing.mode"),
                    isCellEditing = editingController && editingController.isEditing() && ("batch" === editingMode || "cell" === editingMode);
                if (isCellEditing || !that._isSortableElement($(event.target))) {
                    return
                }
                if (column && !commonUtils.isDefined(column.groupIndex) && !column.command) {
                    if (event.shiftKey) {
                        keyName = "shift"
                    } else {
                        if (event.ctrlKey) {
                            keyName = "ctrl"
                        }
                    }
                    setTimeout(function() {
                        that._columnsController.changeSortOrder(column.index, keyName)
                    })
                }
            }))
        }
        return $row
    },
    _renderCellContent: function($cell, options) {
        var that = this,
            column = options.column;
        if (!column.command && "header" === options.rowType) {
            that._applyColumnState({
                name: "sort",
                rootElement: $cell,
                column: column,
                showColumnLines: that.option("showColumnLines")
            })
        }
        that.callBase($cell, options)
    },
    _columnOptionChanged: function(e) {
        var changeTypes = e.changeTypes;
        if (1 === changeTypes.length && changeTypes.sorting) {
            this._updateIndicators("sort");
            return
        }
        this.callBase(e)
    },
    optionChanged: function(args) {
        var that = this;
        switch (args.name) {
            case "sorting":
                that._invalidate();
                args.handled = true;
                break;
            default:
                that.callBase(args)
        }
    }
});
var HeaderPanelSortingExtender = extend({}, sortingMixin, {
    _createGroupPanelItem: function($rootElement, groupColumn) {
        var that = this,
            $item = that.callBase.apply(that, arguments);
        $item.on(eventUtils.addNamespace(clickEvent.name, "dxDataGridHeaderPanel"), that.createAction(function() {
            setTimeout(function() {
                that.getController("columns").changeSortOrder(groupColumn.index)
            })
        }));
        that._applyColumnState({
            name: "sort",
            rootElement: $item,
            column: {
                alignment: that.option("rtlEnabled") ? "right" : "left",
                allowSorting: groupColumn.allowSorting,
                sortOrder: "desc" === groupColumn.sortOrder ? "desc" : "asc"
            },
            showColumnLines: true
        });
        return $item
    },
    optionChanged: function(args) {
        var that = this;
        switch (args.name) {
            case "sorting":
                that._invalidate();
                args.handled = true;
                break;
            default:
                that.callBase(args)
        }
    }
});
module.exports = {
    defaultOptions: function() {
        return {
            sorting: {
                mode: "single",
                ascendingText: messageLocalization.format("dxDataGrid-sortingAscendingText"),
                descendingText: messageLocalization.format("dxDataGrid-sortingDescendingText"),
                clearText: messageLocalization.format("dxDataGrid-sortingClearText")
            }
        }
    },
    extenders: {
        views: {
            columnHeadersView: ColumnHeadersViewSortingExtender,
            headerPanel: HeaderPanelSortingExtender
        }
    }
};
