/*!
 * devextreme-angular
 * Version: 17.1.6
 * Build date: Wed Sep 06 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { ElementRef, NgZone, OnDestroy, OnChanges, DoCheck, SimpleChanges, QueryList } from '@angular/core';
import DxMap from 'devextreme/ui/map';
import { DxComponent } from '../core/component';
import { DxTemplateHost } from '../core/template-host';
import { NestedOptionHost } from '../core/nested-option';
import { WatcherHelper } from '../core/watcher-helper';
import { IterableDifferHelper } from '../core/iterable-differ-helper';
import { DxiCenterComponent } from './nested/center-dxi';
import { DxiMarkerComponent } from './nested/marker-dxi';
import { DxiRouteComponent } from './nested/route-dxi';
export declare class DxMapComponent extends DxComponent implements OnDestroy, OnChanges, DoCheck {
    private _watcherHelper;
    private _idh;
    instance: DxMap;
    accessKey: any;
    activeStateEnabled: any;
    autoAdjust: any;
    center: any;
    controls: any;
    disabled: any;
    elementAttr: any;
    focusStateEnabled: any;
    height: any;
    hint: any;
    hoverStateEnabled: any;
    key: any;
    markerIconSrc: any;
    markers: any;
    provider: any;
    routes: any;
    rtlEnabled: any;
    tabIndex: any;
    type: any;
    visible: any;
    width: any;
    zoom: any;
    onClick: any;
    onDisposing: any;
    onInitialized: any;
    onMarkerAdded: any;
    onMarkerRemoved: any;
    onOptionChanged: any;
    onReady: any;
    onRouteAdded: any;
    onRouteRemoved: any;
    accessKeyChange: any;
    activeStateEnabledChange: any;
    autoAdjustChange: any;
    centerChange: any;
    controlsChange: any;
    disabledChange: any;
    elementAttrChange: any;
    focusStateEnabledChange: any;
    heightChange: any;
    hintChange: any;
    hoverStateEnabledChange: any;
    keyChange: any;
    markerIconSrcChange: any;
    markersChange: any;
    providerChange: any;
    routesChange: any;
    rtlEnabledChange: any;
    tabIndexChange: any;
    typeChange: any;
    visibleChange: any;
    widthChange: any;
    zoomChange: any;
    centerChildren: QueryList<DxiCenterComponent>;
    markersChildren: QueryList<DxiMarkerComponent>;
    routesChildren: QueryList<DxiRouteComponent>;
    constructor(elementRef: ElementRef, ngZone: NgZone, templateHost: DxTemplateHost, _watcherHelper: WatcherHelper, _idh: IterableDifferHelper, optionHost: NestedOptionHost);
    protected _createInstance(element: any, options: any): DxMap;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngDoCheck(): void;
    _setOption(name: string, value: any): void;
}
export declare class DxMapModule {
}
