/*!
 * devextreme-angular
 * Version: 17.1.6
 * Build date: Wed Sep 06 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { ElementRef, NgZone, OnDestroy, OnChanges, DoCheck, SimpleChanges, QueryList } from '@angular/core';
import DxChart from 'devextreme/viz/chart';
import { DxComponent } from '../core/component';
import { DxTemplateHost } from '../core/template-host';
import { NestedOptionHost } from '../core/nested-option';
import { WatcherHelper } from '../core/watcher-helper';
import { IterableDifferHelper } from '../core/iterable-differ-helper';
import { DxiPaneComponent } from './nested/pane-dxi';
import { DxiSeriesComponent } from './nested/series-dxi';
import { DxiValueAxisComponent } from './nested/value-axis-dxi';
export declare class DxChartComponent extends DxComponent implements OnDestroy, OnChanges, DoCheck {
    private _watcherHelper;
    private _idh;
    instance: DxChart;
    adaptiveLayout: any;
    adjustOnZoom: any;
    animation: any;
    argumentAxis: any;
    barWidth: any;
    commonAxisSettings: any;
    commonPaneSettings: any;
    commonSeriesSettings: any;
    containerBackgroundColor: any;
    crosshair: any;
    customizeLabel: any;
    customizePoint: any;
    dataPrepareSettings: any;
    dataSource: any;
    defaultPane: any;
    elementAttr: any;
    equalBarWidth: any;
    export: any;
    legend: any;
    loadingIndicator: any;
    margin: any;
    maxBubbleSize: any;
    minBubbleSize: any;
    negativesAsZeroes: any;
    palette: any;
    panes: any;
    pathModified: any;
    pointSelectionMode: any;
    redrawOnResize: any;
    resolveLabelOverlapping: any;
    rotated: any;
    rtlEnabled: any;
    scrollBar: any;
    scrollingMode: any;
    series: any;
    seriesSelectionMode: any;
    seriesTemplate: any;
    size: any;
    synchronizeMultiAxes: any;
    theme: any;
    title: any;
    tooltip: any;
    useAggregation: any;
    valueAxis: any;
    zoomingMode: any;
    onArgumentAxisClick: any;
    onDisposing: any;
    onDone: any;
    onDrawn: any;
    onExported: any;
    onExporting: any;
    onFileSaving: any;
    onIncidentOccurred: any;
    onInitialized: any;
    onLegendClick: any;
    onOptionChanged: any;
    onPointClick: any;
    onPointHoverChanged: any;
    onPointSelectionChanged: any;
    onSeriesClick: any;
    onSeriesHoverChanged: any;
    onSeriesSelectionChanged: any;
    onTooltipHidden: any;
    onTooltipShown: any;
    onZoomEnd: any;
    onZoomStart: any;
    adaptiveLayoutChange: any;
    adjustOnZoomChange: any;
    animationChange: any;
    argumentAxisChange: any;
    barWidthChange: any;
    commonAxisSettingsChange: any;
    commonPaneSettingsChange: any;
    commonSeriesSettingsChange: any;
    containerBackgroundColorChange: any;
    crosshairChange: any;
    customizeLabelChange: any;
    customizePointChange: any;
    dataPrepareSettingsChange: any;
    dataSourceChange: any;
    defaultPaneChange: any;
    elementAttrChange: any;
    equalBarWidthChange: any;
    exportChange: any;
    legendChange: any;
    loadingIndicatorChange: any;
    marginChange: any;
    maxBubbleSizeChange: any;
    minBubbleSizeChange: any;
    negativesAsZeroesChange: any;
    paletteChange: any;
    panesChange: any;
    pathModifiedChange: any;
    pointSelectionModeChange: any;
    redrawOnResizeChange: any;
    resolveLabelOverlappingChange: any;
    rotatedChange: any;
    rtlEnabledChange: any;
    scrollBarChange: any;
    scrollingModeChange: any;
    seriesChange: any;
    seriesSelectionModeChange: any;
    seriesTemplateChange: any;
    sizeChange: any;
    synchronizeMultiAxesChange: any;
    themeChange: any;
    titleChange: any;
    tooltipChange: any;
    useAggregationChange: any;
    valueAxisChange: any;
    zoomingModeChange: any;
    panesChildren: QueryList<DxiPaneComponent>;
    seriesChildren: QueryList<DxiSeriesComponent>;
    valueAxisChildren: QueryList<DxiValueAxisComponent>;
    constructor(elementRef: ElementRef, ngZone: NgZone, templateHost: DxTemplateHost, _watcherHelper: WatcherHelper, _idh: IterableDifferHelper, optionHost: NestedOptionHost);
    protected _createInstance(element: any, options: any): DxChart;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngDoCheck(): void;
    _setOption(name: string, value: any): void;
}
export declare class DxChartModule {
}
