/*!
 * devextreme-angular
 * Version: 17.1.6
 * Build date: Wed Sep 06 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var events_strategy_1 = require('./events-strategy');
var nested_option_1 = require('./nested-option');
var DxComponent = (function () {
    function DxComponent(element, ngZone, templateHost, watcherHelper) {
        this.element = element;
        this.ngZone = ngZone;
        this.watcherHelper = watcherHelper;
        this._optionToUpdate = {};
        this.changedOptions = {};
        this.renderOnViewInit = true;
        this.templates = [];
        templateHost.setHost(this);
        this._collectionContainerImpl = new nested_option_1.CollectionNestedOptionContainerImpl(this._setOption.bind(this));
        this.eventHelper = new events_strategy_1.EmitterHelper(this.ngZone, this);
    }
    DxComponent.prototype._initTemplates = function () {
        if (this.templates.length) {
            var initialTemplates_1 = {};
            this.templates.forEach(function (template) {
                initialTemplates_1[template.name] = template;
            });
            this._optionToUpdate.integrationOptions.templates = initialTemplates_1;
        }
    };
    DxComponent.prototype._initOptions = function () {
        this._optionToUpdate.eventsStrategy = this.eventHelper.strategy;
        this._optionToUpdate.integrationOptions.watchMethod = this.watcherHelper.getWatchMethod();
    };
    DxComponent.prototype._createEventEmitters = function (events) {
        var _this = this;
        events.forEach(function (event) {
            _this.eventHelper.createEmitter(event.emit, event.subscribe);
        });
    };
    DxComponent.prototype._shouldOptionChange = function (name, value) {
        if (this.changedOptions.hasOwnProperty(name)) {
            var prevValue = this.changedOptions[name];
            delete this.changedOptions[name];
            return value !== prevValue;
        }
        return true;
    };
    DxComponent.prototype._getOption = function (name) {
        return this.instance ?
            this.instance.option(name) :
            this._optionToUpdate[name];
    };
    DxComponent.prototype._setOption = function (name, value) {
        if (this._shouldOptionChange(name, value)) {
            this._optionToUpdate[name] = value;
        }
        ;
    };
    DxComponent.prototype._createWidget = function (element) {
        var _this = this;
        var events = [];
        this._optionToUpdate.integrationOptions = {};
        this._initTemplates();
        this._initOptions();
        var optionChangeHandler = function (e) {
            events.push(e.name);
        };
        this._optionToUpdate.onInitializing = function () {
            this.on('optionChanged', optionChangeHandler);
        };
        this.instance = this._createInstance(element, this._optionToUpdate);
        this._optionToUpdate = {};
        this.instance.off('optionChanged', optionChangeHandler);
        this.instance.on('optionChanged', function (e) {
            _this.changedOptions[e.name] = e.value;
            _this.eventHelper.fireNgEvent(e.name + 'Change', [e.value]);
        });
        var subsriber = this.ngZone.onStable.subscribe(function () {
            subsriber.unsubscribe();
            _this.ngZone.run(function () {
                events.forEach(function (name) {
                    _this.eventHelper.fireNgEvent(name + 'Change', [_this[name]]);
                });
            });
        });
    };
    DxComponent.prototype._destroyWidget = function () {
        if (this.instance) {
            var element = this.instance.element();
            element.triggerHandler({ type: 'dxremove', _angularIntegration: true });
            element.remove();
        }
    };
    DxComponent.prototype.ngAfterContentChecked = function () {
        if (this.instance && Object.keys(this._optionToUpdate).length) {
            this.instance.option(this._optionToUpdate);
            this._optionToUpdate = {};
        }
    };
    DxComponent.prototype.ngAfterViewInit = function () {
        if (this.renderOnViewInit) {
            this._createWidget(this.element.nativeElement);
        }
    };
    DxComponent.prototype.setTemplate = function (template) {
        this.templates.push(template);
    };
    DxComponent.prototype.setChildren = function (propertyName, items) {
        return this._collectionContainerImpl.setChildren(propertyName, items);
    };
    return DxComponent;
}());
exports.DxComponent = DxComponent;
var DxComponentExtension = (function (_super) {
    __extends(DxComponentExtension, _super);
    function DxComponentExtension() {
        _super.apply(this, arguments);
    }
    DxComponentExtension.prototype.createInstance = function (element) {
        this._createWidget(element);
    };
    return DxComponentExtension;
}(DxComponent));
exports.DxComponentExtension = DxComponentExtension;
//# sourceMappingURL=component.js.map