/**
 * @license Angular v4.4.7
 * (c) 2010-2017 Google, Inc. https://angular.io/
 * License: MIT
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports,require("tslib"),require("@angular/core"),require("rxjs/observable/of"),require("rxjs/operator/concatMap"),require("rxjs/operator/filter"),require("rxjs/operator/map"),require("@angular/common"),require("rxjs/Observable")):"function"==typeof define&&define.amd?define(["exports","tslib","@angular/core","rxjs/observable/of","rxjs/operator/concatMap","rxjs/operator/filter","rxjs/operator/map","@angular/common","rxjs/Observable"],factory):factory((global.ng=global.ng||{},global.ng.common=global.ng.common||{},global.ng.common.http=global.ng.common.http||{}),global.tslib_1,global.ng.core,global.Rx.Observable.prototype,global.Rx.Observable.prototype,global.Rx.Observable.prototype,global.Rx.Observable.prototype,global._angular_common,global.Rx)}(this,function(exports,tslib_1,_angular_core,rxjs_observable_of,rxjs_operator_concatMap,rxjs_operator_filter,rxjs_operator_map,_angular_common,rxjs_Observable){"use strict";function paramParser(rawParams,codec){var map$$1=new Map;if(rawParams.length>0){rawParams.split("&").forEach(function(param){var eqIdx=param.indexOf("="),_a=-1==eqIdx?[codec.decodeKey(param),""]:[codec.decodeKey(param.slice(0,eqIdx)),codec.decodeValue(param.slice(eqIdx+1))],key=_a[0],val=_a[1],list=map$$1.get(key)||[];list.push(val),map$$1.set(key,list)})}return map$$1}function standardEncoding(v){return encodeURIComponent(v).replace(/%40/gi,"@").replace(/%3A/gi,":").replace(/%24/gi,"$").replace(/%2C/gi,",").replace(/%3B/gi,";").replace(/%2B/gi,"+").replace(/%3D/gi,"=").replace(/%3F/gi,"?").replace(/%2F/gi,"/")}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function mightHaveBody(method){switch(method){case"DELETE":case"GET":case"HEAD":case"OPTIONS":case"JSONP":return!1;default:return!0}}function isArrayBuffer(value){return"undefined"!=typeof ArrayBuffer&&value instanceof ArrayBuffer}function isBlob(value){return"undefined"!=typeof Blob&&value instanceof Blob}function isFormData(value){return"undefined"!=typeof FormData&&value instanceof FormData}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function addBody(options,body){return{body:body,headers:options.headers,observe:options.observe,params:options.params,reportProgress:options.reportProgress,responseType:options.responseType,withCredentials:options.withCredentials}}function getResponseUrl(xhr){return"responseURL"in xhr&&xhr.responseURL?xhr.responseURL:/^X-Request-URL:/m.test(xhr.getAllResponseHeaders())?xhr.getResponseHeader("X-Request-URL"):null}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function interceptingHandler(backend,interceptors){return void 0===interceptors&&(interceptors=[]),interceptors?interceptors.reduceRight(function(next,interceptor){return new HttpInterceptorHandler(next,interceptor)},backend):backend}function jsonpCallbackContext(){return"object"==typeof window?window:{}}/**
 * @license Angular v4.4.7
 * (c) 2010-2017 Google, Inc. https://angular.io/
 * License: MIT
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var HttpHandler=function(){function HttpHandler(){}return HttpHandler.prototype.handle=function(req){},HttpHandler}(),HttpBackend=function(){function HttpBackend(){}return HttpBackend.prototype.handle=function(req){},HttpBackend}(),HttpUrlEncodingCodec=function(){function HttpUrlEncodingCodec(){}return HttpUrlEncodingCodec.prototype.encodeKey=function(k){return standardEncoding(k)},HttpUrlEncodingCodec.prototype.encodeValue=function(v){return standardEncoding(v)},HttpUrlEncodingCodec.prototype.decodeKey=function(k){return decodeURIComponent(k)},HttpUrlEncodingCodec.prototype.decodeValue=function(v){return decodeURIComponent(v)},HttpUrlEncodingCodec}(),HttpParams=function(){function HttpParams(options){void 0===options&&(options={}),this.updates=null,this.cloneFrom=null,this.encoder=options.encoder||new HttpUrlEncodingCodec,this.map=options.fromString?paramParser(options.fromString,this.encoder):null}return HttpParams.prototype.has=function(param){return this.init(),this.map.has(param)},HttpParams.prototype.get=function(param){this.init();var res=this.map.get(param);return res?res[0]:null},HttpParams.prototype.getAll=function(param){return this.init(),this.map.get(param)||null},HttpParams.prototype.keys=function(){return this.init(),Array.from(this.map.keys())},HttpParams.prototype.append=function(param,value){return this.clone({param:param,value:value,op:"a"})},HttpParams.prototype.set=function(param,value){return this.clone({param:param,value:value,op:"s"})},HttpParams.prototype.delete=function(param,value){return this.clone({param:param,value:value,op:"d"})},HttpParams.prototype.toString=function(){var _this=this;return this.init(),this.keys().map(function(key){var eKey=_this.encoder.encodeKey(key);return _this.map.get(key).map(function(value){return eKey+"="+_this.encoder.encodeValue(value)}).join("&")}).join("&")},HttpParams.prototype.clone=function(update){var clone=new HttpParams({encoder:this.encoder});return clone.cloneFrom=this.cloneFrom||this,clone.updates=(this.updates||[]).concat([update]),clone},HttpParams.prototype.init=function(){var _this=this;null===this.map&&(this.map=new Map),null!==this.cloneFrom&&(this.cloneFrom.init(),this.cloneFrom.keys().forEach(function(key){return _this.map.set(key,_this.cloneFrom.map.get(key))}),this.updates.forEach(function(update){switch(update.op){case"a":case"s":var base=("a"===update.op?_this.map.get(update.param):void 0)||[];base.push(update.value),_this.map.set(update.param,base);break;case"d":if(void 0===update.value){_this.map.delete(update.param);break}var base_1=_this.map.get(update.param)||[],idx=base_1.indexOf(update.value);-1!==idx&&base_1.splice(idx,1),base_1.length>0?_this.map.set(update.param,base_1):_this.map.delete(update.param)}}),this.cloneFrom=null)},HttpParams}(),HttpHeaders=function(){function HttpHeaders(headers){var _this=this;this.normalizedNames=new Map,this.lazyUpdate=null,headers?this.lazyInit="string"==typeof headers?function(){_this.headers=new Map,headers.split("\n").forEach(function(line){var index=line.indexOf(":");if(index>0){var name=line.slice(0,index),key=name.toLowerCase(),value=line.slice(index+1).trim();_this.maybeSetNormalizedName(name,key),_this.headers.has(key)?_this.headers.get(key).push(value):_this.headers.set(key,[value])}})}:function(){_this.headers=new Map,Object.keys(headers).forEach(function(name){var values=headers[name],key=name.toLowerCase();"string"==typeof values&&(values=[values]),values.length>0&&(_this.headers.set(key,values),_this.maybeSetNormalizedName(name,key))})}:this.headers=new Map}return HttpHeaders.prototype.has=function(name){return this.init(),this.headers.has(name.toLowerCase())},HttpHeaders.prototype.get=function(name){this.init();var values=this.headers.get(name.toLowerCase());return values&&values.length>0?values[0]:null},HttpHeaders.prototype.keys=function(){return this.init(),Array.from(this.normalizedNames.values())},HttpHeaders.prototype.getAll=function(name){return this.init(),this.headers.get(name.toLowerCase())||null},HttpHeaders.prototype.append=function(name,value){return this.clone({name:name,value:value,op:"a"})},HttpHeaders.prototype.set=function(name,value){return this.clone({name:name,value:value,op:"s"})},HttpHeaders.prototype.delete=function(name,value){return this.clone({name:name,value:value,op:"d"})},HttpHeaders.prototype.maybeSetNormalizedName=function(name,lcName){this.normalizedNames.has(lcName)||this.normalizedNames.set(lcName,name)},HttpHeaders.prototype.init=function(){var _this=this;this.lazyInit&&(this.lazyInit instanceof HttpHeaders?this.copyFrom(this.lazyInit):this.lazyInit(),this.lazyInit=null,this.lazyUpdate&&(this.lazyUpdate.forEach(function(update){return _this.applyUpdate(update)}),this.lazyUpdate=null))},HttpHeaders.prototype.copyFrom=function(other){var _this=this;other.init(),Array.from(other.headers.keys()).forEach(function(key){_this.headers.set(key,other.headers.get(key)),_this.normalizedNames.set(key,other.normalizedNames.get(key))})},HttpHeaders.prototype.clone=function(update){var clone=new HttpHeaders;return clone.lazyInit=this.lazyInit&&this.lazyInit instanceof HttpHeaders?this.lazyInit:this,clone.lazyUpdate=(this.lazyUpdate||[]).concat([update]),clone},HttpHeaders.prototype.applyUpdate=function(update){var key=update.name.toLowerCase();switch(update.op){case"a":case"s":var value=update.value;if("string"==typeof value&&(value=[value]),0===value.length)return;this.maybeSetNormalizedName(update.name,key);var base=("a"===update.op?this.headers.get(key):void 0)||[];base.push.apply(base,value),this.headers.set(key,base);break;case"d":var toDelete_1=update.value;if(toDelete_1){var existing=this.headers.get(key);if(!existing)return;existing=existing.filter(function(value){return-1===toDelete_1.indexOf(value)}),0===existing.length?(this.headers.delete(key),this.normalizedNames.delete(key)):this.headers.set(key,existing)}else this.headers.delete(key),this.normalizedNames.delete(key)}},HttpHeaders.prototype.forEach=function(fn){var _this=this;this.init(),Array.from(this.normalizedNames.keys()).forEach(function(key){return fn(_this.normalizedNames.get(key),_this.headers.get(key))})},HttpHeaders}(),HttpRequest=function(){function HttpRequest(method,url,third,fourth){this.url=url,this.body=null,this.reportProgress=!1,this.withCredentials=!1,this.responseType="json",this.method=method.toUpperCase();var options;if(mightHaveBody(this.method)||fourth?(this.body=third||null,options=fourth):options=third,options&&(this.reportProgress=!!options.reportProgress,this.withCredentials=!!options.withCredentials,options.responseType&&(this.responseType=options.responseType),options.headers&&(this.headers=options.headers),options.params&&(this.params=options.params)),this.headers||(this.headers=new HttpHeaders),this.params){var params=this.params.toString();if(0===params.length)this.urlWithParams=url;else{var qIdx=url.indexOf("?"),sep=-1===qIdx?"?":qIdx<url.length-1?"&":"";this.urlWithParams=url+sep+params}}else this.params=new HttpParams,this.urlWithParams=url}return HttpRequest.prototype.serializeBody=function(){return null===this.body?null:isArrayBuffer(this.body)||isBlob(this.body)||isFormData(this.body)||"string"==typeof this.body?this.body:this.body instanceof HttpParams?this.body.toString():"object"==typeof this.body||"boolean"==typeof this.body||Array.isArray(this.body)?JSON.stringify(this.body):this.body.toString()},HttpRequest.prototype.detectContentTypeHeader=function(){return null===this.body?null:isFormData(this.body)?null:isBlob(this.body)?this.body.type||null:isArrayBuffer(this.body)?null:"string"==typeof this.body?"text/plain":this.body instanceof HttpParams?"application/x-www-form-urlencoded;charset=UTF-8":"object"==typeof this.body||"number"==typeof this.body||Array.isArray(this.body)?"application/json":null},HttpRequest.prototype.clone=function(update){void 0===update&&(update={});var method=update.method||this.method,url=update.url||this.url,responseType=update.responseType||this.responseType,body=void 0!==update.body?update.body:this.body,withCredentials=void 0!==update.withCredentials?update.withCredentials:this.withCredentials,reportProgress=void 0!==update.reportProgress?update.reportProgress:this.reportProgress,headers=update.headers||this.headers,params=update.params||this.params;return void 0!==update.setHeaders&&(headers=Object.keys(update.setHeaders).reduce(function(headers,name){return headers.set(name,update.setHeaders[name])},headers)),update.setParams&&(params=Object.keys(update.setParams).reduce(function(params,param){return params.set(param,update.setParams[param])},params)),new HttpRequest(method,url,body,{params:params,headers:headers,reportProgress:reportProgress,responseType:responseType,withCredentials:withCredentials})},HttpRequest}(),HttpEventType={};HttpEventType.Sent=0,HttpEventType.UploadProgress=1,HttpEventType.ResponseHeader=2,HttpEventType.DownloadProgress=3,HttpEventType.Response=4,HttpEventType.User=5,HttpEventType[HttpEventType.Sent]="Sent",HttpEventType[HttpEventType.UploadProgress]="UploadProgress",HttpEventType[HttpEventType.ResponseHeader]="ResponseHeader",HttpEventType[HttpEventType.DownloadProgress]="DownloadProgress",HttpEventType[HttpEventType.Response]="Response",HttpEventType[HttpEventType.User]="User";var HttpResponseBase=function(){function HttpResponseBase(init,defaultStatus,defaultStatusText){void 0===defaultStatus&&(defaultStatus=200),void 0===defaultStatusText&&(defaultStatusText="OK"),this.headers=init.headers||new HttpHeaders,this.status=void 0!==init.status?init.status:defaultStatus,this.statusText=init.statusText||defaultStatusText,this.url=init.url||null,this.ok=this.status>=200&&this.status<300}return HttpResponseBase}(),HttpHeaderResponse=function(_super){function HttpHeaderResponse(init){void 0===init&&(init={});var _this=_super.call(this,init)||this;return _this.type=HttpEventType.ResponseHeader,_this}return tslib_1.__extends(HttpHeaderResponse,_super),HttpHeaderResponse.prototype.clone=function(update){return void 0===update&&(update={}),new HttpHeaderResponse({headers:update.headers||this.headers,status:void 0!==update.status?update.status:this.status,statusText:update.statusText||this.statusText,url:update.url||this.url||void 0})},HttpHeaderResponse}(HttpResponseBase),HttpResponse=function(_super){function HttpResponse(init){void 0===init&&(init={});var _this=_super.call(this,init)||this;return _this.type=HttpEventType.Response,_this.body=init.body||null,_this}return tslib_1.__extends(HttpResponse,_super),HttpResponse.prototype.clone=function(update){return void 0===update&&(update={}),new HttpResponse({body:void 0!==update.body?update.body:this.body,headers:update.headers||this.headers,status:void 0!==update.status?update.status:this.status,statusText:update.statusText||this.statusText,url:update.url||this.url||void 0})},HttpResponse}(HttpResponseBase),HttpErrorResponse=function(_super){function HttpErrorResponse(init){var _this=_super.call(this,init,0,"Unknown Error")||this;return _this.name="HttpErrorResponse",_this.ok=!1,_this.status>=200&&_this.status<300?_this.message="Http failure during parsing for "+(init.url||"(unknown url)"):_this.message="Http failure response for "+(init.url||"(unknown url)")+": "+init.status+" "+init.statusText,_this.error=init.error||null,_this}return tslib_1.__extends(HttpErrorResponse,_super),HttpErrorResponse}(HttpResponseBase),HttpClient=function(){function HttpClient(handler){this.handler=handler}return HttpClient.prototype.request=function(first,url,options){var _this=this;void 0===options&&(options={});var req;req=first instanceof HttpRequest?first:new HttpRequest(first,url,options.body||null,{headers:options.headers,params:options.params,reportProgress:options.reportProgress,responseType:options.responseType||"json",withCredentials:options.withCredentials});var events$=rxjs_operator_concatMap.concatMap.call(rxjs_observable_of.of(req),function(req){return _this.handler.handle(req)});if(first instanceof HttpRequest||"events"===options.observe)return events$;var res$=rxjs_operator_filter.filter.call(events$,function(event){return event instanceof HttpResponse});switch(options.observe||"body"){case"body":switch(req.responseType){case"arraybuffer":return rxjs_operator_map.map.call(res$,function(res){if(null!==res.body&&!(res.body instanceof ArrayBuffer))throw new Error("Response is not an ArrayBuffer.");return res.body});case"blob":return rxjs_operator_map.map.call(res$,function(res){if(null!==res.body&&!(res.body instanceof Blob))throw new Error("Response is not a Blob.");return res.body});case"text":return rxjs_operator_map.map.call(res$,function(res){if(null!==res.body&&"string"!=typeof res.body)throw new Error("Response is not a string.");return res.body});case"json":default:return rxjs_operator_map.map.call(res$,function(res){return res.body})}case"response":return res$;default:throw new Error("Unreachable: unhandled observe type "+options.observe+"}")}},HttpClient.prototype.delete=function(url,options){return void 0===options&&(options={}),this.request("DELETE",url,options)},HttpClient.prototype.get=function(url,options){return void 0===options&&(options={}),this.request("GET",url,options)},HttpClient.prototype.head=function(url,options){return void 0===options&&(options={}),this.request("HEAD",url,options)},HttpClient.prototype.jsonp=function(url,callbackParam){return this.request("JSONP",url,{params:(new HttpParams).append(callbackParam,"JSONP_CALLBACK"),observe:"body",responseType:"json"})},HttpClient.prototype.options=function(url,options){return void 0===options&&(options={}),this.request("OPTIONS",url,options)},HttpClient.prototype.patch=function(url,body,options){return void 0===options&&(options={}),this.request("PATCH",url,addBody(options,body))},HttpClient.prototype.post=function(url,body,options){return void 0===options&&(options={}),this.request("POST",url,addBody(options,body))},HttpClient.prototype.put=function(url,body,options){return void 0===options&&(options={}),this.request("PUT",url,addBody(options,body))},HttpClient}();HttpClient.decorators=[{type:_angular_core.Injectable}],HttpClient.ctorParameters=function(){return[{type:HttpHandler}]};/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var HttpInterceptorHandler=function(){function HttpInterceptorHandler(next,interceptor){this.next=next,this.interceptor=interceptor}return HttpInterceptorHandler.prototype.handle=function(req){return this.interceptor.intercept(req,this.next)},HttpInterceptorHandler}(),HTTP_INTERCEPTORS=new _angular_core.InjectionToken("HTTP_INTERCEPTORS"),NoopInterceptor=function(){function NoopInterceptor(){}return NoopInterceptor.prototype.intercept=function(req,next){return next.handle(req)},NoopInterceptor}();NoopInterceptor.decorators=[{type:_angular_core.Injectable}],NoopInterceptor.ctorParameters=function(){return[]};/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var nextRequestId=0,JsonpCallbackContext=function(){function JsonpCallbackContext(){}return JsonpCallbackContext}(),JsonpClientBackend=function(){function JsonpClientBackend(callbackMap,document){this.callbackMap=callbackMap,this.document=document}return JsonpClientBackend.prototype.nextCallback=function(){return"ng_jsonp_callback_"+nextRequestId++},JsonpClientBackend.prototype.handle=function(req){var _this=this;if("JSONP"!==req.method)throw new Error("JSONP requests must use JSONP request method.");if("json"!==req.responseType)throw new Error("JSONP requests must use Json response type.");return new rxjs_Observable.Observable(function(observer){var callback=_this.nextCallback(),url=req.urlWithParams.replace(/=JSONP_CALLBACK(&|$)/,"="+callback+"$1"),node=_this.document.createElement("script");node.src=url;var body=null,finished=!1,cancelled=!1;_this.callbackMap[callback]=function(data){delete _this.callbackMap[callback],cancelled||(body=data,finished=!0)};var cleanup=function(){node.parentNode&&node.parentNode.removeChild(node),delete _this.callbackMap[callback]},onLoad=function(event){if(!cancelled){if(cleanup(),!finished)return void observer.error(new HttpErrorResponse({url:url,status:0,statusText:"JSONP Error",error:new Error("JSONP injected script did not invoke callback.")}));observer.next(new HttpResponse({body:body,status:200,statusText:"OK",url:url})),observer.complete()}},onError=function(error){cancelled||(cleanup(),observer.error(new HttpErrorResponse({error:error,status:0,statusText:"JSONP Error",url:url})))};return node.addEventListener("load",onLoad),node.addEventListener("error",onError),_this.document.body.appendChild(node),observer.next({type:HttpEventType.Sent}),function(){cancelled=!0,node.removeEventListener("load",onLoad),node.removeEventListener("error",onError),cleanup()}})},JsonpClientBackend}();JsonpClientBackend.decorators=[{type:_angular_core.Injectable}],JsonpClientBackend.ctorParameters=function(){return[{type:JsonpCallbackContext},{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_common.DOCUMENT]}]}]};var JsonpInterceptor=function(){function JsonpInterceptor(jsonp){this.jsonp=jsonp}return JsonpInterceptor.prototype.intercept=function(req,next){return"JSONP"===req.method?this.jsonp.handle(req):next.handle(req)},JsonpInterceptor}();JsonpInterceptor.decorators=[{type:_angular_core.Injectable}],JsonpInterceptor.ctorParameters=function(){return[{type:JsonpClientBackend}]};/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var XSSI_PREFIX=/^\)\]\}',?\n/,XhrFactory=function(){function XhrFactory(){}return XhrFactory.prototype.build=function(){},XhrFactory}(),BrowserXhr=function(){function BrowserXhr(){}return BrowserXhr.prototype.build=function(){return new XMLHttpRequest},BrowserXhr}();BrowserXhr.decorators=[{type:_angular_core.Injectable}],BrowserXhr.ctorParameters=function(){return[]};var HttpXhrBackend=function(){function HttpXhrBackend(xhrFactory){this.xhrFactory=xhrFactory}return HttpXhrBackend.prototype.handle=function(req){var _this=this;if("JSONP"===req.method)throw new Error("Attempted to construct Jsonp request without JsonpClientModule installed.");return new rxjs_Observable.Observable(function(observer){var xhr=_this.xhrFactory.build();if(xhr.open(req.method,req.urlWithParams),req.withCredentials&&(xhr.withCredentials=!0),req.headers.forEach(function(name,values){return xhr.setRequestHeader(name,values.join(","))}),req.headers.has("Accept")||xhr.setRequestHeader("Accept","application/json, text/plain, */*"),!req.headers.has("Content-Type")){var detectedType=req.detectContentTypeHeader();null!==detectedType&&xhr.setRequestHeader("Content-Type",detectedType)}if(req.responseType){var responseType=req.responseType.toLowerCase();xhr.responseType="json"!==responseType?responseType:"text"}var reqBody=req.serializeBody(),headerResponse=null,partialFromXhr=function(){if(null!==headerResponse)return headerResponse;var status=1223===xhr.status?204:xhr.status,statusText=xhr.statusText||"OK",headers=new HttpHeaders(xhr.getAllResponseHeaders()),url=getResponseUrl(xhr)||req.url;return headerResponse=new HttpHeaderResponse({headers:headers,status:status,statusText:statusText,url:url})},onLoad=function(){var _a=partialFromXhr(),headers=_a.headers,status=_a.status,statusText=_a.statusText,url=_a.url,body=null;204!==status&&(body=void 0===xhr.response?xhr.responseText:xhr.response),0===status&&(status=body?200:0);var ok=status>=200&&status<300;if(ok&&"json"===req.responseType&&"string"==typeof body){body=body.replace(XSSI_PREFIX,"");try{body=JSON.parse(body)}catch(error){ok=!1,body={error:error,text:body}}}else if(!ok&&"json"===req.responseType&&"string"==typeof body)try{body=JSON.parse(body)}catch(error){}ok?(observer.next(new HttpResponse({body:body,headers:headers,status:status,statusText:statusText,url:url||void 0})),observer.complete()):observer.error(new HttpErrorResponse({error:body,headers:headers,status:status,statusText:statusText,url:url||void 0}))},onError=function(error){var res=new HttpErrorResponse({error:error,status:xhr.status||0,statusText:xhr.statusText||"Unknown Error"});observer.error(res)},sentHeaders=!1,onDownProgress=function(event){sentHeaders||(observer.next(partialFromXhr()),sentHeaders=!0);var progressEvent={type:HttpEventType.DownloadProgress,loaded:event.loaded};event.lengthComputable&&(progressEvent.total=event.total),"text"===req.responseType&&xhr.responseText&&(progressEvent.partialText=xhr.responseText),observer.next(progressEvent)},onUpProgress=function(event){var progress={type:HttpEventType.UploadProgress,loaded:event.loaded};event.lengthComputable&&(progress.total=event.total),observer.next(progress)};return xhr.addEventListener("load",onLoad),xhr.addEventListener("error",onError),req.reportProgress&&(xhr.addEventListener("progress",onDownProgress),null!==reqBody&&xhr.upload&&xhr.upload.addEventListener("progress",onUpProgress)),xhr.send(reqBody),observer.next({type:HttpEventType.Sent}),function(){xhr.removeEventListener("error",onError),xhr.removeEventListener("load",onLoad),req.reportProgress&&(xhr.removeEventListener("progress",onDownProgress),null!==reqBody&&xhr.upload&&xhr.upload.removeEventListener("progress",onUpProgress)),xhr.abort()}})},HttpXhrBackend}();HttpXhrBackend.decorators=[{type:_angular_core.Injectable}],HttpXhrBackend.ctorParameters=function(){return[{type:XhrFactory}]};/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var XSRF_COOKIE_NAME=new _angular_core.InjectionToken("XSRF_COOKIE_NAME"),XSRF_HEADER_NAME=new _angular_core.InjectionToken("XSRF_HEADER_NAME"),HttpXsrfTokenExtractor=function(){function HttpXsrfTokenExtractor(){}return HttpXsrfTokenExtractor.prototype.getToken=function(){},HttpXsrfTokenExtractor}(),HttpXsrfCookieExtractor=function(){function HttpXsrfCookieExtractor(doc,platform,cookieName){this.doc=doc,this.platform=platform,this.cookieName=cookieName,this.lastCookieString="",this.lastToken=null,this.parseCount=0}return HttpXsrfCookieExtractor.prototype.getToken=function(){if("server"===this.platform)return null;var cookieString=this.doc.cookie||"";return cookieString!==this.lastCookieString&&(this.parseCount++,this.lastToken=_angular_common.ɵparseCookieValue(cookieString,this.cookieName),this.lastCookieString=cookieString),this.lastToken},HttpXsrfCookieExtractor}();HttpXsrfCookieExtractor.decorators=[{type:_angular_core.Injectable}],HttpXsrfCookieExtractor.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_common.DOCUMENT]}]},{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.PLATFORM_ID]}]},{type:void 0,decorators:[{type:_angular_core.Inject,args:[XSRF_COOKIE_NAME]}]}]};var HttpXsrfInterceptor=function(){function HttpXsrfInterceptor(tokenService,headerName){this.tokenService=tokenService,this.headerName=headerName}return HttpXsrfInterceptor.prototype.intercept=function(req,next){var lcUrl=req.url.toLowerCase();if("GET"===req.method||"HEAD"===req.method||lcUrl.startsWith("http://")||lcUrl.startsWith("https://"))return next.handle(req);var token=this.tokenService.getToken();return null===token||req.headers.has(this.headerName)||(req=req.clone({headers:req.headers.set(this.headerName,token)})),next.handle(req)},HttpXsrfInterceptor}();HttpXsrfInterceptor.decorators=[{type:_angular_core.Injectable}],HttpXsrfInterceptor.ctorParameters=function(){return[{type:HttpXsrfTokenExtractor},{type:void 0,decorators:[{type:_angular_core.Inject,args:[XSRF_HEADER_NAME]}]}]};var HttpClientXsrfModule=function(){function HttpClientXsrfModule(){}return HttpClientXsrfModule.disable=function(){return{ngModule:HttpClientXsrfModule,providers:[{provide:HttpXsrfInterceptor,useClass:NoopInterceptor}]}},HttpClientXsrfModule.withOptions=function(options){return void 0===options&&(options={}),{ngModule:HttpClientXsrfModule,providers:[options.cookieName?{provide:XSRF_COOKIE_NAME,useValue:options.cookieName}:[],options.headerName?{provide:XSRF_HEADER_NAME,useValue:options.headerName}:[]]}},HttpClientXsrfModule}();HttpClientXsrfModule.decorators=[{type:_angular_core.NgModule,args:[{providers:[HttpXsrfInterceptor,{provide:HTTP_INTERCEPTORS,useExisting:HttpXsrfInterceptor,multi:!0},{provide:HttpXsrfTokenExtractor,useClass:HttpXsrfCookieExtractor},{provide:XSRF_COOKIE_NAME,useValue:"XSRF-TOKEN"},{provide:XSRF_HEADER_NAME,useValue:"X-XSRF-TOKEN"}]}]}],HttpClientXsrfModule.ctorParameters=function(){return[]};var HttpClientModule=function(){function HttpClientModule(){}return HttpClientModule}();HttpClientModule.decorators=[{type:_angular_core.NgModule,args:[{imports:[HttpClientXsrfModule.withOptions({cookieName:"XSRF-TOKEN",headerName:"X-XSRF-TOKEN"})],providers:[HttpClient,{provide:HttpHandler,useFactory:interceptingHandler,deps:[HttpBackend,[new _angular_core.Optional,new _angular_core.Inject(HTTP_INTERCEPTORS)]]},HttpXhrBackend,{provide:HttpBackend,useExisting:HttpXhrBackend},BrowserXhr,{provide:XhrFactory,useExisting:BrowserXhr}]}]}],HttpClientModule.ctorParameters=function(){return[]};var HttpClientJsonpModule=function(){function HttpClientJsonpModule(){}return HttpClientJsonpModule}();HttpClientJsonpModule.decorators=[{type:_angular_core.NgModule,args:[{providers:[JsonpClientBackend,{provide:JsonpCallbackContext,useFactory:jsonpCallbackContext},{provide:HTTP_INTERCEPTORS,useClass:JsonpInterceptor,multi:!0}]}]}],HttpClientJsonpModule.ctorParameters=function(){return[]},exports.HttpBackend=HttpBackend,exports.HttpHandler=HttpHandler,exports.HttpClient=HttpClient,exports.HttpHeaders=HttpHeaders,exports.HTTP_INTERCEPTORS=HTTP_INTERCEPTORS,exports.JsonpClientBackend=JsonpClientBackend,exports.JsonpInterceptor=JsonpInterceptor,exports.HttpClientJsonpModule=HttpClientJsonpModule,exports.HttpClientModule=HttpClientModule,exports.HttpClientXsrfModule=HttpClientXsrfModule,exports.ɵinterceptingHandler=interceptingHandler,exports.HttpParams=HttpParams,exports.HttpUrlEncodingCodec=HttpUrlEncodingCodec,exports.HttpRequest=HttpRequest,exports.HttpErrorResponse=HttpErrorResponse,exports.HttpEventType=HttpEventType,exports.HttpHeaderResponse=HttpHeaderResponse,exports.HttpResponse=HttpResponse,exports.HttpResponseBase=HttpResponseBase,exports.HttpXhrBackend=HttpXhrBackend,exports.XhrFactory=XhrFactory,exports.HttpXsrfTokenExtractor=HttpXsrfTokenExtractor,exports.ɵa=NoopInterceptor,exports.ɵb=JsonpCallbackContext,exports.ɵc=jsonpCallbackContext,exports.ɵd=BrowserXhr,exports.ɵg=HttpXsrfCookieExtractor,exports.ɵh=HttpXsrfInterceptor,exports.ɵe=XSRF_COOKIE_NAME,exports.ɵf=XSRF_HEADER_NAME,Object.defineProperty(exports,"__esModule",{value:!0})});
//# sourceMappingURL=common-http.umd.min.js.map
