const config = require('./app-config');
const log4js = require('log4js');
const log = log4js.getLogger("backend-startup");
const path = require('path');
const _ = require('lodash');
const ds = require('fd-diskspace');

const jarPath = path.normalize(__dirname + path.sep + config.backend.jarPath);
var javaPath = path.normalize(__dirname + path.sep + config.backend.javaPath);
const datasourceUrl = config.backend.datasourceUrl;
const arelleExecutable = config.backend.arelleExecutable;
const differenceProtocolExecutable = config.backend.differenceProtocolExecutable;
const testConfigValue = config.backend.testConfigValue;
const port = config.backend.port;
const xlsxWriteAspectData = config.backend.xlsxWriteAspectData;
const xlsxWriteAxisId = config.backend.xlsxWriteAxisId;
const requiredSizeStr = config.backend.requiredSize;

const isTemplateTabAvailable = config.backend.isTemplateTabAvailable;
const isTechTestingTab = config.backend.isTechTestingTab;
const processLogOverSocket = config.backend.processLogOverSocket;
var isStartAppBlocked = false;
var skipFreeSizeChecking = false;
const _1024 = 1024;
var childProcess;

if (requiredSizeStr) {
  try {
    var statsSync = ds.diskSpaceSync();
  }
  catch (e) {
    log.info(e);
    skipFreeSizeChecking = true;
  }
  var appdata = process.env.appdata;
  if (!appdata) {
    log.info('Проверка свободного места на системном разделе. Не удалось определить appdata');
    skipFreeSizeChecking = true;
  }
  if (!skipFreeSizeChecking) {
    var disk = statsSync.disks[appdata.toString().split(":")[0]];
    if (!disk) {
      log.info("Проверка свободного места на системном разделе. AppData: " + appdata);
      log.info("Проверка свободного места на системном разделе. StatsSync: ");
      log.info(statsSync);
      log.info('Проверка свободного места на системном разделе. Не удалось найти системный раздел (appdata) в результатах запроса статистики разделов компьютера. Запуск без сравнения.');
      skipFreeSizeChecking = true;
    }
  }
  if (!skipFreeSizeChecking) {
    var freeSpace = disk.free;
    if (!freeSpace) {
      log.info("Проверка свободного места на системном разделе. AppData: " + appdata);
      log.info("Проверка свободного места на системном разделе. StatsSync: ");
      log.info(statsSync);
      log.info('Проверка свободного места на системном разделе. Не удалось найти информацию о своодном месте на системном разделе (appdata). Запуск без сравнения.');
      skipFreeSizeChecking = true;
    }
  }
  if (!skipFreeSizeChecking) {
    var length = requiredSizeStr.toString().length;
    var requiredSize = requiredSizeStr.toString().substring(0, length - 1);
    var sizeType = requiredSizeStr.toString().substring(length - 1);
    if (sizeType == 'K' || sizeType == 'k') {
      requiredSize = requiredSize * _1024;
    }
    if (sizeType == 'M' || sizeType == 'm') {
      requiredSize = requiredSize * _1024 * _1024;
    }
    if (sizeType == 'G' || sizeType == 'g') {
      requiredSize = requiredSize * _1024 * _1024 * _1024;
    }
    if (freeSpace < requiredSize) {
      // block start with message
      isStartAppBlocked = true;
      log.info('На системном разделе не достаточно свободного места для запуска. Выход.');
    } else {
      log.info('На системном разделе достаточно свободного места для запуска.');
    }
  }
} else {
  log.info('Проверка свободного места на системного разделе не установлена.');
}

if (!skipFreeSizeChecking && isStartAppBlocked) {
  module.exports = {'isStartAppBlocked': isStartAppBlocked};
  return;
}
log.info('jarPath', jarPath);
log.info('datasourceUrl', datasourceUrl);
log.info('testConfigValue', testConfigValue);
log.info('arelleExecutable', arelleExecutable);
log.info('differenceProtocolExecutable', differenceProtocolExecutable);

var args = [];
args.push('--converter.electronappLogFileName=' + global.LOG_FILE_NAME);
if (datasourceUrl) args.push('--spring.datasource.url=' + datasourceUrl);
if (testConfigValue) args.push('--converter.testConfigValue=' + testConfigValue);
if (arelleExecutable) args.push('--converter.arelleExecutable=' + arelleExecutable);
if (differenceProtocolExecutable) args.push('--converter.differenceProtocolExecutable=' + differenceProtocolExecutable);
if (xlsxWriteAspectData) args.push('--converter.xlsxWriteAspectData=' + xlsxWriteAspectData);
if (xlsxWriteAxisId) args.push('--converter.xlsxWriteAxisId=' + xlsxWriteAxisId);
if (port) args.push("--server.port=" + port);
if (isTemplateTabAvailable) args.push('--converter.isTemplateTabAvailable=' + isTemplateTabAvailable);
if (isTechTestingTab) args.push('--converter.isTechTestingTab=' + isTechTestingTab);
if (processLogOverSocket !== undefined && processLogOverSocket !== null) args.push("--converter.processLogOverSocket=" + processLogOverSocket);

var spawn = require('child_process').spawn('java', ['-version']);
spawn.on('error', function (err) {
  log.info('Java is not installed');
  start();
});
spawn.stderr.on('data', function (data) {
  var dataLines = data.toString().split('\n');
  var dataVersion = dataLines[0];
  var dataBit = dataLines.length > 2 ? dataLines[2] : null;
  var checkBit = false;
  var javaVersion = new RegExp('java version').test(dataVersion) ? dataVersion.split(' ')[2].replace(/"/g, '').toString().trim() : false;
  if (dataBit && dataBit.toString().indexOf('64-Bit') > -1) {
    checkBit = true;
  }
  if (javaVersion) {
    log.info('Installed java version: ' + javaVersion + (checkBit ? ' 64-Bit' : ''));
    var javaVersionNumbers = javaVersion.split('.');
    if (javaVersionNumbers[0] && +javaVersionNumbers[0] === 1 && javaVersionNumbers[1] && +javaVersionNumbers[1] === 8 && checkBit) {
      log.info('Using installed java: ' + javaVersion);
      javaPath = 'java';
    } else {
      log.info('Using java from anketa-redaktor installation.');
    }
  }
  start();
});

function start() {
  const jvmOptions = config.backend.jvmOptions && _.isArray(config.backend.jvmOptions) ? config.backend.jvmOptions : [];

  if (config.backend.options && _.isArray(config.backend.options)) args = args.concat(config.backend.options);

  var allArgs = jvmOptions.concat(['-jar', jarPath], args);

  allArgs = _.uniq(allArgs);
  const command = javaPath + " " + allArgs.join(' ');
  log.info('Backend execute command: ' + command);

  childProcess = require('child_process').spawn(javaPath, allArgs);

  childProcess.stdout.on('data', function (data) {
    if (data) log.info(data.toString());
  });

  childProcess.stderr.on("data", function (data) {
    if (data) log.error(data.toString());
  });
}

function getChildProcess() {
  return childProcess;
}

module.exports = {'getChildProcess': getChildProcess};
