/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.IncompatibleSchemaRefException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model.enums.XmlContentType;
import ru.cbr.xbrl.converter.model.validation.PositionInfo;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlFootnote;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnit;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.xbrl.import_export.XbrlParser;
import ru.cbr.xbrl.converter.xbrl.import_export.scenario.XbrlContextScenarioParser;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.XbrlXmlParser;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.enums.XbrlXmlTags;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class XbrlXmlParser
implements XbrlParser {
    private static final Logger log = LoggerFactory.getLogger(XbrlXmlParser.class);
    public static final String XBRL_INSTANCE_URI = "http://www.xbrl.org/2003/instance";
    public static final String DEFAULT_XBRL_INSTANCE_PREFIX = "xbrli";
    public static final String IXBRL_INSTANCE_URI = "http://www.w3.org/1999/xhtml";
    public static final String ISO4217_URI = "http://www.xbrl.org/2003/iso4217";
    public static final String DEFAULT_ISO4217_PREFIX = "iso4217";
    public static final String MEM_INT_URI = "http://www.cbr.ru/xbrl/udr/dom/mem-int";
    public static final String DEFAULT_MEM_INT_PREFIX = "mem-int";
    public static final String DIM_INT_URI = "http://www.cbr.ru/xbrl/udr/dim/dim-int";
    public static final String DEFAULT_DIM_INT_PREFIX = "dim-int";
    public static final String QNAME_DIVIDER = ":";
    private final String xbrlFilePath;
    private Consumer<String> eventMessageConsumer;
    private String expectedEntryPoint;
    private ConfigProperties.Xbrl configPropertiesXbrl;
    private QName currentElement;
    private LinkedList<QName> parentElements = new LinkedList();
    private XbrlContext currentXbrlContext;
    private XbrlUnit currentXbrlUnit;
    private XbrlValue currentXbrlValue;
    private XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private StringWriter scenarioStringWriter = new StringWriter();
    private XMLEventWriter scenarioXmlEventWriter = null;
    private boolean isProcessingScenario = false;
    private StringWriter segmentStringWriter = new StringWriter();
    private XMLEventWriter segmentXmlEventWriter = null;
    private boolean isProcessingSegment = false;
    private Map<String, List<XbrlFootnote>> footnoteMap = new HashMap();
    private Map<String, String> footnoteIdMap = new HashMap();
    private Map<String, String> footnoteValueMap = new HashMap();
    private Map<String, Map<String, String>> footnoteArcMap = new HashMap();
    private boolean isProcessingFootnotes = false;
    private boolean processingFootnoteLabel = false;
    private String cuurentFootnoteValueLabel;
    private String cuurentFootnoteValueLang;
    private boolean skipCurrentUnit = false;
    private boolean checkOnlyEntryPoint = false;
    private boolean isCheckedEntryPoint = false;
    private DateTimeFormatter periodDateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private String entryPoint;
    private NamespaceContext namespaceContext;
    private int indent = 0;
    private int counter = 0;
    private int scenarioEventCounter = 0;
    private int segmentEventCounter = 0;
    private Set<Namespace> namespaces = new HashSet();
    private Map<String, String> defaultNamespacePrefixes = new HashMap();
    private XmlContentType currentContentType = null;
    private boolean valueAllowed;
    private Integer elementCounter = 1;
    private int schemaRefElementCounter = 0;
    private String currentValueContextId;
    private String currentValueUnitId;
    private boolean isEntity = false;
    String baseValue = null;

    public XbrlXmlParser(ConfigProperties.Xbrl configPropetiesXbrl, String xbrlFilePath) throws IncompatibleSchemaRefException {
        this.configPropertiesXbrl = configPropetiesXbrl;
        this.xbrlFilePath = xbrlFilePath;
        try {
            this.parseXml((InputStream)new FileInputStream(xbrlFilePath));
        }
        catch (FileNotFoundException e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public XbrlXmlParser(ConfigProperties.Xbrl configPropetiesXbrl, InputStream inputStream, String expectedEntryPoint, String xbrlFilePath) throws IncompatibleSchemaRefException {
        this.configPropertiesXbrl = configPropetiesXbrl;
        this.expectedEntryPoint = expectedEntryPoint;
        this.xbrlFilePath = xbrlFilePath;
        this.parseXml(inputStream);
    }

    public XbrlXmlParser(ConfigProperties.Xbrl configPropetiesXbrl, InputStream inputStream, String expectedEntryPoint, boolean checkOnlyEntryPoint, String xbrlFilePath) throws IncompatibleSchemaRefException {
        this.configPropertiesXbrl = configPropetiesXbrl;
        this.expectedEntryPoint = expectedEntryPoint;
        this.checkOnlyEntryPoint = checkOnlyEntryPoint;
        this.xbrlFilePath = xbrlFilePath;
        this.parseXml(inputStream);
    }

    public XbrlXmlParser(ConfigProperties.Xbrl configPropetiesXbrl, InputStream inputStream, Map<String, String> defaultNamespacePrefixes, String expectedEntryPoint, Consumer<String> eventMessageConsumer, String xbrlFilePath) throws IncompatibleSchemaRefException {
        this.configPropertiesXbrl = configPropetiesXbrl;
        this.expectedEntryPoint = expectedEntryPoint;
        this.defaultNamespacePrefixes = defaultNamespacePrefixes;
        this.xbrlFilePath = xbrlFilePath;
        this.eventMessageConsumer = eventMessageConsumer;
        this.parseXml(inputStream);
    }

    private void parseXml(InputStream inputStream) throws IncompatibleSchemaRefException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(new InputStreamReader((InputStream)new BOMInputStream(inputStream), "UTF-8"));
            this.schemaRefElementCounter = 0;
            while (xmlEventReader.hasNext() && !this.isCheckedEntryPoint) {
                XMLEvent xmlEvent = xmlEventReader.peek();
                this.processEvent(xmlEvent);
                ++this.counter;
                xmlEventReader.nextEvent();
            }
            if (this.schemaRefElementCounter == 0) {
                this.addError("\u041e\u0442\u0447\u0435\u0442 XBRL \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c, \u043a\u0430\u043a \u043c\u0438\u043d\u0438\u043c\u0443\u043c, \u043e\u0434\u0438\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 <schemaRef>");
            }
        }
        catch (XMLStreamException e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (FileNotFoundException e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (XbrlImportException e) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void processEvent(XMLEvent xmlEvent) throws IOException, XMLStreamException, XbrlImportException, IncompatibleSchemaRefException {
        try {
            if (xmlEvent.toString().contains("purcb-dictionary")) {
                boolean bl = false;
            }
            if (!xmlEvent.isStartDocument()) {
                if (xmlEvent.isStartElement()) {
                    QName elementQName;
                    ++this.indent;
                    this.namespaceContext = xmlEvent.asStartElement().getNamespaceContext();
                    StartElement startElement = xmlEvent.asStartElement();
                    Iterator<Namespace> it = startElement.getNamespaces();
                    while (it.hasNext()) {
                        Namespace ns = it.next();
                        this.namespaces.add(ns);
                    }
                    this.currentElement = elementQName = startElement.getName();
                    this.logTreeItem(this.indent, "startElement " + elementQName.getLocalPart());
                    this.parseSchemRefStartEvents(startElement);
                    if (!this.isCheckedEntryPoint) {
                        this.parseContextStartEvents(startElement);
                        this.parseUnitStartEvents(startElement);
                        if (this.valueAllowed) {
                            this.parseValueStartEvents(startElement);
                            this.parseFootnoteStartEvents(startElement);
                        }
                        this.parentElements.push(elementQName);
                    }
                } else if (xmlEvent.isCharacters()) {
                    this.processCharacters(xmlEvent);
                } else if (xmlEvent.isEndElement()) {
                    this.parentElements.poll();
                    --this.indent;
                    EndElement endElement = xmlEvent.asEndElement();
                    QName elementQName = endElement.getName();
                    this.currentElement = null;
                    this.logTreeItem(this.indent, "endElement " + elementQName.getLocalPart());
                    this.parseContextEndEvents(endElement);
                    this.parseUnitEndEvents(endElement);
                    if (this.valueAllowed) {
                        this.parseValueEndEvents();
                        this.parseFootnoteEndEvents(endElement);
                    }
                } else if (xmlEvent.isEndDocument()) {
                    if (this.scenarioXmlEventWriter != null) {
                        this.scenarioXmlEventWriter.close();
                    }
                    if (this.segmentXmlEventWriter != null) {
                        this.segmentXmlEventWriter.close();
                    }
                }
            }
            this.processScenarioChildren(xmlEvent);
            this.processSegmentChildren(xmlEvent);
        }
        catch (Exception e) {
            if (e instanceof IncompatibleSchemaRefException) {
                throw (IncompatibleSchemaRefException)((Object)e);
            }
            log.info("Parsing error: " + xmlEvent.getLocation());
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlImportException();
        }
        finally {
            if (this.scenarioStringWriter != null) {
                this.scenarioStringWriter.close();
            }
            if (this.segmentStringWriter != null) {
                this.segmentStringWriter.close();
            }
        }
    }

    private void processCharacters(XMLEvent xmlEvent) throws Exception {
        Characters characters = xmlEvent.asCharacters();
        if (StringUtils.isNotBlank((CharSequence)characters.getData())) {
            this.logTreeItem(this.indent + 1, "characters " + characters.getData() + "///  of " + this.currentElement.getLocalPart());
        }
        if (this.currentContentType == null) {
            return;
        }
        switch (1.$SwitchMap$ru$cbr$xbrl$converter$model$enums$XmlContentType[this.currentContentType.ordinal()]) {
            case 1: {
                this.parseContextCharacters(characters);
                break;
            }
            case 2: {
                this.parseUnitCharacters(characters);
                break;
            }
            case 3: {
                this.parseValueCharacters(characters);
                break;
            }
            case 4: {
                this.parseFootnoteCharacters(characters);
                if (!this.processingFootnoteLabel) break;
                this.parseFootnoteCharacters(characters);
            }
        }
    }

    private void parseUnitStartEvents(StartElement startElement) {
        QName elementQName = startElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.UNIT)) {
            this.currentContentType = XmlContentType.UNIT;
            Integer n = this.elementCounter;
            Integer n2 = this.elementCounter = Integer.valueOf(this.elementCounter + 1);
            this.skipCurrentUnit = false;
            this.currentXbrlUnit = new XbrlUnit();
            Attribute unitIdAttr = startElement.getAttributeByName(XbrlXmlTags.UNIT_ID_ATTR);
            this.currentXbrlUnit.getXbrlUnitId().setUnitId(unitIdAttr.getValue());
        }
    }

    private void parseUnitEndEvents(EndElement endElement) {
        if (this.currentContentType == null || this.currentContentType != XmlContentType.UNIT) {
            return;
        }
        QName elementQName = endElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.UNIT)) {
            this.currentContentType = null;
            if (!this.skipCurrentUnit) {
                this.processXbrlUnit(this.currentXbrlUnit, this.xbrlFilePath, Integer.valueOf(0));
            }
        } else if (Objects.equals(elementQName, XbrlXmlTags.UNIT_MEASURE)) {
            // empty if block
        }
    }

    private void parseUnitCharacters(Characters characters) throws Exception {
        String instancePrefix = this.namespaceContext.getPrefix("http://www.xbrl.org/2003/instance");
        String inlinePrefix = this.namespaceContext.getPrefix("http://www.w3.org/1999/xhtml");
        String iso4217Prefix = this.namespaceContext.getPrefix("http://www.xbrl.org/2003/iso4217");
        if (Objects.equals(this.currentElement, XbrlXmlTags.UNIT_MEASURE)) {
            QName parentElementQName = (QName)this.parentElements.get(1);
            String charactersData = characters.getData();
            if (Objects.equals(parentElementQName, XbrlXmlTags.UNIT)) {
                this.currentXbrlUnit.setMeasure(charactersData);
            } else if (Objects.equals(parentElementQName, XbrlXmlTags.UNIT_NUMERATOR)) {
                this.currentXbrlUnit.setNumeratorMeasure(charactersData);
            } else if (Objects.equals(parentElementQName, XbrlXmlTags.UNIT_DENOMINATOR)) {
                this.currentXbrlUnit.setDenominatorMeasure(charactersData);
            }
        }
    }

    private void parseFootnoteStartEvents(StartElement startElement) {
        QName elementQName = startElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.FOOTNOTE_LINK)) {
            this.currentContentType = XmlContentType.FOOTNOTE;
            Integer n = this.elementCounter;
            Integer n2 = this.elementCounter = Integer.valueOf(this.elementCounter + 1);
            return;
        }
        if (Objects.equals(elementQName, XbrlXmlTags.FOOTNOTE_LOC)) {
            Attribute href = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_HREF_ATTR);
            if (href == null) {
                return;
            }
            String hrefStr = href.getValue();
            Attribute label = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_LABEL_ATTR);
            if (label == null) {
                return;
            }
            String labelStr = label.getValue();
            if (StringUtils.isBlank((CharSequence)labelStr)) {
                return;
            }
            this.footnoteIdMap.put(labelStr, hrefStr);
            return;
        }
        if (Objects.equals(elementQName, XbrlXmlTags.FOOTNOTE)) {
            Attribute label = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_LABEL_ATTR);
            if (label == null) {
                return;
            }
            String labelStr = label.getValue();
            if (StringUtils.isBlank((CharSequence)labelStr)) {
                return;
            }
            Attribute lang = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_LANG_ATTR);
            if (lang != null) {
                this.cuurentFootnoteValueLang = lang.getValue();
            }
            this.cuurentFootnoteValueLabel = labelStr;
            this.processingFootnoteLabel = true;
        }
        if (Objects.equals(elementQName, XbrlXmlTags.FOOTNOTE_ARC)) {
            Attribute from = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_FROM_ATTR);
            Attribute to = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_TO_ATTR);
            Attribute order = startElement.getAttributeByName(XbrlXmlTags.FOOTNOTE_ORDER_ATTR);
            if (from == null || to == null) {
                return;
            }
            String fromStr = from.getValue();
            String toStr = to.getValue();
            String orderStr = null;
            if (order != null) {
                orderStr = order.getValue();
            }
            if (StringUtils.isBlank((CharSequence)fromStr) || StringUtils.isBlank((CharSequence)toStr)) {
                return;
            }
            HashMap<String, String> currentFootnoteArcMap = (HashMap<String, String>)this.footnoteArcMap.get(fromStr);
            if (currentFootnoteArcMap == null) {
                currentFootnoteArcMap = new HashMap<String, String>();
                currentFootnoteArcMap.put("1.0", toStr);
                this.footnoteArcMap.put(fromStr, currentFootnoteArcMap);
            } else if (StringUtils.isBlank((CharSequence)orderStr) || currentFootnoteArcMap.get(orderStr) != null) {
                Set orderSet = currentFootnoteArcMap.keySet();
                Integer maxOrder = 0;
                for (String currentOrder : orderSet) {
                    Integer currentOrderInt;
                    if (StringUtils.isBlank((CharSequence)currentOrder)) continue;
                    if (StringUtils.contains((CharSequence)currentOrder, (CharSequence)".")) {
                        currentOrder = StringUtils.split((String)currentOrder, (String)".")[0];
                    }
                    try {
                        currentOrderInt = Integer.parseInt(currentOrder);
                    }
                    catch (NumberFormatException e) {
                        log.warn("\u041f\u0430\u0440\u0441\u0438\u043d\u0433 xml, \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438. \u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 order");
                        continue;
                    }
                    if (currentOrderInt <= maxOrder) continue;
                    maxOrder = currentOrderInt;
                }
                currentFootnoteArcMap.put(maxOrder + 1 + ".0", toStr);
            } else {
                currentFootnoteArcMap.put(orderStr, toStr);
            }
        }
    }

    private void parseFootnoteCharacters(Characters characters) {
        if (characters == null) {
            return;
        }
        this.processingFootnoteLabel = false;
        if (StringUtils.isBlank((CharSequence)this.cuurentFootnoteValueLabel)) {
            return;
        }
        this.footnoteValueMap.put(this.cuurentFootnoteValueLabel, characters.getData());
        this.cuurentFootnoteValueLabel = "";
    }

    private void parseFootnoteEndEvents(EndElement endElement) {
        if (this.currentContentType == null || this.currentContentType != XmlContentType.FOOTNOTE) {
            return;
        }
        QName elementQName = endElement.getName();
        if (!Objects.equals(elementQName, XbrlXmlTags.FOOTNOTE_LINK)) {
            return;
        }
        HashMap<String, String> currentFootnoteArcToMap = new HashMap<String, String>();
        for (Map.Entry currentFootnoteArcEntry : this.footnoteArcMap.entrySet()) {
            Map currentFootnoteArcMap = (Map)currentFootnoteArcEntry.getValue();
            if (CollectionUtils.isEmpty((Map)currentFootnoteArcMap)) continue;
            for (Map.Entry currentFootnote : currentFootnoteArcMap.entrySet()) {
                String v;
                if (currentFootnote == null || currentFootnoteArcToMap.get(v = (String)currentFootnote.getValue()) != null) continue;
                currentFootnoteArcToMap.put(v, v);
            }
        }
        for (Map.Entry currentFootnoteValueEntry : this.footnoteValueMap.entrySet()) {
            String currentFNLabel = (String)currentFootnoteValueEntry.getKey();
            if (currentFootnoteArcToMap.get(currentFNLabel) != null) continue;
            this.addWarning(String.format("\u041d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 <footnote> label = %s \u0432 <footnoteLink> \u043d\u0435 \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u043d\u0438 \u043e\u0434\u043d\u0430 \u0430\u0440\u043a\u0430 <footnoteArc>.", currentFNLabel));
        }
        for (Map.Entry currentFootnoteArcEntry : this.footnoteArcMap.entrySet()) {
            String currentFactLabel = (String)currentFootnoteArcEntry.getKey();
            String footnoteFactHrefFull = (String)this.footnoteIdMap.get(currentFactLabel);
            if (StringUtils.isBlank((CharSequence)footnoteFactHrefFull)) {
                this.addWarning(String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 from = %s \u0430\u0440\u043a\u0438 <footnoteArc> \u0432 <footnoteLink> \u043d\u0435 \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0430\u0435\u0442 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 <loc>.", currentFactLabel));
                continue;
            }
            if (!StringUtils.contains((CharSequence)footnoteFactHrefFull, (CharSequence)"#")) {
                this.addWarning(String.format("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u0430 href \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 <loc> href = %s", footnoteFactHrefFull));
                continue;
            }
            String fileName = StringUtils.substringBefore((String)footnoteFactHrefFull, (String)"#");
            if (!StringUtils.isBlank((CharSequence)fileName) && !StringUtils.equalsIgnoreCase((CharSequence)FilenameUtils.getName((String)fileName), (CharSequence)FilenameUtils.getName((String)this.xbrlFilePath))) {
                this.addWarning(String.format("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 <loc> \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0432 <footnoteLink> \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u0441\u044b\u043b\u0430\u0442\u044c\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b (items) \u0442\u043e\u0433\u043e \u0436\u0435 \u0441\u0430\u043c\u043e\u0433\u043e \u043e\u0442\u0447\u0435\u0442\u0430 XBRL, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 <loc> href = %s", footnoteFactHrefFull));
                continue;
            }
            String footnoteFactHref = StringUtils.substringAfter((String)footnoteFactHrefFull, (String)"#");
            if (StringUtils.isBlank((CharSequence)footnoteFactHref)) {
                this.addWarning(String.format("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u0430 href \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 <loc> href = %s", footnoteFactHrefFull));
                continue;
            }
            List currentXbrlFootnoteList = (List)this.footnoteMap.get(footnoteFactHref);
            if (currentXbrlFootnoteList == null) {
                this.addWarning(String.format("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 <loc> \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0432 <footnoteLink> \u0434\u043e\u043b\u0436\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0441\u044b\u043b\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b (items) \u0442\u043e\u0433\u043e \u0436\u0435 \u0441\u0430\u043c\u043e\u0433\u043e \u043e\u0442\u0447\u0435\u0442\u0430 XBRL, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 <loc> href = %s", footnoteFactHref));
                continue;
            }
            Map currentFootnoteArcMap = (Map)currentFootnoteArcEntry.getValue();
            if (CollectionUtils.isEmpty((Map)currentFootnoteArcMap)) continue;
            for (Map.Entry currentFootnote : currentFootnoteArcMap.entrySet()) {
                if (currentFootnote == null) continue;
                String order = (String)currentFootnote.getKey();
                String value = (String)currentFootnote.getValue();
                if (StringUtils.isBlank((CharSequence)order) || StringUtils.isBlank((CharSequence)value)) {
                    if (!StringUtils.isBlank((CharSequence)value)) continue;
                    this.addWarning(String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 to = %s \u0430\u0440\u043a\u0438 <footnoteArc> \u0432 <footnoteLink> \u043d\u0435 \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0430\u0435\u0442 \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 <footnote>.", value));
                    continue;
                }
                XbrlFootnote currentXbrlFootnote = new XbrlFootnote();
                currentXbrlFootnote.setFootnoteFactId(footnoteFactHref);
                currentXbrlFootnote.setContent(StringUtils.trim((String)((String)this.footnoteValueMap.get(value))));
                currentXbrlFootnote.setLanguage("ru");
                currentXbrlFootnote.setFootnoteNo(order);
                currentXbrlFootnoteList.add(currentXbrlFootnote);
            }
        }
        for (Map.Entry stringXbrlFootnoteEntry : this.footnoteMap.entrySet()) {
            List xbrlFootnoteList = (List)stringXbrlFootnoteEntry.getValue();
            if (CollectionUtils.isEmpty((Collection)xbrlFootnoteList)) continue;
            for (XbrlFootnote xbrlFootnote : xbrlFootnoteList) {
                this.processXbrlFootnote(xbrlFootnote, this.xbrlFilePath, Integer.valueOf(0));
            }
        }
    }

    private boolean isNamespaceAllowed(QName elementName) {
        if (CollectionUtils.isEmpty((Map)this.defaultNamespacePrefixes) || elementName == null) {
            return false;
        }
        String namespaceURI = elementName.getNamespaceURI();
        if (StringUtils.isBlank((CharSequence)namespaceURI)) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)((CharSequence)this.defaultNamespacePrefixes.get(namespaceURI)));
    }

    private void parseValueStartEvents(StartElement startElement) {
        QName elementQName = startElement.getName();
        if (this.currentContentType == null && this.isNamespaceAllowed(elementQName)) {
            Attribute footnoteId;
            Attribute precisionAttr;
            if (Objects.equals(elementQName, XbrlXmlTags.FOOTNOTE_LINK)) {
                return;
            }
            this.currentContentType = XmlContentType.VALUE;
            Integer n = this.elementCounter;
            Integer n2 = this.elementCounter = Integer.valueOf(this.elementCounter + 1);
            Attribute contextRefAttr = startElement.getAttributeByName(XbrlXmlTags.VALUE_CONTEXT_REF_ATTR);
            this.currentValueContextId = contextRefAttr != null ? contextRefAttr.getValue() : null;
            String localPart = elementQName.getLocalPart();
            this.currentXbrlValue = new XbrlValue();
            String namespaceURI = elementQName.getNamespaceURI();
            this.currentXbrlValue.setElementUri(namespaceURI);
            this.currentXbrlValue.setElementName(localPart);
            String prefix = (String)this.defaultNamespacePrefixes.get(namespaceURI);
            if (StringUtils.isBlank((CharSequence)prefix)) {
                prefix = elementQName.getPrefix();
                log.warn("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0444\u0430\u043a\u0442\u043e\u0432. \u0414\u043b\u044f \u043e\u0447\u0435\u0440\u0435\u0434\u043d\u043e\u0433\u043e \u0444\u0430\u043a\u0442\u0430 {} \u0441 namespace {} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u0441\u0440\u0435\u0434\u0438 \u043f\u0440\u0435\u0434\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0432 \u043e\u0442\u0447\u0435\u0442\u0435 {}", new Object[]{localPart, namespaceURI, prefix});
            }
            String elementLabel = prefix + ":" + localPart;
            this.currentXbrlValue.getXbrlValueId().setElementLabel(elementLabel);
            Attribute unitRefAttr = startElement.getAttributeByName(XbrlXmlTags.VALUE_UNIT_REF_ATTR);
            this.currentValueUnitId = unitRefAttr != null ? unitRefAttr.getValue() : null;
            Attribute decimalsAttr = startElement.getAttributeByName(XbrlXmlTags.VALUE_DECIMALS_ATTR);
            if (decimalsAttr != null) {
                this.currentXbrlValue.setDecimals(XbrlXmlParser.safeParseInt((String)decimalsAttr.getValue()));
            }
            if ((precisionAttr = startElement.getAttributeByName(XbrlXmlTags.VALUE_PRECISION_ATTR)) != null) {
                this.currentXbrlValue.setPrecision(XbrlXmlParser.safeParseInt((String)precisionAttr.getValue()));
            }
            if ((footnoteId = startElement.getAttributeByName(XbrlXmlTags.VALUE_FOOTNOTE_ID_ATTR)) != null) {
                String id = footnoteId.getValue();
                this.currentXbrlValue.setId(id);
                this.footnoteMap.put(id, new ArrayList());
            }
        }
    }

    public static Integer safeParseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void parseValueCharacters(Characters characters) throws Exception {
        QName parentElementQName;
        if (this.parentElements.size() == 2 && this.isNamespaceAllowed(parentElementQName = (QName)this.parentElements.get(0))) {
            String value = characters.getData();
            if (this.currentXbrlValue != null) {
                if (this.currentXbrlValue.getValue() == null) {
                    this.currentXbrlValue.setValue("");
                }
                String currentValue = this.currentXbrlValue.getValue() + value;
                this.currentXbrlValue.setValue(currentValue);
            }
        }
    }

    private String normalizePrefix(String parsedQname, String normalizedPrefix) {
        boolean hasNamespacePrefix = parsedQname.contains(":") && this.namespaces.stream().anyMatch(namespace -> namespace.getPrefix().equals(parsedQname.split(":")[0]));
        return hasNamespacePrefix ? normalizedPrefix + ":" + parsedQname.split(":")[1] : parsedQname;
    }

    private void parseValueEndEvents() throws NotFoundException {
        if (this.currentContentType == XmlContentType.VALUE) {
            PositionInfo positionInfo = new PositionInfo();
            positionInfo.setElementNumber(this.elementCounter);
            this.processXbrlValue(this.currentValueContextId, this.currentValueUnitId, this.currentXbrlValue, this.xbrlFilePath, positionInfo);
            this.currentContentType = null;
        }
    }

    private void processScenarioChildren(XMLEvent xmlEvent) throws XMLStreamException {
        boolean isEmptyCharactersEvent;
        boolean isScenarioStartEvent = xmlEvent.isStartElement() && xmlEvent.asStartElement().getName().equals(XbrlXmlTags.CONTEXT_SCENARIO);
        boolean bl = isEmptyCharactersEvent = xmlEvent.isCharacters() && StringUtils.isBlank((CharSequence)xmlEvent.asCharacters().getData());
        if (this.isProcessingScenario && !isScenarioStartEvent && !isEmptyCharactersEvent) {
            this.scenarioXmlEventWriter.add(xmlEvent);
            ++this.scenarioEventCounter;
        }
    }

    private void processSegmentChildren(XMLEvent xmlEvent) throws XMLStreamException {
        boolean isEmptyCharactersEvent;
        boolean isSegmentStartEvent = xmlEvent.isStartElement() && xmlEvent.asStartElement().getName().equals(XbrlXmlTags.CONTEXT_SEGMENT);
        boolean bl = isEmptyCharactersEvent = xmlEvent.isCharacters() && StringUtils.isBlank((CharSequence)xmlEvent.asCharacters().getData());
        if (this.isProcessingSegment && !isSegmentStartEvent && !isEmptyCharactersEvent) {
            this.segmentXmlEventWriter.add(xmlEvent);
            ++this.segmentEventCounter;
        }
    }

    private void parseContextCharacters(Characters characters) throws Exception {
        if (Objects.equals(this.currentElement, XbrlXmlTags.CONTEXT_PERIOD_INSTANT)) {
            this.currentXbrlContext.setInstantDate(this.parseDate(characters.getData()));
        } else if (Objects.equals(this.currentElement, XbrlXmlTags.CONTEXT_PERIOD_STARTDATE)) {
            this.currentXbrlContext.setStartDate(this.parseDate(characters.getData()));
        } else if (Objects.equals(this.currentElement, XbrlXmlTags.CONTEXT_PERIOD_ENDDATE)) {
            this.currentXbrlContext.setEndDate(this.parseDate(characters.getData()));
        } else if (Objects.equals(this.currentElement, XbrlXmlTags.CONTEXT_IDENTIFIER)) {
            this.currentXbrlContext.setIdentifier(characters.getData());
        } else if (Objects.equals(this.currentElement, XbrlXmlTags.CONTEXT_SCENARIO)) {
            // empty if block
        }
    }

    private void parseSchemRefStartEvents(StartElement startElement) throws IncompatibleSchemaRefException {
        Attribute baseAttr;
        QName elementQName = startElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.XBRL_ROOT) && (baseAttr = startElement.getAttributeByName(XbrlXmlTags.BASE_ATTR)) != null) {
            this.baseValue = baseAttr.getValue();
            return;
        }
        if (Objects.equals(elementQName, XbrlXmlTags.SCHEMA_REF)) {
            Attribute hrefType;
            ++this.schemaRefElementCounter;
            Attribute hrefAttr = startElement.getAttributeByName(XbrlXmlTags.SCHEMA_REF_HREF_ATTR);
            this.entryPoint = hrefAttr.getValue();
            boolean isError = false;
            if (this.baseValue != null && !this.entryPoint.contains("/")) {
                this.entryPoint = this.baseValue + this.entryPoint;
            }
            if ((hrefType = startElement.getAttributeByName(XbrlXmlTags.SCHEMA_REF_TYPE_ATTR)) == null) {
                log.warn("Incompatible schemaRefs {}", (Object)this.entryPoint);
                this.addWarning("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 xlink:type \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043e\u0431\u044a\u044f\u0432\u043b\u0435\u043d");
            } else if (hrefType.getValue() == null || !"simple".equals(hrefType.getValue())) {
                log.warn("Incompatible schemaRefs {}", (Object)this.entryPoint);
                this.addWarning("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 xlink:type \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"simple\"");
            }
            if (!this.entryPoint.startsWith("http://")) {
                log.warn("Incompatible schemaRefs {}", (Object)this.entryPoint);
                this.addWarning("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 <schemaRef> \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URI: " + this.entryPoint);
            } else {
                String currentEntryPoint = "http://" + this.expectedEntryPoint.substring(3);
                if (!this.entryPoint.equals(currentEntryPoint)) {
                    if (this.baseValue == null) {
                        this.addWarning("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 <schemaRef> \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0431\u0441\u043e\u043b\u044e\u0442\u043d\u044b\u0439 URI \u0441 \u043e\u0448\u0438\u0431\u043a\u043e\u0439 \u0432 \u043f\u0443\u0442\u0438");
                    } else {
                        this.addWarning("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 xml:base \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0443\u0442\u044c");
                    }
                    log.warn("Incompatible schemaRefs {}", (Object)this.expectedEntryPoint);
                }
            }
            if (this.checkOnlyEntryPoint) {
                this.isCheckedEntryPoint = true;
            }
        }
    }

    public void addError(String message) {
    }

    public void addWarning(String message) {
    }

    public void addContextError(String key, String message) {
    }

    private void checkEntryPoint(String ep) throws IncompatibleSchemaRefException {
        String parsedXmlSchema;
        String expectedSchema = FilenameUtils.getBaseName((String)this.expectedEntryPoint);
        if (!Objects.equals(expectedSchema, parsedXmlSchema = FilenameUtils.getBaseName((String)ep))) {
            log.warn("Incompatible schemaRefs, expected {}, current {}", (Object)expectedSchema, (Object)parsedXmlSchema);
            throw new IncompatibleSchemaRefException();
        }
    }

    private void parseContextStartEvents(StartElement startElement) throws XMLStreamException {
        QName elementQName = startElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT)) {
            this.currentContentType = XmlContentType.CONTEXT;
            Integer n = this.elementCounter;
            Integer n2 = this.elementCounter = Integer.valueOf(this.elementCounter + 1);
            this.currentXbrlContext = new XbrlContext();
            Attribute contextIdAttr = startElement.getAttributeByName(XbrlXmlTags.CONTEXT_ID_ATTR);
            this.currentXbrlContext.getXbrlContextId().setContextId(contextIdAttr.getValue());
        } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_ENTITY)) {
            this.isEntity = true;
        } else if (!Objects.equals(elementQName, XbrlXmlTags.CONTEXT_PERIOD)) {
            Attribute contextSchemeAttr;
            if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_PERIOD_INSTANT)) {
                this.currentXbrlContext.setPeriodType(PeriodType.INSTANT);
            } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_PERIOD_STARTDATE)) {
                this.currentXbrlContext.setPeriodType(PeriodType.DURATION);
            } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_PERIOD_STARTDATE)) {
                this.currentXbrlContext.setPeriodType(PeriodType.DURATION);
            } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_SCENARIO)) {
                if (this.scenarioXmlEventWriter != null) {
                    this.scenarioXmlEventWriter.close();
                }
                try {
                    if (this.scenarioStringWriter != null) {
                        this.scenarioStringWriter.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.scenarioStringWriter = new StringWriter();
                this.scenarioXmlEventWriter = this.xmlOutputFactory.createXMLEventWriter(this.scenarioStringWriter);
                this.scenarioEventCounter = 0;
                this.isProcessingScenario = true;
            } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_SEGMENT)) {
                if (this.segmentXmlEventWriter != null) {
                    this.segmentXmlEventWriter.close();
                }
                try {
                    if (this.segmentStringWriter != null) {
                        this.segmentStringWriter.close();
                    }
                }
                catch (IOException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
                this.segmentStringWriter = new StringWriter();
                this.segmentXmlEventWriter = this.xmlOutputFactory.createXMLEventWriter(this.segmentStringWriter);
                this.segmentEventCounter = 0;
                this.isProcessingSegment = true;
            } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_IDENTIFIER) && (contextSchemeAttr = startElement.getAttributeByName(XbrlXmlTags.CONTEXT_SCHEME_ATTR)) != null) {
                this.currentXbrlContext.setScheme(contextSchemeAttr.getValue());
            }
        }
    }

    private void parseContextEndEvents(EndElement endElement) throws XMLStreamException {
        if (this.currentContentType == null || this.currentContentType != XmlContentType.CONTEXT) {
            return;
        }
        QName elementQName = endElement.getName();
        if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT)) {
            this.currentContentType = null;
            this.processXbrlContext(this.currentXbrlContext, this.xbrlFilePath, Integer.valueOf(0));
            this.valueAllowed = true;
        } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_SCENARIO)) {
            this.isProcessingScenario = false;
            String scenario = this.scenarioStringWriter.toString();
            ArrayList xbrlContextDimensions = new ArrayList();
            String instancePrefix = this.namespaceContext.getPrefix("http://www.xbrl.org/2003/instance");
            new XbrlContextScenarioParser(scenario, this.namespaces, this.defaultNamespacePrefixes, instancePrefix, xbrlContextDimension -> xbrlContextDimensions.add(xbrlContextDimension));
            String preparedScenario = XbrlContextDimension.buildScenario(xbrlContextDimensions);
            this.currentXbrlContext.setScenario(preparedScenario);
            this.scenarioXmlEventWriter.close();
        } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_SEGMENT)) {
            if (!this.isEntity) {
                this.isProcessingSegment = false;
                this.segmentXmlEventWriter.close();
                this.addContextError(this.currentXbrlContext.getXbrlContextId().getContextId(), "\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 " + this.currentXbrlContext.getXbrlContextId().getContextId() + " \u0438\u043c\u0435\u0435\u0442 \u043d\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0443\u044e \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0443");
            }
            this.isProcessingSegment = false;
            this.currentXbrlContext.setSegment(this.segmentStringWriter.toString());
            this.segmentXmlEventWriter.close();
        } else if (Objects.equals(elementQName, XbrlXmlTags.CONTEXT_ENTITY)) {
            this.isEntity = false;
        }
    }

    public Date parseDate(String stringDate) throws Exception {
        if (StringUtils.isBlank((CharSequence)stringDate)) {
            throw new Exception("Date is blank");
        }
        try {
            DateTime dt = this.periodDateFormatter.parseDateTime(stringDate);
            return dt.toDate();
        }
        catch (IllegalArgumentException e) {
            log.info("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 xml. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0432 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0435 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 {}", (Object)stringDate);
            return null;
        }
    }

    private void logTreeItem(int indent, String message) {
    }

    public abstract void processXbrlContext(XbrlContext var1, String var2, Integer var3);

    public abstract void processXbrlValue(String var1, String var2, XbrlValue var3, String var4, PositionInfo var5) throws NotFoundException;

    public abstract void processXbrlUnit(XbrlUnit var1, String var2, Integer var3);

    public abstract void processXbrlFootnote(XbrlFootnote var1, String var2, Integer var3);

    public String getEntryPoint() {
        return this.entryPoint;
    }
}

