/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.PerformanceMetricValue;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.MetricType;

public class PerformanceMetricsParser {
    private static final Logger log = LoggerFactory.getLogger(PerformanceMetricsParser.class);
    private static final QName METRIC_QNAME = new QName("metric");
    private static final QName REPORT_QNAME = new QName("report");
    private static final QName TYPE_QNAME = new QName("type");
    private static final QName VALUE_QNAME = new QName("value");
    private static final QName MOMENT_QNAME = new QName("moment");
    private List<PerformanceMetricValue> performanceMetricValues = new ArrayList();
    private PerformanceMetricValue performanceMetricValue;

    public List<PerformanceMetricValue> parseXml(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(new InputStreamReader((InputStream)new BOMInputStream(inputStream), StandardCharsets.UTF_8));
        while (xmlEventReader.hasNext()) {
            EndElement endElement;
            XMLEvent xmlEvent = xmlEventReader.peek();
            if (xmlEvent.isStartElement()) {
                StartElement startElement = xmlEvent.asStartElement();
                if (startElement.getName().equals(METRIC_QNAME)) {
                    this.performanceMetricValue = new PerformanceMetricValue();
                    this.performanceMetricValue.setReportName(startElement.getAttributeByName(REPORT_QNAME).getValue());
                    this.performanceMetricValue.setMetricType(MetricType.valueOf((String)startElement.getAttributeByName(TYPE_QNAME).getValue()));
                    this.performanceMetricValue.setValue(Double.parseDouble(startElement.getAttributeByName(VALUE_QNAME).getValue()));
                    this.performanceMetricValue.setMoment(LocalTime.parse(startElement.getAttributeByName(MOMENT_QNAME).getValue()));
                }
            } else if (xmlEvent.isEndElement() && (endElement = xmlEvent.asEndElement()).getName().equals(METRIC_QNAME)) {
                this.performanceMetricValues.add(this.performanceMetricValue);
            }
            xmlEventReader.nextEvent();
        }
        return this.performanceMetricValues;
    }
}

