/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xml;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.TemplateMapping;

public class MappingXmlParser {
    private static final Logger log = LoggerFactory.getLogger(MappingXmlParser.class);

    public TemplateMapping parse(InputStream inputStream) throws XMLStreamException, IOException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        StringBuilder json = new StringBuilder();
        XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(new InputStreamReader((InputStream)new BOMInputStream(inputStream), "UTF-8"));
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            if (xmlEvent.isCharacters()) {
                json.append(xmlEvent.asCharacters().getData());
            }
            xmlEventReader.nextEvent();
        }
        return (TemplateMapping)new ObjectMapper().readValue(json.toString(), TemplateMapping.class);
    }
}

