/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.controller.import_export.ExportTemplateStruct;
import ru.cbr.xbrl.converter.utils.StaxPrettyPrintHandler;

public class DeltaXmlWriter {
    private static final Logger log = LoggerFactory.getLogger(DeltaXmlWriter.class);
    private final ExportTemplateStruct exportTemplateStruct;
    private final OutputStream outputStream;
    private final XMLStreamWriter xmlOut;
    private final String ENTRY_POINT_FILE_EXT = ".xsd";

    public DeltaXmlWriter(ExportTemplateStruct exportTemplateStruct, OutputStream outputStream) throws XMLStreamException, UnsupportedEncodingException {
        this.exportTemplateStruct = exportTemplateStruct;
        this.outputStream = outputStream;
        XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)));
        StaxPrettyPrintHandler handler = new StaxPrettyPrintHandler(xmlStreamWriter);
        this.xmlOut = (XMLStreamWriter)Proxy.newProxyInstance(XMLStreamWriter.class.getClassLoader(), new Class[]{XMLStreamWriter.class}, (InvocationHandler)handler);
        this.prepare();
        this.writeBaseInfo();
    }

    private void prepare() {
        try {
            this.xmlOut.writeStartDocument("UTF-8", "1.0");
            this.xmlOut.writeCharacters(System.getProperty("line.separator"));
        }
        catch (XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void writeBaseInfo() {
        try {
            this.xmlOut.writeStartElement("template");
            this.xmlOut.writeAttribute("createDate", LocalDate.now().toString());
            this.xmlOut.writeAttribute("version", this.exportTemplateStruct.getVersion());
            this.xmlOut.writeAttribute("entryPoint", this.exportTemplateStruct.getEntryPoint());
            this.xmlOut.writeAttribute("taxonomyVersion", this.exportTemplateStruct.getTaxonomyVersion());
            String defaultTemplateName = "Template_" + FilenameUtils.getName((String)this.exportTemplateStruct.getEntryPoint()).replace(".xsd", "") + "_" + LocalDate.now().toString() + "_" + this.exportTemplateStruct.getVersion();
            String templateName = this.exportTemplateStruct.getName().equals(defaultTemplateName) ? defaultTemplateName : this.exportTemplateStruct.getName();
            this.xmlOut.writeAttribute("name", templateName);
            this.xmlOut.writeEndElement();
            this.xmlOut.writeEndDocument();
            OutputStreamWriter osw = new OutputStreamWriter(this.outputStream);
            osw.write("");
            osw.flush();
            this.xmlOut.flush();
            this.xmlOut.close();
        }
        catch (IOException | XMLStreamException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

