/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls.presentation_definition;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.exception.SchemaValidationException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model.enums.AxisType;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.import_export.XlsxPresentationDefinitionParserHandler;
import ru.cbr.xbrl.converter.service.log.EventLogService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxParserBase;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxSheetNameGenerator;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.presentation_definition.XslxPresentationDefinitionWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public class XlsxPresentationDefinitionParser
extends XlsxParserBase {
    private static final Logger log = LoggerFactory.getLogger(XlsxPresentationDefinitionParser.class);
    public static final int TOC_OFFSET = 1;
    public static final int HEADER_INDEX = 4;
    private final String xslxFileName;
    private final XbrlPackage xbrlPackage;
    private final ConceptInMemoryService conceptInMemoryService;
    private final EventLogService eventLogService;
    private final XlsxPresentationDefinitionParserHandler aspectCelldataListConsumer;
    private final List<PresentationDefinitionRole> roles;
    private final HashMap<String, Pair<String, String>> generatedSheetNamesMap;
    private DataFormatter formatter = new DataFormatter();

    public XlsxPresentationDefinitionParser(String xslxFileName, XbrlPackage xbrlPackage, List<PresentationDefinitionRole> roles, ConceptInMemoryService conceptInMemoryService, EventLogService eventLogService, XlsxPresentationDefinitionParserHandler aspectCelldataListConsumer) throws XbrlImportException {
        this.xslxFileName = xslxFileName;
        this.xbrlPackage = xbrlPackage;
        this.eventLogService = eventLogService;
        this.aspectCelldataListConsumer = aspectCelldataListConsumer;
        this.roles = roles;
        this.conceptInMemoryService = conceptInMemoryService;
        this.generatedSheetNamesMap = this.generateSheetNamesMap();
        try {
            this.parse();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlImportException();
        }
    }

    private HashMap<String, Pair<String, String>> generateSheetNamesMap() {
        List roleNames = this.roles.stream().map(PresentationDefinitionRole::getTitle).collect(Collectors.toList());
        List generatedSheetNames = XlsxSheetNameGenerator.generateSheetNames(roleNames);
        HashMap<String, Pair<String, String>> generatedSheetNamesHashMap = new HashMap<String, Pair<String, String>>();
        for (int i = 0; i < roleNames.size(); ++i) {
            PresentationDefinitionRole role = (PresentationDefinitionRole)this.roles.get(i);
            generatedSheetNamesHashMap.putIfAbsent(role.getSystemId(), (Pair<String, String>)new ImmutablePair((Object)role.getTitle(), generatedSheetNames.get(i)));
        }
        return generatedSheetNamesHashMap;
    }

    private static String getSheetRoleSystemId(Sheet sheet) {
        Row systemIdRow = sheet.getRow(2);
        if (systemIdRow == null) {
            return null;
        }
        Cell systemIdCell = systemIdRow.getCell(0);
        if (systemIdCell == null) {
            return null;
        }
        return systemIdCell.getStringCellValue();
    }

    public static HashSet<String> getRolesFromFile(String xslxFileName) {
        HashSet<String> result = new HashSet<String>();
        try (FileInputStream excelFile = new FileInputStream(xslxFileName);
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)excelFile);){
            Iterator sheetIterator = workbook.sheetIterator();
            while (sheetIterator.hasNext()) {
                XSSFSheet xlsxSheet = (XSSFSheet)sheetIterator.next();
                String roleSystemId = XlsxPresentationDefinitionParser.getSheetRoleSystemId((Sheet)xlsxSheet);
                result.add(roleSystemId);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void parse() throws IOException {
        log.info("Parse XLSX workbook for presentation definition: " + this.xslxFileName);
        Date start = new Date();
        Map<String, PresentationDefinitionRole> rolesMap = this.roles.stream().collect(Collectors.toMap(PresentationDefinitionRole::getSystemId, r -> r));
        try (FileInputStream excelFile = new FileInputStream(this.xslxFileName);
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)excelFile);){
            AtomicInteger xlsxSheetIndex = new AtomicInteger();
            Iterator sheetIterator = workbook.sheetIterator();
            while (sheetIterator.hasNext()) {
                XSSFSheet xlsxSheet = (XSSFSheet)sheetIterator.next();
                String roleSystemId = XlsxPresentationDefinitionParser.getSheetRoleSystemId((Sheet)xlsxSheet);
                if (roleSystemId == null || !rolesMap.containsKey(roleSystemId)) continue;
                log.info("Parse XLSX workbook for presentation definition: " + roleSystemId);
                PresentationDefinitionRole role = rolesMap.get(roleSystemId);
                Map memEnums = XslxPresentationDefinitionWriter.createFromMembers((PresentationDefinitionRole)role);
                int xlsxPageIndex = 1 + xlsxSheetIndex.getAndIncrement();
                List roleAspectCellDataList = this.parseRole(role, xlsxSheet, memEnums);
                NotificationEvent notificationEvent = new NotificationEvent();
                notificationEvent.setTitle(role.getTitle());
                int currentStage = xlsxPageIndex;
                notificationEvent.setCurrentStage(Integer.valueOf(currentStage));
                notificationEvent.setTotalNumberOfStages(Integer.valueOf(this.roles.size()));
                Float progress = Float.valueOf(Float.valueOf(currentStage).floatValue() / (float)this.roles.size());
                notificationEvent.setProgress(progress);
                this.aspectCelldataListConsumer.process(role, roleAspectCellDataList, notificationEvent);
            }
            log.info("Parse XLSX workbook for presentation Definition completed in " + (new Date().getTime() - start.getTime()) + " msec");
        }
    }

    private List<AspectCellData> parseRole(PresentationDefinitionRole role, XSSFSheet xlsxSheet, Map<String, List<EnumerateItem>> memEnums) {
        ArrayList<AspectCellData> roleAspectCellData = new ArrayList<AspectCellData>();
        List dimensions = role.getDimensions();
        List concepts = role.getConcepts();
        LinkedList<Pair> expectedColumns = new LinkedList<Pair>();
        expectedColumns.add(Pair.of((Object)"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f", (Object)"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f"));
        expectedColumns.addAll(dimensions != null ? dimensions : new LinkedList());
        expectedColumns.addAll(role.getPeriods() != null ? role.getPeriods() : new LinkedList());
        HashMap mapHeader = new HashMap();
        Iterator rowIterator = xlsxSheet.rowIterator();
        List mergedRegions = xlsxSheet.getMergedRegions();
        rowIterator.forEachRemaining(row -> {
            if (!this.isExcludedRow(row)) {
                this.analyzeRow(row, roleAspectCellData, dimensions, concepts, mapHeader, mergedRegions, expectedColumns, role, memEnums);
            }
        });
        roleAspectCellData.forEach(aspectCellData -> aspectCellData.setRoleLabel(xlsxSheet.getSheetName()));
        return roleAspectCellData;
    }

    private void analyzeRow(Row row, List<AspectCellData> roleAspectCellData, List<Pair<String, String>> dimensions, List<Pair<String, String>> concepts, Map<Integer, AspectData> mapHeader, List<CellRangeAddress> mergedRegions, List<Pair<String, String>> expectedColumns, PresentationDefinitionRole role, Map<String, List<EnumerateItem>> memEnums) {
        Iterator cellIterator = row.cellIterator();
        cellIterator.forEachRemaining(cell -> this.analyzeCell(row, cell, roleAspectCellData, dimensions, concepts, mapHeader, mergedRegions, expectedColumns, role, memEnums));
    }

    private void analyzeCell(Row row, Cell cell, List<AspectCellData> roleAspectCellData, List<Pair<String, String>> dimensions, List<Pair<String, String>> concepts, Map<Integer, AspectData> mapHeader, List<CellRangeAddress> mergedRegions, List<Pair<String, String>> expectedColumns, PresentationDefinitionRole role, Map<String, List<EnumerateItem>> memEnums) {
        int columnIndex = cell.getColumnIndex();
        if (row.getRowNum() == 4) {
            this.analyzeHeader(cell, dimensions, mapHeader, columnIndex, expectedColumns, role);
        } else if (columnIndex == 0) {
            this.addConceptToMap(cell, concepts, mapHeader, columnIndex);
        } else if (dimensions != null && columnIndex <= dimensions.size()) {
            this.setAspectValueInDimension(cell, mapHeader, columnIndex, memEnums);
        } else {
            this.createAspectCellData(cell, roleAspectCellData, dimensions, mapHeader, columnIndex, mergedRegions);
        }
    }

    private void createAspectCellData(Cell cell, List<AspectCellData> roleAspectCellData, List<Pair<String, String>> dimensions, Map<Integer, AspectData> mapHeader, int columnIndex, List<CellRangeAddress> mergedRegions) {
        String cellValue = this.formatter.formatCellValue(cell);
        if (mapHeader.get(0) != null && StringUtils.isNotBlank((CharSequence)cellValue)) {
            ArrayList<AspectData> aspectDatas = new ArrayList<AspectData>();
            aspectDatas.add(mapHeader.get(0));
            int dimSize = dimensions == null ? 0 : dimensions.size();
            for (int i = 0; i < dimSize; ++i) {
                AspectData dim = mapHeader.get(i + 1);
                if (!StringUtils.isNotBlank((CharSequence)dim.getAspectValue())) continue;
                aspectDatas.add(dim);
            }
            AspectData period = mapHeader.get(columnIndex);
            aspectDatas.add(period);
            AspectCellData aspectCellData = new AspectCellData();
            aspectCellData.setAspectDataList(aspectDatas);
            aspectCellData.setCellValue(cellValue);
            CellReference cellReference = new CellReference(cell.getRowIndex(), columnIndex, false, false);
            aspectCellData.setAddress(cellReference.formatAsString());
            aspectCellData.setMerged(mergedRegions.stream().anyMatch(region -> this.isRegionContainsCell(region, cell)));
            roleAspectCellData.add(aspectCellData);
        }
    }

    private void analyzeHeader(Cell cell, List<Pair<String, String>> dimensions, Map<Integer, AspectData> mapHeader, int columnIndex, List<Pair<String, String>> expectedColumns, PresentationDefinitionRole role) {
        this.validateSchema(cell, columnIndex, expectedColumns);
        if (columnIndex != 0) {
            String cellValue = this.formatter.formatCellValue(cell);
            if (dimensions != null && columnIndex <= dimensions.size()) {
                this.addDimensionToMap(dimensions, mapHeader, columnIndex, role);
            } else {
                this.addPeriodToMap(mapHeader, columnIndex, cellValue);
            }
        }
    }

    private void validateSchema(Cell cell, int columnIndex, List<Pair<String, String>> expectedColumns) {
        Pair<String, String> expectedColumn;
        if (expectedColumns.size() <= columnIndex) {
            return;
        }
        String cellValue = this.formatter.formatCellValue(cell);
        if (!cellValue.equals((expectedColumn = expectedColumns.get(columnIndex)).getValue()) && !cellValue.equals(expectedColumn.getKey())) {
            EventLog eventLog = new EventLog();
            eventLog.setEventLogType(EventLog.EventLogType.IMPORT_XLSX);
            eventLog.setAddress(cell.getAddress().formatAsString());
            eventLog.setRole(cell.getSheet().getSheetName());
            eventLog.setMessage("\u041e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c: " + (String)expectedColumn.getValue());
            eventLog.setXbrlReportId(this.xbrlPackage.getXbrlReport().getId());
            this.eventLogService.createInNewTransaction(eventLog);
            throw new SchemaValidationException();
        }
    }

    private void addPeriodToMap(Map<Integer, AspectData> mapHeader, int columnIndex, String cellValue) {
        AspectData aspectData = new AspectData("period", AspectType.PERIOD, cellValue, null, null, null);
        mapHeader.put(columnIndex, aspectData);
    }

    private void setAspectValueInDimension(Cell cell, Map<Integer, AspectData> mapHeader, int columnIndex, Map<String, List<EnumerateItem>> memEnums) {
        String dimValue;
        String cellValue = this.formatter.formatCellValue(cell);
        AspectData dim = mapHeader.get(columnIndex);
        String dimAspect = dim.getAspect();
        if (!memEnums.isEmpty() && memEnums.containsKey(dimAspect) && (dimValue = this.findMemMemberForValue(memEnums, cellValue, dimAspect)) != null) {
            cellValue = dimValue;
        }
        AspectData aspectData = new AspectData(dimAspect, AspectType.DIMENSION, cellValue, dim.getDomain(), null, dim.getDimensionType());
        mapHeader.replace(columnIndex, aspectData);
    }

    private String findMemMemberForValue(Map<String, List<EnumerateItem>> memEnums, String cellValue, String dimAspect) {
        return memEnums.get(dimAspect).stream().filter(value -> value.getLabel().equals(cellValue)).findFirst().map(EnumerateItem::getMember).orElse(null);
    }

    private void addConceptToMap(Cell cell, List<Pair<String, String>> concepts, Map<Integer, AspectData> mapHeader, int columnIndex) {
        String conceptValue = this.formatter.formatCellValue(cell);
        Pair aspectValue = concepts.stream().filter(pair -> ((String)pair.getValue()).equals(conceptValue)).findFirst().orElse(null);
        if (aspectValue != null) {
            AspectData conceptRow = new AspectData("concept", AspectType.CONCEPT, (String)aspectValue.getKey(), null, null, null);
            conceptRow.setXsdType(this.conceptInMemoryService.findXsdTypeByConcept((String)aspectValue.getKey()));
            mapHeader.put(columnIndex, conceptRow);
        }
    }

    private void addDimensionToMap(List<Pair<String, String>> dimensions, Map<Integer, AspectData> mapHeader, int columnIndex, PresentationDefinitionRole role) {
        Pair<String, String> dimension = dimensions.get(columnIndex - 1);
        String aspect = (String)dimension.getKey();
        String domain = null;
        DimensionType type = DimensionType.EXPLICIT_MEMBER;
        if (role.getDimensions() != null && role.getDomains().containsKey(aspect)) {
            domain = (String)role.getDomains().get(aspect);
        }
        if (role.getDimensionsAxisType().containsKey(aspect) && ((AxisType)role.getDimensionsAxisType().get(aspect)).equals((Object)AxisType.OPEN)) {
            type = DimensionType.TYPED_MEMBER;
        }
        AspectData aspectData = new AspectData(aspect, AspectType.DIMENSION, null, domain, null, type);
        mapHeader.put(columnIndex, aspectData);
    }

    private boolean isExcludedRow(Row row) {
        if (row != null) {
            return row.getRowNum() < 4;
        }
        return true;
    }
}

