/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.exception.RewritableFileOpenException;
import ru.cbr.xbrl.converter.model.XbrlParameter;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.service.TemplateService;
import ru.cbr.xbrl.converter.service.XbrlParameterService;
import ru.cbr.xbrl.converter.service.XbrlPeriodService;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxEnumerationDataSheet;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxSheetNameGenerator;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxTemplateSheet;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxWriter;

@Service
@Transactional(value="cacheTransactionManager", readOnly=true)
public class XslxTemplateWriter {
    private static final Logger log = LoggerFactory.getLogger(XslxTemplateWriter.class);
    private final String xslxFileName;
    private final XbrlPackage xbrlPackage;
    private final Consumer<NotificationEvent> notificationEventConsumer;
    private final XlsxEnumerationDataSheet xlsxEnumerationDataSheet;
    private final XslxWriter.CellEditableCheckerFunction cellEditableCheckerFunction;
    private final TemplateService templateService;
    private final XbrlPeriodService xbrlPeriodService;
    private final XbrlParameterService parameterService;

    @Autowired
    public XslxTemplateWriter(String xslxFileName, XbrlPackage xbrlPackage, Consumer<NotificationEvent> notificationEventConsumer, XslxWriter.CellEditableCheckerFunction cellEditableCheckerFunction, TemplateService templateService, XbrlPeriodService xbrlPeriodService, XbrlParameterService parameterService) {
        this.xslxFileName = xslxFileName;
        this.xbrlPackage = xbrlPackage;
        this.notificationEventConsumer = notificationEventConsumer;
        this.xlsxEnumerationDataSheet = new XlsxEnumerationDataSheet(xslxFileName);
        this.cellEditableCheckerFunction = cellEditableCheckerFunction;
        this.templateService = templateService;
        this.xbrlPeriodService = xbrlPeriodService;
        this.parameterService = parameterService;
    }

    public void draw() throws IOException, RewritableFileOpenException {
        FileOutputStream out;
        XSSFWorkbook workbook = new XSSFWorkbook();
        List roles = this.xbrlPackage.getXbrlReport().getXbrlReportRoles();
        int totalRoles = this.xbrlPackage.getXbrlReport().getXbrlReportRoles().size();
        List roleNames = this.xbrlPackage.getXbrlReport().getXbrlReportRoles().stream().sorted(Comparator.comparing(XbrlReportRole::getCompareString)).map(XbrlReportRole::getTitle).collect(Collectors.toList());
        List sheetNames = XlsxSheetNameGenerator.generateSheetNames(roleNames);
        for (int i = 0; i < roles.size(); ++i) {
            FileOutputStream out2;
            String sheetTitle = (String)sheetNames.get(i);
            XbrlReportRole xbrlReportRole = (XbrlReportRole)roles.get(i);
            int currentStage = i + 1;
            this.sendNotificationEvent(totalRoles, xbrlReportRole, currentStage);
            try {
                out2 = new FileOutputStream(this.xslxFileName);
            }
            catch (FileNotFoundException e) {
                throw new RewritableFileOpenException();
            }
            XslxTemplateSheet xslxTemplateSheet = new XslxTemplateSheet(workbook, xbrlReportRole, sheetTitle, this.xlsxEnumerationDataSheet, this.cellEditableCheckerFunction, this.templateService, this.xbrlPeriodService);
            xslxTemplateSheet.drawRoleForTemplate();
            workbook.write((OutputStream)out2);
            out2.close();
        }
        try {
            out = new FileOutputStream(this.xslxFileName);
        }
        catch (FileNotFoundException e) {
            throw new RewritableFileOpenException();
        }
        XSSFSheet sheet = workbook.createSheet("\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        List parameters = this.parameterService.findAll();
        for (int rowNumber = 0; rowNumber < parameters.size(); ++rowNumber) {
            XSSFRow row = sheet.createRow(rowNumber);
            XbrlParameter parameter = (XbrlParameter)parameters.get(rowNumber);
            XSSFCell cell = row.createCell(0);
            cell.setCellValue("#" + parameter.getQName());
        }
        workbook.write((OutputStream)out);
        out.close();
        this.xlsxEnumerationDataSheet.drawEnumerationsPage(workbook);
    }

    private void sendNotificationEvent(int totalRoles, XbrlReportRole xbrlReportRole, int currentStage) {
        NotificationEvent notificationEvent = new NotificationEvent();
        notificationEvent.setTitle(xbrlReportRole.getTitle());
        notificationEvent.setTotalNumberOfStages(Integer.valueOf(totalRoles));
        notificationEvent.setCurrentStage(Integer.valueOf(currentStage));
        Float progress = Float.valueOf(Float.valueOf(currentStage).floatValue() / (float)totalRoles);
        notificationEvent.setProgress(progress);
        this.notificationEventConsumer.accept(notificationEvent);
    }
}

