/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.Fact;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.service.TemplateService;
import ru.cbr.xbrl.converter.service.XbrlPeriodService;
import ru.cbr.xbrl.converter.utils.TemplateUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.CellRange;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TableLinkViewUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TopHeaderModel;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxEnumerationDataSheet;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxWriter;

@Transactional(value="cacheTransactionManager", readOnly=true)
public class XslxTemplateSheet {
    private static final Logger log = LoggerFactory.getLogger(XslxTemplateSheet.class);
    private static final String EMPTY_ROW_HEADER = "empty row header";
    private final XSSFSheet sheet;
    private final XslxWriter.CellEditableCheckerFunction cellEditableCheckerFunction;
    private final String roleCode;
    private final TemplateService templateService;
    private final XbrlPeriodService xbrlPeriodService;
    private final TableLinkBaseStructure tableLinkBaseStructure;
    private CellRange[][] periodCellsRange;
    private CellStyle CELL_STYLE_BORDERED;
    private CellStyle CELL_STYLE_HEADER;
    private CellStyle CELL_STYLE_DISABLED;
    private XlsxEnumerationDataSheet xlsxEnumerationDataSheet;
    private Map<String, List<AspectData>> xCodes = new LinkedHashMap();
    private Map<String, List<AspectData>> yCodes = new LinkedHashMap();
    private Map<String, List<AspectData>> zCodes = new LinkedHashMap();
    private Map<String, AxisMemberHierarchy> yItems = new LinkedHashMap();
    private int topHeaderHeight;
    private int topHeaderWidth;
    private ColumnHeader[][] header;
    private List<ColumnHeader> leavesHeader = new ArrayList();
    private boolean haveZRow = false;
    private boolean isXRcCodePresent;
    private boolean isYRcCodePresent;
    private String[] xRcCodes;

    public XslxTemplateSheet(XSSFWorkbook book, XbrlReportRole xbrlReportRole, String sheetTitle, XlsxEnumerationDataSheet xlsxEnumerationDataSheet, XslxWriter.CellEditableCheckerFunction cellEditableCheckerFunction, TemplateService templateService, XbrlPeriodService xbrlPeriodService) throws IOException {
        this.tableLinkBaseStructure = (TableLinkBaseStructure)new ObjectMapper().readValue((Reader)new StringReader(xbrlReportRole.getStaticStructureJson()), TableLinkBaseStructure.class);
        this.sheet = book.createSheet(sheetTitle);
        this.roleCode = xbrlReportRole.getRoleId();
        this.xlsxEnumerationDataSheet = xlsxEnumerationDataSheet;
        this.cellEditableCheckerFunction = cellEditableCheckerFunction;
        this.templateService = templateService;
        this.xbrlPeriodService = xbrlPeriodService;
        this.createDefaultStyle();
        this.createBoldStyle();
        this.createDisabledStyle();
    }

    public void drawRoleForTemplate() {
        try {
            this.templateService.fillAxisCodes(this.zCodes, this.tableLinkBaseStructure.getZAxis(), "", new ArrayList());
            this.isXRcCodePresent = StringUtils.equals((CharSequence)this.tableLinkBaseStructure.getXAxis().getRcCode(), (CharSequence)"true");
            this.isYRcCodePresent = StringUtils.equals((CharSequence)this.tableLinkBaseStructure.getYAxis().getRcCode(), (CharSequence)"true");
            List zData = this.zCodes.containsKey("1") ? (List)this.zCodes.get("1") : this.zCodes.getOrDefault("1N", Collections.emptyList());
            this.haveZRow = zData.size() > 0;
            ArrayList generalAspectData = new ArrayList(zData);
            if (this.tableLinkBaseStructure.getPeriods() != null && this.tableLinkBaseStructure.getPeriods().size() > 0) {
                XbrlPeriod period = this.xbrlPeriodService.getContextPeriod();
                if (period == null) {
                    period = this.xbrlPeriodService.getDefaultPeriod();
                }
                generalAspectData.add(period.toPeriodDates().buildAspectData());
            }
            this.tableLinkBaseStructure.getXAxis().getAxisMemberHierarchyList().remove(0);
            List encodedAxises = this.encodeAxises(generalAspectData);
            this.buildHeader();
            this.drawRows(encodedAxises);
            this.drawTopheaderArray();
            this.drawPeriodToExcel();
            if (this.haveZRow) {
                XSSFRow row = this.sheet.createRow(0);
                if (zData.size() == 2) {
                    List notEmptyRows = IteratorUtils.toList((Iterator)this.sheet.rowIterator()).stream().filter(row1 -> row1.getPhysicalNumberOfCells() > 0).collect(Collectors.toList());
                    int firstCell = notEmptyRows.stream().mapToInt(Row::getFirstCellNum).min().orElse(0);
                    int lastCell = notEmptyRows.stream().mapToInt(notEmptyRow -> notEmptyRow.getLastCellNum() - 1).max().orElse(0);
                    CellRangeAddress range = new CellRangeAddress(((Row)notEmptyRows.get(0)).getRowNum(), ((Row)notEmptyRows.get(notEmptyRows.size() - 1)).getRowNum(), firstCell, lastCell);
                    row.createCell(0).setCellValue("R_" + range.formatAsString().replace(":", "_"));
                }
                for (int i = 0; i < zData.size(); ++i) {
                    row.createCell(i + 1).setCellValue("Z:" + ((AspectData)zData.get(i)).getAspect());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<YLevel> encodeAxises(List<AspectData> generalAspectData) {
        this.templateService.fillAxisCodes(this.xCodes, this.tableLinkBaseStructure.getXAxis(), "", new ArrayList());
        this.templateService.fillAxisCodes(this.yCodes, this.tableLinkBaseStructure.getYAxis(), "", new ArrayList());
        this.templateService.fillCodeItems(this.yItems, this.tableLinkBaseStructure.getYAxis(), "");
        ArrayList<YLevel> yLevels = new ArrayList<YLevel>();
        for (String yCode : this.yCodes.keySet()) {
            YLevel yLevel = new YLevel();
            AxisMemberHierarchy yItem = (AxisMemberHierarchy)this.yItems.get(yCode);
            yLevel.setRcCode(yItem.getRcCode());
            yLevel.setTitle(TemplateUtils.getTitleCode((boolean)false, (String)this.roleCode, (String)"0", (String)yCode, (AxisMemberHierarchy)yItem));
            yLevel.setLevel(Integer.valueOf(yCode.split("-").length));
            for (String xCode : this.xCodes.keySet()) {
                Fact fact = new Fact();
                ArrayList<AspectData> fullAspectData = new ArrayList<AspectData>();
                fullAspectData.addAll((Collection)this.xCodes.get(xCode));
                fullAspectData.addAll((Collection)this.yCodes.get(yCode));
                fullAspectData.addAll(generalAspectData);
                AspectCellData aspectCellData = new AspectCellData(fullAspectData);
                if (yItem.isAbstractNode() || aspectCellData.getConcept() == null || aspectCellData.getConcept().isAbstractNode() || this.cellEditableCheckerFunction.check(aspectCellData)) {
                    fact.setDisabled(true);
                } else {
                    fact.setValue(this.roleCode + ":" + xCode + ":" + yCode);
                }
                yLevel.getFactMap().put(xCode, fact);
            }
            yLevel.setAspectDataList((List)this.yCodes.get(yCode));
            yLevels.add(yLevel);
        }
        return yLevels;
    }

    private void buildHeader() {
        ColumnHeader parentHeader = new ColumnHeader();
        this.templateService.buildColumnsHierarchy(this.roleCode, parentHeader, this.tableLinkBaseStructure.getXAxis(), "");
        this.templateService.fillColumnsColspan(parentHeader);
        this.templateService.findLeaveHeaders(this.leavesHeader, parentHeader);
        this.topHeaderHeight = TableLinkViewUtils.calcHeadersDepth((List)parentHeader.getColumnList());
        if (this.isXRcCodePresent) {
            ++this.topHeaderHeight;
        }
        this.topHeaderWidth = this.leavesHeader.size() + 1;
        this.periodCellsRange = new CellRange[this.topHeaderHeight + this.yCodes.size() + 1][this.topHeaderWidth + 1];
        this.header = new ColumnHeader[this.topHeaderWidth][this.topHeaderHeight];
        ColumnHeader titleHeader = new ColumnHeader();
        titleHeader.setCaption(this.roleCode);
        titleHeader.setDataField("title");
        titleHeader.setColspan(Integer.valueOf(1));
        titleHeader.setY(Integer.valueOf(0));
        titleHeader.setX(Integer.valueOf(0));
        titleHeader.setHash("title");
        this.header[0][0] = titleHeader;
        this.xRcCodes = new String[this.topHeaderWidth];
        TopHeaderModel.fillTopHeaderCoords((ColumnHeader[][])this.header, (String[])this.xRcCodes, (List)parentHeader.getColumnList(), (int)1, (int)0);
    }

    private void drawRows(List<YLevel> yLevels) {
        for (int y = 0; y < yLevels.size(); ++y) {
            YLevel columnHeader = yLevels.get(y);
            int cellY = y + this.topHeaderHeight;
            String value = StringUtils.isNotBlank((CharSequence)columnHeader.getTitle()) ? columnHeader.getTitle() : EMPTY_ROW_HEADER;
            String levelIndent = StringUtils.repeat((String)" ", (int)(6 * (columnHeader.getLevel() - 1)));
            this.periodCellsRange[cellY][0] = new CellRange();
            this.periodCellsRange[cellY][0].setValue(levelIndent + value);
            if (this.isYRcCodePresent) {
                this.periodCellsRange[cellY][1] = new CellRange();
                String rcCode = columnHeader.getRcCode();
                if (StringUtils.isBlank((CharSequence)rcCode) && StringUtils.startsWith((CharSequence)value, (CharSequence)"C_")) {
                    this.periodCellsRange[cellY][1].setValue("<->");
                } else {
                    this.periodCellsRange[cellY][1].setValue(rcCode);
                }
            }
            this.drawFacts(cellY, columnHeader.getFactMap());
        }
    }

    private void drawFacts(int cellY, Map<String, Fact> facts) {
        List dataFields = this.leavesHeader.stream().map(ColumnHeader::getDataField).collect(Collectors.toList());
        for (int colIndex = 0; colIndex < dataFields.size(); ++colIndex) {
            String dataField = (String)dataFields.get(colIndex);
            if (StringUtils.equals((CharSequence)dataField, (CharSequence)"rcCode")) continue;
            int cellX = colIndex + 1;
            this.periodCellsRange[cellY][cellX] = new CellRange();
            if (dataField == null) continue;
            Fact fact = facts.getOrDefault(dataField, new Fact());
            String factValue = fact.getValue();
            this.periodCellsRange[cellY][cellX].setEditable(!fact.isDisabled());
            this.periodCellsRange[cellY][cellX].setValue(factValue);
        }
    }

    private void drawTopheaderArray() {
        for (int x = 0; x < this.topHeaderWidth; ++x) {
            for (int y = 0; y < this.topHeaderHeight; ++y) {
                String value;
                if (y + 1 == this.topHeaderHeight && this.isXRcCodePresent) {
                    this.periodCellsRange[y][x] = new CellRange();
                    this.periodCellsRange[y][x].setValue(this.xRcCodes[x]);
                    this.periodCellsRange[y][x].setColspan(1);
                    continue;
                }
                ColumnHeader columnHeader = this.header[x][y];
                if (columnHeader == null) continue;
                this.periodCellsRange[y][x] = new CellRange();
                String string = value = StringUtils.isNotBlank((CharSequence)columnHeader.getCaption()) ? columnHeader.getCaption() : "";
                if (StringUtils.startsWith((CharSequence)value, (CharSequence)"header_common_title_")) {
                    value = "";
                }
                this.periodCellsRange[y][x].setValue(value);
                this.periodCellsRange[y][x].setColspan(columnHeader.getColspan().intValue());
            }
        }
    }

    private void drawPeriodToExcel() {
        this.setWidths();
        for (int y = 0; y < this.topHeaderHeight + this.yCodes.size(); ++y) {
            int rowNum = y + BooleanUtils.toInteger((boolean)this.haveZRow);
            XSSFRow row = this.sheet.createRow(rowNum);
            for (int x = 0; x < this.topHeaderWidth; ++x) {
                Cell cell = row.createCell(x);
                boolean isFirstColumn = x % (this.topHeaderWidth + 1) == 0;
                boolean isTopHeader = y < this.topHeaderHeight;
                CellRange cellRange = this.periodCellsRange[y][x];
                if (isFirstColumn) {
                    cell.setCellStyle(this.CELL_STYLE_HEADER);
                } else if (isTopHeader) {
                    cell.setCellStyle(this.CELL_STYLE_HEADER);
                } else if (cellRange != null && !cellRange.isEditable()) {
                    cell.setCellStyle(this.CELL_STYLE_DISABLED);
                } else {
                    cell.setCellStyle(this.CELL_STYLE_BORDERED);
                }
                if (cellRange == null) continue;
                if (StringUtils.isNotBlank((CharSequence)cellRange.getValue())) {
                    cell.setCellValue(cellRange.getValue());
                }
                String conceptName = cellRange.getConceptName();
                this.addEnumConstraintsToCell(cell, conceptName);
                if (cellRange.getColspan() <= 1) continue;
                try {
                    this.sheet.addMergedRegion(new CellRangeAddress(rowNum, rowNum, x, x + cellRange.getColspan() - 1));
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void addEnumConstraintsToCell(Cell cell, String conceptName) {
        if (StringUtils.isNotBlank((CharSequence)conceptName) && this.xlsxEnumerationDataSheet.getEnumPageItemsMap().containsKey(conceptName)) {
            CellRangeAddressList addressList = new CellRangeAddressList(cell.getRow().getRowNum(), cell.getRow().getRowNum(), cell.getColumnIndex(), cell.getColumnIndex());
            XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(this.sheet);
            XSSFDataValidationConstraint constraint = (XSSFDataValidationConstraint)dvHelper.createFormulaListConstraint(this.xlsxEnumerationDataSheet.getEnumReference(conceptName));
            XSSFDataValidation dataValidation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)constraint, addressList);
            dataValidation.setEmptyCellAllowed(true);
            dataValidation.setShowErrorBox(true);
            this.sheet.addValidationData((DataValidation)dataValidation);
        }
    }

    private void setWidths() {
        for (int x = 0; x < this.topHeaderWidth; ++x) {
            boolean isFirstColumn;
            boolean bl = isFirstColumn = x % this.topHeaderWidth == 0;
            if (isFirstColumn) {
                this.sheet.setColumnWidth(x, 12750);
                continue;
            }
            this.sheet.setColumnWidth(x, 5100);
        }
    }

    private void createDefaultStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        this.CELL_STYLE_BORDERED = style;
    }

    private void createBoldStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont defaultFont = this.sheet.getWorkbook().createFont();
        defaultFont.setFontHeightInPoints((short)10);
        defaultFont.setFontName("Arial");
        defaultFont.setColor(IndexedColors.BLACK.getIndex());
        defaultFont.setItalic(false);
        style.setFont((Font)defaultFont);
        this.CELL_STYLE_HEADER = style;
    }

    private void createDisabledStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.CELL_STYLE_DISABLED = style;
    }
}

