/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.exception.UnsupportedAlternativeExportRoleException;
import ru.cbr.xbrl.converter.model.DataType;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.Fact;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.PeriodLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.TLBUiModel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.ZLevel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.CellRange;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.SheetModel;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TableLinkViewUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxEnumerationDataSheet;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public class XslxSheet {
    private static final Logger log = LoggerFactory.getLogger(XslxSheet.class);
    public static final String EMPTY_ROW_HEADER = "empty row header";
    private final XSSFSheet sheet;
    private final XbrlReportRole xbrlReportRole;
    private final Boolean xlsxWriteAxisId;
    private final Boolean xlsxWriteAspectData;
    private final XslxWriter.CellEditableCheckerFunction cellEditableCheckerFunction;
    private SheetModel sheetModel;
    private CellRange[][] periodCellsRange;
    private CellStyle CELL_STYLE_BORDERED;
    private CellStyle CELL_STYLE_HEADER;
    private CellStyle CELL_STYLE_DISABLED;
    private static String CHAR_130 = Character.toString('\u0082');
    private XlsxEnumerationDataSheet xlsxEnumerationDataSheet;
    private boolean yLevelAsColumns;
    private boolean exportWithDataOnly;

    XslxSheet(XSSFWorkbook book, XbrlReportRole xbrlReportRole, String sheetTitle, TLBUiModel tlbUiModel, XlsxEnumerationDataSheet xlsxEnumerationDataSheet, Boolean xlsxWriteAspectData, Boolean xlsxWriteAxisId, XslxWriter.CellEditableCheckerFunction cellEditableCheckerFunction, boolean yLevelAsColumns, boolean exportWithDataOnly) throws UnsupportedAlternativeExportRoleException {
        this.xbrlReportRole = xbrlReportRole;
        this.xlsxWriteAxisId = xlsxWriteAxisId;
        this.sheet = book.createSheet(sheetTitle);
        this.drawRoleInfo(book, xbrlReportRole);
        this.xlsxEnumerationDataSheet = xlsxEnumerationDataSheet;
        this.xlsxWriteAspectData = xlsxWriteAspectData;
        this.cellEditableCheckerFunction = cellEditableCheckerFunction;
        this.yLevelAsColumns = yLevelAsColumns;
        this.exportWithDataOnly = exportWithDataOnly;
        this.createDefaultStyle();
        this.createBoldStyle();
        this.createDisabledStyle();
    }

    boolean draw(TLBUiModel tlbUiModel) {
        boolean isThereAnyData = false;
        if (tlbUiModel != null) {
            boolean hasZAxis;
            TableLinkViewUtils.calcColspans((List)tlbUiModel.getColumnList());
            this.sheetModel = new SheetModel(tlbUiModel, this.yLevelAsColumns);
            List periods = tlbUiModel.getPeriodLevelList();
            boolean bl = hasZAxis = periods.size() > 0 && ((PeriodLevel)periods.get(0)).getZLevelList() != null && ((PeriodLevel)periods.get(0)).getZLevelList().size() > 0;
            if (hasZAxis) {
                isThereAnyData = this.drawRole();
            }
        }
        return isThereAnyData;
    }

    private void drawRoleInfo(XSSFWorkbook workbook, XbrlReportRole xbrlReportRole) {
        XSSFCell cellToc = this.sheet.createRow(0).createCell(0);
        cellToc.setCellValue("TOC");
        XSSFHyperlink link = workbook.getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
        link.setAddress("'TOC'!A1");
        cellToc.setHyperlink((Hyperlink)link);
        this.sheet.createRow(1).createCell(0).setCellValue(xbrlReportRole.getTitle());
        this.sheet.createRow(2).createCell(0).setCellValue(xbrlReportRole.getSystemId());
    }

    private void drawRows(PeriodLevel periodLevel, ZLevel zLevel, int leftX, List<YLevel> yLevelsUnwinded) {
        for (int y = 0; y < yLevelsUnwinded.size(); ++y) {
            String value;
            YLevel columnHeader = yLevelsUnwinded.get(y);
            int cellY = y + this.sheetModel.getTopHeaderHeight() + 1;
            String string = value = StringUtils.isNotBlank((CharSequence)columnHeader.getTitle()) ? columnHeader.getTitle() : "empty row header";
            if (BooleanUtils.isTrue((Boolean)this.xlsxWriteAspectData)) {
                value = value + "\n" + this.aspectDataListToString(columnHeader.getFullAspectDataList());
                if (BooleanUtils.isTrue((Boolean)this.xlsxWriteAxisId)) {
                    value = value + this.getAxisId(columnHeader.getFullAspectDataList());
                }
            }
            String levelIndent = StringUtils.repeat((String)" ", (int)(6 * (columnHeader.getLevel() - 1)));
            this.periodCellsRange[cellY][leftX] = new CellRange();
            this.periodCellsRange[cellY][leftX].setValue(levelIndent + value);
            if (this.sheetModel.isYRcCodePresent()) {
                this.periodCellsRange[cellY][leftX + 1] = new CellRange();
                this.periodCellsRange[cellY][leftX + 1].setValue(columnHeader.getRcCode());
            }
            this.drawFacts(periodLevel, zLevel, columnHeader, leftX, cellY, columnHeader.getFactMap());
        }
    }

    private String getAxisId(List<AspectData> aspectDataList) {
        return aspectDataList.stream().filter(aspectData -> aspectData.getAxisId() != null).findFirst().map(aspectData -> String.format("\n%s:%s", "AXIS_ID_TC", aspectData.getAxisId())).orElse("");
    }

    private void drawFacts(PeriodLevel periodLevel, ZLevel zLevel, YLevel yLevel, int leftX, int cellY, Map<String, Fact> facts) {
        ColumnHeader[] leaves = this.sheetModel.getTopHeaderModel().getLeaves();
        String[] dataFields = this.sheetModel.getTopHeaderModel().getDataFields();
        for (int colIndex = 1; colIndex < dataFields.length; ++colIndex) {
            String conceptName;
            String dataField = dataFields[colIndex];
            if (StringUtils.equals((CharSequence)dataField, (CharSequence)"rcCode")) continue;
            int cellX = leftX + colIndex;
            this.periodCellsRange[cellY][cellX] = new CellRange();
            if (!StringUtils.startsWith((CharSequence)dataField, (CharSequence)"header_common_title_")) {
                conceptName = this.getConceptName(periodLevel, zLevel, yLevel, leaves, dataField);
                if (conceptName == null) {
                    log.warn("Concept is null, role {}, yLevel {}, dataField {}", new Object[]{this.xbrlReportRole.getTitle(), yLevel.getTitle(), dataField});
                }
            } else {
                conceptName = "header_common_title_";
            }
            if (dataField == null) continue;
            Fact fact = facts.getOrDefault(dataField, new Fact());
            String factValue = fact.getValue();
            this.periodCellsRange[cellY][cellX].setEditable(!fact.isDisabled());
            if (this.sheetModel.getEnumerations().containsKey(conceptName)) {
                Optional enumerateItemOptional = XslxSheet.getEnumeratedFactValueByMember((Map)this.sheetModel.getEnumerations(), (String)factValue, (String)conceptName);
                if (!enumerateItemOptional.isPresent() && StringUtils.isNotBlank((CharSequence)factValue)) {
                    log.warn("Enumeration value not present, role {}, conceptName {}, factValue {}", new Object[]{this.xbrlReportRole.getTitle(), conceptName, factValue});
                }
                String enumValue = enumerateItemOptional.isPresent() ? ((EnumerateItem)enumerateItemOptional.get()).getLabel() : factValue;
                this.periodCellsRange[cellY][cellX].setConceptName(conceptName);
                this.periodCellsRange[cellY][cellX].setValue(enumValue);
                continue;
            }
            this.periodCellsRange[cellY][cellX].setValue(factValue);
        }
    }

    public String checkEnumerationValue(String factValue, AspectData concept, Map<String, List<EnumerateItem>> enumerations) {
        String conceptName = concept.getAspectValue();
        DataType dataType = concept.getConceptDataType();
        if (StringUtils.isBlank((CharSequence)factValue)) {
            return "";
        }
        if (CollectionUtils.isEmpty(enumerations)) {
            return factValue;
        }
        if (!enumerations.containsKey(conceptName)) {
            return factValue;
        }
        Optional enumerateItemOptional = XslxSheet.getEnumeratedFactValueByMember(enumerations, (String)factValue, (String)conceptName);
        if (dataType == DataType.ENUM2) {
            return XslxSheet.getEnumeratedFactValueByMemberEnum2(enumerations, (String)factValue, (String)conceptName);
        }
        if (!enumerateItemOptional.isPresent()) {
            log.warn("Enumeration value not present, role {}, conceptName {}, factValue {}", new Object[]{this.xbrlReportRole.getTitle(), conceptName, factValue});
        }
        return enumerateItemOptional.isPresent() ? ((EnumerateItem)enumerateItemOptional.get()).getLabel() : factValue;
    }

    public static String getEnumeratedFactValueByMemberEnum2(Map<String, List<EnumerateItem>> enumerations, String factValue, String conceptName) {
        String[] factValues = factValue.split(" ");
        ArrayList<String> labelsList = new ArrayList<String>();
        List<EnumerateItem> enumerateItems = enumerations.get(conceptName);
        block0: for (String factVal : factValues) {
            for (EnumerateItem item : enumerateItems) {
                if (!factVal.equals(item.getMember())) continue;
                labelsList.add(item.getLabel());
                continue block0;
            }
        }
        Collections.sort(labelsList);
        String label = String.join((CharSequence)", ", labelsList);
        return label;
    }

    public static Optional<EnumerateItem> getEnumeratedFactValueByMember(Map<String, List<EnumerateItem>> enumerations, String factValue, String conceptName) {
        List<EnumerateItem> enumerateItems = enumerations.get(conceptName);
        Optional<EnumerateItem> enumerateItemOptional = enumerateItems.stream().filter(enumerateItem -> enumerateItem.getMember().equals(factValue)).findFirst();
        return enumerateItemOptional;
    }

    public static Optional<EnumerateItem> getEnumeratedFactValueByLabel(Map<String, List<EnumerateItem>> enumerations, String factValue, String conceptName) {
        List<EnumerateItem> enumerateItems = enumerations.get(conceptName);
        Optional<EnumerateItem> enumerateItemOptional = enumerateItems.stream().filter(enumerateItem -> enumerateItem.getLabel().equals(factValue)).findFirst();
        return enumerateItemOptional;
    }

    public static String getEnumeratedFactValueByLabel(Map<String, List<EnumerateItem>> enumerations, String factValue, AspectData concept) {
        List<EnumerateItem> enumerateItems = enumerations.get(concept.getAspectValue());
        if (enumerateItems == null) {
            return factValue;
        }
        if (concept.getConceptDataType() != DataType.ENUM2) {
            Optional<EnumerateItem> enumerateItemOptional = enumerateItems.stream().filter(enumerateItem -> enumerateItem.getLabel().equals(factValue)).findFirst();
            if (enumerateItemOptional.isPresent()) {
                return enumerateItemOptional.get().getMember();
            }
        } else {
            String[] factLabels = factValue.split(", ");
            ArrayList<String> members = new ArrayList<String>();
            block0: for (String f : factLabels) {
                for (EnumerateItem enumerateItem2 : enumerateItems) {
                    if (!enumerateItem2.getLabel().trim().equals(f.trim())) continue;
                    members.add(enumerateItem2.getMember());
                    continue block0;
                }
            }
            Collections.sort(members);
            return String.join((CharSequence)" ", members);
        }
        return null;
    }

    private String getConceptName(PeriodLevel periodLevel, ZLevel zLevel, YLevel yLevel, ColumnHeader[] columnHeaders, String dataField) {
        AspectCellData aspectCellData = this.getAspectCellData(periodLevel, zLevel, yLevel, columnHeaders, dataField);
        AspectData concept = aspectCellData.getConcept();
        if (concept == null) {
            return null;
        }
        return concept.getAspectValue();
    }

    private AspectCellData getAspectCellData(PeriodLevel periodLevel, ZLevel zLevel, YLevel yLevel, ColumnHeader[] columnHeaders, String dataField) {
        ArrayList aspectDataList = new ArrayList();
        aspectDataList.addAll(periodLevel.getAspectDataList());
        aspectDataList.addAll(zLevel.getAspectDataList());
        aspectDataList.addAll(yLevel.getFullAspectDataList());
        Optional<ColumnHeader> columnHeader = Arrays.stream(columnHeaders).filter(c -> c.getDataField().equals(dataField)).findFirst();
        aspectDataList.addAll(columnHeader.get().getFullAspectDataList());
        AspectCellData aspectCellData = new AspectCellData();
        aspectCellData.setAspectDataList(aspectDataList);
        return aspectCellData;
    }

    public void drawTopheaderArray(int leftX) {
        for (int y = 0; y < this.sheetModel.getTopHeaderHeight(); ++y) {
            int cellY = y + 1;
            for (int x = leftX; x < leftX + this.sheetModel.getTableWidth(); ++x) {
                String value;
                int cellX = x;
                if (y + 1 == this.sheetModel.getTopHeaderHeight() && this.sheetModel.isXRcCodePresent()) {
                    value = this.sheetModel.getTopHeaderModel().getRcCodes()[x - leftX];
                    this.periodCellsRange[cellY][cellX] = new CellRange();
                    this.periodCellsRange[cellY][cellX].setValue(value);
                    this.periodCellsRange[cellY][cellX].setColspan(1);
                    continue;
                }
                ColumnHeader columnHeader = this.sheetModel.getTopHeaderModel().getTopHeaderModel()[x - leftX][y];
                if (columnHeader == null) continue;
                if (this.yLevelAsColumns) {
                    cellY = columnHeader.getDataField() != null && columnHeader.getDataField().startsWith("header_common_title_") ? this.sheetModel.getTopHeaderHeight() : y + 1;
                }
                this.periodCellsRange[cellY][cellX] = new CellRange();
                String string = value = StringUtils.isNotBlank((CharSequence)columnHeader.getCaption()) ? columnHeader.getCaption() : "";
                if (StringUtils.startsWith((CharSequence)value, (CharSequence)"header_common_title_")) {
                    value = "";
                }
                if (BooleanUtils.isTrue((Boolean)this.xlsxWriteAspectData)) {
                    value = value + "\n" + this.aspectDataListToString(columnHeader.getFullAspectDataList());
                }
                this.periodCellsRange[cellY][cellX].setValue(value);
                this.periodCellsRange[cellY][cellX].setColspan(columnHeader.getColspan().intValue());
            }
        }
    }

    public String aspectDataListToString(List<AspectData> aspectDataList) {
        return aspectDataList.stream().map(aspectData -> {
            if (aspectData.getType().equals((Object)AspectType.CONCEPT)) {
                return "CONCEPT: " + aspectData.getAspectValue();
            }
            if (aspectData.getType().equals((Object)AspectType.DIMENSION)) {
                return "DIMENSION: " + aspectData.getAspect() + " ->" + aspectData.getAspectValue();
            }
            return "";
        }).collect(Collectors.joining("\n"));
    }

    private boolean drawRole() {
        boolean isThereAnyData = false;
        try {
            for (int periodIndex = 0; periodIndex < this.sheetModel.getTlbUiModel().getPeriodLevelList().size(); ++periodIndex) {
                PeriodLevel periodLevel = (PeriodLevel)this.sheetModel.getTlbUiModel().getPeriodLevelList().get(periodIndex);
                isThereAnyData = isThereAnyData || this.drawPeriodLevel(periodIndex, periodLevel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isThereAnyData;
    }

    private void drawGridLabels(int zTableOffset, PeriodLevel periodLevel, ZLevel zLevel) {
        int firstColumnIndex = zTableOffset;
        int lastColumnIndex = zTableOffset + this.sheetModel.getTableWidth() - 1;
        int rowIndex = 0;
        this.periodCellsRange[rowIndex][firstColumnIndex] = new CellRange();
        String periodLabelText = StringUtils.isNotBlank((CharSequence)periodLevel.getLabel()) ? periodLevel.getLabel() : "empty period label";
        this.periodCellsRange[rowIndex][firstColumnIndex].setValue("T= " + periodLabelText);
        this.periodCellsRange[rowIndex][lastColumnIndex] = new CellRange();
        this.periodCellsRange[rowIndex][lastColumnIndex].setValue("Z= " + zLevel.getTitle());
    }

    private boolean drawPeriodLevel(int periodIndex, PeriodLevel periodLevel) {
        List zLevelList = periodLevel.getZLevelList();
        this.periodCellsRange = new CellRange[this.sheetModel.getTableHeight() + 1][(this.sheetModel.getTableWidth() + 1 + 1) * zLevelList.size()];
        int actualZIdx = 0;
        boolean isThereAnyData = false;
        for (int z = 0; z < zLevelList.size(); ++z) {
            ZLevel zLevel = (ZLevel)zLevelList.get(z);
            List yLevelsUnwinded = new ArrayList();
            if (!this.yLevelAsColumns) {
                yLevelsUnwinded = this.sheetModel.getLeftHeaderModel().prepareLeftHeader(zLevel);
            }
            boolean isThereAnyDataInZ = yLevelsUnwinded.stream().anyMatch(it -> it.getFactMap().values().stream().anyMatch(v -> v != null && !"".equals(v.getValue())));
            boolean bl = isThereAnyData = isThereAnyData || isThereAnyDataInZ;
            if (this.exportWithDataOnly && !isThereAnyDataInZ) continue;
            YLevel.collectFullAspectListForEachYLevel((List)zLevel.getYLevelList(), null);
            int zTableOffset = actualZIdx * (this.sheetModel.getTableWidth() + 1);
            ++actualZIdx;
            this.drawGridLabels(zTableOffset, periodLevel, zLevel);
            if (CollectionUtils.isEmpty(yLevelsUnwinded)) {
                this.drawLines(periodLevel, zLevel, zTableOffset);
            } else {
                this.drawRows(periodLevel, zLevel, zTableOffset, yLevelsUnwinded);
            }
            this.drawTopheaderArray(zTableOffset);
        }
        if (actualZIdx > 0) {
            this.drawPeriodToExcel(periodIndex, actualZIdx);
        }
        return isThereAnyData;
    }

    private void drawLines(PeriodLevel periodLevel, ZLevel zLevel, int leftX) {
        List yLevelList = zLevel.getYLevelList();
        if (CollectionUtils.isEmpty((Collection)yLevelList)) {
            return;
        }
        int cellY = this.sheetModel.getTopHeaderHeight() + 1;
        Integer maxLevel = ((YLevel)yLevelList.get(0)).getLevel();
        ArrayList yLevelLastChildList = new ArrayList();
        if (((YLevel)yLevelList.get(0)).getNodeType() == NodeType.ASPECT) {
            for (YLevel yLevel : yLevelList) {
                yLevelLastChildList.addAll(this.prepareLastChildList(yLevel));
            }
        }
        if (((YLevel)yLevelList.get(0)).getNodeType() == NodeType.RULE) {
            for (YLevel yLevel : yLevelList) {
                yLevelLastChildList.addAll(this.prepareRuleChildList(yLevel));
            }
        }
        for (YLevel yLevel : yLevelLastChildList) {
            this.drawLine(periodLevel, zLevel, leftX, yLevel, maxLevel, cellY);
            ++cellY;
        }
    }

    private List<YLevel> prepareRuleChildList(YLevel yLevel) {
        if (yLevel == null) {
            return Collections.emptyList();
        }
        ArrayList<YLevel> yLevelRuleChildList = new ArrayList<YLevel>();
        List yLevelList = yLevel.getYLevelList();
        yLevelRuleChildList.add(yLevel);
        for (YLevel level : yLevelList) {
            yLevelRuleChildList.addAll(this.prepareLastChildList(level));
        }
        return yLevelRuleChildList;
    }

    private List<YLevel> prepareLastChildList(YLevel yLevel) {
        if (yLevel == null) {
            return Collections.emptyList();
        }
        ArrayList<YLevel> yLevelLastChildList = new ArrayList<YLevel>();
        List yLevelList = yLevel.getYLevelList();
        if (CollectionUtils.isEmpty((Collection)yLevelList)) {
            yLevelLastChildList.add(yLevel);
            return yLevelLastChildList;
        }
        for (YLevel level : yLevelList) {
            yLevelLastChildList.addAll(this.prepareLastChildList(level));
        }
        return yLevelLastChildList;
    }

    private void drawLine(PeriodLevel periodLevel, ZLevel zLevel, int leftX, YLevel yLevel, Integer maxLevel, int cellY) {
        ColumnHeader[] leaves = this.sheetModel.getTopHeaderModel().getLeaves();
        String[] dataFields = this.sheetModel.getTopHeaderModel().getDataFields();
        for (int colIndex = 0; colIndex < dataFields.length; ++colIndex) {
            String factValue;
            Fact fact;
            String conceptName;
            if (yLevel.getNodeType() == NodeType.RULE && maxLevel - yLevel.getLevel() > colIndex) continue;
            String dataField = dataFields[colIndex];
            int cellX = leftX + colIndex;
            try {
                this.periodCellsRange[cellY][cellX] = new CellRange();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (!StringUtils.startsWith((CharSequence)dataField, (CharSequence)"header_common_title_")) {
                conceptName = this.getConceptName(periodLevel, zLevel, yLevel, leaves, dataField);
                if (conceptName == null) {
                    log.warn("Concept is null, role {}, yLevel {}, dataField {}", new Object[]{this.xbrlReportRole.getTitle(), yLevel.getTitle(), dataField});
                }
            } else {
                conceptName = "header_common_title_";
                if (yLevel.getNodeType() == NodeType.RULE) {
                    fact = yLevel.getFactMap().getOrDefault(dataField, new Fact());
                    factValue = fact.getValue();
                    this.periodCellsRange[cellY][cellX].setEditable(false);
                    if (!yLevel.isAbstractNode() && !StringUtils.isBlank((CharSequence)factValue)) {
                        this.periodCellsRange[cellY][cellX].setColspan(yLevel.getLevel().intValue());
                    }
                    this.periodCellsRange[cellY][cellX].setValue(factValue);
                    continue;
                }
            }
            if (dataField == null) continue;
            fact = yLevel.getFactMap().getOrDefault(dataField, new Fact());
            factValue = fact.getValue();
            this.periodCellsRange[cellY][cellX].setEditable(!fact.isDisabled());
            if (!StringUtils.isNotBlank((CharSequence)factValue)) continue;
            if (this.sheetModel.getEnumerations().containsKey(conceptName)) {
                Optional enumerateItemOptional = XslxSheet.getEnumeratedFactValueByMember((Map)this.sheetModel.getEnumerations(), (String)factValue, (String)conceptName);
                if (!enumerateItemOptional.isPresent()) {
                    log.warn("Enumeration value not present, role {}, conceptName {}, factValue {}", new Object[]{this.xbrlReportRole.getTitle(), conceptName, factValue});
                }
                String enumValue = enumerateItemOptional.isPresent() ? ((EnumerateItem)enumerateItemOptional.get()).getLabel() : factValue;
                this.periodCellsRange[cellY][cellX].setValue(enumValue);
                continue;
            }
            this.periodCellsRange[cellY][cellX].setValue(factValue);
        }
    }

    private void drawPeriodToExcel(int periodIndex, int zSize) {
        int periodBias = this.sheetModel.getPeriodBias(periodIndex);
        this.setWidths(zSize);
        for (int y = 0; y < this.sheetModel.getTableHeight(); ++y) {
            XSSFRow row = this.sheet.createRow(y + periodBias);
            for (int x = 0; x < (this.sheetModel.getTableWidth() + 1) * zSize - 1; ++x) {
                Cell cell = row.createCell(x);
                boolean isVertDivider = x % (this.sheetModel.getTableWidth() + 1) == this.sheetModel.getTableWidth();
                boolean isFirstColumn = x % (this.sheetModel.getTableWidth() + 1) == 0;
                boolean isTopHeader = y < this.sheetModel.getTopHeaderHeight() + 1;
                CellRange cellRange = this.periodCellsRange[y][x];
                if (isFirstColumn) {
                    cell.setCellStyle(this.CELL_STYLE_HEADER);
                } else if (!isVertDivider) {
                    if (isTopHeader) {
                        cell.setCellStyle(this.CELL_STYLE_HEADER);
                    } else if (cellRange != null && !cellRange.isEditable()) {
                        cell.setCellStyle(this.CELL_STYLE_DISABLED);
                    } else {
                        cell.setCellStyle(this.CELL_STYLE_BORDERED);
                    }
                }
                if (cellRange == null) continue;
                if (StringUtils.isNotBlank((CharSequence)cellRange.getValue())) {
                    cell.setCellValue(cellRange.getValue());
                }
                if (BooleanUtils.isTrue((Boolean)this.xlsxWriteAspectData) && !isTopHeader && !isFirstColumn && StringUtils.isNotBlank((CharSequence)cellRange.getConceptName())) {
                    cell.setCellValue(cellRange.getConceptName());
                }
                String conceptName = cellRange.getConceptName();
                this.addEnumConstraintsToCell(cell, conceptName);
                if (cellRange.getColspan() <= 1) continue;
                try {
                    this.sheet.addMergedRegion(new CellRangeAddress(y + periodBias, y + periodBias, x, x + cellRange.getColspan() - 1));
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Row getRow(int rowNum) {
        XSSFRow row = this.sheet.getRow(rowNum);
        if (row == null) {
            return this.sheet.createRow(rowNum);
        }
        return row;
    }

    public Cell createCell(Row row, int colNum) {
        return row.createCell(colNum);
    }

    public void addEnumConstraintsToCell(Cell cell, String conceptName) {
        this.addEnumConstraintsToCell(cell, conceptName, false);
    }

    public void addEnumConstraintsToCell(Cell cell, String conceptName, boolean isShowError) {
        if (StringUtils.isNotBlank((CharSequence)conceptName) && this.xlsxEnumerationDataSheet.getEnumPageItemsMap().containsKey(conceptName)) {
            CellRangeAddressList addressList = new CellRangeAddressList(cell.getRow().getRowNum(), cell.getRow().getRowNum(), cell.getColumnIndex(), cell.getColumnIndex());
            XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(this.sheet);
            XSSFDataValidationConstraint constraint = (XSSFDataValidationConstraint)dvHelper.createFormulaListConstraint(this.xlsxEnumerationDataSheet.getEnumReference(conceptName));
            XSSFDataValidation dataValidation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)constraint, addressList);
            dataValidation.setEmptyCellAllowed(true);
            dataValidation.setShowErrorBox(isShowError);
            this.sheet.addValidationData((DataValidation)dataValidation);
        }
    }

    private void setWidths(int zSize) {
        for (int x = 0; x < (this.sheetModel.getTableWidth() + 1) * zSize - 1; ++x) {
            boolean isFirstColumn;
            boolean bl = isFirstColumn = x % (this.sheetModel.getTableWidth() + 1) == 0;
            if (isFirstColumn) {
                this.sheet.setColumnWidth(x, 12750);
                continue;
            }
            this.sheet.setColumnWidth(x, 5100);
        }
    }

    public void createDefaultStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        this.CELL_STYLE_BORDERED = style;
    }

    public void createBoldStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont defaultFont = this.sheet.getWorkbook().createFont();
        defaultFont.setFontHeightInPoints((short)10);
        defaultFont.setFontName("Arial");
        defaultFont.setColor(IndexedColors.BLACK.getIndex());
        defaultFont.setItalic(false);
        style.setFont((Font)defaultFont);
        this.CELL_STYLE_HEADER = style;
    }

    public void createDisabledStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.CELL_STYLE_DISABLED = style;
    }

    public CellStyle getCellStyleBordered() {
        return this.CELL_STYLE_BORDERED;
    }

    public CellStyle getCellStyleHeader() {
        return this.CELL_STYLE_HEADER;
    }

    public CellStyle getCellStyleDisabled() {
        return this.CELL_STYLE_DISABLED;
    }

    public void addMergedRegion(CellRangeAddress region) {
        try {
            this.sheet.addMergedRegion(region);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setColumnWidth(int colNumber, int width) {
        this.sheet.setColumnWidth(colNumber, width);
    }

    public XlsxEnumerationDataSheet getEnumeratorData() {
        return this.xlsxEnumerationDataSheet;
    }

    public void setRegionBorder(BorderStyle border, CellRangeAddress cra) {
        RegionUtil.setBorderBottom((BorderStyle)border, (CellRangeAddress)cra, (Sheet)this.sheet);
        RegionUtil.setBorderTop((BorderStyle)border, (CellRangeAddress)cra, (Sheet)this.sheet);
        RegionUtil.setBorderLeft((BorderStyle)border, (CellRangeAddress)cra, (Sheet)this.sheet);
        RegionUtil.setBorderRight((BorderStyle)border, (CellRangeAddress)cra, (Sheet)this.sheet);
    }

    public boolean isExportWithDataOnly() {
        return this.exportWithDataOnly;
    }
}

