/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxSheetNameGenerator;

public class XlsxContentSheet {
    public static final int DEFAULT_ASPECT_OFFSET = 2;
    public static final String DEFAULT_LANGUAGE = "ru";
    private final String currency;
    private CellStyle CELL_STYLE_BORDERED;
    private CellStyle CELL_STYLE_TABLE_HEADER;
    private final XbrlPackage xbrlPackage;
    private XSSFWorkbook workbook;
    private XSSFSheet sheet;
    public static final int DEFAULT_ASPECT_HEIGHT = 6;
    public static final int LINK_N_WIDTH = 4080;
    public static final int LINK_COLUMN_WIDTH = 8160;
    public static final int LINK_DESCRIPTION_WIDTH = 24480;

    public XlsxContentSheet(XSSFWorkbook workbook, XbrlPackage xbrlPackage, List<XbrlReportRole> roles, List<PresentationDefinitionRole> presentationDefinitionRoles, String currency) {
        this.workbook = workbook;
        this.xbrlPackage = xbrlPackage;
        this.currency = currency;
        this.draw(roles, presentationDefinitionRoles);
    }

    public XlsxContentSheet(XSSFWorkbook workbook, XbrlPackage xbrlPackage, String currency) {
        this.workbook = workbook;
        this.xbrlPackage = xbrlPackage;
        this.currency = currency;
        this.createSheet();
    }

    private void createSheet() {
        this.sheet = this.workbook.createSheet("TOC");
        this.createBoldStyle();
        this.createBorderedStyle();
        this.sheet.setColumnWidth(0, 4080);
        this.sheet.setColumnWidth(1, 8160);
        this.sheet.setColumnWidth(2, 24480);
        this.sheet.createRow(0).createCell(0).setCellValue(this.xbrlPackage.getPathToXsd());
        this.drawDefaultAspect(2);
    }

    public void drawToc(List<XbrlReportRole> roles, List<PresentationDefinitionRole> presentationDefinitionRoles) {
        this.drawToc(11, roles, presentationDefinitionRoles);
    }

    private void draw(List<XbrlReportRole> roles, List<PresentationDefinitionRole> presentationDefinitionRoles) {
        this.createSheet();
        this.drawToc(11, roles, presentationDefinitionRoles);
    }

    private void drawToc(int offset, List<XbrlReportRole> roles, List<PresentationDefinitionRole> presentationDefinitionRoles) {
        XSSFCell cellHeaderDescription;
        XSSFCell cellHeaderTable;
        XSSFRow titleRow = this.sheet.createRow(offset);
        titleRow.createCell(0).setCellValue("Table of Contents");
        XSSFRow headerRow = this.sheet.createRow(offset + 1);
        XSSFCell cellHeaderNo = headerRow.createCell(0);
        cellHeaderNo.setCellValue("No.");
        this.setComment(cellHeaderNo, "The serial number");
        cellHeaderNo.setCellStyle(this.CELL_STYLE_TABLE_HEADER);
        if (roles != null) {
            cellHeaderTable = headerRow.createCell(1);
            cellHeaderTable.setCellValue("table");
            this.setComment(cellHeaderTable, "The name of the table. Clink on the link to go to that related sheet.");
            cellHeaderTable.setCellStyle(this.CELL_STYLE_TABLE_HEADER);
            cellHeaderDescription = headerRow.createCell(2);
            cellHeaderDescription.setCellValue("description");
            this.setComment(cellHeaderDescription, "The description of the table.");
            cellHeaderDescription.setCellStyle(this.CELL_STYLE_TABLE_HEADER);
        } else {
            cellHeaderTable = headerRow.createCell(1);
            cellHeaderTable.setCellValue("Role");
            this.setComment(cellHeaderTable, "The name of the role. Clink on the link to go to that related sheet.");
            cellHeaderTable.setCellStyle(this.CELL_STYLE_TABLE_HEADER);
            cellHeaderDescription = headerRow.createCell(2);
            cellHeaderDescription.setCellValue("Primary item");
            this.setComment(cellHeaderDescription, "The primary item of the role.");
            cellHeaderDescription.setCellStyle(this.CELL_STYLE_TABLE_HEADER);
        }
        List roleNames = null;
        roleNames = roles != null ? roles.stream().map(XbrlReportRole::getTitle).collect(Collectors.toList()) : presentationDefinitionRoles.stream().map(PresentationDefinitionRole::getRoledefinition).collect(Collectors.toList());
        List sheetNames = XlsxSheetNameGenerator.generateSheetNames(roleNames);
        for (int i = 0; i < roleNames.size(); ++i) {
            String sheetName = (String)sheetNames.get(i);
            XSSFRow tocRow = this.sheet.createRow(offset + i + 2);
            XSSFCell cellNo = tocRow.createCell(0);
            cellNo.setCellValue((double)(i + 1));
            cellNo.setCellStyle(this.CELL_STYLE_BORDERED);
            XSSFCell tocTableCell = tocRow.createCell(1);
            tocTableCell.setCellValue((String)roleNames.get(i));
            tocTableCell.setCellStyle(this.CELL_STYLE_BORDERED);
            XSSFHyperlink link = this.workbook.getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
            link.setAddress("'" + sheetName + "'!A1");
            tocTableCell.setHyperlink((Hyperlink)link);
            XSSFCell roleNameCell = tocRow.createCell(2);
            if (roles != null) {
                roleNameCell.setCellValue((String)roleNames.get(i));
                roleNameCell.setCellStyle(this.CELL_STYLE_BORDERED);
                continue;
            }
            PresentationDefinitionRole pdRole = presentationDefinitionRoles.get(i);
            roleNameCell.setCellValue(pdRole.getTitle());
            roleNameCell.setCellStyle(this.CELL_STYLE_BORDERED);
        }
    }

    private void drawDefaultAspect(int offset) {
        XSSFRow titleRow = this.sheet.createRow(offset);
        titleRow.createCell(0).setCellValue("Default Aspect");
        XSSFRow headerRow = this.sheet.createRow(offset + 1);
        XSSFCell cellCategory = headerRow.createCell(0);
        cellCategory.setCellValue("category");
        this.setComment(cellCategory, "The category of the default aspect information.");
        cellCategory.setCellStyle(this.CELL_STYLE_TABLE_HEADER);
        XSSFCell cellValue = headerRow.createCell(1);
        cellValue.setCellValue("value");
        this.setComment(cellValue, "The value of the aspect.");
        cellValue.setCellStyle(this.CELL_STYLE_TABLE_HEADER);
        LinkedHashMap<String, String> rows = new LinkedHashMap<String, String>();
        rows.put("Period Start", PeriodDates.formatDate((Date)this.xbrlPackage.getContextPeriod().getStartDate()));
        rows.put("Period End", PeriodDates.formatDate((Date)this.xbrlPackage.getContextPeriod().getEndDate()));
        rows.put("Identifier", this.xbrlPackage.getOgrn());
        rows.put("Scheme", "http://www.cbr.ru");
        rows.put("Currency", this.currency);
        rows.put("Language", DEFAULT_LANGUAGE);
        AtomicInteger i = new AtomicInteger();
        rows.entrySet().stream().forEach(stringStringEntry -> {
            String aspectName = (String)stringStringEntry.getKey();
            String aspectValue = (String)stringStringEntry.getValue();
            XSSFRow aspectRow = this.sheet.createRow(offset + i.get() + 1 + 1);
            XSSFCell aspectNameCell = aspectRow.createCell(0);
            aspectNameCell.setCellValue(aspectName);
            aspectNameCell.setCellStyle(this.CELL_STYLE_BORDERED);
            XSSFCell aspectValueCell = aspectRow.createCell(1);
            aspectValueCell.setCellValue(aspectValue);
            aspectValueCell.setCellStyle(this.CELL_STYLE_BORDERED);
            i.incrementAndGet();
        });
    }

    private void createBorderedStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        this.CELL_STYLE_BORDERED = style;
    }

    private void createBoldStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont defaultFont = this.sheet.getWorkbook().createFont();
        defaultFont.setFontHeightInPoints((short)10);
        defaultFont.setFontName("Arial");
        defaultFont.setColor(IndexedColors.BLACK.getIndex());
        defaultFont.setItalic(false);
        style.setFont((Font)defaultFont);
        this.CELL_STYLE_TABLE_HEADER = style;
    }

    private void setComment(XSSFCell cell, String commentText) {
        XSSFClientAnchor anchor = this.workbook.getCreationHelper().createClientAnchor();
        XSSFDrawing drawing = this.sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment((ClientAnchor)anchor);
        XSSFRichTextString str = this.workbook.getCreationHelper().createRichTextString(commentText);
        comment.setString((RichTextString)str);
        comment.setAuthor("Apache POI");
        cell.setCellComment(comment);
    }
}

