/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.PeriodLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.TLBUiModel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.YLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.ZLevel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;

/*
 * Exception performing whole class analysis ignored.
 */
public class TableLinkViewUtils {
    static void calcColspans(List<ColumnHeader> columnHeaders) {
        for (ColumnHeader columnHeader : columnHeaders) {
            TableLinkViewUtils.calcColspans((List)columnHeader.getColumnList());
            Integer sumChildrenColspan = columnHeader.getColumnList().isEmpty() ? Integer.valueOf(1) : columnHeader.getColumnList().stream().map(ColumnHeader::getColspan).reduce(0, Integer::sum);
            columnHeader.setColspan(sumChildrenColspan);
        }
    }

    public static int calcHeadersDepth(List<ColumnHeader> columnHeaders) {
        if (columnHeaders.isEmpty()) {
            return 0;
        }
        ArrayList<Integer> depths = new ArrayList<Integer>();
        for (ColumnHeader columnHeader : columnHeaders) {
            int depth = TableLinkViewUtils.calcHeadersDepth((List)columnHeader.getColumnList());
            depths.add(depth);
        }
        if (columnHeaders.stream().map(ColumnHeader::getCaption).collect(Collectors.toSet()).stream().allMatch(s -> StringUtils.startsWith((CharSequence)s, (CharSequence)"header_common_title_"))) {
            return (Integer)Collections.max(depths);
        }
        return (Integer)Collections.max(depths) + 1;
    }

    public static void calcYLevelSpans(List<YLevel> columnHeaders, int depth) {
        for (YLevel columnHeader : columnHeaders) {
            TableLinkViewUtils.calcYLevelSpans((List)columnHeader.getYLevelList(), (int)(depth + 1));
            Integer sumChildrenColspan = columnHeader.getYLevelList().isEmpty() ? Integer.valueOf(1) : columnHeader.getYLevelList().stream().map(c -> c.getRowspan()).reduce(0, Integer::sum);
            columnHeader.setRowspan(sumChildrenColspan);
            columnHeader.setLevel(Integer.valueOf(depth));
        }
    }

    public static int calcYLevelDepth(List<YLevel> yLevelList) {
        if (yLevelList.isEmpty()) {
            return 0;
        }
        ArrayList<Integer> depths = new ArrayList<Integer>();
        for (YLevel columnHeader : yLevelList) {
            int depth = TableLinkViewUtils.calcYLevelDepth((List)columnHeader.getYLevelList());
            depths.add(depth);
        }
        return (Integer)Collections.max(depths) + 1;
    }

    public static int calcYLevelRuleDepth(List<YLevel> yLevelList) {
        if (yLevelList.isEmpty()) {
            return 0;
        }
        ArrayList<Integer> depths = new ArrayList<Integer>();
        for (YLevel yLevel : yLevelList) {
            if (yLevel.getNodeType() != NodeType.RULE) continue;
            int depth = TableLinkViewUtils.calcYLevelDepth((List)yLevel.getYLevelList());
            depths.add(depth);
        }
        return (Integer)Collections.max(depths) + 1;
    }

    public static List<YLevel> unwindYlevels(List<YLevel> columnHeaders) {
        ArrayList<YLevel> result = new ArrayList<YLevel>();
        for (YLevel columnHeader : columnHeaders) {
            result.add(columnHeader);
            result.addAll(TableLinkViewUtils.unwindYlevels((List)columnHeader.getYLevelList()));
        }
        return result;
    }

    public static ColumnHeader[][] transpose(ColumnHeader[][] array) {
        if (array == null || array.length == 0) {
            return array;
        }
        int width = array.length;
        int height = array[0].length;
        ColumnHeader[][] array_new = new ColumnHeader[height][width];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                array_new[y][x] = array[x][y];
            }
        }
        return array_new;
    }

    public static void printArray(ColumnHeader[][] array) {
        int colLength = 15;
        for (ColumnHeader[] columnRow : array) {
            String line = StringUtils.repeat((String)"-", (int)((colLength + 4) * columnRow.length + 1));
            System.out.println(line);
            for (ColumnHeader col : columnRow) {
                int i = 1;
                String v = col == null ? "spanned" : (col.getCaption() != null ? StringUtils.substring((String)col.getCaption(), (int)0, (int)colLength) : "empty");
                String value = String.format("|%02d %" + colLength + "s", i, v);
                System.out.print(value);
                ++i;
            }
            System.out.println("|\n" + line);
        }
    }

    public static int calcXAxisAspects(TLBUiModel tlbUiModel) {
        return 0;
    }

    public static Set<String> calcYAxisAspects(List<YLevel> yLevelList) {
        if (CollectionUtils.isEmpty(yLevelList)) {
            return Collections.emptySet();
        }
        HashSet<String> aspectNodeIdSet = new HashSet<String>();
        for (YLevel yLevel : yLevelList) {
            if (yLevel.getNodeType() == NodeType.ASPECT) {
                aspectNodeIdSet.addAll(yLevel.getAspectDataList().stream().map(AspectData::getAspect).collect(Collectors.toSet()));
            }
            aspectNodeIdSet.addAll(TableLinkViewUtils.calcYAxisAspects((List)yLevel.getYLevelList()));
        }
        return aspectNodeIdSet;
    }

    private static Set<String> getChildAspectSet(YLevel yLevel) {
        if (yLevel == null) {
            return Collections.emptySet();
        }
        List childAspectNodeList = yLevel.getChildAspectNodes();
        HashSet<String> result = CollectionUtils.isEmpty((Collection)childAspectNodeList) ? new HashSet<String>() : new HashSet(childAspectNodeList);
        List yLevelList = yLevel.getYLevelList();
        if (CollectionUtils.isEmpty((Collection)yLevelList)) {
            return result;
        }
        for (YLevel level : yLevelList) {
            result.addAll(TableLinkViewUtils.getChildAspectSet((YLevel)level));
        }
        return result;
    }

    public static List<YLevel> getYLevel(TLBUiModel tlbUiModel) {
        List periodLevelList = tlbUiModel.getPeriodLevelList();
        if (CollectionUtils.isEmpty((Collection)periodLevelList)) {
            return Collections.emptyList();
        }
        PeriodLevel periodLevel = (PeriodLevel)periodLevelList.get(0);
        if (periodLevel == null) {
            return Collections.emptyList();
        }
        List zLevelList = periodLevel.getZLevelList();
        if (CollectionUtils.isEmpty((Collection)zLevelList)) {
            return Collections.emptyList();
        }
        ZLevel zLevel = (ZLevel)zLevelList.get(0);
        if (zLevel == null) {
            return Collections.emptyList();
        }
        return zLevel.getYLevelList();
    }

    private TableLinkViewUtils() {
    }
}

