/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.xls;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.PeriodLevel;
import ru.cbr.xbrl.converter.model.tableLinkBase.ui.TLBUiModel;
import ru.cbr.xbrl.converter.model.web.rest.ColumnHeader;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.LeftHeaderModel;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TableLinkViewUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.TopHeaderModel;

public class SheetModel {
    private static final Logger log = LoggerFactory.getLogger(SheetModel.class);
    public static final int INDENT_SIZE = 6;
    public static final int GRID_DIVIDER_HORIZONTAL = 1;
    public static final int GRID_DIVIDER_VERTICAL = 1;
    public static final int GRID_LABELS_OFFSET = 1;
    public static final int PERIODS_TOP_OFFSET = 4;
    public static final int COLUMN_WIDTH_FIRST_HEADER = 12750;
    public static final int COLUMN_WIDTH_DEFAULT = 5100;
    private final Integer topHeaderHeight;
    private final Integer tableWidth;
    private final Map<String, List<EnumerateItem>> enumerations;
    private Integer tableHeight;
    private TLBUiModel tlbUiModel;
    private TopHeaderModel topHeaderModel;
    private LeftHeaderModel leftHeaderModel;
    private boolean isXRcCodePresent;
    private boolean isYRcCodePresent;

    SheetModel(TLBUiModel tlbUiModel, boolean yLevelAsColumns) {
        boolean hasZAxis;
        this.isXRcCodePresent = tlbUiModel.isXRcCodePresent();
        this.isYRcCodePresent = tlbUiModel.isYRcCodePresent();
        this.tlbUiModel = tlbUiModel;
        this.enumerations = tlbUiModel.getEnumerations();
        int headersDepth = TableLinkViewUtils.calcHeadersDepth((List)tlbUiModel.getColumnList());
        this.topHeaderHeight = yLevelAsColumns && headersDepth > 2 ? Integer.valueOf(headersDepth + 1) : (this.isXRcCodePresent ? Integer.valueOf(headersDepth + 1) : Integer.valueOf(headersDepth));
        this.topHeaderModel = new TopHeaderModel(tlbUiModel, yLevelAsColumns);
        this.tableWidth = tlbUiModel.getColumnList().stream().map(ColumnHeader::getColspan).reduce(0, Integer::sum);
        List periods = tlbUiModel.getPeriodLevelList();
        boolean bl = hasZAxis = periods.size() > 0 && ((PeriodLevel)periods.get(0)).getZLevelList() != null && ((PeriodLevel)periods.get(0)).getZLevelList().size() > 0;
        if (hasZAxis && !yLevelAsColumns) {
            this.leftHeaderModel = new LeftHeaderModel(tlbUiModel);
            int leftHeaderHeight = this.leftHeaderModel.getLeftHeaderHeight();
            this.tableHeight = leftHeaderHeight + this.topHeaderHeight + 1;
        }
    }

    int getPeriodBias(int periodIndex) {
        int tableHeight = this.getTableHeight() != null ? this.getTableHeight() : 0;
        int periodBias = 4 + (1 + tableHeight) * periodIndex;
        return periodBias;
    }

    int getPeriodBiasNewFormat(int periodIndex, int tableHeight) {
        return 4 + (1 + tableHeight) * periodIndex;
    }

    public Integer getTopHeaderHeight() {
        return this.topHeaderHeight;
    }

    public Integer getTableWidth() {
        return this.tableWidth;
    }

    public Map<String, List<EnumerateItem>> getEnumerations() {
        return this.enumerations;
    }

    public Integer getTableHeight() {
        return this.tableHeight;
    }

    public TLBUiModel getTlbUiModel() {
        return this.tlbUiModel;
    }

    public TopHeaderModel getTopHeaderModel() {
        return this.topHeaderModel;
    }

    public LeftHeaderModel getLeftHeaderModel() {
        return this.leftHeaderModel;
    }

    public boolean isXRcCodePresent() {
        return this.isXRcCodePresent;
    }

    public boolean isYRcCodePresent() {
        return this.isYRcCodePresent;
    }

    public void setTableHeight(Integer tableHeight) {
        this.tableHeight = tableHeight;
    }

    public void setTlbUiModel(TLBUiModel tlbUiModel) {
        this.tlbUiModel = tlbUiModel;
    }

    public void setTopHeaderModel(TopHeaderModel topHeaderModel) {
        this.topHeaderModel = topHeaderModel;
    }

    public void setLeftHeaderModel(LeftHeaderModel leftHeaderModel) {
        this.leftHeaderModel = leftHeaderModel;
    }

    public void setXRcCodePresent(boolean isXRcCodePresent) {
        this.isXRcCodePresent = isXRcCodePresent;
    }

    public void setYRcCodePresent(boolean isYRcCodePresent) {
        this.isYRcCodePresent = isYRcCodePresent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SheetModel)) {
            return false;
        }
        SheetModel other = (SheetModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$topHeaderHeight = this.getTopHeaderHeight();
        Integer other$topHeaderHeight = other.getTopHeaderHeight();
        if (this$topHeaderHeight == null ? other$topHeaderHeight != null : !((Object)this$topHeaderHeight).equals(other$topHeaderHeight)) {
            return false;
        }
        Integer this$tableWidth = this.getTableWidth();
        Integer other$tableWidth = other.getTableWidth();
        if (this$tableWidth == null ? other$tableWidth != null : !((Object)this$tableWidth).equals(other$tableWidth)) {
            return false;
        }
        Map this$enumerations = this.getEnumerations();
        Map other$enumerations = other.getEnumerations();
        if (this$enumerations == null ? other$enumerations != null : !((Object)this$enumerations).equals(other$enumerations)) {
            return false;
        }
        Integer this$tableHeight = this.getTableHeight();
        Integer other$tableHeight = other.getTableHeight();
        if (this$tableHeight == null ? other$tableHeight != null : !((Object)this$tableHeight).equals(other$tableHeight)) {
            return false;
        }
        TLBUiModel this$tlbUiModel = this.getTlbUiModel();
        TLBUiModel other$tlbUiModel = other.getTlbUiModel();
        if (this$tlbUiModel == null ? other$tlbUiModel != null : !this$tlbUiModel.equals(other$tlbUiModel)) {
            return false;
        }
        TopHeaderModel this$topHeaderModel = this.getTopHeaderModel();
        TopHeaderModel other$topHeaderModel = other.getTopHeaderModel();
        if (this$topHeaderModel == null ? other$topHeaderModel != null : !this$topHeaderModel.equals(other$topHeaderModel)) {
            return false;
        }
        LeftHeaderModel this$leftHeaderModel = this.getLeftHeaderModel();
        LeftHeaderModel other$leftHeaderModel = other.getLeftHeaderModel();
        if (this$leftHeaderModel == null ? other$leftHeaderModel != null : !this$leftHeaderModel.equals(other$leftHeaderModel)) {
            return false;
        }
        if (this.isXRcCodePresent() != other.isXRcCodePresent()) {
            return false;
        }
        return this.isYRcCodePresent() == other.isYRcCodePresent();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SheetModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $topHeaderHeight = this.getTopHeaderHeight();
        result = result * 59 + ($topHeaderHeight == null ? 43 : ((Object)$topHeaderHeight).hashCode());
        Integer $tableWidth = this.getTableWidth();
        result = result * 59 + ($tableWidth == null ? 43 : ((Object)$tableWidth).hashCode());
        Map $enumerations = this.getEnumerations();
        result = result * 59 + ($enumerations == null ? 43 : ((Object)$enumerations).hashCode());
        Integer $tableHeight = this.getTableHeight();
        result = result * 59 + ($tableHeight == null ? 43 : ((Object)$tableHeight).hashCode());
        TLBUiModel $tlbUiModel = this.getTlbUiModel();
        result = result * 59 + ($tlbUiModel == null ? 43 : $tlbUiModel.hashCode());
        TopHeaderModel $topHeaderModel = this.getTopHeaderModel();
        result = result * 59 + ($topHeaderModel == null ? 43 : $topHeaderModel.hashCode());
        LeftHeaderModel $leftHeaderModel = this.getLeftHeaderModel();
        result = result * 59 + ($leftHeaderModel == null ? 43 : $leftHeaderModel.hashCode());
        result = result * 59 + (this.isXRcCodePresent() ? 79 : 97);
        result = result * 59 + (this.isYRcCodePresent() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SheetModel(topHeaderHeight=" + this.getTopHeaderHeight() + ", tableWidth=" + this.getTableWidth() + ", enumerations=" + this.getEnumerations() + ", tableHeight=" + this.getTableHeight() + ", tlbUiModel=" + this.getTlbUiModel() + ", topHeaderModel=" + this.getTopHeaderModel() + ", leftHeaderModel=" + this.getLeftHeaderModel() + ", isXRcCodePresent=" + this.isXRcCodePresent() + ", isYRcCodePresent=" + this.isYRcCodePresent() + ")";
    }
}

