/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.scenario;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

public class XbrlContextScenarioParser {
    private static final Logger log = LoggerFactory.getLogger(XbrlContextScenarioParser.class);
    public static final QName SCENARIO = new QName("http://www.xbrl.org/2003/instance", "scenario");
    public static final QName SCENARIO_EXPLICIT_MEMBER = new QName("http://xbrl.org/2006/xbrldi", "explicitMember");
    public static final QName SCENARIO_TYPED_MEMBER = new QName("http://xbrl.org/2006/xbrldi", "typedMember");
    public static final QName DIMENSION_ATTR = new QName("dimension");
    public static final String MEM_INT_URI = "http://www.cbr.ru/xbrl/udr/dom/mem-int";
    public static final String DEFAULT_MEM_INT_PREFIX = "mem-int";
    public static final String DIM_INT_URI = "http://www.cbr.ru/xbrl/udr/dim/dim-int";
    public static final String DEFAULT_DIM_INT_PREFIX = "dim-int";
    public static final String DEFAULT_SCENARIO_NAMESPACES = "<xbrli:scenario xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xbrldi=\"http://xbrl.org/2006/xbrldi\" xmlns:xbrli=\"http://www.xbrl.org/2003/instance\" xmlns:dim-int=\"http://www.cbr.ru/xbrl/udr/dim/dim-int\">";
    public static final String QNAME_DIVIDER = ":";
    private Map<String, String> defaultNamespacePrefixes = new HashMap();
    private Set<Namespace> scenarioNamespaces = new HashSet();
    private String instancePrefix;
    private NamespaceContext namespaceContext;
    private final Consumer<XbrlContextDimension> consumer;
    int indent = 0;
    private QName currentElement;
    private XbrlContextDimension currentXbrlContextDimension;
    private boolean isTypedMemberProcessed = false;

    public XbrlContextScenarioParser(String scenarioXml, Consumer<XbrlContextDimension> consumer) {
        this.consumer = consumer;
        if (StringUtils.isNotBlank((CharSequence)scenarioXml)) {
            this.parse(this.wrapScenario(scenarioXml));
        }
    }

    public XbrlContextScenarioParser(String scenarioXml, Set<Namespace> scenarioNamespaces, Map<String, String> defaultNamespacePrefixes, String instancePrefix, Consumer<XbrlContextDimension> consumer) {
        this.consumer = consumer;
        this.scenarioNamespaces = scenarioNamespaces;
        this.instancePrefix = instancePrefix;
        this.defaultNamespacePrefixes = defaultNamespacePrefixes;
        if (StringUtils.isNotBlank((CharSequence)scenarioXml)) {
            this.parse(this.wrapScenario(scenarioXml));
        }
    }

    private void parse(String xml) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(new StringReader(xml));
            while (xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.peek();
                this.processEvent(xmlEvent);
                xmlEventReader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XbrlImportException e) {
            e.printStackTrace();
        }
    }

    private void processEvent(XMLEvent xmlEvent) throws IOException, XMLStreamException, XbrlImportException {
        block8: {
            try {
                if (xmlEvent.isStartDocument()) break block8;
                if (xmlEvent.isStartElement()) {
                    QName elementQName;
                    ++this.indent;
                    StartElement startElement = xmlEvent.asStartElement();
                    this.currentElement = elementQName = startElement.getName();
                    this.logTreeItem(this.indent, "startElement " + elementQName.getLocalPart());
                    this.parseExplicitMemberStart(xmlEvent, startElement);
                    this.parseTypedMemberStart(xmlEvent, startElement);
                    break block8;
                }
                if (xmlEvent.isCharacters()) {
                    Characters characters = xmlEvent.asCharacters();
                    if (StringUtils.isNotBlank((CharSequence)characters.getData())) {
                        this.logTreeItem(this.indent + 1, "characters " + characters.getData() + "///  of " + this.currentElement.getLocalPart());
                    }
                    this.parseExplicitMemberCharacters(xmlEvent, characters);
                    this.parseTypedMemberCharacters(xmlEvent, characters);
                    break block8;
                }
                if (xmlEvent.isEndElement()) {
                    EndElement endElement = xmlEvent.asEndElement();
                    QName elementQName = endElement.getName();
                    this.parseExplicitMemberEnd(xmlEvent, endElement);
                    this.parseTypedMemberEnd(xmlEvent, endElement);
                    this.currentElement = null;
                    this.logTreeItem(this.indent, "endElement " + elementQName.getLocalPart());
                    --this.indent;
                    break block8;
                }
                if (!xmlEvent.isEndDocument()) break block8;
            }
            catch (Exception e) {
                log.error("Parsing error: " + xmlEvent.getLocation());
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw new XbrlImportException();
            }
        }
    }

    private void parseExplicitMemberStart(XMLEvent xmlEvent, StartElement startElement) {
        QName elementQName = startElement.getName();
        if (Objects.equals(elementQName, SCENARIO_EXPLICIT_MEMBER)) {
            this.currentXbrlContextDimension = new XbrlContextDimension();
            this.currentXbrlContextDimension.setDimensionType(DimensionType.EXPLICIT_MEMBER);
            Attribute dimensionAttr = startElement.getAttributeByName(DIMENSION_ATTR);
            String parsedDimension = dimensionAttr.getValue();
            String normalizedDimension = this.normalizePrefix(parsedDimension, DEFAULT_DIM_INT_PREFIX);
            this.currentXbrlContextDimension.setDimension(normalizedDimension);
        }
    }

    private String normalizePrefix(String parsedQname, String normalizedPrefix) {
        if (this.defaultNamespacePrefixes.isEmpty()) {
            return parsedQname;
        }
        String xmlPrefix = parsedQname.contains(QNAME_DIVIDER) ? parsedQname.split(QNAME_DIVIDER)[0] : "";
        Optional<Namespace> namespaceOptional = this.scenarioNamespaces.stream().filter(namespace -> namespace.getPrefix().equals(xmlPrefix)).findFirst();
        Namespace namespace2 = namespaceOptional.get();
        String namespaceUri = namespace2.getNamespaceURI();
        String defaultNamespacePrefix = (String)this.defaultNamespacePrefixes.get(namespaceUri);
        String xmlSuffix = parsedQname.contains(QNAME_DIVIDER) ? parsedQname.split(QNAME_DIVIDER)[1] : parsedQname;
        return defaultNamespacePrefix + QNAME_DIVIDER + xmlSuffix;
    }

    private void parseExplicitMemberCharacters(XMLEvent xmlEvent, Characters characters) {
        if (Objects.equals(this.currentElement, SCENARIO_EXPLICIT_MEMBER)) {
            String parsedMember = characters.getData();
            String normalizedMember = this.normalizePrefix(parsedMember, DEFAULT_MEM_INT_PREFIX);
            this.currentXbrlContextDimension.setMember(normalizedMember);
        }
    }

    private void parseExplicitMemberEnd(XMLEvent xmlEvent, EndElement endElement) {
        if (Objects.equals(endElement.getName(), SCENARIO_EXPLICIT_MEMBER)) {
            this.consumer.accept(this.currentXbrlContextDimension);
        }
    }

    private void parseTypedMemberStart(XMLEvent xmlEvent, StartElement startElement) {
        QName elementQName = startElement.getName();
        if (Objects.equals(elementQName, SCENARIO_TYPED_MEMBER)) {
            this.currentXbrlContextDimension = new XbrlContextDimension();
            this.currentXbrlContextDimension.setDimensionType(DimensionType.TYPED_MEMBER);
            Attribute dimensionAttr = startElement.getAttributeByName(DIMENSION_ATTR);
            String parsedDimension = dimensionAttr.getValue();
            String normalizedDimension = this.normalizePrefix(parsedDimension, DEFAULT_DIM_INT_PREFIX);
            this.currentXbrlContextDimension.setDimension(normalizedDimension);
            this.currentXbrlContextDimension.setDomainValue("");
            this.isTypedMemberProcessed = true;
        } else if (this.isTypedMemberProcessed) {
            String normalizedDomain = this.normalizePrefix(elementQName.getPrefix() + QNAME_DIVIDER + elementQName.getLocalPart(), DEFAULT_DIM_INT_PREFIX);
            String domain = elementQName.getPrefix() + QNAME_DIVIDER + elementQName.getLocalPart();
            this.currentXbrlContextDimension.setDomain(normalizedDomain);
        }
    }

    private void parseTypedMemberCharacters(XMLEvent xmlEvent, Characters characters) {
        if (this.isTypedMemberProcessed) {
            String value = this.currentXbrlContextDimension.getDomainValue() + characters.getData();
            this.currentXbrlContextDimension.setDomainValue(value);
        }
    }

    private void parseTypedMemberEnd(XMLEvent xmlEvent, EndElement endElement) {
        if (Objects.equals(endElement.getName(), SCENARIO_TYPED_MEMBER)) {
            this.isTypedMemberProcessed = false;
            this.consumer.accept(this.currentXbrlContextDimension);
        }
    }

    private void logTreeItem(int indent, String message) {
    }

    public String wrapScenario(String scenarioContent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (CollectionUtils.isEmpty((Collection)this.scenarioNamespaces)) {
            stringBuilder.append(DEFAULT_SCENARIO_NAMESPACES);
            stringBuilder.append(scenarioContent);
            stringBuilder.append("</xbrli:scenario>");
        } else if (StringUtils.isNotEmpty((CharSequence)this.instancePrefix)) {
            stringBuilder.append("<" + this.instancePrefix + ":scenario " + this.namespase() + ">");
            stringBuilder.append(scenarioContent);
            stringBuilder.append("</" + this.instancePrefix + ":scenario>");
        } else {
            stringBuilder.append("<scenario " + this.namespase() + ">");
            stringBuilder.append(scenarioContent);
            stringBuilder.append("</scenario>");
        }
        return stringBuilder.toString();
    }

    private String namespase() {
        return this.scenarioNamespaces.stream().map(Object::toString).collect(Collectors.joining(" ")).replace('\'', '\"');
    }
}

