/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.reference_linkbase;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import ru.cbr.xbrl.converter.model.reference_linkbase.ReferenceLinkbase;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReferenceLinkbaseXmlParser {
    private static final Logger log = LoggerFactory.getLogger(ReferenceLinkbaseXmlParser.class);
    private static JAXBContext jaxbContext;

    public ReferenceLinkbaseXmlParser() {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ReferenceLinkbase.class});
        }
        catch (JAXBException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void parse(String fullFileName, Consumer<ReferenceLinkbase> referenceLinkbaseConsumer) {
        try (FileInputStream fileInputStream = new FileInputStream(fullFileName);){
            this.parse(referenceLinkbaseConsumer, fileInputStream);
        }
        catch (Exception e) {
            ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    private void parse(Consumer<ReferenceLinkbase> referenceLinkbaseConsumer, FileInputStream fileInputStream) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        MutablePair currentRole = new MutablePair();
        XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(new BufferedInputStream(fileInputStream));
        ReferenceLinkbase currentReferenceLinkbase = null;
        block6: while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 7: {
                    break;
                }
                case 1: {
                    String attributeValue;
                    QName attributeName;
                    int i;
                    int n;
                    String currentStartElement = reader.getName().toString();
                    if (StringUtils.equalsIgnoreCase((CharSequence)"linkrole", (CharSequence)currentStartElement)) {
                        n = reader.getAttributeCount();
                        for (i = 0; i < n; ++i) {
                            attributeName = reader.getAttributeName(i);
                            attributeValue = reader.getAttributeValue(i);
                            if (StringUtils.equalsIgnoreCase((CharSequence)"role", (CharSequence)attributeName.toString())) {
                                currentRole.setLeft((Object)attributeValue);
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)"roledefinition", (CharSequence)attributeName.toString())) continue;
                            currentRole.setRight((Object)attributeValue);
                        }
                        continue block6;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"concept", (CharSequence)currentStartElement)) {
                        currentReferenceLinkbase = new ReferenceLinkbase();
                        currentReferenceLinkbase.setLinkrole((String)currentRole.getLeft());
                        currentReferenceLinkbase.setLinkroleLabel((String)currentRole.getRight());
                        n = reader.getAttributeCount();
                        for (i = 0; i < n; ++i) {
                            attributeName = reader.getAttributeName(i);
                            attributeValue = reader.getAttributeValue(i);
                            if (StringUtils.equalsIgnoreCase((CharSequence)"name", (CharSequence)attributeName.toString())) {
                                currentReferenceLinkbase.setName(attributeValue);
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)"label", (CharSequence)attributeName.toString())) continue;
                            currentReferenceLinkbase.setLabel(attributeValue);
                        }
                        continue block6;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"resource", (CharSequence)currentStartElement)) {
                        n = reader.getAttributeCount();
                        for (i = 0; i < n; ++i) {
                            String unescaped;
                            attributeName = reader.getAttributeName(i);
                            attributeValue = reader.getAttributeValue(i);
                            if (StringUtils.equalsIgnoreCase((CharSequence)"innerXml", (CharSequence)attributeName.toString()) && StringUtils.isNotBlank((CharSequence)(unescaped = StringEscapeUtils.unescapeHtml4((String)attributeValue)))) {
                                String unescapedXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<referenceLinkbase xmlns:cbr-ref=\"http://www.cbr.ru/xbrl/ext/cbr-ref\">" + unescaped.replaceAll("<cbr-ref:", "\n    <cbr-ref:") + "\n</referenceLinkbase>";
                                ReferenceLinkbase unmarshalledReferenceLinkbase = ReferenceLinkbaseXmlParser.unmarshalReferenceLinkbase((String)unescapedXml);
                                this.copyNotNullProperies(unmarshalledReferenceLinkbase, currentReferenceLinkbase);
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)"text", (CharSequence)attributeName.toString())) continue;
                            currentReferenceLinkbase.setText(attributeValue);
                        }
                        continue block6;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"arcrole", (CharSequence)currentStartElement)) break;
                }
                case 2: {
                    String currentEndElement = reader.getName().toString();
                    if (StringUtils.equalsIgnoreCase((CharSequence)"concept", (CharSequence)currentEndElement)) {
                        referenceLinkbaseConsumer.accept(currentReferenceLinkbase);
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"linkrole", (CharSequence)currentEndElement)) break;
                    break;
                }
                case 8: {
                    break;
                }
            }
        }
    }

    private void copyNotNullProperies(ReferenceLinkbase src, ReferenceLinkbase dst) {
        Arrays.asList(BeanUtils.getPropertyDescriptors(ReferenceLinkbase.class)).forEach(pd -> {
            try {
                Method readMethod;
                Object value;
                Method writeMethod = pd.getWriteMethod();
                if (writeMethod != null && (value = (readMethod = pd.getReadMethod()).invoke((Object)src, new Object[0])) != null) {
                    writeMethod.invoke((Object)dst, value);
                }
            }
            catch (Exception e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
    }

    public static ReferenceLinkbase unmarshalReferenceLinkbase(String xml) {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader stringReader = new StringReader(xml);
            ReferenceLinkbase referenceLinkbase = (ReferenceLinkbase)unmarshaller.unmarshal((Reader)stringReader);
            return referenceLinkbase;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }
}

