/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.edit;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import ru.cbr.xbrl.converter.model.DataType;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

public class AspectData
implements Serializable {
    private String aspect;
    private AspectType type;
    private String aspectValue;
    private PeriodType conceptPeriodType;
    private DimensionType dimensionType;
    private String domain;
    private String label;
    private String axisLabel;
    private String axisValueLabel;
    private boolean abstractNode;
    private String tagSelector;
    private String tag;
    private String periodFormula;
    private Boolean merge;
    private String xsdType;
    private String pattern;
    private DataType conceptDataType;
    private String repairTagSelector;
    private String axisId;
    private String hash;
    private String commonId;

    public AspectData(String aspect, AspectType type, String aspectValue, PeriodType conceptPeriodType) {
        this.aspect = aspect;
        this.type = type;
        this.aspectValue = aspectValue;
        this.conceptPeriodType = conceptPeriodType;
    }

    public AspectData(String aspect, AspectType type, String aspectValue, String domain, String label, DimensionType dimensionType) {
        this.aspect = aspect;
        this.type = type;
        this.aspectValue = aspectValue;
        this.domain = domain;
        this.label = label;
        this.dimensionType = dimensionType;
    }

    public AspectData(AspectData that) {
        this.aspect = that.aspect;
        this.type = that.type;
        this.aspectValue = that.aspectValue;
        this.conceptPeriodType = that.conceptPeriodType;
        this.dimensionType = that.dimensionType;
        this.domain = that.domain;
        this.label = that.label;
        this.abstractNode = that.abstractNode;
        this.tagSelector = that.tagSelector;
        this.tag = that.tag;
        this.periodFormula = that.periodFormula;
        this.merge = that.merge;
        this.xsdType = that.xsdType;
        this.pattern = that.pattern;
        this.conceptDataType = that.conceptDataType;
        this.axisLabel = that.axisLabel;
        this.axisValueLabel = that.axisValueLabel;
        this.repairTagSelector = that.repairTagSelector;
        this.axisId = that.axisId;
        this.hash = that.hash;
        this.commonId = that.commonId;
    }

    public static AspectData buildConcept(String concept) {
        AspectData aspectData = new AspectData();
        aspectData.setType(AspectType.CONCEPT);
        aspectData.setAspect("concept");
        aspectData.setAspectValue(concept);
        return aspectData;
    }

    public static AspectData buildExplicitDimension(String dimension, String member) {
        AspectData aspectData = new AspectData();
        aspectData.setType(AspectType.DIMENSION);
        aspectData.setDimensionType(DimensionType.EXPLICIT_MEMBER);
        aspectData.setAspect(dimension);
        aspectData.setAspectValue(member);
        return aspectData;
    }

    public static AspectData buildTypedDimension(String dimension, String domain, String domainValue) {
        AspectData aspectData = new AspectData();
        aspectData.setType(AspectType.DIMENSION);
        aspectData.setDimensionType(DimensionType.TYPED_MEMBER);
        aspectData.setAspect(dimension);
        aspectData.setDomain(domain);
        aspectData.setAspectValue(domainValue);
        return aspectData;
    }

    @JsonIgnore
    public boolean isDimension() {
        return this.type == AspectType.DIMENSION;
    }

    @JsonIgnore
    public boolean isConcept() {
        return this.type == AspectType.CONCEPT;
    }

    public String getAspect() {
        return this.aspect;
    }

    public AspectType getType() {
        return this.type;
    }

    public String getAspectValue() {
        return this.aspectValue;
    }

    public PeriodType getConceptPeriodType() {
        return this.conceptPeriodType;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getLabel() {
        return this.label;
    }

    public String getAxisLabel() {
        return this.axisLabel;
    }

    public String getAxisValueLabel() {
        return this.axisValueLabel;
    }

    public boolean isAbstractNode() {
        return this.abstractNode;
    }

    public String getTagSelector() {
        return this.tagSelector;
    }

    public String getTag() {
        return this.tag;
    }

    public String getPeriodFormula() {
        return this.periodFormula;
    }

    public Boolean getMerge() {
        return this.merge;
    }

    public String getXsdType() {
        return this.xsdType;
    }

    public String getPattern() {
        return this.pattern;
    }

    public DataType getConceptDataType() {
        return this.conceptDataType;
    }

    public String getRepairTagSelector() {
        return this.repairTagSelector;
    }

    public String getAxisId() {
        return this.axisId;
    }

    public String getHash() {
        return this.hash;
    }

    public String getCommonId() {
        return this.commonId;
    }

    public void setAspect(String aspect) {
        this.aspect = aspect;
    }

    public void setType(AspectType type) {
        this.type = type;
    }

    public void setAspectValue(String aspectValue) {
        this.aspectValue = aspectValue;
    }

    public void setConceptPeriodType(PeriodType conceptPeriodType) {
        this.conceptPeriodType = conceptPeriodType;
    }

    public void setDimensionType(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAxisLabel(String axisLabel) {
        this.axisLabel = axisLabel;
    }

    public void setAxisValueLabel(String axisValueLabel) {
        this.axisValueLabel = axisValueLabel;
    }

    public void setAbstractNode(boolean abstractNode) {
        this.abstractNode = abstractNode;
    }

    public void setTagSelector(String tagSelector) {
        this.tagSelector = tagSelector;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setPeriodFormula(String periodFormula) {
        this.periodFormula = periodFormula;
    }

    public void setMerge(Boolean merge) {
        this.merge = merge;
    }

    public void setXsdType(String xsdType) {
        this.xsdType = xsdType;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setConceptDataType(DataType conceptDataType) {
        this.conceptDataType = conceptDataType;
    }

    public void setRepairTagSelector(String repairTagSelector) {
        this.repairTagSelector = repairTagSelector;
    }

    public void setAxisId(String axisId) {
        this.axisId = axisId;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setCommonId(String commonId) {
        this.commonId = commonId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspectData)) {
            return false;
        }
        AspectData other = (AspectData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$aspect = this.getAspect();
        String other$aspect = other.getAspect();
        if (this$aspect == null ? other$aspect != null : !this$aspect.equals(other$aspect)) {
            return false;
        }
        AspectType this$type = this.getType();
        AspectType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$aspectValue = this.getAspectValue();
        String other$aspectValue = other.getAspectValue();
        if (this$aspectValue == null ? other$aspectValue != null : !this$aspectValue.equals(other$aspectValue)) {
            return false;
        }
        PeriodType this$conceptPeriodType = this.getConceptPeriodType();
        PeriodType other$conceptPeriodType = other.getConceptPeriodType();
        if (this$conceptPeriodType == null ? other$conceptPeriodType != null : !this$conceptPeriodType.equals(other$conceptPeriodType)) {
            return false;
        }
        DimensionType this$dimensionType = this.getDimensionType();
        DimensionType other$dimensionType = other.getDimensionType();
        if (this$dimensionType == null ? other$dimensionType != null : !this$dimensionType.equals(other$dimensionType)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$axisLabel = this.getAxisLabel();
        String other$axisLabel = other.getAxisLabel();
        if (this$axisLabel == null ? other$axisLabel != null : !this$axisLabel.equals(other$axisLabel)) {
            return false;
        }
        String this$axisValueLabel = this.getAxisValueLabel();
        String other$axisValueLabel = other.getAxisValueLabel();
        if (this$axisValueLabel == null ? other$axisValueLabel != null : !this$axisValueLabel.equals(other$axisValueLabel)) {
            return false;
        }
        if (this.isAbstractNode() != other.isAbstractNode()) {
            return false;
        }
        String this$tagSelector = this.getTagSelector();
        String other$tagSelector = other.getTagSelector();
        if (this$tagSelector == null ? other$tagSelector != null : !this$tagSelector.equals(other$tagSelector)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$periodFormula = this.getPeriodFormula();
        String other$periodFormula = other.getPeriodFormula();
        if (this$periodFormula == null ? other$periodFormula != null : !this$periodFormula.equals(other$periodFormula)) {
            return false;
        }
        Boolean this$merge = this.getMerge();
        Boolean other$merge = other.getMerge();
        if (this$merge == null ? other$merge != null : !((Object)this$merge).equals(other$merge)) {
            return false;
        }
        String this$xsdType = this.getXsdType();
        String other$xsdType = other.getXsdType();
        if (this$xsdType == null ? other$xsdType != null : !this$xsdType.equals(other$xsdType)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        DataType this$conceptDataType = this.getConceptDataType();
        DataType other$conceptDataType = other.getConceptDataType();
        if (this$conceptDataType == null ? other$conceptDataType != null : !this$conceptDataType.equals(other$conceptDataType)) {
            return false;
        }
        String this$repairTagSelector = this.getRepairTagSelector();
        String other$repairTagSelector = other.getRepairTagSelector();
        if (this$repairTagSelector == null ? other$repairTagSelector != null : !this$repairTagSelector.equals(other$repairTagSelector)) {
            return false;
        }
        String this$axisId = this.getAxisId();
        String other$axisId = other.getAxisId();
        if (this$axisId == null ? other$axisId != null : !this$axisId.equals(other$axisId)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$commonId = this.getCommonId();
        String other$commonId = other.getCommonId();
        return !(this$commonId == null ? other$commonId != null : !this$commonId.equals(other$commonId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AspectData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $aspect = this.getAspect();
        result = result * 59 + ($aspect == null ? 43 : $aspect.hashCode());
        AspectType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $aspectValue = this.getAspectValue();
        result = result * 59 + ($aspectValue == null ? 43 : $aspectValue.hashCode());
        PeriodType $conceptPeriodType = this.getConceptPeriodType();
        result = result * 59 + ($conceptPeriodType == null ? 43 : $conceptPeriodType.hashCode());
        DimensionType $dimensionType = this.getDimensionType();
        result = result * 59 + ($dimensionType == null ? 43 : $dimensionType.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $axisLabel = this.getAxisLabel();
        result = result * 59 + ($axisLabel == null ? 43 : $axisLabel.hashCode());
        String $axisValueLabel = this.getAxisValueLabel();
        result = result * 59 + ($axisValueLabel == null ? 43 : $axisValueLabel.hashCode());
        result = result * 59 + (this.isAbstractNode() ? 79 : 97);
        String $tagSelector = this.getTagSelector();
        result = result * 59 + ($tagSelector == null ? 43 : $tagSelector.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $periodFormula = this.getPeriodFormula();
        result = result * 59 + ($periodFormula == null ? 43 : $periodFormula.hashCode());
        Boolean $merge = this.getMerge();
        result = result * 59 + ($merge == null ? 43 : ((Object)$merge).hashCode());
        String $xsdType = this.getXsdType();
        result = result * 59 + ($xsdType == null ? 43 : $xsdType.hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        DataType $conceptDataType = this.getConceptDataType();
        result = result * 59 + ($conceptDataType == null ? 43 : $conceptDataType.hashCode());
        String $repairTagSelector = this.getRepairTagSelector();
        result = result * 59 + ($repairTagSelector == null ? 43 : $repairTagSelector.hashCode());
        String $axisId = this.getAxisId();
        result = result * 59 + ($axisId == null ? 43 : $axisId.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $commonId = this.getCommonId();
        result = result * 59 + ($commonId == null ? 43 : $commonId.hashCode());
        return result;
    }

    public String toString() {
        return "AspectData(aspect=" + this.getAspect() + ", type=" + this.getType() + ", aspectValue=" + this.getAspectValue() + ", conceptPeriodType=" + this.getConceptPeriodType() + ", dimensionType=" + this.getDimensionType() + ", domain=" + this.getDomain() + ", label=" + this.getLabel() + ", axisLabel=" + this.getAxisLabel() + ", axisValueLabel=" + this.getAxisValueLabel() + ", abstractNode=" + this.isAbstractNode() + ", tagSelector=" + this.getTagSelector() + ", tag=" + this.getTag() + ", periodFormula=" + this.getPeriodFormula() + ", merge=" + this.getMerge() + ", xsdType=" + this.getXsdType() + ", pattern=" + this.getPattern() + ", conceptDataType=" + this.getConceptDataType() + ", repairTagSelector=" + this.getRepairTagSelector() + ", axisId=" + this.getAxisId() + ", hash=" + this.getHash() + ", commonId=" + this.getCommonId() + ")";
    }

    public AspectData() {
    }

    @ConstructorProperties(value={"aspect", "type", "aspectValue", "conceptPeriodType", "dimensionType", "domain", "label", "axisLabel", "axisValueLabel", "abstractNode", "tagSelector", "tag", "periodFormula", "merge", "xsdType", "pattern", "conceptDataType", "repairTagSelector", "axisId", "hash", "commonId"})
    public AspectData(String aspect, AspectType type, String aspectValue, PeriodType conceptPeriodType, DimensionType dimensionType, String domain, String label, String axisLabel, String axisValueLabel, boolean abstractNode, String tagSelector, String tag, String periodFormula, Boolean merge, String xsdType, String pattern, DataType conceptDataType, String repairTagSelector, String axisId, String hash, String commonId) {
        this.aspect = aspect;
        this.type = type;
        this.aspectValue = aspectValue;
        this.conceptPeriodType = conceptPeriodType;
        this.dimensionType = dimensionType;
        this.domain = domain;
        this.label = label;
        this.axisLabel = axisLabel;
        this.axisValueLabel = axisValueLabel;
        this.abstractNode = abstractNode;
        this.tagSelector = tagSelector;
        this.tag = tag;
        this.periodFormula = periodFormula;
        this.merge = merge;
        this.xsdType = xsdType;
        this.pattern = pattern;
        this.conceptDataType = conceptDataType;
        this.repairTagSelector = repairTagSelector;
        this.axisId = axisId;
        this.hash = hash;
        this.commonId = commonId;
    }
}

