/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.edit;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.model.DataType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.service.import_export.CellValidator;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.utils.AspectUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.ConceptDimensionsAspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;

/*
 * Exception performing whole class analysis ignored.
 */
public class AspectCellData
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AspectCellData.class);
    private Long roleId;
    private String roleLabel;
    private List<AspectData> aspectDataList = new ArrayList();
    private String cellValue;
    private String address;
    private String decimals;
    private String precision;
    private String unitId;
    private Long footnoteId;
    private Integer footnoteCount;
    private boolean merged;
    private boolean isAbstractNode;

    public AspectCellData(List<AspectData> aspectDataList) {
        this.aspectDataList = aspectDataList;
    }

    public AspectCellData(XbrlValue xbrlValue) {
        this.setCellValue(xbrlValue.getValue());
        this.setDecimals(xbrlValue.getDecimals() != null ? xbrlValue.getDecimals().toString() : null);
        this.setPrecision(xbrlValue.getPrecision() != null ? xbrlValue.getPrecision().toString() : null);
        this.setUnitId(xbrlValue.getXbrlUnit());
        if (xbrlValue.getAspectDataList() == null) {
            xbrlValue.unpackAspectDataList();
        }
        this.setAspectDataList(xbrlValue.getAspectDataList());
    }

    @JsonIgnore
    public AspectData getPeriodAspect() {
        Optional<AspectData> periodAspect = this.aspectDataList.stream().filter(a -> a.getType() != null).filter(a -> a.getType().equals((Object)AspectType.PERIOD)).reduce((a, b) -> b);
        return periodAspect.orElse(null);
    }

    @JsonIgnore
    public AspectData getConcept() {
        return AspectCellData.getConceptByStream((List)this.aspectDataList);
    }

    @JsonIgnore
    public AspectData getTagLabel() {
        Optional<AspectData> aspectDataOptional = this.aspectDataList.stream().filter(a -> a.getType() != null).filter(a -> a.getType().equals((Object)AspectType.TAG_LABEL)).reduce((a, b) -> b);
        return aspectDataOptional.orElse(null);
    }

    @JsonIgnore
    public AspectData getConceptByTag(String tag) {
        AspectData d = null;
        if (tag != null) {
            Optional<AspectData> aspectDataOptional = this.aspectDataList.stream().filter(a -> a.getType() != null).filter(a -> a.getType().equals((Object)AspectType.CONCEPT)).filter(a -> tag.equals(a.getTag())).reduce((a, b) -> b);
            d = aspectDataOptional.orElse(null);
        }
        if (d != null) {
            return d;
        }
        Optional<AspectData> aspectDataOptional1 = this.aspectDataList.stream().filter(a -> a.getType() != null).filter(a -> a.getType().equals((Object)AspectType.CONCEPT)).filter(a -> a.getTag() == null).reduce((a, b) -> b);
        return aspectDataOptional1.orElse(null);
    }

    @JsonIgnore
    public static AspectData getConceptByStream(List<AspectData> aspectDataList) {
        Optional<AspectData> aspectDataOptional = aspectDataList.stream().filter(a -> a.getType() != null).filter(a -> a.getType().equals((Object)AspectType.CONCEPT)).filter(a -> !a.isAbstractNode()).reduce((a, b) -> b);
        if (aspectDataOptional.isPresent()) {
            return aspectDataOptional.get();
        }
        aspectDataOptional = aspectDataList.stream().filter(a -> a.getType() != null).filter(a -> a.getType().equals((Object)AspectType.CONCEPT)).reduce((a, b) -> b);
        return aspectDataOptional.orElse(null);
    }

    @JsonIgnore
    public static AspectData getLastDimensionByStream(Stream<AspectData> stream) {
        Optional<AspectData> aspectDataOptional = stream.filter(a -> a.getType() != null).filter(a -> a.getType().equals((Object)AspectType.DIMENSION)).reduce((a, b) -> b);
        return aspectDataOptional.orElse(null);
    }

    @JsonIgnore
    public List<AspectData> getDimensions() {
        return AspectCellData.getDimensionsByStream(this.aspectDataList.stream());
    }

    @JsonIgnore
    public static ConceptDimensionsAspectData getConceptAndDimensionsByStream(Stream<AspectData> aspectDataList) {
        ConceptDimensionsAspectData conceptDimensionsAspectData = new ConceptDimensionsAspectData();
        if (aspectDataList == null) {
            return conceptDimensionsAspectData;
        }
        aspectDataList.forEach(aspectData -> {
            AspectType type = aspectData.getType();
            if (type == null) {
                return;
            }
            switch (1.$SwitchMap$ru$cbr$xbrl$converter$xbrl$import_export$enums$AspectType[type.ordinal()]) {
                case 1: {
                    conceptDimensionsAspectData.getDimensionList().add(aspectData);
                    break;
                }
                case 2: {
                    conceptDimensionsAspectData.setConcept(aspectData);
                    break;
                }
            }
        });
        return conceptDimensionsAspectData;
    }

    @JsonIgnore
    public static List<AspectData> getDimensionsByStream(Stream<AspectData> stream) {
        List dimensions = stream.filter(a -> a.getType() != null).filter(a -> a.getType().equals((Object)AspectType.DIMENSION)).collect(Collectors.toList());
        return AspectCellData.removeDimensionDuplicates(dimensions);
    }

    public boolean validate() {
        AspectData concept = this.getConcept();
        if (concept != null) {
            if (concept.getConceptDataType() == DataType.ENUM2) {
                return CellValidator.validateSafe((String)this.cellValue, (String)concept.getXsdType());
            }
            return CellValidator.validateSafe((String)this.cellValue, (String)concept.getXsdType()) && CellValidator.validatePattern((String)this.cellValue, (String)concept.getPattern());
        }
        return true;
    }

    public void prepare() {
        String type;
        AspectData concept = this.getConcept();
        if (concept != null && (type = concept.getXsdType()) != null && type.equals("decimal")) {
            this.cellValue = this.cellValue.replaceAll(",", ".");
        }
    }

    private static List<AspectData> removeDimensionDuplicates(List<AspectData> aspectData) {
        HashMap map = new HashMap();
        aspectData.forEach(d -> map.put(d.getAspect(), d));
        return map.keySet().stream().map(k -> (AspectData)map.get(k)).collect(Collectors.toList());
    }

    public String buildCompareAspectString(Map<String, String> dimensionsDefault) {
        AspectData concept = this.getConcept();
        String conceptName = concept.getAspectValue();
        String dimensionsString = this.buildDimensionStringWithoutDefault(dimensionsDefault);
        PeriodDates defaultPeriodDates = AspectUtils.getDefaultPeriodDates((AspectCellData)this);
        PeriodDates periodDates = AspectUtils.getPeriodDatesForConceptOrDefault((List)this.getAspectDataList(), (AspectData)concept, (PeriodDates)defaultPeriodDates);
        String periodString = periodDates.formatDate();
        return String.format("%s %s %s", conceptName, dimensionsString, periodString);
    }

    public String buildDimensionString() {
        List dimensions = this.getDimensions();
        List xbrlContextDimensions = XbrlContextDimension.buildFromAspectDataList((List)dimensions);
        return XbrlContextDimension.dimensionsToString((List)xbrlContextDimensions);
    }

    public String buildDimensionStringWithoutDefault(Map<String, String> dimensionsDefault) {
        List dimensions = this.getDimensions();
        dimensions = XbrlContextDimension.removeDefaultDimensions((List)dimensions, dimensionsDefault);
        List xbrlContextDimensions = XbrlContextDimension.buildFromAspectDataList((List)dimensions);
        return XbrlContextDimension.dimensionsToString((List)xbrlContextDimensions);
    }

    public String buildDimensionHash() {
        List dimensions = this.getDimensions();
        List xbrlContextDimensions = XbrlContextDimension.buildFromAspectDataList((List)dimensions);
        return XbrlContextDimension.dimensionToHash((List)xbrlContextDimensions);
    }

    public boolean hasDimension(String d) {
        return this.getDimensions().stream().anyMatch(a -> a.getAspect().equals(d));
    }

    public String toShortString() {
        Optional<AspectData> concept = Optional.ofNullable(this.getConcept());
        String conceptValue = concept.map(AspectData::getAspectValue).orElse("");
        AspectData periodAspect = this.getPeriodAspect();
        Optional<AspectData> period = Optional.empty();
        if (periodAspect != null) {
            period = Optional.of(periodAspect);
        }
        String periodValue = period.map(AspectData::getAspectValue).orElse("");
        return String.format("Value %s concept %s period %s dimensions %s ", this.cellValue, conceptValue, periodValue, this.buildDimensionString());
    }

    public Long getRoleId() {
        return this.roleId;
    }

    public String getRoleLabel() {
        return this.roleLabel;
    }

    public List<AspectData> getAspectDataList() {
        return this.aspectDataList;
    }

    public String getCellValue() {
        return this.cellValue;
    }

    public String getAddress() {
        return this.address;
    }

    public String getDecimals() {
        return this.decimals;
    }

    public String getPrecision() {
        return this.precision;
    }

    public String getUnitId() {
        return this.unitId;
    }

    public Long getFootnoteId() {
        return this.footnoteId;
    }

    public Integer getFootnoteCount() {
        return this.footnoteCount;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public boolean isAbstractNode() {
        return this.isAbstractNode;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public void setRoleLabel(String roleLabel) {
        this.roleLabel = roleLabel;
    }

    public void setAspectDataList(List<AspectData> aspectDataList) {
        this.aspectDataList = aspectDataList;
    }

    public void setCellValue(String cellValue) {
        this.cellValue = cellValue;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setDecimals(String decimals) {
        this.decimals = decimals;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    public void setFootnoteId(Long footnoteId) {
        this.footnoteId = footnoteId;
    }

    public void setFootnoteCount(Integer footnoteCount) {
        this.footnoteCount = footnoteCount;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    public void setAbstractNode(boolean isAbstractNode) {
        this.isAbstractNode = isAbstractNode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspectCellData)) {
            return false;
        }
        AspectCellData other = (AspectCellData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$roleId = this.getRoleId();
        Long other$roleId = other.getRoleId();
        if (this$roleId == null ? other$roleId != null : !((Object)this$roleId).equals(other$roleId)) {
            return false;
        }
        String this$roleLabel = this.getRoleLabel();
        String other$roleLabel = other.getRoleLabel();
        if (this$roleLabel == null ? other$roleLabel != null : !this$roleLabel.equals(other$roleLabel)) {
            return false;
        }
        List this$aspectDataList = this.getAspectDataList();
        List other$aspectDataList = other.getAspectDataList();
        if (this$aspectDataList == null ? other$aspectDataList != null : !((Object)this$aspectDataList).equals(other$aspectDataList)) {
            return false;
        }
        String this$cellValue = this.getCellValue();
        String other$cellValue = other.getCellValue();
        if (this$cellValue == null ? other$cellValue != null : !this$cellValue.equals(other$cellValue)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$decimals = this.getDecimals();
        String other$decimals = other.getDecimals();
        if (this$decimals == null ? other$decimals != null : !this$decimals.equals(other$decimals)) {
            return false;
        }
        String this$precision = this.getPrecision();
        String other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !this$precision.equals(other$precision)) {
            return false;
        }
        String this$unitId = this.getUnitId();
        String other$unitId = other.getUnitId();
        if (this$unitId == null ? other$unitId != null : !this$unitId.equals(other$unitId)) {
            return false;
        }
        Long this$footnoteId = this.getFootnoteId();
        Long other$footnoteId = other.getFootnoteId();
        if (this$footnoteId == null ? other$footnoteId != null : !((Object)this$footnoteId).equals(other$footnoteId)) {
            return false;
        }
        Integer this$footnoteCount = this.getFootnoteCount();
        Integer other$footnoteCount = other.getFootnoteCount();
        if (this$footnoteCount == null ? other$footnoteCount != null : !((Object)this$footnoteCount).equals(other$footnoteCount)) {
            return false;
        }
        if (this.isMerged() != other.isMerged()) {
            return false;
        }
        return this.isAbstractNode() == other.isAbstractNode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AspectCellData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $roleId = this.getRoleId();
        result = result * 59 + ($roleId == null ? 43 : ((Object)$roleId).hashCode());
        String $roleLabel = this.getRoleLabel();
        result = result * 59 + ($roleLabel == null ? 43 : $roleLabel.hashCode());
        List $aspectDataList = this.getAspectDataList();
        result = result * 59 + ($aspectDataList == null ? 43 : ((Object)$aspectDataList).hashCode());
        String $cellValue = this.getCellValue();
        result = result * 59 + ($cellValue == null ? 43 : $cellValue.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $decimals = this.getDecimals();
        result = result * 59 + ($decimals == null ? 43 : $decimals.hashCode());
        String $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : $precision.hashCode());
        String $unitId = this.getUnitId();
        result = result * 59 + ($unitId == null ? 43 : $unitId.hashCode());
        Long $footnoteId = this.getFootnoteId();
        result = result * 59 + ($footnoteId == null ? 43 : ((Object)$footnoteId).hashCode());
        Integer $footnoteCount = this.getFootnoteCount();
        result = result * 59 + ($footnoteCount == null ? 43 : ((Object)$footnoteCount).hashCode());
        result = result * 59 + (this.isMerged() ? 79 : 97);
        result = result * 59 + (this.isAbstractNode() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AspectCellData(roleId=" + this.getRoleId() + ", roleLabel=" + this.getRoleLabel() + ", aspectDataList=" + this.getAspectDataList() + ", cellValue=" + this.getCellValue() + ", address=" + this.getAddress() + ", decimals=" + this.getDecimals() + ", precision=" + this.getPrecision() + ", unitId=" + this.getUnitId() + ", footnoteId=" + this.getFootnoteId() + ", footnoteCount=" + this.getFootnoteCount() + ", merged=" + this.isMerged() + ", isAbstractNode=" + this.isAbstractNode() + ")";
    }

    public AspectCellData() {
    }
}

