/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.xbrl.import_export.csv;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.exception.FileAlreadyExistsException;
import ru.cbr.xbrl.converter.exception.RewritableFileOpenException;
import ru.cbr.xbrl.converter.exception.WriteFileException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlFootnote;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlUnit;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.utils.FileUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.XbrlWriter;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvCommon;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvFileSet;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.enums.CsvContextColumns;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.enums.CsvFootnoteColumns;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.enums.CsvUnitColumns;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.enums.CsvValueColumns;

public class XbrlCsvWriter
implements XbrlWriter {
    private static final Logger log = LoggerFactory.getLogger(XbrlCsvWriter.class);
    private final CsvFileSet csvFileSet;
    private static final Object[] CONTEXT_HEADER = Arrays.stream(CsvContextColumns.values()).map(c -> c.name).toArray(String[]::new);
    private static final Object[] UNIT_HEADER = Arrays.stream(CsvUnitColumns.values()).map(c -> c.name).toArray(String[]::new);
    private static final Object[] VALUE_HEADER = Arrays.stream(CsvValueColumns.values()).map(c -> c.name).toArray(String[]::new);
    private static final Object[] FOOTNOTES_HEADER = Arrays.stream(CsvFootnoteColumns.values()).map(c -> c.name).toArray(String[]::new);
    private CSVPrinter printerContext;
    private CSVPrinter printerUnit;
    private CSVPrinter printerValue;
    private CSVPrinter printerFootnotes;
    private PrintStream contextsOut;
    private PrintStream unitsOut;
    private PrintStream valuesOut;
    private PrintStream footnotesOut;
    private boolean isFootnoteSkipping = false;

    public XbrlCsvWriter(CsvFileSet csvFileSet, Boolean allowOverwriteFile) throws XbrlExportException, FileAlreadyExistsException, WriteFileException {
        String footnotesPath = csvFileSet.getFootnotesPath();
        if (StringUtils.isBlank((CharSequence)footnotesPath) || StringUtils.equalsIgnoreCase((CharSequence)footnotesPath, (CharSequence)"null")) {
            log.info("\u041f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443 \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d. \u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0441\u044f.");
            this.isFootnoteSkipping = true;
        } else {
            FileUtils.checkFileWritable((String)footnotesPath, (Boolean)allowOverwriteFile);
            this.isFootnoteSkipping = false;
        }
        FileUtils.checkFileWritable((String)csvFileSet.getContextsPath(), (Boolean)allowOverwriteFile);
        FileUtils.checkFileWritable((String)csvFileSet.getUnitsPath(), (Boolean)allowOverwriteFile);
        FileUtils.checkFileWritable((String)csvFileSet.getValuesPath(), (Boolean)allowOverwriteFile);
        this.csvFileSet = csvFileSet;
    }

    public void prepare(Supplier<String> currentVersion) throws XbrlExportException {
        try {
            this.contextsOut = new PrintStream(this.csvFileSet.getContextsPath(), "cp1251");
            this.printerContext = CsvCommon.CSV_FORMAT.print((Appendable)this.contextsOut);
            this.printerContext.printRecord(CONTEXT_HEADER);
            this.unitsOut = new PrintStream(this.csvFileSet.getUnitsPath(), "cp1251");
            this.printerUnit = CsvCommon.CSV_FORMAT.print((Appendable)this.unitsOut);
            this.printerUnit.printRecord(UNIT_HEADER);
            this.valuesOut = new PrintStream(this.csvFileSet.getValuesPath(), "cp1251");
            this.printerValue = CsvCommon.CSV_FORMAT.print((Appendable)this.valuesOut);
            this.printerValue.printRecord(VALUE_HEADER);
            if (!this.isFootnoteSkipping) {
                this.footnotesOut = new PrintStream(this.csvFileSet.getFootnotesPath(), "cp1251");
                this.printerFootnotes = CsvCommon.CSV_FORMAT.print((Appendable)this.footnotesOut);
                this.printerFootnotes.printRecord(FOOTNOTES_HEADER);
            }
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            this.finalize();
            throw new XbrlExportException();
        }
    }

    public void writeXbrlContext(XbrlContext xbrlContext) throws XbrlExportException {
        ArrayList<String> row = new ArrayList<String>();
        row.add(xbrlContext.getXbrlContextId().getContextId());
        row.add(xbrlContext.getPeriod());
        row.add(xbrlContext.getIdentifier());
        row.add(xbrlContext.getScheme());
        row.add(xbrlContext.getSegment());
        row.add(xbrlContext.getScenario());
        try {
            this.printerContext.printRecord(row);
        }
        catch (IOException e) {
            this.finalize();
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    public void writeXbrlUnit(XbrlUnit xbrlUnit) throws XbrlExportException {
        ArrayList<String> row = new ArrayList<String>();
        try {
            row.add(xbrlUnit.getXbrlUnitId().getUnitId());
            row.add(xbrlUnit.getContent());
            this.printerUnit.printRecord(row);
        }
        catch (IOException e) {
            this.finalize();
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    public void writeXbrlValue(XbrlValue xbrlValue) throws XbrlExportException {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(xbrlValue.getXbrlValueId().getElementLabel());
            row.add(xbrlValue.getElementUri());
            row.add(xbrlValue.getElementName());
            row.add(xbrlValue.getValue());
            row.add(xbrlValue.getNil());
            row.add(xbrlValue.getXbrlValueId().getXbrlContextId());
            row.add(xbrlValue.getXbrlUnit());
            row.add(xbrlValue.getTuple());
            row.add(xbrlValue.getPrecision());
            row.add(xbrlValue.getDecimals());
            row.add(xbrlValue.getLang());
            this.printerValue.printRecord(row);
        }
        catch (IOException e) {
            this.finalize();
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    public void writeXbrlFootnote(XbrlFootnote xbrlFootnote) throws XbrlExportException {
        if (this.isFootnoteSkipping) {
            return;
        }
        ArrayList<String> row = new ArrayList<String>();
        try {
            row.add(xbrlFootnote.getFootnoteNo());
            row.add(xbrlFootnote.getContent());
            row.add(xbrlFootnote.getLanguage());
            String extendedLinkRole = xbrlFootnote.getExtendedLinkRole();
            row.add(StringUtils.isBlank((CharSequence)extendedLinkRole) ? "http://www.xbrl.org/2003/role/link" : extendedLinkRole);
            String locatorRole = xbrlFootnote.getLocatorRole();
            row.add(StringUtils.isBlank((CharSequence)locatorRole) ? "http://www.xbrl.org/2003/role/footnote" : locatorRole);
            row.add(xbrlFootnote.getElementUri());
            row.add(xbrlFootnote.getElementName());
            row.add(xbrlFootnote.getValue());
            row.add(xbrlFootnote.getContext());
            row.add(xbrlFootnote.getUnit());
            row.add(xbrlFootnote.getTuple());
            this.printerFootnotes.printRecord(row);
        }
        catch (IOException e) {
            this.finalize();
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    public void writeFootnoteStartTag() throws XbrlExportException {
    }

    public void writeFootnoteEndTag() throws XbrlExportException {
    }

    public void finalize() throws XbrlExportException {
        try {
            this.contextsOut.flush();
            this.contextsOut.close();
            this.printerContext.close();
            this.unitsOut.flush();
            this.unitsOut.close();
            this.printerUnit.close();
            this.valuesOut.flush();
            this.valuesOut.close();
            this.printerValue.close();
            if (!this.isFootnoteSkipping) {
                this.footnotesOut.flush();
                this.footnotesOut.close();
                this.printerFootnotes.close();
            }
        }
        catch (NullPointerException e) {
            throw new RewritableFileOpenException();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

