/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.utils;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;

public class TextUtils {
    public static String quotedText(String text) {
        return "\"" + text + "\"";
    }

    public static String removeBoundaryQuotes(String text) {
        return text.replaceAll("^\"|\"$", "");
    }

    public static void replaceInFile(String fileName, String regex, String replacement) {
        Path path = Paths.get(fileName, new String[0]);
        Charset charset = StandardCharsets.UTF_8;
        String content = null;
        try {
            content = new String(Files.readAllBytes(path), charset);
            content = content.replaceAll(regex, replacement);
            Files.write(path, content.getBytes(charset), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String buildCalculationWeightValue(String weight, Boolean isFirst) {
        boolean isOne;
        String sign;
        String value;
        String result = "";
        if (StringUtils.isBlank((CharSequence)weight) || isFirst == null) {
            return result;
        }
        if (StringUtils.startsWith((CharSequence)weight, (CharSequence)"-")) {
            value = StringUtils.substring((String)weight, (int)1);
            sign = "-";
        } else {
            value = weight;
            sign = "+";
        }
        boolean bl = isOne = StringUtils.equals((CharSequence)value, (CharSequence)"1") || StringUtils.equals((CharSequence)value, (CharSequence)"1.0");
        sign = isFirst == false ? " " + sign + " " : (sign.equals("+") ? " " : " " + sign);
        if (isOne) {
            return sign;
        }
        return sign + value;
    }

    public static Integer parseIntSafe(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer countMatchesIgnoreCase(String str, String subStr) {
        if (StringUtils.isBlank((CharSequence)str) || StringUtils.isBlank((CharSequence)subStr)) {
            return 0;
        }
        String upperStr = str.toUpperCase();
        String upperSubStr = subStr.toUpperCase();
        return StringUtils.countMatches((CharSequence)upperStr, (CharSequence)upperSubStr);
    }

    public static String getNoun(int number, String one, String two, String five) {
        int n = Math.abs(number);
        if ((n %= 100) >= 5 && n <= 20) {
            return five;
        }
        if ((n %= 10) == 1) {
            return one;
        }
        if (n >= 2 && n <= 4) {
            return two;
        }
        return five;
    }

    private TextUtils() {
    }
}

