/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;

public class StaxPrettyPrintHandler
implements InvocationHandler {
    private final XMLStreamWriter target;
    private int depth = 0;
    private final Map<Integer, Boolean> hasChildElement = new HashMap();
    private static final String INDENT_CHAR = "    ";
    private static final String LINEFEED_CHAR = "\n";

    public StaxPrettyPrintHandler(XMLStreamWriter target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String m = method.getName();
        if ("writeStartElement".equals(m)) {
            if (this.depth > 0) {
                this.hasChildElement.put(this.depth - 1, true);
            }
            this.hasChildElement.put(this.depth, false);
            this.target.writeCharacters(LINEFEED_CHAR);
            this.target.writeCharacters(this.repeat(this.depth, INDENT_CHAR));
            ++this.depth;
        } else if ("writeEndElement".equals(m)) {
            --this.depth;
            if (((Boolean)this.hasChildElement.get(this.depth)).booleanValue()) {
                this.target.writeCharacters(LINEFEED_CHAR);
                this.target.writeCharacters(this.repeat(this.depth, INDENT_CHAR));
            }
        } else if ("writeEmptyElement".equals(m)) {
            if (this.depth > 0) {
                this.hasChildElement.put(this.depth - 1, true);
            }
            this.target.writeCharacters(LINEFEED_CHAR);
            this.target.writeCharacters(this.repeat(this.depth, INDENT_CHAR));
        }
        method.invoke((Object)this.target, args);
        return null;
    }

    private String repeat(int d, String s) {
        String _s = "";
        while (d-- > 0) {
            _s = _s + s;
        }
        return _s;
    }
}

