/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.utils;

import java.util.function.Function;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Slice;
import ru.cbr.xbrl.converter.exception.XbrlExportException;

public abstract class PageIterator<T> {
    private EntityManager entityManager;
    private Function<Integer, Slice<T>> getSliceFunction;

    public PageIterator(EntityManager entityManager, Function<Integer, Slice<T>> getSliceFunction) throws XbrlExportException {
        this.entityManager = entityManager;
        this.getSliceFunction = getSliceFunction;
        this.processPage();
    }

    private void processPage() throws XbrlExportException {
        Slice page;
        int pageNum = 0;
        do {
            page = (Slice)this.getSliceFunction.apply(pageNum);
            for (Object xbrlValue : page) {
                this.processItem(xbrlValue);
            }
            this.entityManager.clear();
            ++pageNum;
        } while (page.hasNext());
    }

    protected abstract void processItem(T var1) throws XbrlExportException;
}

