/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.utils.AspectUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;

/*
 * Exception performing whole class analysis ignored.
 */
public class LabelUtils {
    public static String calcLabel(List<AspectData> aspectDataList, String labLabel) {
        if (labLabel != null) {
            return labLabel;
        }
        ArrayList<String> labels = new ArrayList<String>();
        if (aspectDataList.stream().filter(aspectData -> aspectData.getType() != AspectType.PARAMS_PERIOD).collect(Collectors.toList()).size() == 0) {
            labels.addAll(LabelUtils.generateDateParamLabels(aspectDataList));
        } else {
            for (AspectData aspectData2 : aspectDataList) {
                if (aspectData2.getType() != AspectType.CONCEPT && aspectData2.getType() != AspectType.DIMENSION || aspectData2.getLabel() == null) continue;
                labels.add(aspectData2.getLabel());
            }
        }
        if (labels.isEmpty()) {
            return "";
        }
        return labels.stream().map(p -> p.trim()).collect(Collectors.joining(", "));
    }

    public static String calcMemberLabel(List<AspectData> aspectDataList) {
        ArrayList<String> labels = new ArrayList<String>();
        labels.addAll(LabelUtils.generateDateParamLabels(aspectDataList));
        for (AspectData aspectData : aspectDataList) {
            if (aspectData.getType() != AspectType.CONCEPT && aspectData.getType() != AspectType.DIMENSION) continue;
            if (aspectData.getAxisLabel() != null) {
                labels.add(aspectData.getAxisLabel());
                continue;
            }
            if (StringUtils.isBlank((CharSequence)aspectData.getLabel())) continue;
            labels.add(aspectData.getLabel());
        }
        if (CollectionUtils.isEmpty(labels)) {
            return "";
        }
        return labels.stream().map(p -> p.trim()).collect(Collectors.joining(", "));
    }

    private static List<String> generateDateParamLabels(List<AspectData> aspectDataList) {
        ArrayList<String> labels = new ArrayList<String>();
        PeriodDates defaultPeriodDates = AspectUtils.getDefaultPeriodDates(aspectDataList);
        if (defaultPeriodDates != null) {
            labels.add(defaultPeriodDates.formatDate());
        }
        Map<String, List<AspectData>> tagToAsp = aspectDataList.stream().filter(it -> it.getTag() != null).collect(Collectors.groupingBy(AspectData::getTag));
        for (String tag : tagToAsp.keySet()) {
            PeriodDates paramPeriodDates = AspectUtils.getParamPeriodDates(tagToAsp.get(tag));
            if (paramPeriodDates == null) continue;
            labels.add(paramPeriodDates.formatDate());
        }
        return labels;
    }

    public static String calcMemberValueLabel(List<AspectData> aspectDataList) {
        ArrayList<String> labels = new ArrayList<String>();
        for (AspectData aspectData : aspectDataList) {
            if (aspectData.getType() != AspectType.DIMENSION || aspectData.getAxisValueLabel() == null) continue;
            labels.add(aspectData.getAxisValueLabel());
        }
        if (CollectionUtils.isEmpty(labels)) {
            return "";
        }
        return labels.stream().map(p -> p.trim()).collect(Collectors.joining(", "));
    }

    public static String calcLabelId(List<AspectData> aspectDataList, String labLabel) {
        if (labLabel != null) {
            return labLabel;
        }
        ArrayList<String> labels = new ArrayList<String>();
        if (aspectDataList.stream().filter(aspectData -> aspectData.getType() != AspectType.PARAMS_PERIOD).collect(Collectors.toList()).size() == 0) {
            labels.addAll(LabelUtils.generateDateParamLabels(aspectDataList));
        } else {
            for (AspectData aspectData2 : aspectDataList) {
                if (aspectData2.getType() != AspectType.CONCEPT && aspectData2.getType() != AspectType.DIMENSION || aspectData2.getLabel() == null) continue;
                labels.add(aspectData2.getLabel());
            }
        }
        if (labels.isEmpty()) {
            return "";
        }
        String res = "";
        for (String l : labels) {
            res = res + l.trim();
        }
        return res;
    }
}

