/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.exception.FileAlreadyExistsException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.WriteFileException;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final String TEMPORARY_FILE_PREFIX = "cbr-converter-temporary-";

    public static String relativePathToAbsolute(String relativePath) {
        File f = new File(relativePath);
        return FilenameUtils.normalize((String)f.getAbsolutePath());
    }

    public static String readTextFile(String fullName) {
        Path path = Paths.get(fullName, new String[0]);
        String content = null;
        try {
            content = new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return content;
    }

    public static String getTempFileName(String suffix) {
        String fileName = null;
        try {
            File temp = File.createTempFile(TEMPORARY_FILE_PREFIX, suffix);
            temp.deleteOnExit();
            fileName = temp.getAbsolutePath();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingFileChannels(String source, String dest) throws IOException {
        AbstractInterruptibleChannel inputChannel = null;
        AbstractInterruptibleChannel outputChannel = null;
        try {
            inputChannel = new FileInputStream(source).getChannel();
            outputChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)outputChannel).transferFrom((ReadableByteChannel)((Object)inputChannel), 0L, ((FileChannel)inputChannel).size());
        }
        finally {
            inputChannel.close();
            outputChannel.close();
        }
    }

    public static void checkFileWritable(String fileFullPath, Boolean allowOverwriteFile) throws FileAlreadyExistsException, WriteFileException {
        if (StringUtils.isEmpty((CharSequence)fileFullPath)) {
            log.warn("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0444\u0430\u0439\u043b. \u041f\u0443\u0442\u044c \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d.");
            return;
        }
        Path path = Paths.get(fileFullPath, new String[0]);
        if (!allowOverwriteFile.booleanValue() && Files.exists(path, new LinkOption[0])) {
            throw new FileAlreadyExistsException();
        }
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                org.apache.commons.io.FileUtils.touch((File)new File(fileFullPath));
            }
            catch (IOException e) {
                log.error("File write error: {}", (Object)fileFullPath);
                throw new WriteFileException();
            }
            finally {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        if (!Files.isWritable(path)) {
            log.error("File write error: {}", (Object)fileFullPath);
            throw new WriteFileException();
        }
    }

    public static long downloadFileFromUrl(String downloadUrl, String destFullPath) throws UploadException {
        File file = new File(destFullPath);
        if (file.exists() && !file.delete()) {
            log.error("\u0421\u043a\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u0441 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0440\u0435\u0441\u0443\u0440\u0441\u0430: {}. \u0424\u0430\u0439\u043b {} \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442, \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0435\u0433\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0434\u043b\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0441\u043a\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u044f.", (Object)downloadUrl, (Object)destFullPath);
            return -1L;
        }
        try {
            URL url = new URL(downloadUrl);
            Files.createDirectories(Paths.get(FilenameUtils.getFullPath((String)destFullPath), new String[0]), new FileAttribute[0]);
            ReadableByteChannel rbc = Channels.newChannel(url.openStream());
            FileOutputStream fos = new FileOutputStream(destFullPath);
            return fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new UploadException();
        }
    }

    public static void deleteDir(String dirAbsolutePath) throws IOException {
        if (Files.isRegularFile(Paths.get(dirAbsolutePath, new String[0]), new LinkOption[0])) {
            throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u043f\u043a\u0443 \u043f\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u043f\u0443\u0442\u0438.");
        }
        org.apache.commons.io.FileUtils.forceDelete((File)new File(dirAbsolutePath));
    }

    public static void deleteFile(String fileAbsolutePath) throws IOException {
        if (!Files.isRegularFile(Paths.get(fileAbsolutePath, new String[0]), new LinkOption[0])) {
            throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u043f\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u043f\u0443\u0442\u0438.");
        }
        org.apache.commons.io.FileUtils.forceDelete((File)new File(fileAbsolutePath));
    }

    private FileUtils() {
    }
}

