/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.utils;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.cbr.xbrl.converter.utils.functional.ThrowingConsumer;

public class ExceptionUtils {
    private static final Logger log = LoggerFactory.getLogger((String)ExceptionUtils.class.getName());

    public static <T> Consumer<T> throwingConsumerWrapper(ThrowingConsumer<T, Exception> throwingConsumer) {
        return i -> {
            try {
                throwingConsumer.accept(i);
            }
            catch (Exception e) {
                log.error("Fatal error " + e.getMessage());
                log.error(org.apache.commons.lang3.exception.ExceptionUtils.getStackTrace((Throwable)e));
                System.exit(-1);
                throw new RuntimeException(e);
            }
        };
    }

    private ExceptionUtils() {
    }
}

