/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.tablelinkbase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.map.SingletonMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.service.tablelinkbase.AxisServiceCalculation;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.ConceptDimensionsAspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.TypedAspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

@Service
public class AxisServiceCalculationImpl
implements AxisServiceCalculation {
    private static final Logger log = LoggerFactory.getLogger(AxisServiceCalculationImpl.class);
    private Map<String, Map<String, List<String>>> cachedConcepts = new ConcurrentHashMap();
    private long timer;
    private long counter;
    @Autowired
    private NamedParameterJdbcTemplate jdbcTemplate;

    @Async(value="calculation")
    public Future<Set<String>> calculateByFactAsync(AxisMemberHierarchy yItem, Map<String, TypedAspectData> flatX, Map<String, TypedAspectData> flatY, List<AspectData> zAspectData, Map<String, String> dimensionsDefault, Map<String, List<String>> flatXId, Map<String, List<String>> flatYId) {
        return new AsyncResult((Object)this.calculateByFact(yItem, new HashMap(), new HashMap(), zAspectData, dimensionsDefault, flatXId, flatYId));
    }

    @Async(value="calculation")
    public Future<Set<String>> calculateByFactListAsync(AxisMemberHierarchy yItem, Map<String, List<AspectData>> flatX, Map<String, List<AspectData>> flatY, List<AspectData> zAspectData, Map<String, String> dimensionsDefault, Map<String, List<String>> flatXId, Map<String, List<String>> flatYId) {
        return new AsyncResult((Object)this.calculateByFactList(yItem, new HashMap(), new HashMap(), zAspectData, dimensionsDefault, flatXId, flatYId));
    }

    public void clearConceptCache() {
        this.cachedConcepts.clear();
    }

    public void clearTimer() {
        this.timer = 0L;
    }

    public long getTimer() {
        return this.timer;
    }

    public void clearCounter() {
        this.counter = 0L;
    }

    public long getCounter() {
        return this.counter;
    }

    public Set<String> calculateByFactList(AxisMemberHierarchy yItem, Map<String, List<AspectData>> flatX, Map<String, List<AspectData>> flatY, List<AspectData> zAspectDataList, Map<String, String> dimensionsDefault, Map<String, List<String>> flatXId, Map<String, List<String>> flatYId, String parentId) {
        HashSet<String> axisesHasValue = new HashSet<String>();
        String currentLevelKey = null;
        for (String xKey : flatX.keySet()) {
            List dimensions;
            List dimensionsWithoutDefaults;
            List xbrlContextDimensions;
            String dimensionsHash;
            List xbrlContectValueDTOList;
            ConceptDimensionsAspectData conceptAndDimensionsByStream;
            AspectData concept;
            List<AspectData> yAspectData;
            List<AspectData> xAspectData;
            List<AspectData> typedXAspectData = flatX.get(xKey);
            currentLevelKey = yItem.getNodeType() == NodeType.ASPECT ? yItem.getId() : (StringUtils.isNotBlank((CharSequence)parentId) ? parentId + "#" + yItem.getId() : yItem.getId());
            List<AspectData> typedYAspectData = flatY.get(currentLevelKey);
            Stream all = new ArrayList().stream();
            if (typedXAspectData != null && (xAspectData = typedXAspectData) != null) {
                all = Stream.concat(all, xAspectData.stream());
            }
            if (typedYAspectData != null && (yAspectData = typedYAspectData) != null) {
                all = Stream.concat(all, yAspectData.stream());
            }
            if (!zAspectDataList.isEmpty()) {
                all = Stream.concat(all, zAspectDataList.stream());
            }
            if ((concept = (conceptAndDimensionsByStream = AspectCellData.getConceptAndDimensionsByStream(all)).getConcept()) == null || concept.isAbstractNode()) continue;
            Map byElementName = (Map)this.cachedConcepts.get(concept.getAspectValue());
            if (byElementName == null) {
                byElementName = this.calculateCacheContextForConcept(concept);
            }
            if (CollectionUtils.isEmpty((Collection)(xbrlContectValueDTOList = (List)byElementName.get(dimensionsHash = XbrlContextDimension.dimensionToHash(xbrlContextDimensions = (dimensionsWithoutDefaults = XbrlContextDimension.removeDefaultDimensions((List)(dimensions = conceptAndDimensionsByStream.getDimensionList()), dimensionsDefault)).stream().map(d -> {
                if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                    return new XbrlContextDimension(d.getAspect(), d.getDomain(), d.getAspectValue());
                }
                return new XbrlContextDimension(d.getAspect(), d.getAspectValue());
            }).collect(Collectors.toList())))))) continue;
            axisesHasValue.addAll((Collection<String>)flatXId.get(xKey));
            axisesHasValue.addAll((Collection<String>)flatYId.get(currentLevelKey));
        }
        for (AxisMemberHierarchy axisMemberHierarchy : yItem.getAxisMemberHierarchyList()) {
            axisesHasValue.addAll(this.calculateByFactList(axisMemberHierarchy, flatX, flatY, zAspectDataList, dimensionsDefault, flatXId, flatYId, currentLevelKey));
        }
        return axisesHasValue;
    }

    public Set<String> calculateByFact(AxisMemberHierarchy yItem, Map<String, TypedAspectData> flatX, Map<String, TypedAspectData> flatY, List<AspectData> zAspectData, Map<String, String> dimensionsDefault, Map<String, List<String>> flatXId, Map<String, List<String>> flatYId) {
        HashSet<String> axisesHasValue = new HashSet<String>();
        for (String xKey : flatX.keySet()) {
            List dimensions;
            List dimensionsWithoutDefaults;
            List xbrlContextDimensions;
            String dimensionsHash;
            List xbrlContectValueDTOList;
            ConceptDimensionsAspectData conceptAndDimensionsByStream;
            AspectData concept;
            List yAspectData;
            List xAspectData;
            TypedAspectData typedXAspectData = flatX.get(xKey);
            TypedAspectData typedYAspectData = flatY.get(yItem.getId());
            if (typedXAspectData != null && typedXAspectData.getNodeType() == NodeType.RULE && yItem.getNodeType() == NodeType.RULE && !typedXAspectData.isParentAspect() && typedYAspectData != null && !typedYAspectData.isParentAspect()) continue;
            Stream all = new ArrayList().stream();
            if (typedXAspectData != null && (xAspectData = typedXAspectData.getAspectData()) != null) {
                all = Stream.concat(all, xAspectData.stream());
            }
            if (typedYAspectData != null && (yAspectData = typedYAspectData.getAspectData()) != null) {
                all = Stream.concat(all, yAspectData.stream());
            }
            if (!zAspectData.isEmpty()) {
                all = Stream.concat(all, zAspectData.stream());
            }
            if ((concept = (conceptAndDimensionsByStream = AspectCellData.getConceptAndDimensionsByStream(all)).getConcept()) == null || concept.isAbstractNode()) continue;
            Map byElementName = (Map)this.cachedConcepts.get(concept.getAspectValue());
            if (byElementName == null) {
                byElementName = this.calculateCacheContextForConcept(concept);
            }
            if (CollectionUtils.isEmpty((Collection)(xbrlContectValueDTOList = (List)byElementName.get(dimensionsHash = XbrlContextDimension.dimensionToHash(xbrlContextDimensions = (dimensionsWithoutDefaults = XbrlContextDimension.removeDefaultDimensions((List)(dimensions = conceptAndDimensionsByStream.getDimensionList()), dimensionsDefault)).stream().map(d -> {
                if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                    return new XbrlContextDimension(d.getAspect(), d.getDomain(), d.getAspectValue());
                }
                return new XbrlContextDimension(d.getAspect(), d.getAspectValue());
            }).collect(Collectors.toList())))))) continue;
            axisesHasValue.addAll((Collection<String>)flatXId.get(xKey));
            axisesHasValue.addAll((Collection<String>)flatYId.get(yItem.getId()));
        }
        for (AxisMemberHierarchy axisMemberHierarchy : yItem.getAxisMemberHierarchyList()) {
            axisesHasValue.addAll(this.calculateByFact(axisMemberHierarchy, flatX, flatY, zAspectData, dimensionsDefault, flatXId, flatYId));
        }
        return axisesHasValue;
    }

    public Set<String> calculateByFactList(AxisMemberHierarchy yItem, Map<String, List<AspectData>> flatX, Map<String, List<AspectData>> flatY, List<AspectData> zAspectData, Map<String, String> dimensionsDefault, Map<String, List<String>> flatXId, Map<String, List<String>> flatYId) {
        HashSet<String> axisesHasValue = new HashSet<String>();
        for (String xKey : flatX.keySet()) {
            List dimensions;
            List dimensionsWithoutDefaults;
            List xbrlContextDimensions;
            String dimensionsHash;
            List xbrlContectValueDTOList;
            ConceptDimensionsAspectData conceptAndDimensionsByStream;
            AspectData concept;
            List<AspectData> yAspectData;
            List<AspectData> xAspectData;
            List<AspectData> typedXAspectData = flatX.get(xKey);
            List<AspectData> typedYAspectData = flatY.get(yItem.getId());
            Stream all = new ArrayList().stream();
            if (typedXAspectData != null && (xAspectData = typedXAspectData) != null) {
                all = Stream.concat(all, xAspectData.stream());
            }
            if (typedYAspectData != null && (yAspectData = typedYAspectData) != null) {
                all = Stream.concat(all, yAspectData.stream());
            }
            if (!zAspectData.isEmpty()) {
                all = Stream.concat(all, zAspectData.stream());
            }
            if ((concept = (conceptAndDimensionsByStream = AspectCellData.getConceptAndDimensionsByStream(all)).getConcept()) == null || concept.isAbstractNode()) continue;
            Map byElementName = (Map)this.cachedConcepts.get(concept.getAspectValue());
            if (byElementName == null) {
                byElementName = this.calculateCacheContextForConcept(concept);
            }
            if (CollectionUtils.isEmpty((Collection)(xbrlContectValueDTOList = (List)byElementName.get(dimensionsHash = XbrlContextDimension.dimensionToHash(xbrlContextDimensions = (dimensionsWithoutDefaults = XbrlContextDimension.removeDefaultDimensions((List)(dimensions = conceptAndDimensionsByStream.getDimensionList()), dimensionsDefault)).stream().map(d -> {
                if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                    return new XbrlContextDimension(d.getAspect(), d.getDomain(), d.getAspectValue());
                }
                return new XbrlContextDimension(d.getAspect(), d.getAspectValue());
            }).collect(Collectors.toList())))))) continue;
            axisesHasValue.addAll((Collection<String>)flatXId.get(xKey));
            axisesHasValue.addAll((Collection<String>)flatYId.get(yItem.getId()));
        }
        for (AxisMemberHierarchy axisMemberHierarchy : yItem.getAxisMemberHierarchyList()) {
            axisesHasValue.addAll(this.calculateByFactList(axisMemberHierarchy, flatX, flatY, zAspectData, dimensionsDefault, flatXId, flatYId));
        }
        return axisesHasValue;
    }

    private Map<String, List<String>> calculateCacheContextForConcept(AspectData concept) {
        HashMap<String, List<String>> byElementName = new HashMap<String, List<String>>();
        List byElementNameList = this.jdbcTemplate.query("select c.dimensionsHash from XbrlValue v, XbrlContext c where v.xbrlContextId = c.contextId and v.elementLabel = :elementLabel", (Map)new SingletonMap((Object)"elementLabel", (Object)concept.getAspectValue()), (rs, rowNum) -> rs.getString("dimensionsHash"));
        this.counter += (long)byElementNameList.size();
        for (String xbrlContectValueDTO : byElementNameList) {
            List xbrlContectValueDTOS = byElementName.computeIfAbsent(xbrlContectValueDTO, k -> new ArrayList());
            xbrlContectValueDTOS.add(xbrlContectValueDTO);
        }
        this.cachedConcepts.put(concept.getAspectValue(), byElementName);
        return byElementName;
    }
}

