/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.tablelinkbase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.model.XbrlDimension;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.filter.FilterViewType;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.AspectNodeMember;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterClosedAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterClosedAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlRoleDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimensionFilter;
import ru.cbr.xbrl.converter.repository.XbrlContextRepository;
import ru.cbr.xbrl.converter.repository.XbrlDimensionRepository;
import ru.cbr.xbrl.converter.repository.XbrlValueRepository;
import ru.cbr.xbrl.converter.service.TableLinkBaseDynamicStructureService;
import ru.cbr.xbrl.converter.service.XbrlContectValueDTO;
import ru.cbr.xbrl.converter.service.XbrlDimensionService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisMemberService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisService;
import ru.cbr.xbrl.converter.service.internal.XbrlReportCrudService;
import ru.cbr.xbrl.converter.service.presentation_definition.InactiveMembersService;
import ru.cbr.xbrl.converter.service.tablelinkbase.AxisServiceCalculation;
import ru.cbr.xbrl.converter.utils.LabelUtils;
import ru.cbr.xbrl.converter.utils.LispStyleUtil;
import ru.cbr.xbrl.converter.utils.MathUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;
import ru.cbr.xbrl.converter.xbrl.import_export.scenario.XbrlContextScenarioParser;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AxisService {
    private static final Logger log = LoggerFactory.getLogger(AxisService.class);
    @Autowired
    private XbrlFilterOpenAxisService xbrlFilterOpenAxisService;
    @Autowired
    private XbrlValueRepository xbrlValueRepository;
    @Autowired
    private XbrlFilterOpenAxisMemberService xbrlFilterOpenAxisMemberService;
    @Autowired
    private XbrlReportCrudService xbrlReportCrudService;
    @Autowired
    private XbrlDimensionRepository xbrlDimensionRepository;
    @Autowired
    private XbrlDimensionService xbrlDimensionService;
    @Autowired
    private InactiveMembersService inactiveMembersService;
    @Autowired
    private XbrlContextRepository xbrlContextRepository;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private TableLinkBaseDynamicStructureService tableLinkBaseDynamicStructureService;
    @Autowired
    private AxisServiceCalculation axisServiceCalculation;
    private static final String PERIOD = "period";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";
    public static final String GENERATED = "EMPTY_AXIS";
    private Long nodeTypeErrorCounter = 0L;
    private Map<String, List<XbrlContectValueDTO>> cachedConcepts = new HashMap();
    public long isContextPathExistTimer = 0L;
    public long createMemberCounter = 0L;
    public long createMemberExplicitCounter = 0L;
    public long createMemberZCounter = 0L;
    private Map<String, AxisMemberHierarchy> hierarchyMap = new HashMap();

    public List<FilterOpenAxis> addTypedAxisToRole(Set<AspectData> typedDimensions, XbrlReportRole xbrlReportRole) {
        ArrayList<FilterOpenAxis> typedAxises = new ArrayList<FilterOpenAxis>();
        for (AspectData typedDimension : typedDimensions) {
            List defaultOpenAxis = this.xbrlFilterOpenAxisService.findFilterOpenAxisBySystemId(typedDimension.getAspect());
            Optional first = defaultOpenAxis.stream().findFirst();
            FilterOpenAxis filterOpenAxis = first.orElseGet(() -> {
                FilterOpenAxis newFilterOpenAxis = new FilterOpenAxis();
                newFilterOpenAxis.setTitle(typedDimension.getLabel());
                newFilterOpenAxis.setSystemId(typedDimension.getAspect());
                newFilterOpenAxis.setDomain(typedDimension.getDomain());
                return this.xbrlFilterOpenAxisService.update(newFilterOpenAxis);
            });
            XbrlRoleDimension xbrlRoleDimension = new XbrlRoleDimension();
            xbrlRoleDimension.setFilterOpenAxis(filterOpenAxis);
            xbrlRoleDimension.setXbrlReportRole(xbrlReportRole);
            xbrlRoleDimension.setDimensionType(DimensionType.TYPED_MEMBER);
            filterOpenAxis.getXbrlRoleDimensionList().add(xbrlRoleDimension);
            typedAxises.add(this.xbrlFilterOpenAxisService.update(filterOpenAxis));
        }
        return typedAxises;
    }

    public void addExplicitAxisToRole(TableLinkBaseStructure structure, XbrlReportRole xbrlReportRole) {
        Set dimensionsOfAspectNodes = structure.getDimensionsOfAspectNodes();
        dimensionsOfAspectNodes.forEach(dimension -> {
            boolean isExplicitDimension = this.xbrlDimensionService.isExplicitDimension(dimension);
            if (isExplicitDimension) {
                XbrlRoleDimension xbrlRoleDimension = new XbrlRoleDimension();
                xbrlRoleDimension.setDimensionType(DimensionType.EXPLICIT_MEMBER);
                xbrlRoleDimension.setDimension(dimension);
                xbrlRoleDimension.setXbrlReportRole(xbrlReportRole);
                xbrlReportRole.getXbrlRoleDimensionList().add(xbrlRoleDimension);
            }
        });
    }

    public List<FilterAxis> fillFilterAxisList(String roleSystemId, List<XbrlRoleDimension> xbrlRoleDimensionList) {
        Long countInactiveOpenMember = this.inactiveMembersService.countInactiveOpenMember();
        List<FilterAxis> filterAxisList = xbrlRoleDimensionList.stream().map(d -> {
            if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                FilterOpenAxis filterOpenAxis = d.getFilterOpenAxis();
                filterOpenAxis.getAxisMemberList().forEach(filterOpenAxisValue -> {
                    boolean isActive = true;
                    if (countInactiveOpenMember > 0L) {
                        isActive = !this.inactiveMembersService.isInactiveOpenMember(roleSystemId, filterOpenAxisValue.getId(), FilterViewType.TABLELINKBASE);
                    }
                    filterOpenAxisValue.setActive(Boolean.valueOf(isActive));
                });
                return filterOpenAxis;
            }
            FilterClosedAxis filterClosedAxis = new FilterClosedAxis();
            List members = this.xbrlDimensionService.findMembers(roleSystemId, d.getDimension());
            if (!members.isEmpty()) {
                filterClosedAxis.setTitle(((XbrlDimension)members.get(0)).getDimIntLabel());
                filterClosedAxis.setSystemId(d.getDimension());
                members.forEach(xbrlDimension -> {
                    FilterClosedAxisValue filterClosedAxisValue = new FilterClosedAxisValue();
                    filterClosedAxisValue.setValue(xbrlDimension.getMemIntLabel());
                    String memInt = xbrlDimension.getMemInt();
                    filterClosedAxisValue.setMember(memInt);
                    boolean isActive = !this.inactiveMembersService.isInactiveClosedMember(roleSystemId, d.getDimension(), memInt, FilterViewType.TABLELINKBASE);
                    filterClosedAxisValue.setActive(Boolean.valueOf(isActive));
                    filterClosedAxis.getAxisMemberList().add(filterClosedAxisValue);
                });
            }
            return filterClosedAxis;
        }).collect(Collectors.toList());
        return filterAxisList;
    }

    public void fillAspectNodeMembers(TableLinkBaseStructure structure, XbrlReportRole xbrlReportRole, Map<String, List<FilterOpenAxis>> filterOpenAxisMap, Map<String, List<XbrlContextDimension>> cacheContextDimensions, List<XbrlContext> usedContext, Boolean onlyWithData) throws ExecutionException, InterruptedException {
        this.cachedConcepts = new HashMap();
        this.axisServiceCalculation.clearConceptCache();
        ArrayList aspectNodes = new ArrayList();
        this.processAspectNodes(structure.getXAxis(), aspectNodes);
        this.processAspectNodes(structure.getYAxis(), aspectNodes);
        this.processAspectNodes(structure.getZAxis(), aspectNodes);
        if (aspectNodes.isEmpty()) {
            return;
        }
        Long date = new Date().getTime();
        HashMap contextsByTypedValues = new HashMap();
        for (XbrlContext c : usedContext) {
            for (XbrlContextDimension d : c.getXbrlContextDimensions()) {
                Set<XbrlContextDimensionFilter> ctxs;
                if (d.getDimensionType() == DimensionType.TYPED_MEMBER) {
                    if (contextsByTypedValues.containsKey(d.getDomainValue())) {
                        ctxs = (Set)contextsByTypedValues.get(d.getDomainValue());
                    } else {
                        ctxs = new HashSet();
                        contextsByTypedValues.put(d.getDomainValue(), ctxs);
                    }
                    ctxs.add(this.initXbrlContextDimensionFilter(c));
                    continue;
                }
                if (contextsByTypedValues.containsKey(d.getMember())) {
                    ctxs = (Set)contextsByTypedValues.get(d.getMember());
                } else {
                    ctxs = new HashSet();
                    contextsByTypedValues.put(d.getMember(), ctxs);
                }
                ctxs.add(this.initXbrlContextDimensionFilter(c));
            }
        }
        Long dateEnd = new Date().getTime();
        log.trace("Prepare context map - {}ms", (Object)(dateEnd - date));
        date = dateEnd;
        this.isContextPathExistTimer = 0L;
        LinkedHashMap defaultHierarchyMap = new LinkedHashMap();
        this.fillDynamicDataForDefaultDimensions(structure.getXAxis(), filterOpenAxisMap, defaultHierarchyMap, new Stack(), new Stack(), null, structure);
        this.hierarchyMap.clear();
        AxisMemberHierarchy xStructure = (AxisMemberHierarchy)LispStyleUtil.car((List)this.fillDynamicData(structure.getXAxis(), filterOpenAxisMap, cacheContextDimensions, contextsByTypedValues, new Stack(), new Stack(), null, !CollectionUtils.isEmpty(defaultHierarchyMap)));
        this.mergeDefaultMemberHierarchy(this.hierarchyMap, defaultHierarchyMap);
        structure.setXAxis(xStructure);
        defaultHierarchyMap.clear();
        this.fillDynamicDataForDefaultDimensions(structure.getYAxis(), filterOpenAxisMap, defaultHierarchyMap, new Stack(), new Stack(), null, structure);
        this.hierarchyMap.clear();
        log.trace("Is Context Path Exist Timer X - {} ms", (Object)this.isContextPathExistTimer);
        this.isContextPathExistTimer = 0L;
        AxisMemberHierarchy yStructure = (AxisMemberHierarchy)LispStyleUtil.car((List)this.fillDynamicData(structure.getYAxis(), filterOpenAxisMap, cacheContextDimensions, contextsByTypedValues, new Stack(), new Stack(), null, !CollectionUtils.isEmpty(defaultHierarchyMap)));
        log.trace("Is Context Path Exist Timer Y - {} ms", (Object)this.isContextPathExistTimer);
        dateEnd = new Date().getTime();
        log.trace("Fill dynamic data - {}ms", (Object)(dateEnd - date));
        this.mergeDefaultMemberHierarchy(this.hierarchyMap, defaultHierarchyMap);
        structure.setYAxis(yStructure);
        this.hierarchyMap.clear();
        defaultHierarchyMap.clear();
        structure.setZAxis((AxisMemberHierarchy)LispStyleUtil.car((List)this.createFilledAxis(structure.getZAxis(), cacheContextDimensions)));
        this.fillDates(structure, xbrlReportRole);
        Set axisesHasValue = this.calculateAspectNodeMembers(structure);
        HashMap cachedClosedMembers = new HashMap();
        date = new Date().getTime();
        this.nodeTypeErrorCounter = 0L;
        this.createMemberCounter = 0L;
        this.createMemberExplicitCounter = 0L;
        this.createMemberZCounter = 0L;
        if (!axisesHasValue.isEmpty()) {
            this.createMembersForAxis(structure.getXAxis(), null, xbrlReportRole, filterOpenAxisMap, axisesHasValue, cachedClosedMembers, onlyWithData);
            this.createMembersForAxis(structure.getYAxis(), null, xbrlReportRole, filterOpenAxisMap, axisesHasValue, cachedClosedMembers, onlyWithData);
        }
        log.trace("Created members typed {}", (Object)this.createMemberCounter);
        log.trace("Created members explicit {}", (Object)this.createMemberExplicitCounter);
        log.trace("Created members Z {}", (Object)this.createMemberZCounter);
        log.trace("Stream duration {}", (Object)this.nodeTypeErrorCounter);
        this.createMembersForZ(structure.getZAxis(), filterOpenAxisMap, xbrlReportRole, null);
        dateEnd = new Date().getTime();
        log.trace("Create members - {}ms", (Object)(dateEnd - date));
        this.xbrlReportCrudService.updateXbrlReportRole(xbrlReportRole);
    }

    private void mergeDefaultMemberHierarchy(Map<String, AxisMemberHierarchy> hierarchyMap, Map<String, AxisMemberHierarchy> defaultHierarchyMap) {
        if (CollectionUtils.isEmpty(hierarchyMap) || CollectionUtils.isEmpty(defaultHierarchyMap)) {
            return;
        }
        for (Map.Entry<String, AxisMemberHierarchy> defaultHierarchyEntry : defaultHierarchyMap.entrySet()) {
            String parentId = defaultHierarchyEntry.getKey();
            AxisMemberHierarchy axisMemberHierarchy = hierarchyMap.get(parentId);
            if (axisMemberHierarchy == null) continue;
            AxisMemberHierarchy defaultMemberHierarchy = defaultHierarchyEntry.getValue();
            axisMemberHierarchy.getAxisMemberHierarchyList().add(defaultMemberHierarchy);
            hierarchyMap.put(defaultMemberHierarchy.getId(), defaultMemberHierarchy);
        }
    }

    private XbrlContextDimensionFilter initXbrlContextDimensionFilter(XbrlContext xbrlContext) {
        XbrlContextDimensionFilter xbrlContextDimensionFilter = new XbrlContextDimensionFilter(xbrlContext);
        List xbrlContextDimensions = xbrlContext.getXbrlContextDimensions();
        for (XbrlContextDimension xbrlContextDimension : xbrlContextDimensions) {
            String dimension = xbrlContextDimension.getDimension();
            String value = xbrlContextDimension.getDimensionType() == DimensionType.TYPED_MEMBER ? xbrlContextDimension.getDomainValue() : xbrlContextDimension.getMember();
            Map xbrlContextDimensionValueMap = xbrlContextDimensionFilter.getXbrlContextDimensionByAspectMemberMap().computeIfAbsent(dimension, k -> new HashMap());
            if (xbrlContextDimensionValueMap.get(value) != null) {
                log.error("Error during building filter context. Context id {}, dimension {}, existing value {}", new Object[]{xbrlContext.getXbrlContextIdContextId(), dimension, value});
            }
            xbrlContextDimensionValueMap.put(value, xbrlContextDimension);
        }
        return xbrlContextDimensionFilter;
    }

    private void createMembersForZ(AxisMemberHierarchy zAxis, Map<String, List<FilterOpenAxis>> filterOpenAxisMap, XbrlReportRole xbrlReportRole, AxisMemberHierarchy parentAxis) {
        List typedAspects = zAxis.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION && it.getDimensionType() == DimensionType.TYPED_MEMBER).collect(Collectors.toList());
        for (AspectData aspectData : typedAspects) {
            List<FilterOpenAxis> filterOpenAxisList = filterOpenAxisMap.get(aspectData.getAspect());
            if (CollectionUtils.isEmpty(filterOpenAxisList)) {
                log.error("create Members For Z ERROR");
                return;
            }
            FilterOpenAxis filterOpenAxis = filterOpenAxisList.iterator().next();
            Optional<FilterOpenAxisValue> firstMember = filterOpenAxis.getAxisMemberList().stream().filter(it -> it.getValue().equals(aspectData.getAspectValue())).findFirst();
            if (firstMember.isPresent()) continue;
            FilterOpenAxisValue newMember = new FilterOpenAxisValue();
            newMember.setFilterOpenAxis(filterOpenAxis);
            newMember.setValue(aspectData.getAspectValue());
            newMember = this.xbrlFilterOpenAxisMemberService.update(newMember);
            ++this.createMemberZCounter;
            filterOpenAxis.getAxisMemberList().add(newMember);
            AspectNodeMember aspectNodeMember = new AspectNodeMember();
            aspectNodeMember.setXbrlReportRole(xbrlReportRole);
            aspectNodeMember.setFilterOpenAxisValue(newMember);
            aspectNodeMember.setDimension(aspectData.getAspect());
            aspectNodeMember.setHash(parentAxis.getId());
            aspectNodeMember.setCommonId(UUID.randomUUID().toString());
            xbrlReportRole.getAspectNodeMembers().add(aspectNodeMember);
        }
        for (AxisMemberHierarchy axisMemberHierarchy : zAxis.getAxisMemberHierarchyList()) {
            this.createMembersForZ(axisMemberHierarchy, filterOpenAxisMap, xbrlReportRole, zAxis);
        }
    }

    private void createMembersForAxis(AxisMemberHierarchy axis, AxisMemberHierarchy parent, XbrlReportRole xbrlReportRole, Map<String, List<FilterOpenAxis>> filterOpenAxisMap, Set<String> axisesHasValue, HashMap<String, List<XbrlDimension>> cachedClosedMembers, Boolean onlyWithData) {
        Optional<AspectData> first;
        if (axis.getNodeType() == NodeType.ASPECT && (!onlyWithData.booleanValue() || axisesHasValue.contains(axis.getId())) && (first = axis.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION).findFirst()).isPresent()) {
            AspectData aspectData = first.get();
            this.addOpenMemberToRole(aspectData, axis.getId(), parent.getId(), xbrlReportRole, filterOpenAxisMap, cachedClosedMembers);
        }
        for (AxisMemberHierarchy axisMemberHierarchy : axis.getAxisMemberHierarchyList()) {
            this.createMembersForAxis(axisMemberHierarchy, axis, xbrlReportRole, filterOpenAxisMap, axisesHasValue, cachedClosedMembers, onlyWithData);
        }
    }

    private void addOpenMemberToRole(AspectData aspectData, String commonId, String hash, XbrlReportRole xbrlReportRole, Map<String, List<FilterOpenAxis>> filterOpenAxisMap, HashMap<String, List<XbrlDimension>> cachedClosedMembers) {
        if (aspectData.getDimensionType() == DimensionType.TYPED_MEMBER) {
            FilterOpenAxisValue target;
            List<FilterOpenAxis> filterOpenAxisList = filterOpenAxisMap.get(aspectData.getAspect());
            if (CollectionUtils.isEmpty(filterOpenAxisList)) {
                log.error("Error of addition open member to the role {}", (Object)xbrlReportRole.getTitle());
                return;
            }
            FilterOpenAxis filterOpenAxis = filterOpenAxisList.iterator().next();
            Optional<FilterOpenAxisValue> first = filterOpenAxis.getAxisMemberList().stream().filter(it -> it.getValue().equals(aspectData.getAspectValue())).findFirst();
            if (first.isPresent()) {
                target = first.get();
            } else {
                target = new FilterOpenAxisValue();
                target.setFilterOpenAxis(filterOpenAxis);
                target.setValue(aspectData.getAspectValue());
                target = this.xbrlFilterOpenAxisMemberService.update(target);
                filterOpenAxis.getAxisMemberList().add(target);
            }
            AspectNodeMember aspectNodeMember = new AspectNodeMember();
            aspectNodeMember.setXbrlReportRole(xbrlReportRole);
            aspectNodeMember.setFilterOpenAxisValue(target);
            aspectNodeMember.setDimension(aspectData.getAspect());
            aspectNodeMember.setHash(hash);
            aspectNodeMember.setCommonId(commonId);
            FilterOpenAxisValue finalTarget = target;
            Optional<AspectNodeMember> existing = xbrlReportRole.getAspectNodeMembers().stream().filter(exist -> exist.getXbrlReportRole().equals((Object)xbrlReportRole) && exist.getFilterOpenAxisValue() != null && exist.getFilterOpenAxisValue().getId().equals(finalTarget.getId()) && exist.getDimension().equals(aspectData.getAspect()) && exist.getHash().equals(hash)).findAny();
            if (!existing.isPresent()) {
                xbrlReportRole.getAspectNodeMembers().add(aspectNodeMember);
                this.xbrlReportCrudService.updateXbrlReportRole(xbrlReportRole);
            }
        } else {
            Optional<XbrlDimension> targetMember;
            AspectNodeMember aspectNodeMember = new AspectNodeMember();
            aspectNodeMember.setXbrlReportRole(xbrlReportRole);
            List xbrlDimensions = cachedClosedMembers.get(aspectData.getAspect());
            if (xbrlDimensions == null) {
                xbrlDimensions = this.xbrlDimensionRepository.findAllByDimInt(aspectData.getAspect());
                cachedClosedMembers.put(aspectData.getAspect(), xbrlDimensions);
            }
            String label = aspectData.getAspectValue();
            if (xbrlDimensions != null && (targetMember = xbrlDimensions.stream().filter(it -> it.getMemInt().equals(aspectData.getAspectValue())).findFirst()).isPresent()) {
                label = targetMember.get().getMemIntLabel();
            }
            aspectNodeMember.setClosedMemberLabel(label);
            aspectNodeMember.setClosedMemberValue(aspectData.getAspectValue());
            aspectNodeMember.setDimension(aspectData.getAspect());
            aspectNodeMember.setHash(hash);
            aspectNodeMember.setCommonId(commonId);
            Optional<AspectNodeMember> existing = xbrlReportRole.getAspectNodeMembers().stream().filter(exist -> exist.getXbrlReportRole().equals((Object)xbrlReportRole) && exist.getClosedMemberValue() != null && exist.getClosedMemberValue().equals(aspectData.getAspectValue()) && exist.getDimension().equals(aspectData.getAspect()) && exist.getHash().equals(hash)).findAny();
            if (!existing.isPresent()) {
                xbrlReportRole.getAspectNodeMembers().add(aspectNodeMember);
                this.xbrlReportCrudService.updateXbrlReportRole(xbrlReportRole);
            }
        }
    }

    private Set<String> calculateAspectNodeMembers(TableLinkBaseStructure structure) throws ExecutionException, InterruptedException {
        HashSet<String> axisesHasValue = new HashSet<String>();
        HashMap flatY = new HashMap();
        HashMap flatX = new HashMap();
        this.nodeTypeErrorCounter = 0L;
        Long date = new Date().getTime();
        this.flattenAspectsWithFullKey(null, structure.getYAxis(), new ArrayList(), flatY);
        this.flattenAspectsWithFullKey(null, structure.getXAxis(), new ArrayList(), flatX);
        Long dateEnd = new Date().getTime();
        HashMap flatYId = new HashMap();
        HashMap flatXId = new HashMap();
        this.flattenIdsWithFullKey(null, structure.getYAxis(), new ArrayList(), flatYId);
        this.flattenIdsWithFullKey(null, structure.getXAxis(), new ArrayList(), flatXId);
        dateEnd = new Date().getTime();
        List axisMemberHierarchyList = structure.getYAxis().getAxisMemberHierarchyList();
        this.axisServiceCalculation.clearTimer();
        this.axisServiceCalculation.clearCounter();
        for (AxisMemberHierarchy zAxisMemberHierarchy : structure.getZAxis().getAxisMemberHierarchyList()) {
            for (AxisMemberHierarchy yItem : axisMemberHierarchyList) {
                axisesHasValue.addAll(this.axisServiceCalculation.calculateByFactList(yItem, flatX, flatY, zAxisMemberHierarchy.getAspectDataList(), structure.getDimensionsDefault(), flatXId, flatYId, structure.getYAxis().getId()));
            }
        }
        dateEnd = new Date().getTime();
        log.trace("Calculate Aspect Node Members - {}s", (Object)(dateEnd - date));
        log.trace("\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0447\u0442\u0435\u043d\u0438\u044f \u0438\u0437 \u0411\u0414 {} ms", (Object)this.axisServiceCalculation.getTimer());
        log.trace("\u0420\u043e\u043b\u044c {}, \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e hasValues {}", (Object)structure.getLabel(), (Object)axisesHasValue.size());
        return axisesHasValue;
    }

    public List<AxisMemberHierarchy> createFilledAxis(AxisMemberHierarchy original, Map<String, List<XbrlContextDimension>> cacheContextDimensions) {
        ArrayList<AxisMemberHierarchy> filled = new ArrayList<AxisMemberHierarchy>();
        List typedAspects = original.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION && it.getDimensionType() == DimensionType.TYPED_MEMBER || it.getDimensionType() == DimensionType.EXPLICIT_MEMBER).collect(Collectors.toList());
        if (original.getNodeType() == NodeType.RULE) {
            AxisMemberHierarchy newSimpleAxisMemberHierarchy = new AxisMemberHierarchy();
            newSimpleAxisMemberHierarchy.setAxis(original.getAxis());
            if ("title".equals(original.getId())) {
                newSimpleAxisMemberHierarchy.setId("title");
            } else {
                newSimpleAxisMemberHierarchy.setId(UUID.randomUUID().toString());
            }
            newSimpleAxisMemberHierarchy.setAspectDataList(original.getAspectDataList());
            newSimpleAxisMemberHierarchy.setLabel(LabelUtils.calcLabel((List)newSimpleAxisMemberHierarchy.getAspectDataList(), (String)original.getLabel()));
            filled.add(newSimpleAxisMemberHierarchy);
        } else {
            ArrayList<List<XbrlContextDimension>> values = new ArrayList<List<XbrlContextDimension>>();
            for (AspectData effectiveAspect : typedAspects) {
                List<XbrlContextDimension> value = cacheContextDimensions.get(effectiveAspect.getAspect());
                if (value == null || value.isEmpty()) continue;
                values.add(value);
            }
            List cartesian = MathUtils.cartesianProduct(values);
            for (List filterOpenAxisValues : cartesian) {
                AxisMemberHierarchy newTypedAxisMemberHierarchy = new AxisMemberHierarchy();
                newTypedAxisMemberHierarchy.setAxis(original.getAxis());
                newTypedAxisMemberHierarchy.setId(UUID.randomUUID().toString());
                for (XbrlContextDimension xbrlContextDimension : filterOpenAxisValues) {
                    AspectData newAspectData = new AspectData();
                    newAspectData.setAspect(xbrlContextDimension.getDimension());
                    if (xbrlContextDimension.getDimensionType() == DimensionType.TYPED_MEMBER) {
                        newAspectData.setAspectValue(xbrlContextDimension.getDomainValue());
                    } else {
                        newAspectData.setAspectValue(xbrlContextDimension.getMember());
                    }
                    newAspectData.setType(AspectType.DIMENSION);
                    newAspectData.setDimensionType(xbrlContextDimension.getDimensionType());
                    newAspectData.setDomain(xbrlContextDimension.getDomain());
                    newTypedAxisMemberHierarchy.getAspectDataList().add(newAspectData);
                }
                newTypedAxisMemberHierarchy.setLabel(LabelUtils.calcLabel((List)newTypedAxisMemberHierarchy.getAspectDataList(), null));
                filled.add(newTypedAxisMemberHierarchy);
            }
        }
        for (AxisMemberHierarchy originalChild : original.getAxisMemberHierarchyList()) {
            filled.forEach(it -> it.getAxisMemberHierarchyList().addAll(this.createFilledAxis(originalChild, cacheContextDimensions)));
        }
        return filled;
    }

    private Boolean IsContextPathExist(AxisMemberHierarchy newItem, Map<String, Set<XbrlContextDimensionFilter>> contextsByTypedValues, List<AxisMemberHierarchy> pathToCheck) {
        AspectData firstData = (AspectData)newItem.getAspectDataList().get(0);
        if (!contextsByTypedValues.containsKey(firstData.getAspectValue())) {
            return false;
        }
        Set<XbrlContextDimensionFilter> availContext = contextsByTypedValues.get(firstData.getAspectValue());
        for (XbrlContextDimensionFilter c : availContext) {
            boolean pathFound = true;
            for (AxisMemberHierarchy p : pathToCheck) {
                AspectData pData = (AspectData)p.getAspectDataList().get(0);
                Map xbrlContextDimensionByAspectMemberMap = c.getXbrlContextDimensionByAspectMemberMap();
                if (CollectionUtils.isEmpty((Map)xbrlContextDimensionByAspectMemberMap)) {
                    pathFound = false;
                    break;
                }
                Map xbrlContextDimensionValueMap = (Map)xbrlContextDimensionByAspectMemberMap.get(pData.getAspect());
                if (CollectionUtils.isEmpty((Map)xbrlContextDimensionValueMap)) {
                    pathFound = false;
                    break;
                }
                XbrlContextDimension xbrlContextDimension = (XbrlContextDimension)xbrlContextDimensionValueMap.get(pData.getAspectValue());
                if (xbrlContextDimension != null) continue;
                pathFound = false;
                break;
            }
            if (!pathFound) continue;
            return true;
        }
        return false;
    }

    private List<AxisMemberHierarchy> fillDynamicData(AxisMemberHierarchy original, Map<String, List<FilterOpenAxis>> filterOpenAxisMap, Map<String, List<XbrlContextDimension>> cacheContextDimensions, Map<String, Set<XbrlContextDimensionFilter>> contextsByTypedValues, Stack<AxisMemberHierarchy> axisMemberHierarchyStack, Stack<AxisMemberHierarchy> axisMemberValueStack, String parentId, boolean shouldFillHierarchyMap) {
        Optional<AspectData> first;
        ArrayList<AxisMemberHierarchy> filled = new ArrayList<AxisMemberHierarchy>();
        List<Object> pathToCheck = new ArrayList<AxisMemberHierarchy>(axisMemberValueStack);
        pathToCheck = pathToCheck.stream().filter(x -> x.getNodeType() == NodeType.ASPECT).collect(Collectors.toList());
        if (original.getNodeType() == NodeType.RULE) {
            AxisMemberHierarchy newSimpleAxisMemberHierarchy = new AxisMemberHierarchy();
            newSimpleAxisMemberHierarchy.setAxis(original.getAxis());
            newSimpleAxisMemberHierarchy.setId(original.getId());
            newSimpleAxisMemberHierarchy.setAspectDataList(original.getAspectDataList());
            newSimpleAxisMemberHierarchy.setDefinitionNodeId(original.getDefinitionNodeId());
            newSimpleAxisMemberHierarchy.setParentDefinitionNodeId(original.getParentDefinitionNodeId());
            filled.add(newSimpleAxisMemberHierarchy);
            if (shouldFillHierarchyMap) {
                this.hierarchyMap.put(newSimpleAxisMemberHierarchy.getId(), newSimpleAxisMemberHierarchy);
            }
        } else if (original.getNodeType() == NodeType.ASPECT && (first = original.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION).findFirst()).isPresent()) {
            List<XbrlContextDimension> xbrlContextDimensions;
            AspectData aspectData = first.get();
            FilterOpenAxis filterOpenAxis = null;
            List<FilterOpenAxis> filterOpenAxisList = filterOpenAxisMap.get(aspectData.getAspect());
            HashMap<String, ArrayList<FilterOpenAxisValue>> filterOpenAxisValueMap = new HashMap<String, ArrayList<FilterOpenAxisValue>>();
            if (!CollectionUtils.isEmpty(filterOpenAxisList)) {
                filterOpenAxis = filterOpenAxisList.iterator().next();
                List axisMemberList = filterOpenAxis.getAxisMemberList();
                for (FilterOpenAxisValue filterOpenAxisValue : axisMemberList) {
                    String value = filterOpenAxisValue.getValue();
                    ArrayList<FilterOpenAxisValue> filterOpenAxisValueList = (ArrayList<FilterOpenAxisValue>)filterOpenAxisValueMap.get(value);
                    if (filterOpenAxisValueList == null) {
                        filterOpenAxisValueList = new ArrayList<FilterOpenAxisValue>();
                        filterOpenAxisValueList.add(filterOpenAxisValue);
                        filterOpenAxisValueMap.put(value, filterOpenAxisValueList);
                        continue;
                    }
                    filterOpenAxisValueList.add(filterOpenAxisValue);
                }
            }
            if ((xbrlContextDimensions = cacheContextDimensions.get(aspectData.getAspect())) != null) {
                for (XbrlContextDimension xbrlContextDimension : xbrlContextDimensions) {
                    String axisValueId;
                    AxisMemberHierarchy newOpenAxisMemberHierarchy = new AxisMemberHierarchy();
                    newOpenAxisMemberHierarchy.setAxis(original.getAxis());
                    newOpenAxisMemberHierarchy.setNodeType(NodeType.ASPECT);
                    newOpenAxisMemberHierarchy.setDefinitionNodeId(original.getDefinitionNodeId());
                    newOpenAxisMemberHierarchy.setParentDefinitionNodeId(original.getParentDefinitionNodeId());
                    AspectData newAspectData = new AspectData();
                    newAspectData.setAspect(xbrlContextDimension.getDimension());
                    if (xbrlContextDimension.getDimensionType() == DimensionType.TYPED_MEMBER) {
                        List valueList;
                        newAspectData.setAspectValue(xbrlContextDimension.getDomainValue());
                        axisValueId = filterOpenAxis != null ? (!CollectionUtils.isEmpty((Collection)(valueList = (List)filterOpenAxisValueMap.get(newAspectData.getAspectValue()))) && valueList.iterator().next() != null ? ((FilterOpenAxisValue)valueList.iterator().next()).getValue() : newAspectData.getAspectValue()) : newAspectData.getAspectValue();
                        axisValueId = DigestUtils.md5Hex((String)axisValueId);
                    } else {
                        newAspectData.setAspectValue(xbrlContextDimension.getMember());
                        axisValueId = xbrlContextDimension.getMember();
                    }
                    String naturalId = original.getDefinitionNodeId() + "#" + newAspectData.getAspect() + "#" + axisValueId;
                    if (parentId != null) {
                        naturalId = parentId + "#" + naturalId;
                    }
                    newOpenAxisMemberHierarchy.setId(naturalId);
                    newAspectData.setType(AspectType.DIMENSION);
                    newAspectData.setDimensionType(xbrlContextDimension.getDimensionType());
                    newAspectData.setDomain(xbrlContextDimension.getDomain());
                    newOpenAxisMemberHierarchy.getAspectDataList().add(newAspectData);
                    if (CollectionUtils.isEmpty(pathToCheck)) {
                        filled.add(newOpenAxisMemberHierarchy);
                        continue;
                    }
                    if (!this.IsContextPathExist(newOpenAxisMemberHierarchy, contextsByTypedValues, pathToCheck).booleanValue()) continue;
                    filled.add(newOpenAxisMemberHierarchy);
                }
            }
        }
        for (AxisMemberHierarchy originalChild : original.getAxisMemberHierarchyList()) {
            axisMemberHierarchyStack.push(originalChild);
            for (AxisMemberHierarchy v : filled) {
                axisMemberValueStack.push(v);
                v.getAxisMemberHierarchyList().addAll(this.fillDynamicData(originalChild, filterOpenAxisMap, cacheContextDimensions, contextsByTypedValues, axisMemberHierarchyStack, axisMemberValueStack, v.getId(), shouldFillHierarchyMap));
                axisMemberValueStack.pop();
            }
            axisMemberHierarchyStack.pop();
        }
        return filled;
    }

    private void fillDynamicDataForDefaultDimensions(AxisMemberHierarchy original, Map<String, List<FilterOpenAxis>> filterOpenAxisMap, Map<String, AxisMemberHierarchy> defaultHierarchyMap, Stack<AxisMemberHierarchy> axisMemberHierarchyStack, Stack<AxisMemberHierarchy> axisMemberValueStack, String parentId, TableLinkBaseStructure structure) {
        Optional<AspectData> first;
        ArrayList<AxisMemberHierarchy> filled = new ArrayList<AxisMemberHierarchy>();
        Map dimensionsDefault = structure.getDimensionsDefault();
        if (original.getNodeType() == NodeType.RULE) {
            AxisMemberHierarchy newSimpleAxisMemberHierarchy = new AxisMemberHierarchy();
            newSimpleAxisMemberHierarchy.setAxis(original.getAxis());
            newSimpleAxisMemberHierarchy.setId(original.getId());
            newSimpleAxisMemberHierarchy.setAspectDataList(original.getAspectDataList());
            newSimpleAxisMemberHierarchy.setDefinitionNodeId(original.getDefinitionNodeId());
            newSimpleAxisMemberHierarchy.setParentDefinitionNodeId(original.getParentDefinitionNodeId());
            filled.add(newSimpleAxisMemberHierarchy);
        } else if (original.getNodeType() == NodeType.ASPECT && (first = original.getAspectDataList().stream().filter(it -> it.getType() == AspectType.DIMENSION).findFirst()).isPresent()) {
            String member;
            AspectData aspectData = first.get();
            FilterOpenAxis filterOpenAxis = null;
            List<FilterOpenAxis> filterOpenAxisList = filterOpenAxisMap.get(aspectData.getAspect());
            HashMap<String, ArrayList<FilterOpenAxisValue>> filterOpenAxisValueMap = new HashMap<String, ArrayList<FilterOpenAxisValue>>();
            if (!CollectionUtils.isEmpty(filterOpenAxisList)) {
                filterOpenAxis = filterOpenAxisList.iterator().next();
                List axisMemberList = filterOpenAxis.getAxisMemberList();
                for (FilterOpenAxisValue filterOpenAxisValue : axisMemberList) {
                    String value = filterOpenAxisValue.getValue();
                    ArrayList<FilterOpenAxisValue> filterOpenAxisValueList = (ArrayList<FilterOpenAxisValue>)filterOpenAxisValueMap.get(value);
                    if (filterOpenAxisValueList == null) {
                        filterOpenAxisValueList = new ArrayList<FilterOpenAxisValue>();
                        filterOpenAxisValueList.add(filterOpenAxisValue);
                        filterOpenAxisValueMap.put(value, filterOpenAxisValueList);
                        continue;
                    }
                    filterOpenAxisValueList.add(filterOpenAxisValue);
                }
            }
            if ((member = (String)dimensionsDefault.get(aspectData.getAspect())) != null) {
                String axisValueId;
                AxisMemberHierarchy newOpenAxisMemberHierarchy = new AxisMemberHierarchy();
                newOpenAxisMemberHierarchy.setAxis(original.getAxis());
                newOpenAxisMemberHierarchy.setNodeType(NodeType.ASPECT);
                newOpenAxisMemberHierarchy.setDefinitionNodeId(original.getDefinitionNodeId());
                newOpenAxisMemberHierarchy.setParentDefinitionNodeId(original.getParentDefinitionNodeId());
                AspectData newAspectData = new AspectData();
                newAspectData.setAspect(aspectData.getAspect());
                if (aspectData.getDimensionType() == DimensionType.TYPED_MEMBER) {
                    List valueList;
                    newAspectData.setAspectValue(member);
                    axisValueId = filterOpenAxis != null ? (!CollectionUtils.isEmpty((Collection)(valueList = (List)filterOpenAxisValueMap.get(newAspectData.getAspectValue()))) && valueList.iterator().next() != null ? ((FilterOpenAxisValue)valueList.iterator().next()).getValue() : newAspectData.getAspectValue()) : newAspectData.getAspectValue();
                    axisValueId = DigestUtils.md5Hex((String)axisValueId);
                } else {
                    newAspectData.setAspectValue(member);
                    axisValueId = member;
                }
                String naturalId = original.getDefinitionNodeId() + "#" + newAspectData.getAspect() + "#" + axisValueId;
                if (parentId != null) {
                    naturalId = parentId + "#" + naturalId;
                }
                newOpenAxisMemberHierarchy.setId(naturalId);
                newAspectData.setType(AspectType.DIMENSION);
                newAspectData.setDimensionType(aspectData.getDimensionType());
                newAspectData.setDomain(aspectData.getDomain());
                newOpenAxisMemberHierarchy.getAspectDataList().add(newAspectData);
                filled.add(newOpenAxisMemberHierarchy);
                defaultHierarchyMap.put(parentId, newOpenAxisMemberHierarchy);
            }
        }
        for (AxisMemberHierarchy originalChild : original.getAxisMemberHierarchyList()) {
            axisMemberHierarchyStack.push(originalChild);
            for (AxisMemberHierarchy v : filled) {
                axisMemberValueStack.push(v);
                this.fillDynamicDataForDefaultDimensions(originalChild, filterOpenAxisMap, defaultHierarchyMap, axisMemberHierarchyStack, axisMemberValueStack, v.getId(), structure);
                axisMemberValueStack.pop();
            }
            axisMemberHierarchyStack.pop();
        }
    }

    private void processAspectNodes(AxisMemberHierarchy axis, List<AxisMemberHierarchy> result) {
        if (axis.getNodeType() == NodeType.ASPECT) {
            result.add(axis);
        }
        for (AxisMemberHierarchy axisMemberHierarchy : axis.getAxisMemberHierarchyList()) {
            this.processAspectNodes(axisMemberHierarchy, result);
        }
    }

    private void flattenIdsWithFullKey(String parentKey, AxisMemberHierarchy axis, List<String> ids, Map<String, List<String>> result) {
        ArrayList<String> newList = new ArrayList<String>(ids);
        String currentLevelKey = axis.getNodeType() == NodeType.ASPECT ? axis.getId() : (StringUtils.isNotBlank((CharSequence)parentKey) ? parentKey + "#" + axis.getId() : axis.getId());
        newList.add(currentLevelKey);
        if (result.containsKey(currentLevelKey)) {
            result.get(currentLevelKey).addAll(newList);
        } else {
            result.put(currentLevelKey, newList);
        }
        for (AxisMemberHierarchy child : axis.getAxisMemberHierarchyList()) {
            this.flattenIdsWithFullKey(currentLevelKey, child, newList, result);
        }
    }

    private void flattenAspectsWithFullKey(String parentKey, AxisMemberHierarchy axis, List<AspectData> aspectDataList, Map<String, List<AspectData>> result) {
        String currentLevelKey;
        ArrayList<AspectData> newList = new ArrayList<AspectData>(aspectDataList);
        if (axis.getNodeType() == NodeType.ASPECT) {
            currentLevelKey = axis.getId();
        } else {
            String string = currentLevelKey = StringUtils.isNotBlank((CharSequence)parentKey) ? parentKey + "#" + axis.getId() : axis.getId();
        }
        if (parentKey != null && axis.getAspectDataList() != null) {
            newList.addAll(axis.getAspectDataList());
            if (result.containsKey(currentLevelKey)) {
                result.get(currentLevelKey).addAll(newList);
            } else {
                result.put(currentLevelKey, newList);
            }
        }
        for (AxisMemberHierarchy child : axis.getAxisMemberHierarchyList()) {
            this.flattenAspectsWithFullKey(currentLevelKey, child, newList, result);
        }
    }

    public void fillDates(TableLinkBaseStructure structure, XbrlReportRole role) {
        List reportRolePeriodList = role.getXbrlReport().getXbrlPackage().getXbrlPackagePeriodList();
        List activePeriods = reportRolePeriodList.stream().filter(it -> it.getIsDefaultPeriod() != false && (it.getActive() == null || it.getActive() != false)).collect(Collectors.toList());
        String periodAxis = structure.getPeriodAxis();
        if (StringUtils.isNotBlank((CharSequence)periodAxis)) {
            AxisMemberHierarchy target;
            HashSet<String> periods = new HashSet<String>();
            periods.add("EMPTY_AXIS");
            structure.setPeriods(periods);
            switch (periodAxis) {
                case "x": {
                    target = structure.getXAxis();
                    break;
                }
                case "y": {
                    target = structure.getYAxis();
                    break;
                }
                case "z": {
                    target = structure.getZAxis();
                    break;
                }
                default: {
                    target = structure.getXAxis();
                }
            }
            for (XbrlPeriod xbrlPeriod : activePeriods) {
                AxisMemberHierarchy currentMemberHierarchy = new AxisMemberHierarchy();
                String period = PeriodDates.from((XbrlPeriod)xbrlPeriod).formatDate();
                currentMemberHierarchy.setAxis(periodAxis);
                currentMemberHierarchy.setLabel(period);
                currentMemberHierarchy.setId(period);
                currentMemberHierarchy.getAspectDataList().add(new AspectData("period", AspectType.forValue((String)"period"), period, null));
                target.getAxisMemberHierarchyList().add(currentMemberHierarchy);
            }
        } else {
            int processed = this.processingParamsPeriods(structure);
            if (processed > 0) {
                HashSet<String> periods = new HashSet<String>();
                periods.add("EMPTY_AXIS");
                structure.setPeriods(periods);
            } else {
                structure.setPeriods(activePeriods.stream().map(it -> PeriodDates.from((XbrlPeriod)it).formatDate()).collect(Collectors.toSet()));
            }
        }
    }

    private int processingParamsPeriods(TableLinkBaseStructure structure) {
        return this.processingMemberParamsPeriods(structure.getXAxis()) + this.processingMemberParamsPeriods(structure.getYAxis()) + this.processingMemberParamsPeriods(structure.getZAxis());
    }

    private int processingMemberParamsPeriods(AxisMemberHierarchy axis) {
        boolean axisHaveParamPeriod;
        int processed = 0;
        if (axis.getAspectDataList() != null && (axisHaveParamPeriod = axis.getAspectDataList().stream().anyMatch(it -> it.getAspect().equals("period type")))) {
            ++processed;
        }
        for (AxisMemberHierarchy axisMemberHierarchy : axis.getAxisMemberHierarchyList()) {
            processed += this.processingMemberParamsPeriods(axisMemberHierarchy);
        }
        return processed;
    }

    public void processAllContexts() {
        Date start = new Date();
        log.info("AxisService process contexts started");
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        List allContexts = this.xbrlContextRepository.findAll();
        List roles = xbrlPackage.getXbrlReport().getXbrlReportRoles();
        long[] maxRoleTime = new long[]{0L};
        roles.forEach(reportRole -> {
            Date d = new Date();
            TableLinkBaseStructure structure = reportRole.unpackTableLinkBaseStructure();
            if (structure.containsAspectNodes()) {
                List roleContext = allContexts.stream().filter(c -> structure.getDimensionsSet().containsAll(c.getDimensionsSet())).collect(Collectors.toList());
                try {
                    this.processContexts(reportRole, structure, roleContext, Boolean.TRUE);
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                    throw new RuntimeException(e);
                }
                long duration = new Date().getTime() - d.getTime();
                if (duration > maxRoleTime[0]) {
                    maxRoleTime[0] = duration;
                }
            }
        });
        log.info("AxisService process contexts complete in {} msec, max role duration is {} msec", (Object)(new Date().getTime() - start.getTime()), (Object)maxRoleTime);
    }

    public void processContexts(List<String> xbrlContextIds) {
        Date start = new Date();
        log.info("AxisService process contexts started");
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        List allContexts = this.xbrlContextRepository.findByXbrlContextId_ContextId(xbrlContextIds);
        List roles = xbrlPackage.getXbrlReport().getXbrlReportRoles();
        long[] maxRoleTime = new long[]{0L};
        roles.forEach(reportRole -> {
            Date d = new Date();
            TableLinkBaseStructure structure = reportRole.unpackTableLinkBaseStructure();
            if (structure.containsAspectNodes()) {
                try {
                    this.processContexts(reportRole, structure, allContexts, Boolean.TRUE);
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                    throw new RuntimeException(e);
                }
                long duration = new Date().getTime() - d.getTime();
                if (duration > maxRoleTime[0]) {
                    maxRoleTime[0] = duration;
                }
            }
        });
        log.info("AxisService process contexts complete in {} msec, max role duration is {} msec", (Object)(new Date().getTime() - start.getTime()), (Object)maxRoleTime);
    }

    public void processContexts(XbrlReportRole xbrlReportRole, TableLinkBaseStructure tableLinkBaseStructure, List<XbrlContext> usedContexts, Boolean onlyWithData) throws ExecutionException, InterruptedException {
        List filterOpenAxes = this.xbrlFilterOpenAxisService.findAll();
        Map dimensionsDefault = tableLinkBaseStructure.getDimensionsDefault();
        HashSet xbrlContextDimensions = new HashSet();
        for (XbrlContext xbrlContext : usedContexts) {
            ArrayList<XbrlContextDimension> dimensionList = new ArrayList<XbrlContextDimension>();
            new XbrlContextScenarioParser(xbrlContext.getScenario(), dim -> {
                if (dim != null) {
                    AxisService.addToUniqueSet((Set)xbrlContextDimensions, (XbrlContextDimension)dim);
                    dimensionList.add((XbrlContextDimension)dim);
                }
            });
            for (String dim2 : tableLinkBaseStructure.getDimensionsSet()) {
                if (!dimensionsDefault.containsKey(dim2)) continue;
                XbrlContextDimension defMem = new XbrlContextDimension(dim2, (String)dimensionsDefault.get(dim2));
                AxisService.addToUniqueSet(xbrlContextDimensions, (XbrlContextDimension)defMem);
                if (dimensionList.stream().anyMatch(d -> d.getDimension().equals(dim2))) continue;
                dimensionList.add(defMem);
            }
            xbrlContext.setXbrlContextDimensions(dimensionList);
        }
        Map cacheContextDimensions = AxisService.sortContextDimeByXbrlDim(xbrlContextDimensions, usedContexts);
        HashMap<String, ArrayList<FilterOpenAxis>> filterOpenAxisMap = new HashMap<String, ArrayList<FilterOpenAxis>>();
        for (FilterOpenAxis filterOpenAxis : filterOpenAxes) {
            String systemId = filterOpenAxis.getSystemId();
            ArrayList<FilterOpenAxis> filterOpenAxisList = (ArrayList<FilterOpenAxis>)filterOpenAxisMap.get(systemId);
            if (filterOpenAxisList == null) {
                filterOpenAxisList = new ArrayList<FilterOpenAxis>();
                filterOpenAxisList.add(filterOpenAxis);
                filterOpenAxisMap.put(systemId, filterOpenAxisList);
                continue;
            }
            filterOpenAxisList.add(filterOpenAxis);
        }
        this.fillAspectNodeMembers(tableLinkBaseStructure, xbrlReportRole, filterOpenAxisMap, cacheContextDimensions, usedContexts, onlyWithData);
    }

    public static Map<String, List<XbrlContextDimension>> sortContextDimeByXbrlDim(Set<XbrlContextDimension> xbrlContextDimensions, List<XbrlContext> usedContexts) {
        HashMap<String, List<XbrlContextDimension>> cacheContextDimensions = new HashMap<String, List<XbrlContextDimension>>();
        xbrlContextDimensions.stream().map(xbrlContextDimension -> xbrlContextDimension.getDimension()).distinct().forEach(s -> {
            LinkedHashSet buffer = new LinkedHashSet();
            usedContexts.forEach(xbrlContext -> buffer.addAll(xbrlContext.getXbrlContextDimensions().stream().filter(xbrlContextDimension -> xbrlContextDimension.getDimension().equals(s)).collect(Collectors.toList())));
            cacheContextDimensions.put((String)s, new ArrayList(buffer));
        });
        return cacheContextDimensions;
    }

    public static void addToUniqueSet(Set<XbrlContextDimension> xbrlContextDimensions, XbrlContextDimension dim) {
        if (dim.getDimensionType() == DimensionType.TYPED_MEMBER) {
            Optional<XbrlContextDimension> first = xbrlContextDimensions.stream().filter(it -> it.getDimension().equals(dim.getDimension()) && it.getDomainValue().equals(dim.getDomainValue())).findFirst();
            if (!first.isPresent()) {
                xbrlContextDimensions.add(dim);
            }
        } else {
            Optional<XbrlContextDimension> first = xbrlContextDimensions.stream().filter(it -> it.getDimension().equals(dim.getDimension()) && it.getMember().equals(dim.getMember())).findFirst();
            if (!first.isPresent()) {
                xbrlContextDimensions.add(dim);
            }
        }
    }
}

