/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.internal.xbrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.web.rest.AspectDataWrapper;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlFootnote;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValueId;
import ru.cbr.xbrl.converter.repository.XbrlFootnoteRepository;
import ru.cbr.xbrl.converter.repository.XbrlValueRepository;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlFootnoteCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlValueCrudService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;

@Service
public class XbrlFootnoteCrudServiceImpl
implements XbrlFootnoteCrudService {
    private static final Logger log = LoggerFactory.getLogger(XbrlFootnoteCrudServiceImpl.class);
    @Autowired
    private XbrlFootnoteRepository xbrlFootnoteRepository;
    @Autowired
    private XbrlValueCrudService xbrlValueCrudService;
    @Autowired
    private XbrlValueRepository xbrlValueRepository;
    @Autowired
    @Lazy
    private PresentationDefinitionService presentationDefinitionService;

    public Slice<XbrlFootnote> list(Pageable pageable) {
        return this.xbrlFootnoteRepository.findAll(pageable);
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlFootnote create(XbrlFootnote xbrlFootnote) {
        return (XbrlFootnote)this.xbrlFootnoteRepository.save((Object)xbrlFootnote);
    }

    public List<XbrlFootnote> listByXbrlValue(XbrlValue xbrlValue) {
        if (xbrlValue == null) {
            return Collections.emptyList();
        }
        return this.listByXbrlValueId(xbrlValue.getXbrlValueId());
    }

    public List<XbrlFootnote> list() {
        return this.xbrlFootnoteRepository.findAll();
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlFootnote createNew(String footnoteContent, XbrlPackage xbrlPackage) {
        if (xbrlPackage == null || xbrlPackage.getXbrlReport() == null || StringUtils.isBlank((CharSequence)footnoteContent)) {
            return null;
        }
        List persistFootnoteList = this.xbrlFootnoteRepository.findByContent(footnoteContent = StringUtils.trim((String)footnoteContent));
        if (persistFootnoteList != null && persistFootnoteList.size() > 0) {
            return (XbrlFootnote)persistFootnoteList.iterator().next();
        }
        XbrlFootnote xbrlFootnote = new XbrlFootnote();
        xbrlFootnote.setId("a" + UUID.randomUUID().toString());
        xbrlFootnote.setContent(footnoteContent);
        xbrlFootnote.setXbrlReportId(xbrlPackage.getXbrlReport().getId());
        xbrlFootnote.setLanguage("ru");
        return (XbrlFootnote)this.xbrlFootnoteRepository.save((Object)xbrlFootnote);
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlFootnote edit(XbrlFootnote xbrlFootnote, XbrlPackage xbrlPackage) {
        if (xbrlPackage == null || xbrlPackage.getXbrlReport() == null || xbrlFootnote == null || StringUtils.isBlank((CharSequence)xbrlFootnote.getId())) {
            return null;
        }
        XbrlFootnote persistXbrlFootnote = this.xbrlFootnoteRepository.findById(xbrlFootnote.getId());
        String content = persistXbrlFootnote.getContent();
        List persistFootnoteList = this.xbrlFootnoteRepository.findByContent(content);
        if (CollectionUtils.isEmpty((Collection)persistFootnoteList)) {
            return null;
        }
        for (XbrlFootnote footnote : persistFootnoteList) {
            footnote.setContent(xbrlFootnote.getContent());
            this.xbrlFootnoteRepository.save((Object)footnote);
        }
        return this.xbrlFootnoteRepository.findById(xbrlFootnote.getId());
    }

    @Transactional(value="cacheTransactionManager")
    public void delete(String xbrlFootnoteId, XbrlPackage xbrlPackage) {
        if (xbrlPackage == null || xbrlPackage.getXbrlReport() == null || StringUtils.isBlank((CharSequence)xbrlFootnoteId)) {
            return;
        }
        XbrlFootnote persistXbrlFootnote = this.xbrlFootnoteRepository.findById(xbrlFootnoteId);
        String content = persistXbrlFootnote.getContent();
        List persistFootnoteList = this.xbrlFootnoteRepository.findByContent(content);
        if (CollectionUtils.isEmpty((Collection)persistFootnoteList)) {
            return;
        }
        this.xbrlFootnoteRepository.delete((Iterable)persistFootnoteList);
    }

    @Transactional(value="cacheTransactionManager")
    public void delete(List<String> xbrlFootnoteList, XbrlPackage xbrlPackage) {
        for (String footnoteId : xbrlFootnoteList) {
            this.delete(footnoteId, xbrlPackage);
        }
    }

    @Transactional(value="cacheTransactionManager")
    public void deleteFound(List<XbrlFootnote> xbrlFootnoteList) {
        if (CollectionUtils.isEmpty(xbrlFootnoteList)) {
            return;
        }
        this.xbrlFootnoteRepository.delete(xbrlFootnoteList);
    }

    @Transactional(value="cacheTransactionManager")
    public List<XbrlFootnote> editFootnoteFactLinkList(XbrlValue xbrlValue, List<XbrlFootnote> xbrlFootnoteList) {
        if (xbrlValue == null) {
            return Collections.emptyList();
        }
        List persistFootnoteList = this.listByXbrlValue(xbrlValue);
        ArrayList<String> footnoteContentList = new ArrayList<String>();
        for (XbrlFootnote currentPersistXbrlFootnote : persistFootnoteList) {
            if (currentPersistXbrlFootnote == null || StringUtils.isBlank((CharSequence)currentPersistXbrlFootnote.getContext())) continue;
            footnoteContentList.add(currentPersistXbrlFootnote.getContext());
        }
        for (XbrlFootnote xbrlFootnote : xbrlFootnoteList) {
            String content = StringUtils.trim((String)xbrlFootnote.getContent());
            if (StringUtils.isBlank((CharSequence)content)) continue;
            if (!CollectionUtils.contains(footnoteContentList.iterator(), (Object)content)) {
                XbrlFootnote newXbrlFootnote = new XbrlFootnote();
                newXbrlFootnote.setId("a" + UUID.randomUUID().toString());
                newXbrlFootnote.setContent(content);
                newXbrlFootnote.setLanguage("ru");
                newXbrlFootnote.setXbrlReportId(xbrlValue.getXbrlValueId().getXbrlReportId());
                this.fillFootnoteByXbrlValue(newXbrlFootnote, xbrlValue);
                this.xbrlFootnoteRepository.save((Object)newXbrlFootnote);
                continue;
            }
            footnoteContentList.remove(content);
        }
        for (XbrlFootnote oldXbrlFootnote : persistFootnoteList) {
            List footnoteList;
            String oldXbrlFootnoteContent = oldXbrlFootnote.getContent();
            if (!CollectionUtils.contains(footnoteContentList.iterator(), (Object)oldXbrlFootnoteContent) || CollectionUtils.isEmpty((Collection)(footnoteList = this.xbrlFootnoteRepository.findByContent(oldXbrlFootnoteContent)))) continue;
            if (footnoteList.size() > 1) {
                this.xbrlFootnoteRepository.delete((Object)oldXbrlFootnote);
                continue;
            }
            oldXbrlFootnote.setFootnoteFactId(null);
            oldXbrlFootnote.setElementLabel(null);
            oldXbrlFootnote.setElementName(null);
            oldXbrlFootnote.setElementUri(null);
            oldXbrlFootnote.setContext(null);
            oldXbrlFootnote.setUnit(null);
            oldXbrlFootnote.setValue(null);
            this.xbrlFootnoteRepository.save((Object)oldXbrlFootnote);
        }
        return null;
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlFootnote editFootnoteFactLink(XbrlValue xbrlValue, XbrlFootnote xbrlFootnote, boolean connected) {
        if (xbrlFootnote == null) {
            return null;
        }
        if (connected) {
            int order = 0;
            String footnoteId = xbrlValue.getId();
            if (StringUtils.isBlank((CharSequence)footnoteId)) {
                footnoteId = "a" + UUID.randomUUID().toString();
                xbrlValue.setId(footnoteId);
                this.xbrlValueCrudService.update(xbrlValue);
            }
            List footnoteList = this.listByXbrlValue(xbrlValue);
            for (XbrlFootnote footnote : footnoteList) {
                int currentNumber;
                if (footnote == null) continue;
                if (StringUtils.equals((CharSequence)StringUtils.trim((String)footnote.getContent()), (CharSequence)StringUtils.trim((String)xbrlFootnote.getContent()))) {
                    return null;
                }
                String currentFootnoteNo = footnote.getFootnoteNo();
                if (StringUtils.isBlank((CharSequence)currentFootnoteNo)) {
                    log.error("\u041f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u043d\u043e\u043c\u0435\u0440\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0444\u0430\u043a\u0442\u0430 {}, \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 {}, label {}", new Object[]{footnote.getValue(), footnote.getContext(), footnote.getElementLabel()});
                    continue;
                }
                String[] split = StringUtils.split((String)currentFootnoteNo, (String)".");
                try {
                    currentNumber = Integer.parseInt(split[0]);
                }
                catch (NumberFormatException e) {
                    log.error("\u041f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0447\u0438\u0441\u043b\u043e\u0432\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 {}, \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0444\u0430\u043a\u0442\u0430 {}, \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 {}, label {}", new Object[]{currentFootnoteNo, footnote.getValue(), footnote.getContext(), footnote.getElementLabel()});
                    continue;
                }
                if (currentNumber <= order) continue;
                order = currentNumber;
            }
            XbrlFootnote newXbrlFootnote = new XbrlFootnote();
            newXbrlFootnote.setId("a" + UUID.randomUUID().toString());
            newXbrlFootnote.setFootnoteFactId(footnoteId);
            newXbrlFootnote.setContent(StringUtils.trim((String)xbrlFootnote.getContent()));
            newXbrlFootnote.setLanguage("ru");
            newXbrlFootnote.setXbrlReportId(xbrlValue.getXbrlValueId().getXbrlReportId());
            newXbrlFootnote.setFootnoteNo(order + 1 + ".0");
            this.fillFootnoteByXbrlValue(newXbrlFootnote, xbrlValue);
            this.xbrlFootnoteRepository.save((Object)newXbrlFootnote);
            return null;
        }
        List footnoteList = this.listByXbrlValue(xbrlValue);
        if (CollectionUtils.isEmpty((Collection)footnoteList)) {
            xbrlValue.setId(null);
            this.xbrlValueCrudService.update(xbrlValue);
            return null;
        }
        for (XbrlFootnote footnote : footnoteList) {
            String trimmedContent;
            if (footnote == null || !StringUtils.equals((CharSequence)(trimmedContent = StringUtils.trim((String)footnote.getContent())), (CharSequence)StringUtils.trim((String)xbrlFootnote.getContent()))) continue;
            List footnoteContentList = this.xbrlFootnoteRepository.findByContent(trimmedContent);
            if (footnoteContentList.size() > 1) {
                this.xbrlFootnoteRepository.delete((Object)footnote);
                continue;
            }
            footnote.setFootnoteFactId(null);
            footnote.setElementLabel(null);
            footnote.setElementName(null);
            footnote.setElementUri(null);
            footnote.setContext(null);
            footnote.setUnit(null);
            footnote.setValue(null);
            this.xbrlFootnoteRepository.save((Object)footnote);
        }
        List checkFootnoteList = this.listByXbrlValue(xbrlValue);
        if (CollectionUtils.isEmpty((Collection)checkFootnoteList)) {
            xbrlValue.setId(null);
            this.xbrlValueCrudService.update(xbrlValue);
        }
        return null;
    }

    public void fillFootnoteByXbrlValue(XbrlFootnote xbrlFootnote, XbrlValue xbrlValue) {
        if (xbrlFootnote == null || xbrlValue == null) {
            return;
        }
        xbrlFootnote.setElementName(xbrlValue.getElementName());
        xbrlFootnote.setElementUri(xbrlValue.getElementUri());
        xbrlFootnote.setContext(xbrlValue.getXbrlValueId().getXbrlContextId());
        xbrlFootnote.setValue(xbrlValue.getValue());
        xbrlFootnote.setUnit(xbrlValue.getXbrlUnit());
        xbrlFootnote.setElementLabel(xbrlValue.getXbrlValueId().getElementLabel());
    }

    public Boolean isFootnoteContentExists(String content) {
        return this.xbrlFootnoteRepository.existsByContent(content);
    }

    public boolean isFootnoteFactLinkExists(String content, String footnoteFactId) {
        return this.xbrlFootnoteRepository.existsByContentAndFootnoteFactId(content, footnoteFactId);
    }

    public List<AspectDataWrapper> getAspectData(String footnoteContent) {
        List footnoteList = this.xbrlFootnoteRepository.findByContent(footnoteContent);
        ArrayList xbrlValueDTOList = new ArrayList();
        footnoteList.stream().filter(xbrlFootnote -> xbrlFootnote.getContext() != null && xbrlFootnote.getElementLabel() != null && xbrlFootnote.getElementName() != null).forEach(xbrlFootnote -> xbrlValueDTOList.addAll(this.xbrlValueRepository.findAll(xbrlFootnote.getContext(), xbrlFootnote.getElementLabel(), xbrlFootnote.getElementName())));
        return this.xbrlValueCrudService.getAspectDataByXbrlValueDTO(xbrlValueDTOList);
    }

    public void moveFootnotes(XbrlValue xbrlValue, XbrlValueId bckpXbrlValueId) {
        if (xbrlValue == null || xbrlValue.getXbrlValueId() == null || bckpXbrlValueId == null) {
            return;
        }
        List footnoteList = this.listByXbrlValueId(bckpXbrlValueId);
        if (CollectionUtils.isEmpty((Collection)footnoteList)) {
            return;
        }
        XbrlValueId xbrlValueId = xbrlValue.getXbrlValueId();
        footnoteList.forEach(xbrlFootnote -> {
            if (xbrlFootnote == null) {
                return;
            }
            xbrlFootnote.setContext(xbrlValueId.getXbrlContextId());
            xbrlFootnote.setElementLabel(xbrlValueId.getElementLabel());
            xbrlFootnote.setXbrlReportId(xbrlValueId.getXbrlReportId());
            this.xbrlFootnoteRepository.save(xbrlFootnote);
            this.xbrlFootnoteRepository.flush();
        });
    }

    private List<XbrlFootnote> listByXbrlValueId(XbrlValueId xbrlValueId) {
        if (xbrlValueId == null) {
            return Collections.emptyList();
        }
        return this.xbrlFootnoteRepository.findAllByElementLabelAndXbrlReportIdAndContext(xbrlValueId.getElementLabel(), xbrlValueId.getXbrlReportId(), xbrlValueId.getXbrlContextId());
    }
}

