/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.internal;

import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.repository.XbrlPackageRepository;
import ru.cbr.xbrl.converter.service.internal.XbrlPackageCrudService;

@Service
public class XbrlPackageCrudServiceImpl
implements XbrlPackageCrudService {
    private static final Logger log = LoggerFactory.getLogger(XbrlPackageCrudServiceImpl.class);
    @Autowired
    private XbrlPackageRepository xbrlPackageRepository;

    public List<XbrlPackage> list() {
        return this.xbrlPackageRepository.findAll();
    }

    public XbrlPackage find(Long id) throws NotFoundException {
        XbrlPackage xbrlPackage = (XbrlPackage)this.xbrlPackageRepository.findOne((Serializable)id);
        if (xbrlPackage == null) {
            log.error("Package not found with id " + id);
            throw new NotFoundException();
        }
        return xbrlPackage;
    }

    public XbrlPackage create(XbrlPackage xbrlPackage) {
        return (XbrlPackage)this.xbrlPackageRepository.save((Object)xbrlPackage);
    }

    public XbrlPackage update(XbrlPackage xbrlPackage) throws NotFoundException {
        return (XbrlPackage)this.xbrlPackageRepository.save((Object)xbrlPackage);
    }

    public void delete(Long id) throws NotFoundException {
        XbrlPackage existingXbrlPackage = this.find(id);
        this.xbrlPackageRepository.delete((Object)existingXbrlPackage);
    }

    public XbrlPackage findLastXbrlPackage() {
        XbrlPackage xbrlPackage = this.xbrlPackageRepository.findFirstByOrderByUploadTimeDesc();
        if (xbrlPackage != null) {
            xbrlPackage.initAllLazy();
        }
        return xbrlPackage;
    }

    public void deleteAll() {
        this.xbrlPackageRepository.deleteAll();
    }
}

