/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.validation.Dimension;
import ru.cbr.xbrl.converter.repository.FilterOpenAxisMemberRepository;
import ru.cbr.xbrl.converter.repository.FilterOpenAxisValueRepository;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisMemberService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisService;

@Service
public class XbrlFilterOpenAxisMemberServiceImpl
implements XbrlFilterOpenAxisMemberService {
    private final FilterOpenAxisMemberRepository filterOpenAxisMemberRepository;
    private final FilterOpenAxisValueRepository filterOpenAxisValueRepository;
    private final XbrlFilterOpenAxisService xbrlFilterOpenAxisService;
    private final NamedParameterJdbcTemplate jdbcTemplate;

    @Autowired
    public XbrlFilterOpenAxisMemberServiceImpl(FilterOpenAxisMemberRepository fIlterOpenAxisMemberRepository, FilterOpenAxisValueRepository filterOpenAxisValueRepository, XbrlFilterOpenAxisService xbrlFilterOpenAxisService, NamedParameterJdbcTemplate jdbcTemplate) {
        this.filterOpenAxisMemberRepository = fIlterOpenAxisMemberRepository;
        this.filterOpenAxisValueRepository = filterOpenAxisValueRepository;
        this.xbrlFilterOpenAxisService = xbrlFilterOpenAxisService;
        this.jdbcTemplate = jdbcTemplate;
    }

    public FilterOpenAxisValue update(FilterOpenAxisValue filterOpenAxisValue) {
        return (FilterOpenAxisValue)this.filterOpenAxisMemberRepository.save((Object)filterOpenAxisValue);
    }

    public FilterOpenAxisValue find(Long id) {
        return (FilterOpenAxisValue)this.filterOpenAxisMemberRepository.findOne((Serializable)id);
    }

    public List<FilterOpenAxisValue> findAll() {
        return this.filterOpenAxisMemberRepository.findAll();
    }

    public FilterOpenAxisValue findByFilterOpenAxisAndMember(FilterOpenAxis filterOpenAxis, FilterOpenAxisValue filterOpenAxisValue) {
        if (filterOpenAxisValue == null) {
            return null;
        }
        return this.filterOpenAxisMemberRepository.findOneByFilterOpenAxisAndValue(filterOpenAxis, filterOpenAxisValue.getValue());
    }

    public void delete(Long memberId) {
        this.filterOpenAxisMemberRepository.delete((Serializable)memberId);
    }

    public FilterOpenAxisValue updateValues(Long memberId, FilterOpenAxisValue filterOpenAxisValue) {
        if (memberId == null || filterOpenAxisValue == null) {
            return null;
        }
        FilterOpenAxisValue filterOpenAxisValuePersist = this.find(memberId);
        filterOpenAxisValuePersist.setValue(filterOpenAxisValue.getValue());
        return filterOpenAxisValuePersist;
    }

    public List<FilterOpenAxisValue> getFilterOpenAxisValuesByFilterOpenAxisAndValue(FilterOpenAxis filterOpenAxis, String value) {
        return this.filterOpenAxisValueRepository.findByFilterOpenAxisAndValue(filterOpenAxis, value);
    }

    public Optional<FilterOpenAxisValue> findFilterOpenAxisValueByDimensionAndValue(Dimension dimension) {
        List filterOpenAxisList = this.xbrlFilterOpenAxisService.findFilterOpenAxisBySystemId(dimension.getDimension());
        if (filterOpenAxisList.isEmpty()) {
            return Optional.empty();
        }
        FilterOpenAxis filterOpenAxis = (FilterOpenAxis)filterOpenAxisList.get(0);
        return this.getFirstFilterOpenAxisValue(filterOpenAxis, dimension.getMember());
    }

    @Transactional(value="cacheTransactionManager")
    public Optional<FilterOpenAxisValue> getFirstFilterOpenAxisValue(FilterOpenAxis filterOpenAxis, String value) {
        Long firstValueId = this.getFilterOpenAxisValueId(filterOpenAxis, value);
        if (firstValueId == null) {
            return Optional.empty();
        }
        return Optional.of(this.find(firstValueId));
    }

    @Transactional(value="cacheTransactionManager")
    public Long getFilterOpenAxisValueId(FilterOpenAxis filterOpenAxis, String value) {
        if (filterOpenAxis == null || filterOpenAxis.getId() == null) {
            return null;
        }
        return this.getFilterOpenAxisValueId(filterOpenAxis.getId(), value);
    }

    private Long getFilterOpenAxisValueId(Long id, String value) {
        HashMap<String, Object> parametersMap = new HashMap<String, Object>();
        parametersMap.put("axisValue", value);
        parametersMap.put("filterOpenAxisId", id);
        List idList = this.jdbcTemplate.query("select v.id from FilterOpenAxisValue v where v.value = :axisValue and v.filterOpenAxis_id = :filterOpenAxisId", parametersMap, (rs, rowNum) -> rs.getLong("id"));
        if (CollectionUtils.isEmpty((Collection)idList)) {
            return null;
        }
        return (Long)idList.iterator().next();
    }
}

