/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.import_export;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.model.interaction.AuditUnitStatus;
import ru.cbr.xbrl.converter.model.interaction.ImportProcess;
import ru.cbr.xbrl.converter.model.interaction.ImportProcessInfo;
import ru.cbr.xbrl.converter.repository.ImportProcessInfoRepository;
import ru.cbr.xbrl.converter.service.import_export.ImportProcessInfoService;

@Service
public class ImportProcessInfoServiceImpl
implements ImportProcessInfoService {
    private final ImportProcessInfoRepository processInfoRepository;

    @Transactional(value="cacheTransactionManager")
    public ImportProcessInfo saveWithProcess(AuditUnitStatus auditStatus, String messageShort, String messageFull, ImportProcess process) {
        ImportProcessInfo processInfo = new ImportProcessInfo();
        processInfo.setEventDateTime(LocalDateTime.now());
        processInfo.setStatus(auditStatus);
        processInfo.setMessage(messageFull);
        processInfo.setShortMessage(messageShort);
        processInfo.setProcess(process);
        processInfo.setId(this.lastId());
        return (ImportProcessInfo)this.processInfoRepository.save((Object)processInfo);
    }

    public Long lastId() {
        List importProcessInfos = this.processInfoRepository.findAll();
        if (CollectionUtils.isEmpty((Collection)importProcessInfos)) {
            return 0L;
        }
        Long id = importProcessInfos.stream().map(ImportProcessInfo::getId).mapToLong(Long::longValue).max().orElse(0L);
        id = id + 1L;
        return id;
    }

    @Transactional(value="cacheTransactionManager")
    public ImportProcessInfo addMappingProcessSuccess(String messageShort, String messageFull, ImportProcess importProcess) {
        return this.saveWithProcess(AuditUnitStatus.SUCCESS, messageShort, messageFull, importProcess);
    }

    @Transactional(value="cacheTransactionManager")
    public ImportProcessInfo addMappingProcessWarn(String messageShort, String messageFull, ImportProcess importProcess) {
        return this.saveWithProcess(AuditUnitStatus.WARNING, messageShort, messageFull, importProcess);
    }

    @Transactional(value="cacheTransactionManager")
    public ImportProcessInfo addMappingProcessException(String messageShort, String messageFull, ImportProcess importProcess) {
        return this.saveWithProcess(AuditUnitStatus.EXCEPTION, messageShort, messageFull, importProcess);
    }

    @Transactional(value="cacheTransactionManager")
    public ImportProcessInfo addMappingProcessFinished(String messageShort, String messageFull, ImportProcess importProcess) {
        return this.saveWithProcess(AuditUnitStatus.FINISHED, messageShort, messageFull, importProcess);
    }

    @Transactional(value="cacheTransactionManager")
    public ImportProcessInfo addMappingProcessInfo(String messageShort, String messageFull, ImportProcess importProcess) {
        return this.saveWithProcess(AuditUnitStatus.INFO, messageShort, messageFull, importProcess);
    }

    @Transactional(value="cacheTransactionManager")
    public ImportProcessInfo addMappingProcessFail(String messageShort, String messageFull, ImportProcess importProcess) {
        return this.saveWithProcess(AuditUnitStatus.FAIL, messageShort, messageFull, importProcess);
    }

    @Transactional(value="cacheTransactionManager")
    public void delete() {
        this.processInfoRepository.delete((Iterable)this.processInfoRepository.findAll());
    }

    @ConstructorProperties(value={"processInfoRepository"})
    public ImportProcessInfoServiceImpl(ImportProcessInfoRepository processInfoRepository) {
        this.processInfoRepository = processInfoRepository;
    }
}

