/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.import_export;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.controller.import_export.ExportXlsxStruct;
import ru.cbr.xbrl.converter.exception.ActionCancelledException;
import ru.cbr.xbrl.converter.exception.FileAlreadyExistsException;
import ru.cbr.xbrl.converter.exception.NamespaceNotFoundException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.RewritableFileOpenException;
import ru.cbr.xbrl.converter.exception.WriteFileException;
import ru.cbr.xbrl.converter.exception.XbrlExportException;
import ru.cbr.xbrl.converter.model.UnitsConfiguration;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.service.CellEditableCheckerService;
import ru.cbr.xbrl.converter.service.EnumerationsService;
import ru.cbr.xbrl.converter.service.NamespacesService;
import ru.cbr.xbrl.converter.service.TableLinkBaseDataService;
import ru.cbr.xbrl.converter.service.UnitService;
import ru.cbr.xbrl.converter.service.UnitsConfigurationService;
import ru.cbr.xbrl.converter.service.UpdateService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.event.NotificationEventService;
import ru.cbr.xbrl.converter.service.event.NotificationEventServiceImpl;
import ru.cbr.xbrl.converter.service.import_export.ExportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.XlsAspectColumnService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlContextCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlFootnoteCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlUnitCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlValueCrudService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionRole;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.utils.FileUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.XbrlWriter;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.CsvFileSet;
import ru.cbr.xbrl.converter.xbrl.import_export.csv.XbrlCsvWriter;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XlsxWriterConfiguration;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.XslxWriter;
import ru.cbr.xbrl.converter.xbrl.import_export.xls.presentation_definition.XslxPresentationDefinitionWriter;
import ru.cbr.xbrl.converter.xbrl.import_export.xml.XbrlXmlWriter;

@Service
public class ExportXbrlServiceImpl
implements ExportXbrlService {
    private static final Logger log = LoggerFactory.getLogger(ExportXbrlServiceImpl.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private XbrlContextCrudService xbrlContextCrudService;
    @Autowired
    private XbrlUnitCrudService xbrlUnitCrudService;
    @Autowired
    private XbrlValueCrudService xbrlValueCrudService;
    @Autowired
    private XbrlFootnoteCrudService xbrlFootnoteCrudService;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private TableLinkBaseDataService tableLinkBaseDataService;
    @Autowired
    private PresentationDefinitionService presentationDefinitionService;
    @Autowired
    private NotificationEventService notificationEventService;
    @Autowired
    private UnitsConfigurationService unitsConfigurationService;
    @Autowired
    private UpdateService updateService;
    @Autowired
    private EnumerationsService enumerationsService;
    @Autowired
    private CellEditableCheckerService cellEditableCheckerService;
    @Autowired
    private XlsAspectColumnService xlsAspectColumnService;
    @Autowired
    private NamespacesService namespaceService;
    @Autowired
    private UnitService unitService;
    final int PAGE_SIZE = 50000;
    private boolean isLastActionCanceled = false;

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public void exportXbrlXml(XbrlPackage xbrlPackage, OutputStream outputStream, Boolean isIncludeDataToTemplate) throws XbrlExportException, NotFoundException {
        Date start = new Date();
        log.info("Export to XBRL XML started...");
        try {
            String pathToXsd = null;
            if (xbrlPackage.getPathToXsd() != null) {
                pathToXsd = xbrlPackage.getPathToXsd().replace("../", "http://");
            }
            ArrayList<ConfigProperties.Namespace> namespaceList = new ArrayList<ConfigProperties.Namespace>(this.configProperties.getXbrl().getNamespace());
            List usedNamespaceList = this.namespaceService.getUsedNamespaceList();
            usedNamespaceList.addAll(this.namespaceService.getNamespacesListFromDefaultPrefixes(this.enumerationsService.getMemberPrefixSet()));
            for (NamespacesService.XbrlXmlNamespace xbrlXmlNamespace : usedNamespaceList) {
                namespaceList.add(new ConfigProperties.Namespace(xbrlXmlNamespace.getPrefix(), xbrlXmlNamespace.getValue(), true));
            }
            XbrlXmlWriter xbrlXmlWriter = new XbrlXmlWriter(outputStream, namespaceList, pathToXsd);
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, new NotificationEvent("\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043a \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0443 \u0434\u0430\u043d\u043d\u044b\u0445"));
            xbrlXmlWriter.prepare(this.getCurrentVersion());
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, new NotificationEvent("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u043e\u0432"));
            this.writeContexts((XbrlWriter)xbrlXmlWriter);
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, new NotificationEvent("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0435\u0434\u0438\u043d\u0438\u0446 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f"));
            this.writeUnits((XbrlWriter)xbrlXmlWriter);
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, new NotificationEvent("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439"));
            this.writeValues((XbrlWriter)xbrlXmlWriter);
            this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, new NotificationEvent("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432"));
            this.writeFootnotes((XbrlWriter)xbrlXmlWriter);
            xbrlXmlWriter.finalize();
            log.info("Export to XBRL XML completed in " + (new Date().getTime() - start.getTime()) + " msec");
        }
        catch (UnsupportedEncodingException | XMLStreamException | NamespaceNotFoundException e) {
            log.error("Export to XBRL XML failed: " + e.getMessage());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public void exportXbrlXml(XbrlPackage xbrlPackage, String localPath, Boolean isIncludeDataToTemplate, Boolean allowOverwriteFile) throws XbrlExportException, FileAlreadyExistsException, WriteFileException {
        FileUtils.checkFileWritable((String)localPath, (Boolean)allowOverwriteFile);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(localPath));){
            this.exportXbrlXml(xbrlPackage, (OutputStream)outputStream, isIncludeDataToTemplate);
        }
        catch (FileNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
        catch (NotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public void exportXbrlXml(Long xbrlReportId, String localPath, Boolean isIncludeDataToTemplate, Boolean allowOverwriteFile) throws XbrlExportException, NotFoundException, FileAlreadyExistsException, WriteFileException {
        XbrlReport xbrlReport = this.xbrlReportService.find(xbrlReportId);
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        this.exportXbrlXml(xbrlPackage, localPath, isIncludeDataToTemplate, allowOverwriteFile);
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public void exportCsv(Long xbrlReportId, CsvFileSet csvFileSet, Boolean isIncludeDataToTemplate, Boolean allowOverwriteFile) throws XbrlExportException, FileAlreadyExistsException, WriteFileException {
        Date start = new Date();
        log.info("Export to XBRL CSV started...");
        XbrlCsvWriter xbrlXmlWriter = new XbrlCsvWriter(csvFileSet, allowOverwriteFile);
        log.info("exportCsv " + csvFileSet);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, new NotificationEvent("\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043a \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0443 \u0434\u0430\u043d\u043d\u044b\u0445"));
        xbrlXmlWriter.prepare(this.getCurrentVersion());
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, new NotificationEvent("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u043e\u0432"));
        this.writeContexts((XbrlWriter)xbrlXmlWriter);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, new NotificationEvent("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0435\u0434\u0438\u043d\u0438\u0446 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f"));
        this.writeUnits((XbrlWriter)xbrlXmlWriter);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, new NotificationEvent("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439"));
        this.writeValues((XbrlWriter)xbrlXmlWriter);
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, new NotificationEvent("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432"));
        this.writeFootnotes((XbrlWriter)xbrlXmlWriter);
        xbrlXmlWriter.finalize();
        log.info("Export to XBRL CSV completed in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public void buildEmptyXbrlXml(OutputStream outputStream, String pathToXsd) throws XbrlExportException {
        try {
            XbrlXmlWriter xbrlXmlWriter = new XbrlXmlWriter(outputStream, this.configProperties.getXbrl().getNamespace(), pathToXsd);
            xbrlXmlWriter.prepare(this.getCurrentVersion());
            xbrlXmlWriter.finalize();
        }
        catch (UnsupportedEncodingException | XMLStreamException | NamespaceNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public String buildEmptyXbrlXmlInTempFile(String fileName, String pathToXsd) throws XbrlExportException {
        String tempDir = org.apache.commons.io.FileUtils.getTempDirectoryPath();
        String fullPath = FilenameUtils.concat((String)tempDir, (String)fileName);
        pathToXsd = pathToXsd.replace("../", "http://");
        File temp = new File(fullPath);
        temp.deleteOnExit();
        try {
            this.buildEmptyXbrlXml((OutputStream)new FileOutputStream(temp), pathToXsd);
        }
        catch (FileNotFoundException e) {
            throw new XbrlExportException();
        }
        catch (XbrlExportException e) {
            throw new XbrlExportException();
        }
        return temp.getAbsolutePath();
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public String buildEmptyXbrlXml(String fullPath, String pathToXsd) throws XbrlExportException {
        pathToXsd = pathToXsd.replace("../", "http://");
        File file = new File(fullPath);
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                this.buildEmptyXbrlXml((OutputStream)outputStream, pathToXsd);
            }
        }
        catch (FileNotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
        catch (XbrlExportException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new XbrlExportException();
        }
        return file.getAbsolutePath();
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public List<String> exportXslx(ExportXlsxStruct exportXlsxStruct) throws IOException, NotFoundException, FileAlreadyExistsException, WriteFileException, RewritableFileOpenException {
        Date start = new Date();
        log.info("Export to XBRL XLSX started...");
        XbrlReport xbrlReport = this.xbrlReportService.find(exportXlsxStruct.getXbrlReportId());
        xbrlReport.getXbrlReportRoles().sort(Comparator.comparing(XbrlReportRole::getCompareString));
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        xbrlPackage.getXbrlReport().setXbrlReportRoles(xbrlPackage.getXbrlReport().getXbrlReportRoles().stream().filter(xbrlReportRole -> exportXlsxStruct.getReportRoleIds().contains(xbrlReportRole.getId())).collect(Collectors.toList()));
        String fullPath = FilenameUtils.concat((String)exportXlsxStruct.getXlsxPath(), (String)(xbrlPackage.getName() + ".xlsx"));
        if (!exportXlsxStruct.isMultipleFiles()) {
            FileUtils.checkFileWritable((String)fullPath, (Boolean)exportXlsxStruct.getAllowOverwriteFile());
        }
        UnitsConfiguration unitsConfiguration = this.unitsConfigurationService.findByXbrlReport(xbrlReport);
        String currency = unitsConfiguration.getCurrency();
        XslxWriter xslxWriter = new XslxWriter(new XlsxWriterConfiguration(xbrlPackage, fullPath, currency, this.tableLinkBaseDataService.getTableLinkBaseUIFromFunction(), notificationEvent -> this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, notificationEvent), this.configProperties.getXlsxWriteAspectData(), this.configProperties.getXlsxWriteAxisId(), exportXlsxStruct.isMultipleFiles(), exportXlsxStruct.getXlsxPath(), arg_0 -> ((CellEditableCheckerService)this.cellEditableCheckerService).isEditable(arg_0), exportXlsxStruct.getIsAlternativeFormat() == false, exportXlsxStruct.getIsExportWithDataOnly().booleanValue()), this.xlsAspectColumnService);
        log.info("Export to XBRL XLSX completed in " + (new Date().getTime() - start.getTime()) + " msec");
        return xslxWriter.draw();
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public void exportPresentationDefinitionXlsx(ExportXlsxStruct exportXlsxStruct) throws IOException, NotFoundException, FileAlreadyExistsException, WriteFileException, RewritableFileOpenException {
        Date start = new Date();
        log.info("Export to XBRL XLSX started...");
        XbrlReport xbrlReport = this.xbrlReportService.find(exportXlsxStruct.getXbrlReportId());
        UnitsConfiguration unitsConfiguration = this.unitsConfigurationService.findByXbrlReport(xbrlReport);
        String currency = unitsConfiguration.getCurrency();
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        String xlsxFileName = xbrlPackage.getName() + ".presentation-definition.xlsx";
        String fullPath = FilenameUtils.concat((String)exportXlsxStruct.getXlsxPath(), (String)xlsxFileName);
        FileUtils.checkFileWritable((String)fullPath, (Boolean)exportXlsxStruct.getAllowOverwriteFile());
        List roles = exportXlsxStruct.getPresentationRoleCodes() != null ? this.presentationDefinitionService.getPresentationDefinitionData().getRoles().stream().filter(role -> exportXlsxStruct.getPresentationRoleCodes().contains(role.getCode())).collect(Collectors.toList()) : this.presentationDefinitionService.getPresentationDefinitionData().getRoles();
        ArrayList<PresentationDefinitionRole> newRoles = new ArrayList<PresentationDefinitionRole>();
        for (PresentationDefinitionRole role2 : roles) {
            newRoles.add(this.presentationDefinitionService.getPresentationDefinitionRole(role2.getCode()));
        }
        Map enumerations = this.enumerationsService.getEnumerations();
        new XslxPresentationDefinitionWriter(xbrlPackage, fullPath, currency, exportXlsxStruct.isMultipleFiles(), exportXlsxStruct.getXlsxPath(), this.presentationDefinitionService.getRoleListItemsFunction(), newRoles, notificationEvent -> this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.EXPORT, notificationEvent), enumerations, arg_0 -> ((CellEditableCheckerService)this.cellEditableCheckerService).isEditable(arg_0), exportXlsxStruct.getIsExportWithDataOnly().booleanValue());
        log.info("Export to XBRL XLSX completed in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    private void writeContexts(XbrlWriter xbrlWriter) throws XbrlExportException {
        Set ctxIds = this.xbrlValueCrudService.list().stream().map(xbrlValue -> xbrlValue.getXbrlValueId().getXbrlContextId()).collect(Collectors.toSet());
        new /* Unavailable Anonymous Inner Class!! */;
    }

    private void writeUnits(XbrlWriter xbrlWriter) throws XbrlExportException {
        this.unitService.clearUnusedXbrlUnits();
        new /* Unavailable Anonymous Inner Class!! */;
    }

    private void writeValues(XbrlWriter xbrlWriter) throws XbrlExportException {
        new /* Unavailable Anonymous Inner Class!! */;
    }

    private void writeFootnotes(XbrlWriter xbrlWriter) throws XbrlExportException {
        AtomicBoolean footnoteWritten = new AtomicBoolean(false);
        new /* Unavailable Anonymous Inner Class!! */;
        if (footnoteWritten.get()) {
            xbrlWriter.writeFootnoteEndTag();
        }
    }

    private void cancelImport() {
        log.info("Import xlsx cancelled by user");
        this.isLastActionCanceled = false;
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CANCEL, new NotificationEvent());
        throw new ActionCancelledException();
    }

    private Supplier<String> getCurrentVersion() {
        return () -> this.updateService.getCurrentVersion();
    }
}

