/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.import_export;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.arelle.parse.HypercubeService;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.NamespaceNotFoundException;
import ru.cbr.xbrl.converter.model.UnitsConfiguration;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.pkg.ContextPeriod;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextId;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlFootnote;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValueId;
import ru.cbr.xbrl.converter.model.xbrl_content.presentation_definition.XbrlValueRole;
import ru.cbr.xbrl.converter.repository.XbrlContextRepository;
import ru.cbr.xbrl.converter.repository.XbrlUnitRepository;
import ru.cbr.xbrl.converter.repository.XbrlValueRoleRepository;
import ru.cbr.xbrl.converter.service.CellEditableCheckerService;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.NamespacesService;
import ru.cbr.xbrl.converter.service.UnitService;
import ru.cbr.xbrl.converter.service.UnitsConfigurationService;
import ru.cbr.xbrl.converter.service.XbrlDimensionService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlPeriodService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.import_export.ContextCacheKey;
import ru.cbr.xbrl.converter.service.import_export.EditXbrlService;
import ru.cbr.xbrl.converter.service.import_export.EditXbrlServiceImpl;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlContextCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlFootnoteCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlValueCrudService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.service.tablelinkbase.AxisService;
import ru.cbr.xbrl.converter.utils.AspectUtils;
import ru.cbr.xbrl.converter.utils.LruCache;
import ru.cbr.xbrl.converter.utils.Profiler;
import ru.cbr.xbrl.converter.utils.TextUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;

@Service
public class EditXbrlServiceImpl
implements EditXbrlService {
    private static final Logger log = LoggerFactory.getLogger(EditXbrlServiceImpl.class);
    public static final String DEFAULT_SCHEME = "http://www.cbr.ru";
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private XbrlContextCrudService xbrlContextCrudService;
    @Autowired
    private XbrlValueCrudService xbrlValueCrudService;
    @Autowired
    private XbrlContextRepository xbrlContextRepository;
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private GaugeService gaugeService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private UnitService unitService;
    @Autowired
    private UnitsConfigurationService unitsConfigurationService;
    @Autowired
    private PresentationDefinitionService presentationDefinitionService;
    @Autowired
    private XbrlPeriodService xbrlPeriodService;
    @Autowired
    private XbrlFootnoteCrudService xbrlFootnoteCrudService;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private XbrlValueRoleRepository xbrlValueRoleRepository;
    @Autowired
    private XbrlUnitRepository xbrlUnitRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private AxisService axisService;
    @Autowired
    private CellEditableCheckerService cellEditableCheckerService;
    @Autowired
    private XbrlDimensionService xbrlDimensionService;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;
    @Autowired
    private HypercubeService hypercubeService;
    @Autowired
    private NamespacesService namespaceService;
    private Set<ContextCacheKey> existenceContextKeyInstantSet = new HashSet();
    private Set<ContextCacheKey> existenceContextKeyDurationSet = new HashSet();

    public Map<String, String> getDimensionsDefault() {
        Date start = new Date();
        ObjectMapper objectMapper = new ObjectMapper();
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        XbrlReport xbrlReport = xbrlPackage.getXbrlReport();
        if (xbrlReport.getXbrlReportRoles().isEmpty()) {
            return new HashMap<String, String>();
        }
        XbrlReportRole xbrlReportRole = (XbrlReportRole)xbrlReport.getXbrlReportRoles().get(0);
        try {
            String roleJson = xbrlReportRole.getStaticStructureJson();
            TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)objectMapper.readValue((Reader)new StringReader(roleJson), TableLinkBaseStructure.class);
            log.trace("Extracted default dimensions in " + (new Date().getTime() - start.getTime()) + " msec");
            Map dimensionsDefault = tableLinkBaseStructure.getDimensionsDefault();
            return dimensionsDefault;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Transactional(value="cacheTransactionManager")
    public void saveCells(XbrlPackage xbrlPackage, List<AspectCellData> aspectCells, boolean footnoteView) throws NamespaceNotFoundException {
        this.saveCells(xbrlPackage, aspectCells, new LruCache(5000), null, footnoteView, Boolean.TRUE);
    }

    @Transactional(value="cacheTransactionManager")
    public void saveCells(XbrlPackage xbrlPackage, List<AspectCellData> aspectCells, LruCache<ContextCacheKey, String> contexIdLruCache, Map<String, String> cachedDimensionsDefault, boolean footnoteView, Boolean isOverwriteData) throws NamespaceNotFoundException {
        log.info("Save cells started...");
        Date start = new Date();
        XbrlReport xbrlReport = xbrlPackage.getXbrlReport();
        String scheme = DEFAULT_SCHEME;
        log.trace("Scheme: " + scheme);
        String identifier = xbrlPackage.getOgrn();
        int counter = 0;
        ArrayList<String> xbrlContextIs = new ArrayList<String>();
        ArrayList<ConfigProperties.Namespace> namespaceList = new ArrayList<ConfigProperties.Namespace>();
        List namespaces = this.namespaceService.getNamespaces();
        if (!CollectionUtils.isEmpty((Collection)namespaces)) {
            for (NamespacesService.XbrlXmlNamespace xbrlXmlNamespace : namespaces) {
                namespaceList.add(new ConfigProperties.Namespace(xbrlXmlNamespace.getPrefix(), xbrlXmlNamespace.getValue(), true));
            }
        }
        HashSet<String> usedNamespaceUriSet = new HashSet<String>();
        for (AspectCellData aspectCellData : aspectCells) {
            boolean isEditable;
            this.setupDimensionType(aspectCellData);
            boolean bl = isEditable = !this.cellEditableCheckerService.checkNotEditable(aspectCellData);
            if (!isEditable) {
                log.info("Skip not editable cell: {}", (Object)aspectCellData.toShortString());
                continue;
            }
            AspectData tag = aspectCellData.getTagLabel();
            AspectData concept = null;
            if (tag != null) {
                aspectCellData.getAspectDataList().remove(tag);
                concept = aspectCellData.getConceptByTag(tag.getTagSelector());
            } else {
                concept = aspectCellData.getConcept();
            }
            if (aspectCellData.validate()) {
                aspectCellData.prepare();
            }
            String cellValue = aspectCellData.getCellValue();
            Long roleId = aspectCellData.getRoleId();
            if (cachedDimensionsDefault == null) {
                cachedDimensionsDefault = this.getDimensionsDefault();
            }
            Map dimensionsDefault = cachedDimensionsDefault;
            List aspectDataList = aspectCellData.getAspectDataList();
            log.trace("-----------------------------------------------------------------------");
            log.trace("\n** Aspect data");
            aspectDataList.stream().forEach(a -> log.trace(String.format("Type %s, Aspect %s, AspectValue %s, ConceptPeriodType %s", a.getType(), a.getAspect(), a.getAspectValue(), a.getConceptPeriodType())));
            log.trace("-----------------------------------------------------------------------");
            String xbrlContextId = this.findOrCreateContext2(xbrlReport, scheme, identifier, aspectCellData, dimensionsDefault, contexIdLruCache);
            xbrlContextIs.add(xbrlContextId);
            log.trace("Found conceptAspect: " + concept);
            String elementLabel = concept.getAspectValue();
            XbrlValue xbrlValue = this.findOrCreateValue(xbrlReport, roleId, concept, cellValue, xbrlContextId, elementLabel, aspectCellData, footnoteView, dimensionsDefault, isOverwriteData, namespaceList, null);
            if (isOverwriteData.booleanValue()) {
                this.saveFootnote(xbrlValue, aspectCellData.getFootnoteId());
            }
            if (xbrlValue != null) {
                usedNamespaceUriSet.add(xbrlValue.getElementUri());
            }
            ++counter;
        }
        if (!CollectionUtils.isEmpty((Collection)namespaces)) {
            for (NamespacesService.XbrlXmlNamespace namespace : namespaces) {
                if (!usedNamespaceUriSet.contains(namespace.getValue())) continue;
                namespace.setUsed(true);
            }
            this.namespaceService.save(namespaces);
        }
        this.unitService.clearUnusedXbrlUnits();
        this.axisService.processContexts(xbrlContextIs);
        log.info("Cells [" + (counter + 1) + " items] saved in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    @Transactional(value="cacheTransactionManager")
    public void saveCellsXls(XbrlPackage xbrlPackage, List<AspectCellData> aspectCells, LruCache<ContextCacheKey, String> contexIdLruCache, Map<String, String> cachedDimensionsDefault, boolean footnoteView, Boolean isOverwriteData) throws NamespaceNotFoundException {
        log.info("Save cells started...");
        Date start = new Date();
        XbrlReport xbrlReport = xbrlPackage.getXbrlReport();
        String scheme = DEFAULT_SCHEME;
        log.trace("Scheme: " + scheme);
        String identifier = xbrlPackage.getOgrn();
        int counter = 0;
        ArrayList<String> xbrlContextIs = new ArrayList<String>();
        ArrayList<ConfigProperties.Namespace> namespaceList = new ArrayList<ConfigProperties.Namespace>();
        List namespaces = this.namespaceService.getNamespaces();
        if (!CollectionUtils.isEmpty((Collection)namespaces)) {
            for (NamespacesService.XbrlXmlNamespace xbrlXmlNamespace : namespaces) {
                namespaceList.add(new ConfigProperties.Namespace(xbrlXmlNamespace.getPrefix(), xbrlXmlNamespace.getValue(), true));
            }
        }
        HashSet<String> usedNamespaceUriSet = new HashSet<String>();
        HashMap<Long, UnitsConfiguration> unitConfigurations = new HashMap<Long, UnitsConfiguration>();
        for (AspectCellData aspectCellData : aspectCells) {
            boolean isEditable;
            this.setupDimensionType(aspectCellData);
            boolean bl = isEditable = !this.cellEditableCheckerService.checkNotEditable(aspectCellData);
            if (!isEditable) {
                log.info("Skip not editable cell: {}", (Object)aspectCellData.toShortString());
                continue;
            }
            AspectData tag = aspectCellData.getTagLabel();
            AspectData concept = null;
            if (tag != null) {
                aspectCellData.getAspectDataList().remove(tag);
                concept = aspectCellData.getConceptByTag(tag.getTagSelector());
            } else {
                concept = aspectCellData.getConcept();
            }
            if (aspectCellData.validate()) {
                aspectCellData.prepare();
            }
            String cellValue = aspectCellData.getCellValue();
            Long roleId = aspectCellData.getRoleId();
            UnitsConfiguration unitConfiguration = (UnitsConfiguration)unitConfigurations.get(roleId);
            if (unitConfiguration == null) {
                log.info("add UnitsConfiguration unitConfiguration for role " + roleId);
                XbrlReportRole xbrlReportRole = this.xbrlReportService.findReportRoleSafe(roleId);
                unitConfiguration = this.unitsConfigurationService.findByRoleOrReport(xbrlReport, xbrlReportRole);
                unitConfigurations.putIfAbsent(roleId, unitConfiguration);
            }
            if (cachedDimensionsDefault == null) {
                cachedDimensionsDefault = this.getDimensionsDefault();
            }
            Map dimensionsDefault = cachedDimensionsDefault;
            List aspectDataList = aspectCellData.getAspectDataList();
            log.trace("-----------------------------------------------------------------------");
            log.trace("\n** Aspect data");
            log.trace("-----------------------------------------------------------------------");
            String xbrlContextId = this.findOrCreateContext2(xbrlReport, scheme, identifier, aspectCellData, dimensionsDefault, contexIdLruCache);
            xbrlContextIs.add(xbrlContextId);
            log.trace("Found conceptAspect: " + concept);
            String elementLabel = concept.getAspectValue();
            XbrlValue xbrlValue = this.findOrCreateValue(xbrlReport, roleId, concept, cellValue, xbrlContextId, elementLabel, aspectCellData, footnoteView, dimensionsDefault, isOverwriteData, namespaceList, unitConfiguration);
            if (isOverwriteData.booleanValue()) {
                this.saveFootnote(xbrlValue, aspectCellData.getFootnoteId());
            }
            if (xbrlValue != null) {
                usedNamespaceUriSet.add(xbrlValue.getElementUri());
            }
            ++counter;
        }
        this.unitService.clearUnusedXbrlUnits();
        if (!CollectionUtils.isEmpty((Collection)namespaces)) {
            for (NamespacesService.XbrlXmlNamespace namespace : namespaces) {
                if (!usedNamespaceUriSet.contains(namespace.getValue())) continue;
                namespace.setUsed(true);
            }
            this.namespaceService.save(namespaces);
        }
        log.info("saveCells:processContexts");
        this.axisService.processContexts(xbrlContextIs);
        log.info("Cells [" + (counter + 1) + " items] saved in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    private void setupDimensionType(AspectCellData aspectCellData) {
        aspectCellData.getDimensions().forEach(aspectData -> aspectData.setDimensionType(this.hypercubeService.getDimensionType(aspectData.getAspect())));
    }

    public XbrlValue findValue(String elementLabel, XbrlReport xbrlReport, String xbrlContext) {
        XbrlValueId xbrlValueId = new XbrlValueId(elementLabel, xbrlReport.getId(), xbrlContext);
        return this.xbrlValueCrudService.find(xbrlValueId);
    }

    private XbrlValue findOrCreateValue(XbrlReport xbrlReport, Long roleId, AspectData concept, String cellValue, String xbrlContext, String elementLabel, AspectCellData aspectCellData, boolean footnoteView, Map<String, String> dimensionsDefault, Boolean isOverwriteData, List<ConfigProperties.Namespace> namespaceList, UnitsConfiguration unitConfiguration) throws NamespaceNotFoundException {
        XbrlValueId xbrlValueId = new XbrlValueId(elementLabel, xbrlReport.getId(), xbrlContext);
        Date startSearchvalue = new Date();
        XbrlValue xbrlValue = this.xbrlValueCrudService.find(xbrlValueId);
        Profiler.add((String)"find-value", (Date)startSearchvalue);
        if (footnoteView) {
            return xbrlValue;
        }
        if (xbrlValue != null) {
            if (!isOverwriteData.booleanValue()) {
                log.info("Value exists, skip update");
                return xbrlValue;
            }
            if (StringUtils.isBlank((CharSequence)cellValue)) {
                this.deleteXbrlValue(xbrlValue);
            } else {
                boolean unitsChanged;
                String oldValue = xbrlValue.getValue();
                log.trace("Found xbrlValue with value " + xbrlValue.getValue());
                boolean bl = unitsChanged = this.hasUnitsData(aspectCellData) && !this.isSameUnitsData(xbrlValue, aspectCellData);
                if (!Objects.equals(xbrlValue.getValue(), cellValue) || unitsChanged) {
                    Date startUpdateValue = new Date();
                    xbrlValue.setValue(cellValue);
                    if (this.hasUnitsData(aspectCellData)) {
                        log.info("hasUnitsData(aspectCellData)");
                        this.fillUnitAndCreateNew(xbrlReport, aspectCellData, xbrlValue, concept);
                    }
                    XbrlValue updated = this.xbrlValueCrudService.update(xbrlValue);
                    Profiler.add((String)"update-value", (Date)startUpdateValue);
                    log.info("value updated, old value: " + oldValue + ", new value: " + updated.getValue());
                }
            }
        } else {
            if (StringUtils.isBlank((CharSequence)cellValue)) {
                log.warn("New fact with empty value. Ignored.");
                return null;
            }
            Date startCreateValue = new Date();
            xbrlValue = new XbrlValue();
            xbrlValue.setXbrlValueId(xbrlValueId);
            xbrlValue.setValue(cellValue);
            xbrlValue.buildGuid();
            String[] parts = elementLabel.split(":");
            String nsPrefix = parts[0];
            Optional<ConfigProperties.Namespace> namespaceOptional = namespaceList.stream().filter(ns -> ns.getPrefix().equals(nsPrefix)).findFirst();
            if (!namespaceOptional.isPresent()) {
                log.error("Namespace not found with prefix " + nsPrefix);
                throw new NamespaceNotFoundException();
            }
            ConfigProperties.Namespace namespace = namespaceOptional.get();
            String elementName = parts[1];
            xbrlValue.setElementUri(namespace.getUri());
            xbrlValue.setElementName(elementName);
            String hash = DigestUtils.md5((String)xbrlContext).toString();
            xbrlValue.setContextIdHash(hash);
            xbrlValue.setDataType(concept.getConceptDataType());
            if (this.hasUnitsData(aspectCellData)) {
                log.info("fillUnitAndCreateNew");
                this.fillUnitAndCreateNew(xbrlReport, aspectCellData, xbrlValue, concept);
            } else if (unitConfiguration != null) {
                this.unitService.fillValueXls(xbrlReport.getId(), xbrlValue, unitConfiguration);
            } else {
                XbrlReportRole xbrlReportRole = this.xbrlReportService.findReportRoleSafe(roleId);
                this.unitService.fillValue(xbrlReport.getId(), xbrlValue, this.unitsConfigurationService.findByRoleOrReport(xbrlReport, xbrlReportRole));
            }
            this.fillAspectDataJson(xbrlValue, aspectCellData, dimensionsDefault);
            XbrlValue created = this.xbrlValueCrudService.create(xbrlValue);
            this.presentationDefinitionService.savePresentationDefinitionRolesData(xbrlReport, created, aspectCellData);
            Profiler.add((String)"create-value", (Date)startCreateValue);
        }
        return xbrlValue;
    }

    private void fillUnitAndCreateNew(XbrlReport xbrlReport, AspectCellData aspectCellData, XbrlValue xbrlValue, AspectData concept) {
        this.fillUnitsData(aspectCellData, xbrlValue);
        switch (1.$SwitchMap$ru$cbr$xbrl$converter$model$DataType[concept.getConceptDataType().ordinal()]) {
            case 1: {
                this.unitService.findOrCreateUnit(xbrlReport.getId(), "iso4217", aspectCellData.getUnitId());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.unitService.findOrCreateUnit(xbrlReport.getId(), "xbrli", aspectCellData.getUnitId());
                break;
            }
        }
    }

    public void fillAspectDataJson(XbrlValue xbrlValue, AspectCellData aspectCellData, Map<String, String> dimensionsDefault) {
        ObjectMapper objectMapper = new ObjectMapper();
        AspectData concept = aspectCellData.getConcept();
        PeriodDates periodDates = AspectUtils.getPeriodDatesForConcept((List)aspectCellData.getAspectDataList(), (AspectData)concept);
        if (periodDates == null) {
            periodDates = PeriodDates.from((XbrlPeriod)this.xbrlPeriodService.getDefaultPeriod());
        }
        if (concept.getConceptPeriodType() == PeriodType.INSTANT) {
            periodDates = periodDates.toInstant();
        }
        AspectData periodAspect = periodDates.buildAspectData();
        List dimensions = aspectCellData.getDimensions();
        List dimensionsWithoutDefaults = XbrlContextDimension.removeDefaultDimensions((List)dimensions, dimensionsDefault);
        ArrayList<AspectData> aspectDataList = new ArrayList<AspectData>();
        aspectDataList.add(periodAspect);
        aspectDataList.add(concept);
        aspectDataList.addAll(dimensionsWithoutDefaults);
        xbrlValue.setAspectDataList(aspectDataList);
        xbrlValue.packAspectDataList();
    }

    private void fillUnitsData(AspectCellData aspectCellData, XbrlValue xbrlValue) {
        xbrlValue.setXbrlUnit(aspectCellData.getUnitId().toUpperCase());
        xbrlValue.setPrecision(TextUtils.parseIntSafe((String)aspectCellData.getPrecision()));
        xbrlValue.setDecimals(TextUtils.parseIntSafe((String)aspectCellData.getDecimals()));
    }

    private boolean hasUnitsData(AspectCellData aspectCellData) {
        String[] unitData = new String[]{aspectCellData.getDecimals(), aspectCellData.getPrecision(), aspectCellData.getUnitId()};
        return Arrays.stream(unitData).anyMatch(StringUtils::isNotBlank);
    }

    public boolean isSameUnitsData(XbrlValue xbrlValue, AspectCellData aspectCellData) {
        boolean decimalsEquals = Objects.equals(xbrlValue.getDecimals(), TextUtils.parseIntSafe((String)aspectCellData.getDecimals()));
        boolean precisionEquals = Objects.equals(xbrlValue.getPrecision(), TextUtils.parseIntSafe((String)aspectCellData.getPrecision()));
        boolean unitsEquals = Objects.equals(xbrlValue.getXbrlUnit(), aspectCellData.getUnitId());
        return decimalsEquals && precisionEquals && unitsEquals;
    }

    private void saveFootnote(XbrlValue xbrlValue, Long footnoteId) {
    }

    public String findOrCreateContext2(XbrlReport xbrlReport, String scheme, String identifier, AspectCellData aspectCellData, Map<String, String> dimensionsDefault, LruCache<ContextCacheKey, String> contexIdLruCache) {
        AspectData concept = aspectCellData.getConcept();
        AspectData periodAspect = aspectCellData.getPeriodAspect();
        PeriodDates periodDates = AspectUtils.getPeriodDatesForConcept((List)aspectCellData.getAspectDataList(), (AspectData)concept);
        if (periodDates == null) {
            log.info("PeriodDates.from(xbrlPeriodService.getDefaultPeriod());");
            periodDates = PeriodDates.from((XbrlPeriod)this.xbrlPeriodService.getDefaultPeriod());
        }
        if (concept.getConceptPeriodType() == PeriodType.INSTANT) {
            periodDates = periodDates.toInstant();
        }
        log.trace("** Period date " + periodDates);
        List dimensions = aspectCellData.getDimensions();
        return this.findOrCreateContext2(xbrlReport, scheme, identifier, periodDates, dimensions, periodAspect, dimensionsDefault, contexIdLruCache);
    }

    public String findContext(XbrlReport xbrlReport, AspectCellData aspectCellData, Map<String, String> dimensionsDefault, LruCache<ContextCacheKey, String> contexIdLruCache, boolean useKeyCache) {
        AspectData concept = aspectCellData.getConcept();
        PeriodDates periodDates = AspectUtils.getPeriodDatesForConcept((List)aspectCellData.getAspectDataList(), (AspectData)concept);
        if (periodDates == null) {
            periodDates = PeriodDates.from((XbrlPeriod)this.xbrlPeriodService.getDefaultPeriod());
        }
        if (concept != null && concept.getConceptPeriodType() == PeriodType.INSTANT) {
            periodDates = periodDates.toInstant();
        }
        List dimensions = aspectCellData.getDimensions();
        PeriodType periodType = periodDates.getPeriodType();
        List dimensionsWithoutDefaults = XbrlContextDimension.removeDefaultDimensions((List)dimensions, dimensionsDefault);
        List xbrlContextDimensions = XbrlContextDimension.buildFromAspectDataList((List)dimensionsWithoutDefaults);
        String dimensionsHash = XbrlContextDimension.dimensionToHash((List)xbrlContextDimensions);
        String xbrlContextId = this.findContext(xbrlReport, periodDates, periodType, dimensionsHash, contexIdLruCache, useKeyCache);
        return xbrlContextId;
    }

    private String findOrCreateContext2(XbrlReport xbrlReport, String scheme, String identifier, PeriodDates periodDates, List<AspectData> dimensions, AspectData periodAspect, Map<String, String> dimensionsDefault, LruCache<ContextCacheKey, String> contexIdLruCache) {
        Date start = new Date();
        log.trace("Search context started...");
        PeriodType periodType = periodDates.getPeriodType();
        List dimensionsWithoutDefaults = XbrlContextDimension.removeDefaultDimensions(dimensions, dimensionsDefault);
        List xbrlContextDimensions = XbrlContextDimension.buildFromAspectDataList((List)dimensionsWithoutDefaults);
        String dimensionsString = XbrlContextDimension.dimensionsToString((List)xbrlContextDimensions);
        log.trace("** DimensionString ");
        Arrays.stream(dimensionsString.split("; ")).forEach(arg_0 -> ((Logger)log).trace(arg_0));
        String dimensionsHash = XbrlContextDimension.dimensionToHash((List)xbrlContextDimensions);
        String dimensionsOpenHash = XbrlContextDimension.dimensionsOpenToHash((List)xbrlContextDimensions, (Set)this.conceptInMemoryService.getExplicitAspectNodeSet());
        String xbrlContextId = this.findContext(xbrlReport, periodDates, periodType, dimensionsHash, contexIdLruCache, false);
        if (xbrlContextId == null) {
            Date startCreateContext = new Date();
            log.trace("Context not found");
            XbrlContext newContext = this.buildNewContext(xbrlReport, scheme, identifier, periodDates, xbrlContextDimensions);
            newContext.setDimensionsHash(dimensionsHash);
            newContext.setDimensionsOpenHash(dimensionsOpenHash);
            newContext.setDimensions(dimensionsString);
            newContext.setAspectDataList(new ArrayList());
            AspectData periodAspect2 = periodDates.buildAspectData();
            newContext.getAspectDataList().add(periodAspect2);
            newContext.getAspectDataList().addAll(dimensions);
            newContext.packAspectDataList();
            XbrlContext xbrlContext1 = this.xbrlContextCrudService.create(newContext);
            xbrlContextId = xbrlContext1.getXbrlContextId().getContextId();
            Profiler.add((String)"create-context", (Date)startCreateContext);
        }
        log.trace("Search context compete in " + (new Date().getTime() - start.getTime()) + " msec");
        return xbrlContextId;
    }

    private String findContext(XbrlReport xbrlReport, PeriodDates periodDates, PeriodType periodType, String dimensionsHash, LruCache<ContextCacheKey, String> contexIdLruCache, boolean useKeyCache) {
        String xbrlContextId;
        Date startFindContext = new Date();
        if (PeriodType.INSTANT.equals((Object)periodType)) {
            Date startFindInstantContext = new Date();
            ContextCacheKey contextCacheKey = new ContextCacheKey(xbrlReport.getId(), periodType, Long.valueOf(periodDates.getInstantDate().getTime()), null, dimensionsHash);
            if (useKeyCache && !this.existenceContextKeyInstantSet.contains(contextCacheKey)) {
                return null;
            }
            xbrlContextId = (String)contexIdLruCache.get((Object)contextCacheKey);
            if (xbrlContextId == null && (xbrlContextId = this.getFirstContextId(this.xbrlContextRepository.findContextIdByPeriodTypeAndDimensionsHashAndInstantDate(periodType, dimensionsHash, periodDates.getInstantDate()))) != null) {
                contexIdLruCache.put((Object)contextCacheKey, (Object)xbrlContextId);
            }
            Profiler.add((String)"find-instant-context", (Date)startFindInstantContext);
        } else if (PeriodType.DURATION.equals((Object)periodType)) {
            Date startFindDurationContext = new Date();
            ContextCacheKey contextCacheKey = new ContextCacheKey(xbrlReport.getId(), periodType, Long.valueOf(periodDates.getStartDate().getTime()), Long.valueOf(periodDates.getEndDate().getTime()), dimensionsHash);
            if (useKeyCache && !this.existenceContextKeyDurationSet.contains(contextCacheKey)) {
                return null;
            }
            xbrlContextId = (String)contexIdLruCache.get((Object)contextCacheKey);
            if (xbrlContextId == null && (xbrlContextId = this.getFirstContextId(this.xbrlContextRepository.findContextIdByPeriodTypeAndDimensionsHashAndStartDateAndEndDate(periodType, dimensionsHash, periodDates.getStartDate(), periodDates.getEndDate()))) != null) {
                contexIdLruCache.put((Object)contextCacheKey, (Object)xbrlContextId);
            }
            Profiler.add((String)"find-duration-context", (Date)startFindDurationContext);
        } else {
            IllegalArgumentException e = new IllegalArgumentException("Unknown periodType");
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        Profiler.add((String)"find-context", (Date)startFindContext);
        return xbrlContextId;
    }

    private String getFirstContextId(List<String> contextIds) {
        return contextIds.stream().findFirst().orElse(null);
    }

    private XbrlContext buildNewContext(XbrlReport xbrlReport, String scheme, String identifier, PeriodDates periodDates, List<XbrlContextDimension> xbrlContextDimensions) {
        XbrlContext xbrlContext = new XbrlContext();
        xbrlContext.setScheme(scheme);
        xbrlContext.setIdentifier(identifier);
        String guid = this.generateContextId();
        XbrlContextId xbrlContextId = new XbrlContextId(guid, xbrlReport.getId());
        xbrlContext.setXbrlContextId(xbrlContextId);
        if (!xbrlContextDimensions.isEmpty()) {
            xbrlContext.setScenario(XbrlContextDimension.buildScenario(xbrlContextDimensions));
        }
        if (periodDates.getPeriodType().equals((Object)PeriodType.INSTANT)) {
            xbrlContext.setPeriodType(PeriodType.INSTANT);
            xbrlContext.setInstantDate(periodDates.getInstantDate());
        } else if (periodDates.getPeriodType().equals((Object)PeriodType.DURATION)) {
            xbrlContext.setPeriodType(PeriodType.DURATION);
            xbrlContext.setStartDate(periodDates.getStartDate());
            xbrlContext.setEndDate(periodDates.getEndDate());
        }
        return xbrlContext;
    }

    public String generateContextId() {
        return "a" + UUID.randomUUID().toString();
    }

    public void initExistenceContextCache() {
        this.existenceContextKeyInstantSet = new HashSet(this.xbrlContextRepository.findAllContextIdCacheForInstant());
        this.existenceContextKeyDurationSet = new HashSet(this.xbrlContextRepository.findAllContextIdCacheForDuration());
    }

    public void clearExistenceContextCache() {
        this.existenceContextKeyInstantSet.clear();
        this.existenceContextKeyDurationSet.clear();
    }

    public XbrlValue findValue(XbrlReport xbrlReport, AspectCellData aspectCellData) {
        if (xbrlReport.getXbrlReportRoles().isEmpty()) {
            return null;
        }
        XbrlReportRole role = (XbrlReportRole)xbrlReport.getXbrlReportRoles().get(0);
        Map dimensionsDefault = this.getDimensionsDefault();
        String contextId = this.findContext(xbrlReport, aspectCellData, dimensionsDefault, new LruCache(100), false);
        AspectData concept = aspectCellData.getConcept();
        XbrlValue xbrlValue = this.findValue(concept.getAspectValue(), xbrlReport, contextId);
        return xbrlValue;
    }

    public Set<String> movePeriodsData(ContextPeriod existingContextPeriod, ContextPeriod newContextPeriod, boolean createForDefault) {
        HashSet<String> movedContextIdSet = new HashSet<String>();
        Date existingStartDate = existingContextPeriod.getStartDate();
        Date existingEndDate = existingContextPeriod.getEndDate();
        Date newStartDate = newContextPeriod.getStartDate();
        Date newEndDate = newContextPeriod.getEndDate();
        PeriodDates currentDefaultDuration = PeriodDates.buildDuration((Date)existingStartDate, (Date)existingContextPeriod.getEndDate());
        PeriodDates newDefaultDuration = PeriodDates.buildDuration((Date)newStartDate, (Date)newContextPeriod.getEndDate());
        this.moveDataByContextPeriod(currentDefaultDuration, newDefaultDuration, createForDefault, movedContextIdSet);
        PeriodDates currentDefaultInstant = PeriodDates.buildInstant((Date)DateUtils.addDays((Date)existingStartDate, (int)-1));
        PeriodDates newDefaultInstant = PeriodDates.buildInstant((Date)DateUtils.addDays((Date)newStartDate, (int)-1));
        this.moveDataByContextPeriod(currentDefaultInstant, newDefaultInstant, createForDefault, movedContextIdSet);
        currentDefaultInstant = PeriodDates.buildInstant((Date)DateUtils.truncate((Date)existingEndDate, (int)5));
        newDefaultInstant = PeriodDates.buildInstant((Date)DateUtils.truncate((Date)newEndDate, (int)5));
        this.moveDataByContextPeriod(currentDefaultInstant, newDefaultInstant, createForDefault, movedContextIdSet);
        if (DateUtils.isSameDay((Date)existingStartDate, (Date)DateUtils.truncate((Date)existingStartDate, (int)1)) || DateUtils.isSameDay((Date)newStartDate, (Date)DateUtils.truncate((Date)newStartDate, (int)1))) {
            return movedContextIdSet;
        }
        Date existingStartYearDate = DateUtils.truncate((Date)existingStartDate, (int)1);
        Date newStartYearDate = DateUtils.truncate((Date)newStartDate, (int)1);
        currentDefaultDuration = PeriodDates.buildDuration((Date)existingStartYearDate, (Date)existingContextPeriod.getEndDate());
        newDefaultDuration = PeriodDates.buildDuration((Date)newStartYearDate, (Date)newContextPeriod.getEndDate());
        this.moveDataByContextPeriod(currentDefaultDuration, newDefaultDuration, createForDefault, movedContextIdSet);
        currentDefaultInstant = PeriodDates.buildInstant((Date)DateUtils.addDays((Date)existingStartYearDate, (int)-1));
        newDefaultInstant = PeriodDates.buildInstant((Date)DateUtils.addDays((Date)newStartYearDate, (int)-1));
        this.moveDataByContextPeriod(currentDefaultInstant, newDefaultInstant, createForDefault, movedContextIdSet);
        return movedContextIdSet;
    }

    public void deletePeriodsData(List<XbrlPeriod> periods) {
        periods.forEach(period -> {
            PeriodDates duration = PeriodDates.buildDuration((Date)period.getStart(), (Date)period.getEnd());
            this.deleteDataByContextPeriod(duration);
            PeriodDates instant = PeriodDates.buildInstant((Date)DateUtils.addDays((Date)period.getStart(), (int)-1));
            this.deleteDataByContextPeriod(instant);
        });
    }

    public void deleteDataByContext(XbrlContext xbrlContext) {
        List xbrlValueList = this.xbrlValueCrudService.findByContextId(xbrlContext.getXbrlContextId().getContextId());
        xbrlValueList.forEach(xbrlValue -> {
            if (xbrlValue == null) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)xbrlValue.getId())) {
                List footnoteList = this.xbrlFootnoteCrudService.listByXbrlValue(xbrlValue);
                this.xbrlFootnoteCrudService.deleteFound(footnoteList);
            }
            this.xbrlValueRoleRepository.deleteAllByGuid(xbrlValue.getGuid());
            this.xbrlValueCrudService.deleteFound(xbrlValue);
        });
        this.xbrlContextRepository.delete((Object)xbrlContext);
        log.info("Removed context {} with {} facts", (Object)xbrlContext.getXbrlContextId().getContextId(), (Object)xbrlValueList.size());
    }

    private void deleteDataByContextPeriod(PeriodDates periodDates) {
        List contextList = this.xbrlContextCrudService.findByPeriodDates(periodDates);
        contextList.forEach(context -> {
            if (context == null) {
                return;
            }
            List xbrlValueList = this.xbrlValueCrudService.findByContextId(context.getXbrlContextId().getContextId());
            xbrlValueList.forEach(xbrlValue -> {
                if (xbrlValue == null) {
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)xbrlValue.getId())) {
                    List footnoteList = this.xbrlFootnoteCrudService.listByXbrlValue(xbrlValue);
                    this.xbrlFootnoteCrudService.deleteFound(footnoteList);
                }
                this.xbrlValueRoleRepository.deleteAllByGuid(xbrlValue.getGuid());
                this.xbrlValueCrudService.deleteFound(xbrlValue);
            });
        });
        this.xbrlContextRepository.delete((Iterable)contextList);
    }

    private void moveDataByContextPeriod(PeriodDates oldPeriodDates, PeriodDates newPeriodDates, boolean createForDefault, Set<String> movedContextIdSet) {
        List contextList = this.xbrlContextCrudService.findByPeriodDates(oldPeriodDates);
        contextList.forEach(context -> {
            if (context == null || context.getXbrlContextId() == null) {
                return;
            }
            if (!CollectionUtils.isEmpty((Collection)movedContextIdSet) && movedContextIdSet.contains(context.getXbrlContextId().getContextId())) {
                log.info("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u043e\u0432 \u043f\u0440\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430. \u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430.");
                return;
            }
            PeriodType periodType = context.getPeriodType();
            if (periodType.equals((Object)PeriodType.DURATION)) {
                context.setStartDate(newPeriodDates.getStartDate());
                context.setEndDate(newPeriodDates.getEndDate());
            } else if (periodType.equals((Object)PeriodType.INSTANT)) {
                context.setInstantDate(newPeriodDates.getInstantDate());
            } else {
                throw new IllegalArgumentException("Wrong periodType");
            }
            this.xbrlContextRepository.save(context);
            movedContextIdSet.add(context.getXbrlContextId().getContextId());
            if (!createForDefault || periodType.equals((Object)PeriodType.INSTANT)) {
                return;
            }
            XbrlContext xbrlCloneContext = null;
            try {
                xbrlCloneContext = (XbrlContext)this.objectMapper.readValue(this.objectMapper.writeValueAsString(context), XbrlContext.class);
            }
            catch (IOException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                return;
            }
            if (xbrlCloneContext == null) {
                log.warn("Manual clone is not implemented");
                return;
            }
            xbrlCloneContext.setAspectDataJson(context.getAspectDataJson());
            String contextId = "a" + UUID.randomUUID().toString();
            xbrlCloneContext.getXbrlContextId().setContextId(contextId);
            xbrlCloneContext.setStartDate(DateUtils.truncate((Date)xbrlCloneContext.getStartDate(), (int)1));
            List xbrlValueList = this.xbrlValueCrudService.findByContextId(context.getXbrlContextId().getContextId());
            if (CollectionUtils.isEmpty((Collection)xbrlValueList)) {
                this.xbrlContextRepository.save((Object)xbrlCloneContext);
                this.xbrlContextRepository.delete(context);
                return;
            }
            xbrlValueList.forEach(xbrlValue -> {
                XbrlValue xbrlCloneValue;
                if (xbrlValue == null) {
                    return;
                }
                try {
                    xbrlCloneValue = (XbrlValue)this.objectMapper.readValue(this.objectMapper.writeValueAsString(xbrlValue), XbrlValue.class);
                }
                catch (IOException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                    return;
                }
                xbrlCloneValue.setAspectDataJson(xbrlValue.getAspectDataJson());
                xbrlCloneValue.getXbrlValueId().setXbrlContextId(contextId);
                String oldGuid = xbrlCloneValue.getGuid();
                xbrlCloneValue.buildGuid();
                if (StringUtils.isBlank((CharSequence)xbrlValue.getId())) {
                    this.copyXbrlValueRoleLinkAndSave(xbrlCloneValue, oldGuid);
                    this.deleteXbrlValue(xbrlValue);
                    return;
                }
                String footnoteFactId = "a" + UUID.randomUUID().toString();
                xbrlCloneValue.setId(footnoteFactId);
                List footnoteList = this.xbrlFootnoteCrudService.listByXbrlValue(xbrlValue);
                if (CollectionUtils.isEmpty((Collection)footnoteList)) {
                    this.copyXbrlValueRoleLinkAndSave(xbrlCloneValue, oldGuid);
                    this.deleteXbrlValue(xbrlValue);
                    return;
                }
                footnoteList.forEach(xbrlFootnote -> {
                    XbrlFootnote xbrlCloneFootnote;
                    if (xbrlFootnote == null) {
                        return;
                    }
                    try {
                        xbrlCloneFootnote = (XbrlFootnote)this.objectMapper.readValue(this.objectMapper.writeValueAsString(xbrlFootnote), XbrlFootnote.class);
                    }
                    catch (IOException e) {
                        log.error(ExceptionUtils.getStackTrace((Throwable)e));
                        return;
                    }
                    xbrlCloneFootnote.setId("a" + UUID.randomUUID().toString());
                    xbrlCloneFootnote.setFootnoteFactId(footnoteFactId);
                    xbrlCloneFootnote.setContext(contextId);
                    this.xbrlFootnoteCrudService.create(xbrlCloneFootnote);
                });
                this.deleteXbrlValue(xbrlValue);
                this.copyXbrlValueRoleLinkAndSave(xbrlCloneValue, oldGuid);
            });
            this.xbrlContextRepository.save((Object)xbrlCloneContext);
        });
    }

    private void copyXbrlValueRoleLinkAndSave(XbrlValue xbrlValue, String oldGuid) {
        if (xbrlValue == null || StringUtils.isBlank((CharSequence)xbrlValue.getGuid()) && StringUtils.isBlank((CharSequence)oldGuid)) {
            return;
        }
        this.xbrlValueCrudService.update(xbrlValue);
        List valueRoleList = this.xbrlValueRoleRepository.findAllByGuid(oldGuid);
        if (CollectionUtils.isEmpty((Collection)valueRoleList)) {
            return;
        }
        valueRoleList.forEach(xbrlValueRole -> {
            if (xbrlValueRole == null) {
                return;
            }
            XbrlValueRole xbrlValueRoleClone = new XbrlValueRole();
            xbrlValueRoleClone.setId("a" + UUID.randomUUID().toString());
            xbrlValueRoleClone.setXbrlValue(xbrlValue);
            xbrlValueRoleClone.setGuid(xbrlValue.getGuid());
            xbrlValueRoleClone.setRoleSystemId(xbrlValueRole.getRoleSystemId());
            this.xbrlValueRoleRepository.save((Object)xbrlValueRoleClone);
        });
    }

    @Transactional(value="cacheTransactionManager")
    public void deleteXbrlValue(XbrlValue xbrlValue) {
        if (xbrlValue == null) {
            return;
        }
        XbrlValueId xbrlValueId = xbrlValue.getXbrlValueId();
        try {
            if (StringUtils.isNotBlank((CharSequence)xbrlValue.getId())) {
                List footnoteList = this.xbrlFootnoteCrudService.listByXbrlValue(xbrlValue);
                this.xbrlFootnoteCrudService.deleteFound(footnoteList);
            }
            List valueroles = this.xbrlValueRoleRepository.findAllByGuid(xbrlValue.getGuid());
            valueroles.forEach(xbrlValueRole -> this.xbrlValueRoleRepository.delete(xbrlValueRole));
            if (xbrlValueId == null) {
                return;
            }
            this.xbrlValueCrudService.delete(xbrlValueId);
            String xbrlContextId = xbrlValueId.getXbrlContextId();
            List xbrlValueList = this.xbrlValueCrudService.findByContextId(xbrlContextId);
            if (CollectionUtils.isEmpty((Collection)xbrlValueList)) {
                this.xbrlContextCrudService.delete(new XbrlContextId(xbrlContextId, xbrlValueId.getXbrlReportId()));
            }
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException("DELETE_XBRL_VALUE_ERROR", e);
        }
    }
}

