/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service.import_export;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.exception.CellDataValidationException;
import ru.cbr.xbrl.converter.model.DataType;
import ru.cbr.xbrl.converter.model.tableLinkBase.EnumerateItem;

/*
 * Exception performing whole class analysis ignored.
 */
public class CellValidator {
    private static Set<String> EXCLUDED_CURRENCIES = new HashSet<String>(Collections.singletonList("RUR"));
    private static Set<String> AVAILABLE_CURRENCIES = Currency.getAvailableCurrencies().stream().map(Currency::getCurrencyCode).filter(c -> !EXCLUDED_CURRENCIES.contains(c)).collect(Collectors.toSet());

    public static boolean validateSafe(String cellData, String xsdType) {
        try {
            CellValidator.validate((String)cellData, (String)xsdType);
            return true;
        }
        catch (CellDataValidationException e) {
            return false;
        }
    }

    public static void validate(String cellData, String xsdType) throws CellDataValidationException {
        if (xsdType == null) {
            return;
        }
        switch (xsdType) {
            case "integer": {
                CellValidator.validateInteger((String)cellData);
                break;
            }
            case "decimal": {
                CellValidator.validateDecimal((String)cellData);
                break;
            }
            case "date": {
                CellValidator.validateDate((String)cellData);
            }
        }
    }

    private static void validateDate(String cellData) {
        if (StringUtils.isBlank((CharSequence)cellData)) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setLenient(false);
        try {
            df.parse(cellData);
        }
        catch (ParseException e) {
            throw new CellDataValidationException();
        }
    }

    private static void validateDecimal(String cellData) throws CellDataValidationException {
        if (!cellData.matches("(\\+|-)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)")) {
            throw new CellDataValidationException();
        }
    }

    private static void validateInteger(String cellData) throws CellDataValidationException {
        if (!cellData.matches("^(-)?\\d+$")) {
            throw new CellDataValidationException();
        }
        try {
            Integer.parseInt(cellData);
        }
        catch (NumberFormatException e) {
            throw new CellDataValidationException();
        }
    }

    public static boolean validatePattern(String cellValue, String regex) {
        if (StringUtils.isBlank((CharSequence)regex) || cellValue == null) {
            return true;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(cellValue);
        return matcher.matches();
    }

    public static String validateEnum2Value(Map<String, List<EnumerateItem>> enumerationsMap, String conceptId, String value) {
        String[] values = value.split(" ");
        HashSet<String> uniqueValues = new HashSet<String>();
        for (String val : values) {
            uniqueValues.add(val.trim());
        }
        ArrayList<String> valsList = new ArrayList<String>();
        valsList.addAll(uniqueValues);
        Collections.sort(valsList);
        value = String.join((CharSequence)" ", valsList);
        return value;
    }

    public static int validateEnumerations(Map<String, List<EnumerateItem>> enumerationsMap, String conceptId, String value, DataType dataType) {
        if (CollectionUtils.isEmpty(enumerationsMap)) {
            return 0;
        }
        List<EnumerateItem> enumerateItems = enumerationsMap.get(conceptId);
        if (CollectionUtils.isEmpty(enumerateItems)) {
            return 0;
        }
        if (dataType != DataType.ENUM2) {
            for (EnumerateItem enumerateItem : enumerateItems) {
                if (enumerateItem == null || !StringUtils.equals((CharSequence)enumerateItem.getMember(), (CharSequence)value)) continue;
                return 0;
            }
            return 1;
        }
        String[] values = value.split(" ");
        HashSet<String> uniqueValues = new HashSet<String>();
        boolean isFound = true;
        boolean isDouble = false;
        boolean isNotSorted = false;
        ArrayList<String> valsList = new ArrayList<String>();
        for (String val : values) {
            valsList.add(val);
            boolean isFound1 = false;
            if (uniqueValues.contains(val.trim())) {
                isDouble = true;
            }
            uniqueValues.add(val.trim());
            for (EnumerateItem enumerateItem : enumerateItems) {
                if (enumerateItem == null || !StringUtils.equals((CharSequence)enumerateItem.getMember(), (CharSequence)val.trim())) continue;
                isFound1 = true;
                break;
            }
            if (isFound1) continue;
            isFound = false;
            break;
        }
        String source = String.join((CharSequence)" ", valsList);
        Collections.sort(valsList);
        String sorted = String.join((CharSequence)" ", valsList);
        if (!sorted.equals(source)) {
            isNotSorted = true;
        }
        if (!isFound) {
            return 2;
        }
        if (isNotSorted && isDouble) {
            return 5;
        }
        if (isDouble) {
            return 3;
        }
        if (isNotSorted) {
            return 4;
        }
        return 0;
    }

    public static int validateEnumerationsValues(Map<String, List<EnumerateItem>> enumerationsMap, String conceptId, String value, DataType dataType) {
        if (CollectionUtils.isEmpty(enumerationsMap)) {
            return 0;
        }
        List<EnumerateItem> enumerateItems = enumerationsMap.get(conceptId);
        if (CollectionUtils.isEmpty(enumerateItems)) {
            return 0;
        }
        if (dataType != DataType.ENUM2) {
            for (EnumerateItem enumerateItem : enumerateItems) {
                if (enumerateItem == null || !StringUtils.equals((CharSequence)enumerateItem.getMember(), (CharSequence)value) && !StringUtils.equals((CharSequence)enumerateItem.getLabel(), (CharSequence)value)) continue;
                return 0;
            }
            return 1;
        }
        String[] values = value.split(", ");
        HashSet<String> uniqueValues = new HashSet<String>();
        boolean isFound = true;
        boolean isDouble = false;
        boolean isNotSorted = false;
        ArrayList<String> valsList = new ArrayList<String>();
        for (String val : values) {
            valsList.add(val);
            boolean isFound1 = false;
            if (uniqueValues.contains(val.trim())) {
                isDouble = true;
            }
            uniqueValues.add(val.trim());
            for (EnumerateItem enumerateItem : enumerateItems) {
                if (enumerateItem == null || !StringUtils.equals((CharSequence)enumerateItem.getLabel().trim(), (CharSequence)val.trim())) continue;
                isFound1 = true;
                break;
            }
            if (isFound1) continue;
            isFound = false;
            break;
        }
        String source = String.join((CharSequence)" ", valsList);
        Collections.sort(valsList);
        String sorted = String.join((CharSequence)" ", valsList);
        if (!sorted.equals(source)) {
            isNotSorted = true;
        }
        if (!isFound) {
            return 2;
        }
        if (isNotSorted && isDouble) {
            return 5;
        }
        if (isDouble) {
            return 3;
        }
        if (isNotSorted) {
            return 4;
        }
        return 0;
    }

    public static boolean validateEnumerations(Map<String, List<EnumerateItem>> enumerationsMap, String conceptId, String value) {
        if (CollectionUtils.isEmpty(enumerationsMap)) {
            return true;
        }
        List<EnumerateItem> enumerateItems = enumerationsMap.get(conceptId);
        if (CollectionUtils.isEmpty(enumerateItems)) {
            return true;
        }
        for (EnumerateItem enumerateItem : enumerateItems) {
            if (enumerateItem == null || !StringUtils.equals((CharSequence)enumerateItem.getMember(), (CharSequence)value)) continue;
            return true;
        }
        return false;
    }

    public static boolean validateUnitContent(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        String[] measureParts = StringUtils.split((String)value, (String)":");
        if (measureParts.length != 2) {
            return false;
        }
        String measureCode = measureParts[1].toUpperCase();
        if (StringUtils.equals((CharSequence)measureParts[0], (CharSequence)"iso4217") && AVAILABLE_CURRENCIES.contains(measureCode)) {
            return true;
        }
        if (StringUtils.equals((CharSequence)measureParts[0], (CharSequence)"xbrli")) {
            return StringUtils.equalsIgnoreCase((CharSequence)measureParts[1], (CharSequence)"SHARES") || StringUtils.equalsIgnoreCase((CharSequence)measureParts[1], (CharSequence)"PURE");
        }
        return false;
    }

    private CellValidator() {
    }
}

