/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.tableLinkBase.AxisMemberHierarchy;
import ru.cbr.xbrl.converter.model.tableLinkBase.NodeType;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.presentation_definition.XbrlValueRole;
import ru.cbr.xbrl.converter.repository.XbrlValueRoleRepository;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.XbrlRoleService;
import ru.cbr.xbrl.converter.service.import_export.EditXbrlService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionData;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.ConceptDimensionsAspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.AspectType;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;

@Service
public class XbrlRoleService {
    private static final Logger log = LoggerFactory.getLogger(XbrlRoleService.class);
    @Autowired
    private XbrlReportService xbrlReportService;
    @Autowired
    private EditXbrlService editXbrlService;
    @Autowired
    private XbrlValueRoleRepository xbrlValueRoleRepository;
    @Autowired
    private PresentationDefinitionService presentationDefinitionService;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;
    private RoleMap tlbRoleMap = new RoleMap(this);
    private RoleMap pdRoleMap = new RoleMap(this);
    private Map<String, List<AspectCellData>> tagSelectorsCellsMap = new ConcurrentHashMap();

    public void processStructure(TableLinkBaseStructure tableLinkBaseStructure) {
        Date start = new Date();
        String tlbRoleSystemId = tableLinkBaseStructure.getName();
        tableLinkBaseStructure.getZAxis().iterate((axisMemberHierarchy, parents) -> {
            this.processAspectDataList(tlbRoleSystemId, axisMemberHierarchy.getAspectDataList());
            this.conceptInMemoryService.addAllExplicitAspectNode(this.getExplicitAspectNodeDimensionSet(axisMemberHierarchy));
        });
        tableLinkBaseStructure.getYAxis().iterate((axisMemberHierarchy, parents) -> {
            this.processAspectDataList(tlbRoleSystemId, axisMemberHierarchy.getAspectDataList());
            this.conceptInMemoryService.addAllExplicitAspectNode(this.getExplicitAspectNodeDimensionSet(axisMemberHierarchy));
        });
        tableLinkBaseStructure.getXAxis().iterate((axisMemberHierarchy, parents) -> {
            this.processAspectDataList(tlbRoleSystemId, axisMemberHierarchy.getAspectDataList());
            this.conceptInMemoryService.addAllExplicitAspectNode(this.getExplicitAspectNodeDimensionSet(axisMemberHierarchy));
        });
        tableLinkBaseStructure.iterateAllAspectsAsync(aspectDataList -> {
            AspectCellData aspectCellData = new AspectCellData(aspectDataList);
            ConceptDimensionsAspectData conceptAndDimensionsByStream = AspectCellData.getConceptAndDimensionsByStream(aspectDataList.stream());
            AspectData concept = conceptAndDimensionsByStream.getConcept();
            if (concept != null && StringUtils.isNotBlank((CharSequence)concept.getTagSelector())) {
                String tagSelector = concept.getTagSelector();
                List aspectCellDataList = this.tagSelectorsCellsMap.computeIfAbsent(tagSelector, k -> Collections.synchronizedList(new ArrayList()));
                aspectCellDataList.add(aspectCellData);
            }
            List dimensionList = conceptAndDimensionsByStream.getDimensionList();
            dimensionList = XbrlContextDimension.removeDefaultDimensions((List)dimensionList, (Map)tableLinkBaseStructure.getDimensionsDefault());
            List xbrlContextDimensionList = XbrlContextDimension.buildFromAspectDataList((List)dimensionList);
            try {
                String contextDimensionOpenToHash = XbrlContextDimension.dimensionsOpenToHash((List)xbrlContextDimensionList, (Set)this.conceptInMemoryService.getExplicitAspectNodeSet());
                this.conceptInMemoryService.addContextRoleMap(tableLinkBaseStructure.getName(), contextDimensionOpenToHash);
            }
            catch (IllegalArgumentException e) {
                log.error("\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u0432\u044f\u0437\u0435\u0439 \u0440\u043e\u043b\u044c - \u043d\u0430\u0431\u043e\u0440 dimensions. \u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
            }
        });
        this.tlbRoleMap.incDuration(new Date().getTime() - start.getTime());
    }

    public Set<String> getExplicitAspectNodeDimensionSet(AxisMemberHierarchy axisMemberHierarchy) {
        if (axisMemberHierarchy.getNodeType() == NodeType.ASPECT) {
            AspectCellData aspectCellData = new AspectCellData(axisMemberHierarchy.getAspectDataList());
            return aspectCellData.getDimensions().stream().filter(aspectData -> aspectData.getDimensionType() == DimensionType.EXPLICIT_MEMBER).map(AspectData::getAspect).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public RoleMap getTlbRoleMap() {
        return this.tlbRoleMap;
    }

    public RoleMap getPdRoleMap() {
        return this.pdRoleMap;
    }

    public void loadFromReport(XbrlReport xbrlReport) {
        Date start = new Date();
        ObjectMapper objectMapper = new ObjectMapper();
        this.tagSelectorsCellsMap.clear();
        this.conceptInMemoryService.clearExplicitAspectNodeSet();
        this.conceptInMemoryService.clearContextRoleMap();
        xbrlReport.getXbrlReportRoles().forEach(xbrlReportRole -> {
            String json = xbrlReportRole.getStaticStructureJson();
            if (StringUtils.isNotBlank((CharSequence)json)) {
                try {
                    TableLinkBaseStructure tableLinkBaseStructure = (TableLinkBaseStructure)objectMapper.readValue(json, TableLinkBaseStructure.class);
                    this.processStructure(tableLinkBaseStructure);
                }
                catch (IOException e) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        });
        log.info("XbrlRoleService.loadFromReport processed in {} msec", (Object)(new Date().getTime() - start.getTime()));
    }

    public void addPresentationDefinitionConcept(String linkrole, String conceptName) {
        this.getPdRoleMap().addConcept(linkrole, conceptName);
    }

    public void addPresentationDefinitionDimension(String linkrole, String dimint, String memint) {
        this.getPdRoleMap().addDimension(linkrole, dimint, memint, null);
    }

    public Set<String> getTlbRolesByContexts(List<XbrlContext> xbrlContexts) {
        return this.getRolesByContexts(this.getTlbRoleMap(), xbrlContexts);
    }

    public Set<String> getPdRRolesByContexts(List<XbrlContext> xbrlContexts) {
        return this.getRolesByContexts(this.getPdRoleMap(), xbrlContexts);
    }

    private Set<String> getRolesByContexts(RoleMap roleMap, List<XbrlContext> xbrlContexts) {
        List<String> dimensionsString = xbrlContexts.stream().map(XbrlContext::getDimensions).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        ArrayList dimensions = new ArrayList();
        dimensionsString.forEach(dimension -> dimensions.addAll(XbrlContextDimension.dimensionsFromString((String)dimension)));
        HashSet<String> roles = new HashSet<String>();
        dimensions.forEach(dimension -> {
            Set rolesPart = (Set)roleMap.getDimintRoleMap().get(dimension.getDimension());
            if (rolesPart != null) {
                roles.addAll(rolesPart);
            }
        });
        return roles;
    }

    public Set<String> getFilledPdRolesByDimension(String dimensionString, String memberString) {
        if (memberString == null) {
            return this.xbrlValueRoleRepository.findRolesByDimension(dimensionString);
        }
        return this.xbrlValueRoleRepository.findRolesByDimension(dimensionString.trim() + " -> " + memberString.trim());
    }

    public Set<String> getFilledPdRolesByPeriod(Date start, Date end) {
        HashSet<String> roles = new HashSet<String>();
        roles.addAll(this.xbrlValueRoleRepository.findRolesByPeriodDuration(PeriodType.DURATION, start, end));
        roles.addAll(this.xbrlValueRoleRepository.findRolesByPeriodInstant(PeriodType.INSTANT, end));
        return roles;
    }

    public Set<String> getFilledTlbRolesByDimensions(String dimensionString, String memberString) {
        HashSet<String> filledTlbRoles = new HashSet<String>();
        Set filledPdRolesByDimension = this.getFilledPdRolesByDimension(dimensionString, memberString);
        filledPdRolesByDimension.forEach(role -> {
            Set pdRoles = this.getTlbRoleByPdRole(role);
            filledTlbRoles.addAll(pdRoles);
        });
        return filledTlbRoles;
    }

    public Set<String> getTlbRoleByPdRole(String pdRole) {
        Map tlbPdRoleMap = Optional.ofNullable(this.presentationDefinitionService.getPresentationDefinitionData()).map(PresentationDefinitionData::getTlbPdRoleMap).orElse((Map)new HashedMap());
        return tlbPdRoleMap.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(pdRole)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private void processAspectDataList(String tlbRoleSystemId, List<AspectData> aspectDataList) {
        List<String> concepts = aspectDataList.stream().filter(a -> a.getType().equals((Object)AspectType.CONCEPT)).map(aspectData -> aspectData.getAspectValue()).collect(Collectors.toList());
        concepts.forEach(c -> this.tlbRoleMap.addConcept(tlbRoleSystemId, c));
        List<AspectData> dimensions = aspectDataList.stream().filter(a -> a.getType().equals((Object)AspectType.DIMENSION)).collect(Collectors.toList());
        dimensions.forEach(aspectData -> this.tlbRoleMap.addDimension(tlbRoleSystemId, aspectData.getAspect(), aspectData.getAspectValue(), aspectData.getDimensionType()));
    }

    public Map<String, List<AspectCellData>> getTagSelectorsCellsMap() {
        return this.tagSelectorsCellsMap;
    }

    public Set<String> getContextSetByRole(String roleId) {
        if (StringUtils.isBlank((CharSequence)roleId)) {
            return Collections.emptySet();
        }
        Set contextList = this.conceptInMemoryService.getContextRole(roleId);
        if (CollectionUtils.isEmpty((Collection)contextList)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(contextList);
    }

    public List<XbrlValueRole> getXbrlValueRoleListBySystemId(String systemId) {
        return this.xbrlValueRoleRepository.findByRoleSystemId(systemId);
    }

    public void clearContextRoleMap() {
        this.conceptInMemoryService.clearContextRoleMap();
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

