/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import ru.cbr.xbrl.converter.arelle.ArelleOutputParser;
import ru.cbr.xbrl.converter.arelle.ArelleService;
import ru.cbr.xbrl.converter.arelle.parse.DimFileParser;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.ActionCancelledException;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;
import ru.cbr.xbrl.converter.exception.DownloadException;
import ru.cbr.xbrl.converter.exception.IncompatibleTxtFilterFileEncodingException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.ReadFileException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model.OpenAxisValidationRule;
import ru.cbr.xbrl.converter.model.PresentationConcept;
import ru.cbr.xbrl.converter.model.PresentationLinkRole;
import ru.cbr.xbrl.converter.model.XbrlFormula;
import ru.cbr.xbrl.converter.model.XbrlPdRolePeriod;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlPresentation;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.XbrlRolePeriod;
import ru.cbr.xbrl.converter.model.event.NotificationEvent;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.ContextPeriod;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.tableLinkBase.XbrlRoleDimension;
import ru.cbr.xbrl.converter.model.validation.ValidationLogInfo;
import ru.cbr.xbrl.converter.model.web.rest.RoleDTO;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContext;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlContextDimension;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValue;
import ru.cbr.xbrl.converter.model.xbrl_content.XbrlValueId;
import ru.cbr.xbrl.converter.model_main.Taxonomy;
import ru.cbr.xbrl.converter.repository.XbrlContextRepository;
import ru.cbr.xbrl.converter.repository.XbrlPdRolePeriodRepository;
import ru.cbr.xbrl.converter.repository.XbrlPeriodRepository;
import ru.cbr.xbrl.converter.repository.XbrlReportRoleRepository;
import ru.cbr.xbrl.converter.repository.XbrlValueRepository;
import ru.cbr.xbrl.converter.repository.XbrlValueRoleRepository;
import ru.cbr.xbrl.converter.service.ConceptInMemoryService;
import ru.cbr.xbrl.converter.service.ConceptService;
import ru.cbr.xbrl.converter.service.DimensionsDefaultService;
import ru.cbr.xbrl.converter.service.EnumerationsService;
import ru.cbr.xbrl.converter.service.NamespacesService;
import ru.cbr.xbrl.converter.service.OpenAxisValidationRulesService;
import ru.cbr.xbrl.converter.service.TaxonomyService;
import ru.cbr.xbrl.converter.service.UnitService;
import ru.cbr.xbrl.converter.service.XbrlDimensionService;
import ru.cbr.xbrl.converter.service.XbrlPackageService;
import ru.cbr.xbrl.converter.service.XbrlParameterService;
import ru.cbr.xbrl.converter.service.XbrlParsedDataService;
import ru.cbr.xbrl.converter.service.XbrlPeriodService;
import ru.cbr.xbrl.converter.service.XbrlReportService;
import ru.cbr.xbrl.converter.service.XbrlRoleService;
import ru.cbr.xbrl.converter.service.event.NotificationEventService;
import ru.cbr.xbrl.converter.service.event.NotificationEventServiceImpl;
import ru.cbr.xbrl.converter.service.import_export.EditXbrlService;
import ru.cbr.xbrl.converter.service.import_export.ExportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.ImportXbrlService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisMemberService;
import ru.cbr.xbrl.converter.service.internal.XbrlFilterOpenAxisService;
import ru.cbr.xbrl.converter.service.internal.XbrlReportCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.RoleCellService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlFootnoteCrudService;
import ru.cbr.xbrl.converter.service.internal.xbrl.XbrlValueCrudService;
import ru.cbr.xbrl.converter.service.label_linkbase.LabelLinkbaseService;
import ru.cbr.xbrl.converter.service.presentation_definition.PresentationDefinitionService;
import ru.cbr.xbrl.converter.service.reference_linkbase.ReferenceLinkbaseService;
import ru.cbr.xbrl.converter.service.tablelinkbase.AxisService;
import ru.cbr.xbrl.converter.utils.XbrlParametersUtils;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectCellData;
import ru.cbr.xbrl.converter.xbrl.import_export.edit.AspectData;
import ru.cbr.xbrl.converter.xbrl.import_export.enums.DimensionType;
import ru.cbr.xbrl.converter.xbrl.import_export.scenario.XbrlContextScenarioParser;

@Service
public class XbrlReportServiceImpl
implements XbrlReportService {
    private static final Logger log = LoggerFactory.getLogger(XbrlReportServiceImpl.class);
    private final OpenAxisValidationRulesService openAxisValidationRulesService;
    @Autowired
    private XbrlPeriodRepository xbrlPeriodRepository;
    @Autowired
    private XbrlReportCrudService xbrlReportCrudService;
    @Autowired
    private XbrlParsedDataService xbrlParsedDataService;
    @Autowired
    private ArelleService arelleService;
    @Autowired
    private TaxonomyService taxonomyService;
    @Autowired
    private ExportXbrlService exportXbrlService;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private ImportXbrlService importXbrlService;
    @Autowired
    private XbrlPeriodService xbrlPeriodService;
    @Autowired
    private XbrlFilterOpenAxisService xbrlFilterOpenAxisService;
    @PersistenceContext(unitName="cachePU")
    private EntityManager entityManager;
    private ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private XbrlFilterOpenAxisMemberService xbrlFilterOpenAxisMemberService;
    @Autowired
    private XbrlValueCrudService xbrlValueCrudService;
    @Autowired
    private ConceptService conceptService;
    @Autowired
    private XbrlValueRepository xbrlValueRepository;
    @Autowired
    private XbrlParameterService xbrlParameterService;
    @Autowired
    private XbrlPackageService xbrlPackageService;
    @Autowired
    private XbrlDimensionService xbrlDimensionService;
    @Autowired
    private AxisService axisService;
    @Autowired
    private XbrlContextRepository xbrlContextRepository;
    @Autowired
    private RoleCellService roleCellService;
    @Autowired
    private PresentationDefinitionService presentationDefinitionService;
    @Autowired
    private DimensionsDefaultService dimensionsDefaultService;
    @Autowired
    private EnumerationsService enumerationsService;
    @Autowired
    private XbrlValueRoleRepository xbrlValueRoleRepository;
    @Autowired
    private NotificationEventService notificationEventService;
    @Autowired
    private XbrlReportRoleRepository xbrlReportRoleRepository;
    @Autowired
    private XbrlPdRolePeriodRepository xbrlPdRolePeriodRepository;
    @Autowired
    private EditXbrlService editXbrlService;
    @Autowired
    private XbrlRoleService xbrlRoleService;
    @Autowired
    private ReferenceLinkbaseService referenceLinkbaseService;
    @Autowired
    private LabelLinkbaseService labelLinkbaseService;
    @Autowired
    private ConceptInMemoryService conceptInMemoryService;
    @Autowired
    private NamespacesService namespacesService;
    @Autowired
    private XbrlFootnoteCrudService xbrlFootnoteCrudService;
    @Autowired
    private UnitService unitService;
    private boolean isLastActionCanceled = false;

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public List<XbrlReport> list() {
        return this.xbrlReportCrudService.list();
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public XbrlReport find(Long id) throws NotFoundException {
        XbrlReport xbrlReport = this.xbrlReportCrudService.find(id);
        xbrlReport.initAllLazy();
        return xbrlReport;
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public XbrlReportRole findReportRole(Long xbrlRoleId) throws NotFoundException {
        return this.xbrlReportCrudService.findRole(xbrlRoleId);
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public XbrlReportRole findReportRoleSafe(Long xbrlRoleId) {
        if (xbrlRoleId == null) {
            return null;
        }
        try {
            return this.xbrlReportCrudService.findRole(xbrlRoleId);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public XbrlReportRole findReportRoleBySystemId(String systemId) throws NotFoundException {
        return this.xbrlReportCrudService.findRoleBySystemId(systemId);
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public List<XbrlPeriod> findReportRolePeriodList(Long xbrlRoleId) throws NotFoundException {
        XbrlReportRole role = this.xbrlReportCrudService.findRole(xbrlRoleId);
        List rolePeriodList = role.getPeriodList();
        List xbrlPackagePeriodList = this.xbrlPeriodRepository.findAll();
        for (XbrlPeriod xbrlPeriod : xbrlPackagePeriodList) {
            xbrlPeriod.setActive(Boolean.valueOf(true));
        }
        if (CollectionUtils.isEmpty((Collection)xbrlPackagePeriodList)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty((Collection)rolePeriodList)) {
            return xbrlPackagePeriodList;
        }
        for (XbrlRolePeriod rolePeriod : rolePeriodList) {
            for (XbrlPeriod packagePeriod : xbrlPackagePeriodList) {
                Long id = rolePeriod.getXbrlPeriod().getId();
                if (id == null || !id.equals(packagePeriod.getId())) continue;
                packagePeriod.setActive(Boolean.valueOf(false));
            }
        }
        return xbrlPackagePeriodList;
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public List<XbrlPeriod> findPdReportRolePeriodList(String xbrlRoleSystemId) {
        List periods = this.xbrlPeriodService.findAll();
        if (xbrlRoleSystemId != null) {
            List pdRolePeriods = this.xbrlPdRolePeriodRepository.findByXbrlPdRolePeriodId_RoleSystemId(xbrlRoleSystemId);
            List inactiveList = pdRolePeriods.stream().filter(xbrlPdRolePeriod -> this.isInactivePDRolePeriod(xbrlRoleSystemId, xbrlPdRolePeriod.getXbrlPdRolePeriodId().getXbrlPeriodId())).map(xbrlPdRolePeriod -> xbrlPdRolePeriod.getXbrlPdRolePeriodId().getXbrlPeriodId()).collect(Collectors.toList());
            periods.forEach(period -> period.setActive(Boolean.valueOf(!inactiveList.contains(period.getId()))));
        }
        return periods;
    }

    @Transactional(value="cacheTransactionManager")
    public List<XbrlPeriod> toggleRolePeriod(Long id, Long periodId) throws NotFoundException {
        XbrlReportRole role = this.xbrlReportCrudService.findRole(id);
        List xbrlPackagePeriodList = role.getXbrlReport().getXbrlPackage().getXbrlPackagePeriodList();
        if (CollectionUtils.isEmpty((Collection)xbrlPackagePeriodList)) {
            return Collections.emptyList();
        }
        if (periodId == null) {
            return xbrlPackagePeriodList;
        }
        XbrlPeriod xbrlPeriod = this.xbrlPeriodService.find(periodId);
        List periodRoleList = this.xbrlReportCrudService.findAllByPeriodAndRole(xbrlPeriod, role);
        if (!CollectionUtils.isEmpty((Collection)periodRoleList)) {
            for (XbrlRolePeriod xbrlRolePeriod : periodRoleList) {
                this.xbrlReportCrudService.deleteRolePeriod(xbrlRolePeriod);
            }
            this.entityManager.flush();
            return this.findReportRolePeriodList(id);
        }
        for (XbrlPeriod rolePeriod : xbrlPackagePeriodList) {
            if (!rolePeriod.getId().equals(periodId)) continue;
            XbrlRolePeriod xbrlRolePeriod = new XbrlRolePeriod();
            rolePeriod.getPeriodList().add(xbrlRolePeriod);
            xbrlRolePeriod.setXbrlPeriod(rolePeriod);
            xbrlRolePeriod.setXbrlReportRole(role);
            role.getPeriodList().add(xbrlRolePeriod);
            this.xbrlReportCrudService.updateRolePeriod(xbrlRolePeriod);
        }
        return this.findReportRolePeriodList(id);
    }

    @Transactional(value="cacheTransactionManager")
    public List<XbrlPeriod> togglePDRolePeriod(String roleSystemId, Long xbrlPeriodId) {
        XbrlPdRolePeriod.XbrlPdRolePeriodId id = new XbrlPdRolePeriod.XbrlPdRolePeriodId(roleSystemId, xbrlPeriodId);
        if (this.isInactivePDRolePeriod(roleSystemId, xbrlPeriodId)) {
            this.xbrlPdRolePeriodRepository.delete((Serializable)id);
        } else {
            XbrlPdRolePeriod inactiveMember = new XbrlPdRolePeriod();
            inactiveMember.setXbrlPdRolePeriodId(id);
            this.xbrlPdRolePeriodRepository.save((Object)inactiveMember);
        }
        return this.findPdReportRolePeriodList(roleSystemId);
    }

    public boolean isInactivePDRolePeriod(String roleSystemId, Long xbrlPeriodId) {
        XbrlPdRolePeriod.XbrlPdRolePeriodId id = new XbrlPdRolePeriod.XbrlPdRolePeriodId(roleSystemId, xbrlPeriodId);
        return this.xbrlPdRolePeriodRepository.exists((Serializable)id);
    }

    @Transactional(value="cacheTransactionManager")
    public List<XbrlPeriod> updateReportRolePeriod(Long roleId, Long periodId, XbrlPeriod xbrlPeriod) throws NotFoundException {
        XbrlPeriod xbrlPeriodPersist = this.xbrlPeriodService.updateValues(periodId, xbrlPeriod);
        if (xbrlPeriodPersist == null) {
            return this.findReportRolePeriodList(roleId);
        }
        this.xbrlPeriodService.save(xbrlPeriodPersist);
        return this.findReportRolePeriodList(roleId);
    }

    @Transactional(value="cacheTransactionManager")
    public void deleteWithFile(Long id) throws NotFoundException, IOException {
        Date start = new Date();
        log.info("Delete xbrlReport id#" + id + " started...");
        XbrlReport existingReport = this.find(id);
        this.importXbrlService.clearXbrlContent(existingReport);
        if (StringUtils.isNotBlank((CharSequence)existingReport.getFilePath())) {
            FileUtils.deleteQuietly((File)new File(existingReport.getFilePath()));
        }
        this.xbrlReportCrudService.delete(existingReport.getId());
        log.info("Delete xbrlReport id#" + id + " completed in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    private String copyXbrlReportToInternalStore(String externalLocalPath) throws IOException {
        String fileName = FilenameUtils.getName((String)externalLocalPath);
        String filePathInternal = ru.cbr.xbrl.converter.utils.FileUtils.relativePathToAbsolute((String)(this.configProperties.getXbrlStorePath() + File.separator + fileName));
        if (!Files.isSameFile(Paths.get(externalLocalPath, new String[0]), Paths.get(filePathInternal, new String[0]))) {
            FileUtils.copyFile((File)new File(externalLocalPath), (File)new File(filePathInternal));
        }
        return filePathInternal;
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlReport uploadLocal(XbrlPackage xbrlPackage, String externalLocalPath, Taxonomy taxonomy) throws UploadException, TaxonomyNotFoundException, CancelledException, NotFoundException {
        if (xbrlPackage.getXbrlReport() != null) {
            this.xbrlReportCrudService.delete(xbrlPackage.getXbrlReport().getId());
            xbrlPackage.setXbrlReport(null);
        }
        try {
            String filePathInternal = this.copyXbrlReportToInternalStore(externalLocalPath);
            return this.processXbrlFile(xbrlPackage, filePathInternal, taxonomy);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new UploadException();
        }
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlReport uploadLocal(String externalLocalPath, Taxonomy taxonomy) throws UploadException, TaxonomyNotFoundException, CancelledException {
        String fileName = FilenameUtils.getName((String)externalLocalPath);
        String filePathInternal = ru.cbr.xbrl.converter.utils.FileUtils.relativePathToAbsolute((String)(this.configProperties.getXbrlStorePath() + File.separator + fileName));
        try {
            FileUtils.copyFile((File)new File(externalLocalPath), (File)new File(filePathInternal));
            return this.processXbrlFile(filePathInternal, taxonomy);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new UploadException();
        }
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlReport processXbrlFile(XbrlPackage xbrlPackage) throws NotFoundException, UploadException, TaxonomyNotFoundException, CancelledException {
        Taxonomy taxonomy = this.taxonomyService.findByVersion(xbrlPackage.getTaxonomyVersion());
        String filePathInternal = xbrlPackage.getXbrlReport().getFilePath();
        return this.processXbrlFile(xbrlPackage.getXbrlReport(), xbrlPackage.getXbrlReport().getFilePath(), taxonomy);
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlReport processXbrlFile(XbrlPackage xbrlPackage, String filePathInternal, Taxonomy taxonomy) throws UploadException, TaxonomyNotFoundException, CancelledException, NotFoundException {
        XbrlReport savedReport = this.processXbrlFile(filePathInternal, taxonomy);
        savedReport.setXbrlPackage(xbrlPackage);
        xbrlPackage.setXbrlReport(savedReport);
        XbrlReport updated = this.xbrlReportCrudService.update(savedReport);
        return this.find(updated.getId());
    }

    public XbrlReport processXbrlFile(String filePathInternal, Taxonomy taxonomy) throws UploadException, TaxonomyNotFoundException, CancelledException {
        XbrlReport xbrlReport = new XbrlReport();
        XbrlReport created = this.xbrlReportCrudService.create(xbrlReport);
        return this.processXbrlFile(created, filePathInternal, taxonomy);
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlReport createXbrlFile(XbrlPackage xbrlPackage, String filePathInternal, Taxonomy taxonomy) throws UploadException, TaxonomyNotFoundException, CancelledException {
        XbrlReport xbrlReport = new XbrlReport();
        this.createReportPeriods(xbrlPackage);
        xbrlReport.setXbrlPackage(xbrlPackage);
        xbrlPackage.setXbrlReport(xbrlReport);
        XbrlReport created = this.xbrlReportCrudService.create(xbrlReport);
        return this.processXbrlFile(created, filePathInternal, taxonomy);
    }

    public void createReportPeriods(XbrlPackage xbrlPackage) {
        ContextPeriod contextPeriod = xbrlPackage.getContextPeriod();
        if (contextPeriod != null) {
            Date startDate = contextPeriod.getStartDate();
            Date startOfYear = DateUtils.truncate((Date)startDate, (int)1);
            Date endDate = contextPeriod.getEndDate();
            XbrlPeriod period1 = new XbrlPeriod(startOfYear, endDate, contextPeriod.getTitle());
            period1.setIsDefaultPeriod(Boolean.valueOf(true));
            period1.setIsEditablePeriod(Boolean.valueOf(false));
            period1.setTitle(PeriodDates.from((XbrlPeriod)period1).formatDate());
            xbrlPackage.getXbrlPackagePeriodList().add(period1);
            period1.setXbrlPackage(xbrlPackage);
            if (!DateUtils.isSameDay((Date)startDate, (Date)startOfYear)) {
                XbrlPeriod period2 = new XbrlPeriod(startDate, endDate, contextPeriod.getTitle());
                period2.setIsDefaultPeriod(Boolean.valueOf(false));
                period2.setIsEditablePeriod(Boolean.valueOf(false));
                period2.setTitle(PeriodDates.from((XbrlPeriod)period2).formatDate());
                xbrlPackage.getXbrlPackagePeriodList().add(period2);
                period2.setXbrlPackage(xbrlPackage);
            }
        }
    }

    private void clearRoles(XbrlReport xbrlReport) {
        Date start = new Date();
        this.xbrlReportCrudService.clearRolesByXbrlReport(xbrlReport);
        log.info("Clear roles complete in " + (new Date().getTime() - start.getTime()) + " msec");
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlReport processXbrlFile(XbrlReport xbrlReport, String filePathInternal, Taxonomy taxonomy) throws UploadException, TaxonomyNotFoundException, CancelledException {
        XbrlPackage xbrlPackage = this.xbrlPackageService.findLastPackage();
        log.info("Xbrl file processing using arelle started...");
        this.clearRoles(xbrlReport);
        Date startProcessing = new Date();
        String fileName = FilenameUtils.getName((String)filePathInternal);
        try {
            File folder;
            File[] listOfFiles;
            this.presentationDefinitionService.clearPresentationDefinitionData();
            xbrlReport.setFileName(fileName);
            xbrlReport.setFilePath(filePathInternal);
            xbrlReport.setUploadTime(new Date());
            if (this.isLastActionCanceled) {
                this.cancelReportProcess();
            }
            Map filePathMap = this.xbrlParsedDataService.saveArelleProcessFiles(filePathInternal, new String[]{taxonomy.getFilePath()});
            String presentation = (String)filePathMap.get("pre");
            log.info("PRESENTATION FILENAME " + presentation);
            String formulaObjects = (String)filePathMap.get("formulae");
            log.info("FORMULAES FILENAME " + formulaObjects);
            for (Map.Entry entry2 : filePathMap.entrySet()) {
                log.info("OutputfilesMap using: " + (String)entry2.getKey() + " " + (String)entry2.getValue());
            }
            String tlbResultsPath = (String)filePathMap.get("exportDir");
            log.info("TABLE LINKBASE RESULT DIR " + tlbResultsPath);
            String parametersFilePath = (String)filePathMap.get("parametersFile");
            log.info("PARAMETERS FILENAME " + parametersFilePath);
            String namespacesFilePath = (String)filePathMap.get("namespacesFile");
            log.info("NAMESPACES FILENAME " + namespacesFilePath);
            String dimPath = (String)filePathMap.get("dim");
            log.info("DIM FILENAME " + dimPath);
            xbrlReport.storeArelleFiles(presentation, dimPath);
            String refFile = (String)filePathMap.get("refFile");
            log.info("REFFILE FILENAME " + refFile);
            String labelRolesFilePath = (String)filePathMap.get("labelRolesFile");
            log.info("LABELROLES FILENAME " + labelRolesFilePath);
            this.parseDimXml(dimPath);
            this.referenceLinkbaseService.parseReferenceLinkbase(refFile);
            this.labelLinkbaseService.load(labelRolesFilePath);
            List xbrlParameters = XbrlParametersUtils.parseParameterFile((String)parametersFilePath);
            xbrlParameters.stream().forEach(xbrlParameter -> xbrlParameter.setXbrlPackage(xbrlPackage));
            this.xbrlParameterService.createAll(xbrlParameters);
            this.namespacesService.parse(namespacesFilePath);
            if (this.isLastActionCanceled) {
                this.cancelReportProcess();
            }
            XbrlPresentation xbrlPresentationInfo = this.xbrlParsedDataService.getXbrlPresentationInfo(presentation);
            if (this.isLastActionCanceled) {
                this.cancelReportProcess();
            }
            List xbrlFormulaObjectList = this.xbrlParsedDataService.getXbrlReportFormulaObjectList(formulaObjects);
            if (this.isLastActionCanceled) {
                this.cancelReportProcess();
            }
            if (((listOfFiles = (folder = new File(tlbResultsPath)).listFiles()) == null || listOfFiles.length == 0) && CollectionUtils.isEmpty((Collection)xbrlFormulaObjectList)) {
                return this.xbrlReportCrudService.create(this.saveXbrlReportWithConcepts(xbrlReport, xbrlPresentationInfo));
            }
            List tableLinkBaseList = this.getTableLinkBaseStructures(listOfFiles);
            Set patterns = tableLinkBaseList.stream().map(TableLinkBaseStructure::getDimensionPattens).map(Map::entrySet).flatMap(Collection::stream).map(entry -> new OpenAxisValidationRule((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toSet());
            this.openAxisValidationRulesService.saveAll(patterns);
            tableLinkBaseList.forEach(tableLinkBaseStructure -> {
                tableLinkBaseStructure.getXbrlRoleDimensionMemberMap().values().stream().flatMap(Collection::stream).forEach(xbrlDimension -> {
                    String roleSystemId = tableLinkBaseStructure.getName();
                    xbrlDimension.setRoleSystemId(roleSystemId);
                    xbrlDimension.setId(DigestUtils.md5Hex((String)(roleSystemId + " -> " + xbrlDimension.getDimInt() + " -> " + xbrlDimension.getMemInt())));
                    this.xbrlDimensionService.save(xbrlDimension);
                });
                tableLinkBaseStructure.getXbrlRoleDimensionMemberMap().clear();
            });
            xbrlReport.setDimensionsDefaultJsonGzipped(DimensionsDefaultService.compressDimensionsDefault((List)tableLinkBaseList));
            xbrlReport.setEnumerationsJsonGzipped(EnumerationsService.compressEnumerations((List)tableLinkBaseList));
            this.entityManager.flush();
            if (this.isLastActionCanceled) {
                this.cancelReportProcess();
            }
            this.addTLBStructuresToXbrlReport(xbrlReport, tableLinkBaseList);
            log.info("Tlb role map processed in {} msec, concepts: {}, dimints: {}", new Object[]{this.xbrlRoleService.getTlbRoleMap().duration, this.xbrlRoleService.getTlbRoleMap().getConceptRoleMap().size(), this.xbrlRoleService.getTlbRoleMap().getDimintRoleMap().size()});
            if (CollectionUtils.isEmpty((Collection)tableLinkBaseList) && CollectionUtils.isEmpty((Collection)xbrlFormulaObjectList)) {
                return this.xbrlReportCrudService.create(this.saveXbrlReportWithConcepts(xbrlReport, xbrlPresentationInfo));
            }
            if (!CollectionUtils.isEmpty((Collection)xbrlFormulaObjectList)) {
                for (XbrlFormula xbrlFormula : xbrlFormulaObjectList) {
                    xbrlFormula.setXbrlReport(xbrlReport);
                    xbrlReport.getXbrlReportFormulaList().add(xbrlFormula);
                }
            }
            this.fillValueDataType();
            XbrlReport processedReport = this.xbrlReportCrudService.update(this.saveXbrlReportWithConcepts(xbrlReport, xbrlPresentationInfo));
            if (this.isLastActionCanceled) {
                this.cancelReportProcess();
            }
            Date startParseDimFile = new Date();
            log.info("ParseDimFile completed in " + (new Date().getTime() - startParseDimFile.getTime()) + " msec");
            Date startLoadPresentationDefinitionData = new Date();
            this.dimensionsDefaultService.loadFromReport(processedReport);
            this.enumerationsService.loadFromReport(processedReport);
            this.presentationDefinitionService.loadDimensionXml(processedReport);
            log.info("loadPresentationDefinitionData completed in " + (new Date().getTime() - startParseDimFile.getTime()) + " msec");
            log.info("Xbrl file processing using arelle completed in " + (new Date().getTime() - startLoadPresentationDefinitionData.getTime()) + " msec");
            if (this.isLastActionCanceled) {
                this.cancelReportProcess();
            }
            return processedReport;
        }
        catch (CancelledException e) {
            this.cancelReportProcess();
            return null;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new UploadException();
        }
        catch (CommandExecutionException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new UploadException();
        }
        catch (NotFoundException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new UploadException();
        }
    }

    private void parseDimXml(String dimPath) {
        DimFileParser.parse((String)dimPath, (indent, xbrlDimension) -> this.xbrlDimensionService.save(xbrlDimension));
    }

    private void fillValueDataType() {
        try {
            this.xbrlValueRepository.streamAll().forEach(xbrlValue -> {
                xbrlValue.setDataType(this.conceptService.findTypeByConcept(xbrlValue.getXbrlValueId().getElementLabel()));
                this.xbrlValueCrudService.update(xbrlValue);
            });
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public List<TableLinkBaseStructure> getTableLinkBaseStructures(File[] listOfFiles) {
        LinkedList<TableLinkBaseStructure> tableLinkBaseList = new LinkedList<TableLinkBaseStructure>();
        if (listOfFiles != null && listOfFiles.length > 0) {
            for (File file : listOfFiles) {
                if (this.isLastActionCanceled) {
                    this.cancelReportProcess();
                }
                log.debug("Current tlb-file {}", (Object)file.getAbsolutePath());
                TableLinkBaseStructure tableLinkBaseStructureByRole = this.xbrlParsedDataService.getTableLinkBaseStructureByRole(file.getAbsolutePath());
                if (tableLinkBaseStructureByRole != null) {
                    tableLinkBaseList.add(tableLinkBaseStructureByRole);
                    continue;
                }
                log.debug("tlb-file {} was not parsed", (Object)file.getAbsolutePath());
            }
        }
        return tableLinkBaseList;
    }

    @Transactional(value="cacheTransactionManager")
    public void addTLBStructuresToXbrlReport(XbrlReport xbrlReport, List<TableLinkBaseStructure> tableLinkBaseList) throws JsonProcessingException, ExecutionException, InterruptedException {
        if (!CollectionUtils.isEmpty(tableLinkBaseList)) {
            List usedContexts = this.xbrlContextRepository.streamAll().collect(Collectors.toList());
            HashSet xbrlContextDimensions = new HashSet();
            for (XbrlContext xbrlContext : usedContexts) {
                ArrayList dimensionList = new ArrayList();
                new XbrlContextScenarioParser(xbrlContext.getScenario(), dim -> {
                    if (dim != null) {
                        AxisService.addToUniqueSet((Set)xbrlContextDimensions, (XbrlContextDimension)dim);
                        dimensionList.add(dim);
                    }
                });
                xbrlContext.setXbrlContextDimensions(dimensionList);
            }
            Map cacheContextDimensions = AxisService.sortContextDimeByXbrlDim(xbrlContextDimensions, usedContexts);
            Date start = new Date();
            this.xbrlRoleService.getTagSelectorsCellsMap().clear();
            this.conceptInMemoryService.clearExplicitAspectNodeSet();
            this.conceptInMemoryService.clearContextRoleMap();
            for (TableLinkBaseStructure tableLinkBaseStructure : tableLinkBaseList) {
                Long dateItem = new Date().getTime();
                if (tableLinkBaseStructure == null || StringUtils.isBlank((CharSequence)tableLinkBaseStructure.getName())) continue;
                log.info("Preparing role " + tableLinkBaseStructure.getLabel());
                Long date = new Date().getTime();
                XbrlReportRole xbrlReportRole = new XbrlReportRole();
                xbrlReportRole.setRoleId(tableLinkBaseStructure.getRoleId());
                xbrlReportRole.setStaticStructureJson(this.objectMapper.writeValueAsString((Object)tableLinkBaseStructure));
                xbrlReportRole.setTitle(tableLinkBaseStructure.getLabel());
                xbrlReportRole.setDocumentation(tableLinkBaseStructure.getDocumentation());
                xbrlReportRole.setSystemId(tableLinkBaseStructure.getName());
                xbrlReportRole.setXbrlReport(xbrlReport);
                xbrlReport.getXbrlReportRoles().add(xbrlReportRole);
                XbrlReportRole updatedXbrlReportRole = (XbrlReportRole)this.xbrlReportRoleRepository.save((Object)xbrlReportRole);
                Long dateEnd = new Date().getTime();
                log.trace("Presaving report role - {}ms", (Object)(dateEnd - date));
                date = new Date().getTime();
                Set typedDimensions = tableLinkBaseStructure.findTypedDimensions();
                dateEnd = new Date().getTime();
                log.trace("findTypedDimensions - {}ms", (Object)(dateEnd - date));
                date = new Date().getTime();
                List filterOpenAxes = this.axisService.addTypedAxisToRole(typedDimensions, updatedXbrlReportRole);
                dateEnd = new Date().getTime();
                log.trace("addTypedAxisToRole - {}ms", (Object)(dateEnd - date));
                date = new Date().getTime();
                HashMap<String, List> filterOpenAxisMap = new HashMap<String, List>();
                for (FilterOpenAxis filterOpenAxis : filterOpenAxes) {
                    String systemId = filterOpenAxis.getSystemId();
                    List filterOpenAxisList = filterOpenAxisMap.computeIfAbsent(systemId, k -> new ArrayList());
                    filterOpenAxisList.add(filterOpenAxis);
                }
                dateEnd = new Date().getTime();
                log.trace("Prepare filterOpenAxisMap - {}ms", (Object)(dateEnd - date));
                Boolean onlyWithData = Boolean.TRUE;
                this.axisService.fillAspectNodeMembers(tableLinkBaseStructure, updatedXbrlReportRole, filterOpenAxisMap, cacheContextDimensions, usedContexts, onlyWithData);
                date = new Date().getTime();
                this.axisService.isContextPathExistTimer = 0L;
                this.axisService.addExplicitAxisToRole(tableLinkBaseStructure, xbrlReportRole);
                dateEnd = new Date().getTime();
                log.trace("Process ExplicitAxisToRole - {}ms", (Object)(dateEnd - date));
                this.axisService.isContextPathExistTimer = 0L;
                date = dateEnd;
                this.xbrlRoleService.processStructure(tableLinkBaseStructure);
                log.trace("Set size {}", (Object)this.conceptInMemoryService.getContextRole(tableLinkBaseStructure.getName()).size());
                dateEnd = new Date().getTime();
                log.trace("Process structure - {}ms", (Object)(dateEnd - date));
                this.xbrlReportRoleRepository.save((Object)xbrlReportRole);
                log.trace("Role prepare duration {}", (Object)(new Date().getTime() - dateItem));
            }
            log.info("Preparing in " + (new Date().getTime() - start.getTime()) + " msec");
        }
    }

    private void prepareXbrlRoleAspectNodeMembers(XbrlReportRole updatedXbrlReportRole) {
        Long date = new Date().getTime();
        if (updatedXbrlReportRole == null) {
            return;
        }
        List aspectNodeMembers = updatedXbrlReportRole.getAspectNodeMembers();
        if (CollectionUtils.isEmpty((Collection)aspectNodeMembers)) {
            return;
        }
        updatedXbrlReportRole.getAspectNodeMemberHashMap().clear();
        Map aspectNodeMemberHashMap = updatedXbrlReportRole.getAspectNodeMemberHashMap();
        aspectNodeMembers.forEach(aspectNodeMember -> {
            String hash = aspectNodeMember.getHash();
            List aspectNodeMemberList = aspectNodeMemberHashMap.computeIfAbsent(hash, k -> new ArrayList());
            aspectNodeMemberList.add(aspectNodeMember);
        });
        log.info("Process aspect node members map - {} ms", (Object)(new Date().getTime() - date));
    }

    public void addTypedDimensions(XbrlContext xbrlContext, List<FilterOpenAxis> allAxises, List<FilterOpenAxisValue> allMembers) {
        List xbrlContextDimensions = xbrlContext.getXbrlContextDimensions();
        for (XbrlContextDimension xbrlContextDimension : xbrlContextDimensions) {
            Optional<FilterOpenAxis> filterOpenAxisBySystemId;
            if (xbrlContextDimension.getDimensionType() != DimensionType.TYPED_MEMBER || !(filterOpenAxisBySystemId = allAxises.stream().filter(it -> it.getSystemId().equals(xbrlContextDimension.getDimension())).findFirst()).isPresent()) continue;
            FilterOpenAxis filterOpenAxis = filterOpenAxisBySystemId.get();
            FilterOpenAxisValue filterOpenAxisValue = new FilterOpenAxisValue();
            filterOpenAxisValue.setValue(xbrlContextDimension.getDomainValue());
            try {
                this.addBatchRoleFilterMember(filterOpenAxis.getId(), filterOpenAxisValue, allMembers);
            }
            catch (Exception e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public byte[] download(Long id) throws NotFoundException, DownloadException {
        XbrlReport xbrlReport = this.find(id);
        try {
            FileInputStream inputStream = new FileInputStream(xbrlReport.getFilePath());
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new DownloadException();
        }
    }

    public void downloadToFolder(Long xbrlReportId, String destinationPath) throws NotFoundException {
        XbrlReport xbrlReport = this.find(xbrlReportId);
        try {
            ru.cbr.xbrl.converter.utils.FileUtils.copyFileUsingFileChannels((String)xbrlReport.getFilePath(), (String)(destinationPath + File.separator + xbrlReport.getFileName()));
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void cancelProcessing() {
        this.isLastActionCanceled = true;
        ArelleOutputParser.setIsLastActionCancelled((Boolean)true);
        this.arelleService.killCurrentArelleProcess();
    }

    public List<FilterOpenAxis> findReportRoleFilter(Long id) {
        return null;
    }

    private XbrlReport saveXbrlReportWithConcepts(XbrlReport xbrlReport, XbrlPresentation xbrlPresentation) {
        if (xbrlPresentation == null) {
            return xbrlReport;
        }
        for (PresentationLinkRole presentationLinkRole : xbrlPresentation.getRoleMap().values()) {
            for (PresentationConcept presentationConcept : presentationLinkRole.getPresentationConceptMap().values()) {
                this.addConceptToReport(xbrlReport, presentationConcept);
            }
        }
        return xbrlReport;
    }

    private void addConceptToReport(XbrlReport xbrlReport, PresentationConcept presentationConcept) {
        if (presentationConcept == null) {
            return;
        }
        List presentationConceptList = presentationConcept.getPresentationConceptList();
        if (CollectionUtils.isEmpty((Collection)presentationConceptList)) {
            presentationConcept.setXbrlReport(xbrlReport);
            xbrlReport.getXbrlReportConceptList().add(presentationConcept);
            return;
        }
        for (PresentationConcept concept : presentationConceptList) {
            this.addConceptToReport(xbrlReport, concept);
        }
    }

    @Transactional(value="cacheTransactionManager")
    public void addRoleFilterMember(Long axisId, FilterOpenAxisValue filterOpenAxisValue) {
        if (axisId == null) {
            return;
        }
        String value = filterOpenAxisValue.getValue();
        filterOpenAxisValue.setValue(value == null ? null : value.trim());
        FilterOpenAxis filterOpenAxis = this.xbrlFilterOpenAxisService.find(axisId);
        if (filterOpenAxisValue == null) {
            return;
        }
        List filterOpenAxisValues = this.xbrlFilterOpenAxisMemberService.getFilterOpenAxisValuesByFilterOpenAxisAndValue(filterOpenAxis, filterOpenAxisValue.getValue());
        Optional first = filterOpenAxisValues.stream().findFirst();
        if (first.isPresent()) {
            return;
        }
        this.openAxisValidationRulesService.validate(filterOpenAxis.getSystemId(), filterOpenAxisValue.getValue());
        filterOpenAxisValue.setFilterOpenAxis(filterOpenAxis);
        this.xbrlFilterOpenAxisMemberService.update(filterOpenAxisValue);
    }

    @Transactional(value="cacheTransactionManager")
    @Deprecated
    public FilterOpenAxis addBatchRoleFilterMember(Long axisId, FilterOpenAxisValue filterOpenAxisValue, List<FilterOpenAxisValue> allMembers) {
        FilterOpenAxis filterOpenAxis = this.xbrlFilterOpenAxisService.find(axisId);
        if (filterOpenAxisValue == null) {
            return filterOpenAxis;
        }
        FilterOpenAxisValue finalFilterOpenAxisValue = filterOpenAxisValue;
        Optional<FilterOpenAxisValue> filterOpenAxisValueCached = allMembers.stream().filter(it -> finalFilterOpenAxisValue.getValue().equals(it.getValue()) && Objects.equals(axisId, it.getFilterOpenAxis().getId())).findFirst();
        if (filterOpenAxisValueCached.isPresent()) {
            return filterOpenAxis;
        }
        filterOpenAxisValue.setFilterOpenAxis(filterOpenAxis);
        filterOpenAxisValue = this.xbrlFilterOpenAxisMemberService.update(filterOpenAxisValue);
        allMembers.add(filterOpenAxisValue);
        return filterOpenAxis;
    }

    @Transactional(value="cacheTransactionManager")
    public void importRoleFilterMembersFromTextFile(Long axisId, String textFileName) throws ReadFileException, IncompatibleTxtFilterFileEncodingException {
        Charset charset = Charset.forName("cp1251");
        try (Stream<String> stream = Files.lines(Paths.get(textFileName, new String[0]), charset);){
            stream.filter(StringUtils::isNotBlank).forEach(val -> this.addRoleFilterMember(axisId, new FilterOpenAxisValue(val)));
        }
        catch (UncheckedIOException e) {
            log.error("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u044b\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c \u0424\u0430\u0439\u043b \u0441 \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u043c\u0438 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0443\u044e \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0443");
            throw new IncompatibleTxtFilterFileEncodingException();
        }
        catch (IOException e) {
            throw new ReadFileException();
        }
    }

    @Transactional(value="cacheTransactionManager")
    public void deleteRoleFilterMember(Long memberId) {
        if (memberId == null) {
            return;
        }
        FilterOpenAxisValue filterOpenAxisValue = this.xbrlFilterOpenAxisMemberService.find(memberId);
        if (filterOpenAxisValue == null) {
            return;
        }
        filterOpenAxisValue.getAspectNodeMemberList().stream().forEach(aspectNodeMember -> this.deleteContextByDimensionValues(aspectNodeMember.getDimension(), filterOpenAxisValue.getValue()));
        this.xbrlFilterOpenAxisMemberService.delete(memberId);
    }

    public void deleteContextByDimensionValues(String dimension, String dimensionValue) {
        List allContexts = this.xbrlContextRepository.findAll();
        allContexts.stream().forEach(xbrlContext -> {
            xbrlContext.unpackAspectDataList();
            xbrlContext.getAspectDataList().forEach(aspectData -> {
                if (aspectData.getAspect().equals(dimension) && aspectData.getAspectValue().equals(dimensionValue)) {
                    XbrlValueId xbrlValueId = new XbrlValueId();
                    xbrlValueId.setXbrlContextId(xbrlContext.getXbrlContextId().getContextId());
                    List xbrlValues = this.xbrlValueCrudService.findByContextId(xbrlContext.getXbrlContextId().getContextId());
                    xbrlValues.forEach(xbrlValue -> {
                        try {
                            if (StringUtils.isNotBlank((CharSequence)xbrlValue.getId())) {
                                List footnoteList = this.xbrlFootnoteCrudService.listByXbrlValue(xbrlValue);
                                this.xbrlFootnoteCrudService.deleteFound(footnoteList);
                            }
                            List valueroles = this.xbrlValueRoleRepository.findAllByGuid(xbrlValue.getGuid());
                            valueroles.forEach(xbrlValueRole -> this.xbrlValueRoleRepository.delete(xbrlValueRole));
                            this.xbrlValueCrudService.delete(xbrlValue.getXbrlValueId());
                        }
                        catch (NotFoundException e) {
                            log.error("Value not found");
                        }
                    });
                    this.xbrlContextRepository.delete((Serializable)xbrlContext.getXbrlContextId());
                }
            });
            AspectCellData aspectCellData = new AspectCellData();
            aspectCellData.setAspectDataList(xbrlContext.getAspectDataList());
        });
        this.unitService.clearUnusedXbrlUnits();
    }

    public void renameContextDimensionValues(String dimension, String dimensionValue, String newDimensionValue) {
        List allContexts = this.xbrlContextRepository.findAll();
        if (CollectionUtils.isEmpty((Collection)allContexts)) {
            return;
        }
        allContexts.forEach(xbrlContext -> {
            if (xbrlContext == null) {
                return;
            }
            boolean[] isChanged = new boolean[]{false};
            xbrlContext.unpackAspectDataList();
            xbrlContext.getAspectDataList().forEach(aspectData -> {
                if (aspectData.getAspect().equals(dimension) && aspectData.getAspectValue().equals(dimensionValue)) {
                    aspectData.setAspectValue(newDimensionValue);
                    isChanged[0] = true;
                }
            });
            if (isChanged[0]) {
                AspectCellData aspectCellData = new AspectCellData();
                aspectCellData.setAspectDataList(xbrlContext.getAspectDataList());
                xbrlContext.setXbrlContextDimensions(XbrlContextDimension.buildFromAspectDataList((List)aspectCellData.getDimensions()));
                xbrlContext.rebuildDimensions(this.conceptInMemoryService.getExplicitAspectNodeSet());
                xbrlContext.setScenario(XbrlContextDimension.buildScenario((List)xbrlContext.getXbrlContextDimensions()));
                xbrlContext.packAspectDataList();
                this.xbrlContextRepository.save(xbrlContext);
            }
        });
    }

    @Transactional(value="cacheTransactionManager")
    public void deleteRoleFilterMember(List<Long> memberIdList) {
        if (CollectionUtils.isEmpty(memberIdList)) {
            return;
        }
        for (Long memberId : memberIdList) {
            this.deleteRoleFilterMember(memberId);
        }
    }

    @Transactional(value="cacheTransactionManager")
    public RoleDTO deleteRoleFilterMember(List<Long> memberIdList, Boolean confirm) {
        RoleDTO roleDTO = new RoleDTO();
        memberIdList.forEach(memberId -> {
            FilterOpenAxisValue filterOpenAxisValue = this.xbrlFilterOpenAxisMemberService.find(memberId);
            if (filterOpenAxisValue == null) {
                return;
            }
            filterOpenAxisValue.getAspectNodeMemberList().size();
            if (BooleanUtils.isNotTrue((Boolean)confirm)) {
                if (filterOpenAxisValue.getAspectNodeMemberList().size() > 0) {
                    filterOpenAxisValue.getAspectNodeMemberList().forEach(aspectNodeMember -> {
                        Set filledPdRolesByDimension = this.xbrlRoleService.getFilledPdRolesByDimension(aspectNodeMember.getDimension(), null);
                        roleDTO.getPdRoles().addAll(filledPdRolesByDimension);
                        filledPdRolesByDimension.forEach(pdRole -> roleDTO.getTblRoles().addAll(this.xbrlRoleService.getTlbRoleByPdRole(pdRole)));
                    });
                } else {
                    Set dims = this.getDimensions(filterOpenAxisValue.getValue(), false);
                    for (String dim : dims) {
                        Set filledPdRolesByDimension = this.xbrlRoleService.getFilledPdRolesByDimension(dim, null);
                        roleDTO.getPdRoles().addAll(filledPdRolesByDimension);
                        filledPdRolesByDimension.forEach(pdRole -> roleDTO.getTblRoles().addAll(this.xbrlRoleService.getTlbRoleByPdRole(pdRole)));
                    }
                }
            }
            if (roleDTO.isRolesEmpty() || BooleanUtils.isTrue((Boolean)confirm)) {
                List xbrlValues = this.xbrlValueCrudService.list();
                for (XbrlValue xbrlValue : xbrlValues) {
                    xbrlValue.unpackAspectDataList();
                    boolean isFound = false;
                    List d = xbrlValue.getAspectDataList();
                    AspectData d1 = null;
                    if (d != null) {
                        for (AspectData aspectData : d) {
                            if (!aspectData.getAspectValue().equals(filterOpenAxisValue.getValue())) continue;
                            isFound = true;
                            d1 = aspectData;
                            String dim = aspectData.getAspect();
                            break;
                        }
                    }
                    if (!isFound) continue;
                    try {
                        if (StringUtils.isNotBlank((CharSequence)xbrlValue.getId())) {
                            List footnoteList = this.xbrlFootnoteCrudService.listByXbrlValue(xbrlValue);
                            this.xbrlFootnoteCrudService.deleteFound(footnoteList);
                        }
                        List valueroles = this.xbrlValueRoleRepository.findAllByGuid(xbrlValue.getGuid());
                        valueroles.forEach(xbrlValueRole -> this.xbrlValueRoleRepository.delete(xbrlValueRole));
                        this.xbrlValueCrudService.delete(xbrlValue.getXbrlValueId());
                    }
                    catch (NotFoundException e) {
                        log.error("Value not found");
                    }
                }
                filterOpenAxisValue.getAspectNodeMemberList().forEach(aspectNodeMember -> this.deleteContextByDimensionValues(aspectNodeMember.getDimension(), filterOpenAxisValue.getValue()));
                this.xbrlFilterOpenAxisMemberService.delete(memberId);
            }
        });
        return roleDTO;
    }

    private Set<String> getDimensions(String filterOpenAxisValue, boolean isDelete) {
        List xbrlValues = this.xbrlValueCrudService.list();
        HashSet<String> dims = new HashSet<String>();
        for (XbrlValue xbrlValue : xbrlValues) {
            xbrlValue.unpackAspectDataList();
            boolean isFound = false;
            List d = xbrlValue.getAspectDataList();
            AspectData d1 = null;
            if (d != null) {
                for (AspectData aspectData : d) {
                    if (!aspectData.getAspectValue().equals(filterOpenAxisValue)) continue;
                    isFound = true;
                    d1 = aspectData;
                    String dim = aspectData.getAspect();
                    dims.add(dim);
                    break;
                }
            }
            if (!isFound || !isDelete) continue;
            try {
                if (StringUtils.isNotBlank((CharSequence)xbrlValue.getId())) {
                    List footnoteList = this.xbrlFootnoteCrudService.listByXbrlValue(xbrlValue);
                    this.xbrlFootnoteCrudService.deleteFound(footnoteList);
                }
                List valueroles = this.xbrlValueRoleRepository.findAllByGuid(xbrlValue.getGuid());
                valueroles.forEach(xbrlValueRole -> this.xbrlValueRoleRepository.delete(xbrlValueRole));
                this.xbrlValueCrudService.delete(xbrlValue.getXbrlValueId());
            }
            catch (NotFoundException e) {
                log.error("Value not found");
            }
        }
        return dims;
    }

    @Transactional(value="cacheTransactionManager")
    public FilterOpenAxisValue updateRoleFilterMember(Long memberId, FilterOpenAxisValue filterOpenAxisValue) {
        if (memberId == null || filterOpenAxisValue == null) {
            return null;
        }
        FilterOpenAxisValue filterOpenAxisMemberPersist = this.xbrlFilterOpenAxisMemberService.find(memberId);
        if (filterOpenAxisMemberPersist == null) {
            return null;
        }
        this.openAxisValidationRulesService.validate(filterOpenAxisMemberPersist.getFilterOpenAxis().getSystemId(), filterOpenAxisValue.getValue());
        String persistValue = filterOpenAxisMemberPersist.getValue();
        if (filterOpenAxisMemberPersist.getAspectNodeMemberList().size() > 0) {
            filterOpenAxisMemberPersist.getAspectNodeMemberList().forEach(aspectNodeMember -> this.renameContextDimensionValues(aspectNodeMember.getDimension(), persistValue, filterOpenAxisValue.getValue()));
        } else {
            this.renameContextDimensionValues(filterOpenAxisMemberPersist.getFilterOpenAxis().getSystemId(), persistValue, filterOpenAxisValue.getValue());
        }
        filterOpenAxisMemberPersist.setValue(filterOpenAxisValue.getValue());
        this.xbrlFilterOpenAxisMemberService.update(filterOpenAxisMemberPersist);
        return filterOpenAxisMemberPersist;
    }

    @Transactional(value="cacheTransactionManager")
    public FilterOpenAxis toggleRoleFilterMember(Long roleId, Long memberId, Boolean state) throws NotFoundException {
        return null;
    }

    void addTypedAxisToRole(AspectData typedDimension, XbrlReportRole xbrlReportRole) {
        List defaultOpenAxis = this.xbrlFilterOpenAxisService.findFilterOpenAxisBySystemId(typedDimension.getAspect());
        Optional first = defaultOpenAxis.stream().findFirst();
        FilterOpenAxis filterOpenAxis = first.orElseGet(() -> {
            FilterOpenAxis newFilterOpenAxis = new FilterOpenAxis();
            newFilterOpenAxis.setTitle(typedDimension.getLabel());
            newFilterOpenAxis.setSystemId(typedDimension.getAspect());
            newFilterOpenAxis.setDomain(typedDimension.getDomain());
            return this.xbrlFilterOpenAxisService.update(newFilterOpenAxis);
        });
        XbrlRoleDimension xbrlRoleDimension = new XbrlRoleDimension();
        xbrlRoleDimension.setFilterOpenAxis(filterOpenAxis);
        xbrlRoleDimension.setXbrlReportRole(xbrlReportRole);
        filterOpenAxis.getXbrlRoleDimensionList().add(xbrlRoleDimension);
        this.xbrlFilterOpenAxisService.update(filterOpenAxis);
    }

    private void cancelReportProcess() {
        log.info("Report processing cancelled by user");
        this.isLastActionCanceled = false;
        this.notificationEventService.sendStompMessage(NotificationEventServiceImpl.StompDestination.CANCEL, new NotificationEvent());
        throw new ActionCancelledException();
    }

    public boolean isLastActionCanceled() {
        return this.isLastActionCanceled;
    }

    public void setLastActionCanceled(boolean lastActionCanceled) {
        this.isLastActionCanceled = lastActionCanceled;
    }

    public boolean checkXbrlFile(XbrlReport xbrlReport, String xbrlFilePath, EventLog.EventLogType eventLogType, ValidationLogInfo validationLogInfo) throws CommandExecutionException, CancelledException, TaxonomyNotFoundException, XbrlImportException {
        Taxonomy taxonomy;
        XbrlPackage xbrlPackage = xbrlReport.getXbrlPackage();
        String taxonomyVersion = xbrlPackage.getTaxonomyVersion();
        String pathToXsd = xbrlPackage.getPathToXsd();
        try {
            taxonomy = this.taxonomyService.findByVersion(taxonomyVersion);
        }
        catch (NotFoundException e) {
            throw new TaxonomyNotFoundException();
        }
        File src = new File(xbrlFilePath);
        String tempFile = null;
        String expectedEntryPoint = xbrlPackage.getPathToXsd();
        String currentEntryPoint = "http://" + expectedEntryPoint.substring(3);
        try {
            tempFile = System.getProperty("java.io.tmpdir") + src.getName();
            if (tempFile.equals(xbrlFilePath)) {
                tempFile = tempFile.replace(".xml", "_1.xml");
            }
            BufferedWriter f = new BufferedWriter(new FileWriter(tempFile));
            try (BufferedReader reader = new BufferedReader(new FileReader(src));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("<link:schemaRef")) {
                        int i = line.indexOf("href");
                        int startIndex = line.indexOf("\"", i);
                        line = line.substring(0, startIndex + 1) + currentEntryPoint + "\"/>";
                    }
                    f.write(line);
                    f.write("\n");
                }
            }
            f.flush();
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.arelleService.checkXbrlFile(tempFile, new String[]{taxonomy.getFilePath()}, eventLogType, validationLogInfo);
    }

    public boolean isEmpty() {
        return this.xbrlValueCrudService.isEmpty();
    }

    @ConstructorProperties(value={"openAxisValidationRulesService"})
    public XbrlReportServiceImpl(OpenAxisValidationRulesService openAxisValidationRulesService) {
        this.openAxisValidationRulesService = openAxisValidationRulesService;
    }
}

