/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.exception.CancelledException;
import ru.cbr.xbrl.converter.exception.CommandExecutionException;
import ru.cbr.xbrl.converter.exception.DownloadException;
import ru.cbr.xbrl.converter.exception.IncompatibleTxtFilterFileEncodingException;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.exception.ReadFileException;
import ru.cbr.xbrl.converter.exception.TaxonomyNotFoundException;
import ru.cbr.xbrl.converter.exception.UploadException;
import ru.cbr.xbrl.converter.exception.XbrlImportException;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.XbrlReport;
import ru.cbr.xbrl.converter.model.XbrlReportRole;
import ru.cbr.xbrl.converter.model.log.EventLog;
import ru.cbr.xbrl.converter.model.pkg.XbrlPackage;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxis;
import ru.cbr.xbrl.converter.model.tableLinkBase.FilterOpenAxisValue;
import ru.cbr.xbrl.converter.model.tableLinkBase.TableLinkBaseStructure;
import ru.cbr.xbrl.converter.model.validation.ValidationLogInfo;
import ru.cbr.xbrl.converter.model.web.rest.RoleDTO;
import ru.cbr.xbrl.converter.model_main.Taxonomy;

public interface XbrlReportService {
    public List<XbrlReport> list();

    public XbrlReport find(Long var1) throws NotFoundException;

    public XbrlReportRole findReportRole(Long var1) throws NotFoundException;

    public XbrlReportRole findReportRoleSafe(Long var1);

    public XbrlReportRole findReportRoleBySystemId(String var1) throws NotFoundException;

    public List<XbrlPeriod> findReportRolePeriodList(Long var1) throws NotFoundException;

    public void deleteWithFile(Long var1) throws NotFoundException, IOException;

    public XbrlReport uploadLocal(String var1, Taxonomy var2) throws UploadException, TaxonomyNotFoundException, CancelledException;

    public XbrlReport uploadLocal(XbrlPackage var1, String var2, Taxonomy var3) throws UploadException, TaxonomyNotFoundException, CancelledException, NotFoundException;

    public XbrlReport processXbrlFile(XbrlPackage var1) throws NotFoundException, UploadException, TaxonomyNotFoundException, CancelledException;

    public XbrlReport processXbrlFile(String var1, Taxonomy var2) throws UploadException, TaxonomyNotFoundException, CancelledException;

    public XbrlReport processXbrlFile(XbrlPackage var1, String var2, Taxonomy var3) throws UploadException, TaxonomyNotFoundException, CancelledException, NotFoundException;

    public XbrlReport createXbrlFile(XbrlPackage var1, String var2, Taxonomy var3) throws UploadException, TaxonomyNotFoundException, CancelledException;

    public void createReportPeriods(XbrlPackage var1);

    public List<TableLinkBaseStructure> getTableLinkBaseStructures(File[] var1);

    public void addTLBStructuresToXbrlReport(XbrlReport var1, List<TableLinkBaseStructure> var2) throws JsonProcessingException, ExecutionException, InterruptedException;

    public byte[] download(Long var1) throws NotFoundException, DownloadException;

    public void downloadToFolder(Long var1, String var2) throws NotFoundException;

    public void cancelProcessing();

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public List<XbrlPeriod> findPdReportRolePeriodList(String var1);

    public List<XbrlPeriod> toggleRolePeriod(Long var1, Long var2) throws NotFoundException;

    public List<XbrlPeriod> togglePDRolePeriod(String var1, Long var2);

    public boolean isInactivePDRolePeriod(String var1, Long var2);

    public List<XbrlPeriod> updateReportRolePeriod(Long var1, Long var2, XbrlPeriod var3) throws NotFoundException;

    public List<FilterOpenAxis> findReportRoleFilter(Long var1);

    public void addRoleFilterMember(Long var1, FilterOpenAxisValue var2);

    public FilterOpenAxis addBatchRoleFilterMember(Long var1, FilterOpenAxisValue var2, List<FilterOpenAxisValue> var3);

    public void importRoleFilterMembersFromTextFile(Long var1, String var2) throws ReadFileException, IncompatibleTxtFilterFileEncodingException;

    public void deleteRoleFilterMember(Long var1);

    public FilterOpenAxis toggleRoleFilterMember(Long var1, Long var2, Boolean var3) throws NotFoundException;

    public void renameContextDimensionValues(String var1, String var2, String var3);

    public void deleteRoleFilterMember(List<Long> var1);

    public RoleDTO deleteRoleFilterMember(List<Long> var1, Boolean var2);

    public FilterOpenAxisValue updateRoleFilterMember(Long var1, FilterOpenAxisValue var2);

    public boolean isLastActionCanceled();

    public void setLastActionCanceled(boolean var1);

    public boolean checkXbrlFile(XbrlReport var1, String var2, EventLog.EventLogType var3, ValidationLogInfo var4) throws CommandExecutionException, CancelledException, TaxonomyNotFoundException, XbrlImportException;

    public boolean isEmpty();
}

