/*
 * Decompiled with CFR 0.152.
 */
package ru.cbr.xbrl.converter.service;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ru.cbr.xbrl.converter.config.ConfigProperties;
import ru.cbr.xbrl.converter.exception.NotFoundException;
import ru.cbr.xbrl.converter.model.XbrlPeriod;
import ru.cbr.xbrl.converter.model.xbrl_content.PeriodType;
import ru.cbr.xbrl.converter.repository.XbrlContextRepository;
import ru.cbr.xbrl.converter.repository.XbrlPeriodRepository;
import ru.cbr.xbrl.converter.repository.XbrlValueRepository;
import ru.cbr.xbrl.converter.service.XbrlPeriodService;
import ru.cbr.xbrl.converter.service.import_export.EditXbrlService;
import ru.cbr.xbrl.converter.service.import_export.PeriodDates;

@Service
public class XbrlPeriodServiceImpl
implements XbrlPeriodService {
    private static final Logger log = LoggerFactory.getLogger(XbrlPeriodServiceImpl.class);
    private static final String COMPARE_DIRECTORY = "comparing_xblr_instance_";
    private final XbrlPeriodRepository xbrlPeriodRepository;
    @Autowired
    private ConfigProperties configProperties;
    @Autowired
    private XbrlContextRepository xbrlContextRepository;
    @Autowired
    private XbrlValueRepository xbrlValueRepository;
    @Autowired
    private EditXbrlService editXbrlService;

    @Autowired
    public XbrlPeriodServiceImpl(XbrlPeriodRepository xbrlPeriodRepository) {
        this.xbrlPeriodRepository = xbrlPeriodRepository;
    }

    @Transactional(value="cacheTransactionManager")
    public XbrlPeriod save(XbrlPeriod xbrlPeriod) {
        if (xbrlPeriod == null) {
            return null;
        }
        return (XbrlPeriod)this.xbrlPeriodRepository.save((Object)xbrlPeriod);
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public XbrlPeriod find(Long periodId) throws NotFoundException {
        XbrlPeriod period = (XbrlPeriod)this.xbrlPeriodRepository.findOne((Serializable)periodId);
        if (period == null) {
            log.info("\u041f\u0435\u0440\u0438\u043e\u0434 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. Id = {}", (Object)periodId);
            throw new NotFoundException();
        }
        return period;
    }

    @Transactional(value="cacheTransactionManager", readOnly=true)
    public List<XbrlPeriod> findAll() {
        return this.xbrlPeriodRepository.findAll();
    }

    public XbrlPeriod find(PeriodDates periodDates) {
        if (periodDates.getPeriodType().equals((Object)PeriodType.INSTANT)) {
            return this.xbrlPeriodRepository.findOneByInstantDate(periodDates.getInstantDate());
        }
        if (periodDates.getPeriodType().equals((Object)PeriodType.DURATION)) {
            return this.xbrlPeriodRepository.findOneByDuration(periodDates.getStartDate(), periodDates.getEndDate());
        }
        throw new IllegalArgumentException("Unknown periodType: " + periodDates.getPeriodType());
    }

    public void delete(XbrlPeriod xbrlPeriod) {
        this.xbrlPeriodRepository.delete((Object)xbrlPeriod);
    }

    public void deleteWithFacts(XbrlPeriod xbrlPeriod) {
        List contexts;
        List otherPeriods = this.xbrlPeriodRepository.findAll().stream().filter(cp -> !cp.getId().equals(xbrlPeriod.getId())).collect(Collectors.toList());
        List otherDurations = otherPeriods.stream().map(period -> period.toPeriodDates().formatDate()).distinct().collect(Collectors.toList());
        List otherInstants = otherPeriods.stream().map(period -> period.getAdditionalInstant().formatDate()).distinct().collect(Collectors.toList());
        if (!otherDurations.contains(xbrlPeriod.toPeriodDates().formatDate())) {
            contexts = this.xbrlContextRepository.findContextByPeriodTypeAndStartDateAndEndDate(PeriodType.DURATION, xbrlPeriod.toPeriodDates().getStartDate(), xbrlPeriod.toPeriodDates().getEndDate());
            contexts.forEach(xbrlContext -> this.editXbrlService.deleteDataByContext(xbrlContext));
        }
        if (!otherInstants.contains(xbrlPeriod.getAdditionalInstant().formatDate())) {
            contexts = this.xbrlContextRepository.findContextByPeriodTypeAndInstantDate(PeriodType.INSTANT, xbrlPeriod.getAdditionalInstant().getInstantDate());
            contexts.forEach(xbrlContext -> this.editXbrlService.deleteDataByContext(xbrlContext));
        }
        this.xbrlPeriodRepository.delete((Object)xbrlPeriod);
    }

    public XbrlPeriod getDefaultPeriod() {
        return this.xbrlPeriodRepository.findOneByIsDefaultPeriodTrue();
    }

    public XbrlPeriod updateValues(Long periodId, XbrlPeriod xbrlPeriod) throws NotFoundException {
        if (periodId == null || xbrlPeriod == null) {
            return null;
        }
        XbrlPeriod xbrlPeriodPersist = this.find(periodId);
        xbrlPeriodPersist.setStart(xbrlPeriod.getStart());
        xbrlPeriodPersist.setEnd(xbrlPeriod.getEnd());
        xbrlPeriodPersist.setTitle(xbrlPeriod.getTitle());
        xbrlPeriodPersist.setFilePath(xbrlPeriod.getFilePath());
        return xbrlPeriodPersist;
    }

    public List<XbrlPeriod> getNotEditableNotDefaultPeriods() {
        List periods = this.findAll();
        List nonEditablePeriods = periods.stream().filter(p -> p.getIsEditablePeriod() == false).collect(Collectors.toList());
        List<XbrlPeriod> notDefaultPeriods = nonEditablePeriods.stream().filter(p -> p.getIsDefaultPeriod() == false).collect(Collectors.toList());
        return notDefaultPeriods;
    }

    public XbrlPeriod getContextPeriod() {
        List notDefaultPeriods = this.getNotEditableNotDefaultPeriods();
        if (notDefaultPeriods.isEmpty()) {
            return this.getDefaultPeriod();
        }
        return (XbrlPeriod)notDefaultPeriods.get(0);
    }
}

